/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.Yd.common.YDMAStringUtil;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopProductTossShoppingAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.shop.data.tossShopping.tossShoppingExitsProductCd;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingProductRegService
implements IProduct {
    private int merchantId = 0;
    private int merchantUserId = 0;

    @Override
    public ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShopProductTossShoppingAdditionDto dtllist = null;
        ShoppingMallDetailDto shoppingMallDetailDto = sendProdList.getShoppingMallDetailDto();
        List<ShopProductDto> prodList = sendProdList.getShopProductDto();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        workMngDto.setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        String uuid = sendProdList.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        dtllist = (ShopProductTossShoppingAdditionDto)sendProdList.getProductAdditionDto();
        int progress = workMngDto.getProgress_rate();
        List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
        IShopCommonLogin l = new IShopCommonLogin(){};
        Map<Object, Object> cookie = new HashMap();
        try {
            cookie = l.loginCookie(shoppingMallDetailDto.getShoppingid(), shoppingMallDetailDto.getPassword(), shoppingMallDetailDto.getShopcd(), true, shoppingMallDetailDto.getAuthkey1());
            if (cookie.size() == 0) {
                throw new Exception("\ub85c\uadf8\uc778\uc744 \uc2e4\ud328\ud558\uc168\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            workMngDto.setWork_status("-1");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            WorkMngDetailDto workMngDetailDto = workMngDetailDtos.get(0);
            workMngDetailDto.setStatus("-1");
            workMngDetailDto.setMessage(e.getMessage());
            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
            return sendProdList;
        }
        double mod = 0.0;
        double rate = 0.0;
        try {
            String loginID = shoppingMallDetailDto.getShoppingid();
            String password = shoppingMallDetailDto.getPassword();
            String authkey1 = shoppingMallDetailDto.getAuthkey1();
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            mod = sendProdList.isManual() ? (double)conf.getProccnt() / (double)prodList.size() : 100.0 / (double)prodList.size();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ShopProductDto dto : prodList) {
                if ((int)(rate += mod) > 0) {
                    progress += (int)rate;
                    rate = 0.0;
                }
                workMngDto.setProgress_rate(progress);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        String forbiddenKeywords = shoppingMallDetailDto.getForbiddenKeywords();
                        ArrayList forbiddenKeywordList = forbiddenKeywords != null && !forbiddenKeywords.isEmpty() ? Arrays.asList(forbiddenKeywords.split(",")) : new ArrayList();
                        String productName = dto.getGoods_nm();
                        for (String keyword : forbiddenKeywordList) {
                            if (!productName.contains(keyword)) continue;
                            throw new Exception("\uc0c1\ud488\uba85\uc5d0 \uae08\uc9c0\ub41c \ud0a4\uc6cc\ub4dc\uac00 \ud3ec\ud568\ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4 : " + keyword);
                        }
                        String ProdNo = tossShoppingExitsProductCd.get().getisExistsProdNo(dto.getCompayny_goods_cd(), cookie);
                        if (!ProdNo.equals("")) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774 \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c \ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774 \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c \ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        ArrayList<String> strImages = new ArrayList();
                        strImages = this.editProductImage(dto, dtllist.getChangesize(), dtllist.getChangeSizeX(), dtllist.getChangeSizeY(), dtllist.getChangeSizeW(), dtllist.getChangeSizeH(), dtllist.getAngle(), dtllist.getScalePercent(), dtllist.getImgThreeOnFour(), dtllist.getRemoveImgTextYN(), dtllist.getMirrorImgYN(), "", "");
                        this.DownLoadImage(dtllist, shoppingMallDetailDto, strImages);
                        String json = this.MakeProductJson(dto, dtllist, loginID, password, strImages, authkey1);
                        this.ProductRegSend(dto, json, loginID, password);
                        if (!dto.getShopprodno().equals("")) {
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            workMngDetailDto.setMessage(String.valueOf(shoppingMallDetailDto.getShopnm()) + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4. [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            dto.setShopprodno(dto.getShopprodno());
                            dto.setResult_text(String.valueOf(shoppingMallDetailDto.getShopnm()) + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4. [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                        } else {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(dto.getResult_text());
                            dto.setResult_code("-1");
                            dto.setResult_text(dto.getResult_text());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    InterruptSource.Thread.sleep((long)5000L);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            workMngDto.setWork_enddate(YDMATimeUtil.getCurrentTimeByYDFormat());
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    private void ProductRegSend(ShopProductDto dto, String json, String loginID, String password) throws Exception {
        Map<Object, Object> cookies = new HashMap();
        IShopCommonLogin is = new IShopCommonLogin(){};
        try {
            cookies = is.getTossCookies(loginID, password);
            Connection.Response rs = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/shopping-internal/merchants/products").header("Content-Type", "application/json").header("X-Merchant-Id", String.valueOf(this.merchantId)).header("X-Merchant-User-Id", String.valueOf(this.merchantUserId)).header("Content-Type", "application/json").cookies(cookies).requestBody(json).method(Connection.Method.POST).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
            String resultType = jsonObject.get("resultType").getAsString();
            if (resultType.equals("SUCCESS")) {
                JsonObject success = (JsonObject)jsonObject.get("success");
                dto.setShopprodno(success.get("id").getAsString());
            } else {
                dto.setResult_text("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328 : " + rs.body());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void DownLoadImage(ShopProductTossShoppingAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            if (dtllist.getResizeThumbnailYN().equals("Y")) {
                ShopCommon.downloadImgFile(img);
                InterruptSource.Thread.sleep((long)1000L);
                continue;
            }
            ShopCommon.downloadImgFile(img);
            InterruptSource.Thread.sleep((long)1000L);
        }
    }

    private String MakeProductJson(ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, String loginID, String password, List<String> strImages, String authkey1) throws Exception {
        String json = "";
        try {
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            ObjectMapper mapper = new ObjectMapper();
            TossProductReg tosReg = new TossProductReg();
            Map<String, String> cookies = this.BasicInfoSetting(tosReg, dtllist, dto, loginID, password, authkey1);
            this.CategorySetting(tosReg, dtllist, dto, cookies);
            this.ImageSetting(tosReg, dtllist, dto, strImages, cookies, loginID, password);
            this.ProductNameSetting(tosReg, dtllist, dto);
            resultMarketPrice = this.PriceSetting(dto, dtllist, resultMarketPrice);
            this.OptionSetting(tosReg, dtllist, dto, resultMarketPrice);
            this.DeiliverySetting(tosReg, dtllist, dto);
            this.ExchangeReturnSetting(tosReg, dtllist, dto);
            this.ExposureSetting(tosReg, dtllist, dto);
            this.GosiSetting(tosReg, dtllist, dto);
            this.GoodsRemarkSetting(tosReg, dtllist, dto);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            json = mapper.writeValueAsString((Object)tosReg);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private Map<String, String> BasicInfoSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, String loginID, String password, String authkey1) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        HashMap<String, String> cookies = new HashMap();
        try {
            cookies = is.getTossCookies(loginID, password);
            Connection.Response rs = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/my-info").cookies(cookies).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(rs.body());
            String resultType = jsonObject.get("resultType").getAsString();
            if (!resultType.equals("SUCCESS")) {
                throw new Exception("\uc0c1\ud488\ub4f1\ub85d \uc911 \uc720\uc800 \uc815\ubcf4\ub97c \ubabb \uac00\uc838\uc624\ub294 \uc5d0\ub7ec \ubc1c\uc0dd");
            }
            JsonObject success = (JsonObject)jsonObject.get("success");
            JsonArray merchantMappingArray = (JsonArray)success.get("merchantMappingInfo");
            JsonObject merchantMappingInfo = Integer.parseInt(authkey1) == 0 ? merchantMappingArray.get(0).getAsJsonObject() : merchantMappingArray.get(Integer.parseInt(authkey1) - 1).getAsJsonObject();
            JsonObject merchantUser = (JsonObject)success.get("merchantUser");
            tosReg.isTaxFree = !dto.getTax_yn().equals("0");
            tosReg.isCultureDeduction = false;
            this.merchantId = merchantMappingInfo.get("merchantId").getAsInt();
            this.merchantUserId = merchantUser.get("id").getAsInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cookies;
    }

    private void CategorySetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, Map<String, String> cookies) throws Exception {
        try {
            if (!dtllist.getShopcatno().equals("")) {
                tosReg.categoryId = Integer.parseInt(dtllist.getShopcatno());
                return;
            }
            if (dto.getShopCid() == null || dto.getShopCid().equals("")) {
                String[] parts = dto.getGmcategnm().split(">");
                if (parts.length == 0) {
                    throw new Exception("\uce74\ud14c\uace0\ub9ac \uc218\uc9d1 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [\uce74\ud14c\uace0\ub9ac\uba85 \uc5c6\uc74c]");
                }
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    JsonArray jsonArray;
                    JsonParser jsonParser = new JsonParser();
                    String element = stringArray[n2];
                    Connection.Response rs = Jsoup.connect((String)("https://api-public.toss.im/api-public/v2/shopping-internal/products/categories?name=" + URLEncoder.encode(element, "UTF-8") + "&page=0&pageSize=30")).cookies(cookies).header("Connection", "keep-alive").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                    String body = rs.body();
                    JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
                    String resultType = jsonObject.get("resultType").getAsString();
                    if (resultType.equals("SUCCESS") && (jsonArray = jsonObject.getAsJsonObject("success").getAsJsonArray("items")) != null && jsonArray.size() != 0) {
                        int i = 0;
                        while (i < jsonArray.size()) {
                            JsonObject data = (JsonObject)jsonArray.get(i);
                            if (data.get("isSellable").getAsBoolean()) {
                                int categoryId = data.get("id").getAsInt();
                                tosReg.categoryId = categoryId;
                                return;
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            } else {
                tosReg.categoryId = Integer.parseInt(dto.getShopCid());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ImageSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, List<String> strImages, Map<String, String> cookies, String loginID, String password) throws Exception {
        String imgpath = ShopCommon.getImgLocalPath(strImages.get(0));
        File jpgFile = new File(imgpath);
        FileInputStream jpgFs = new FileInputStream(jpgFile);
        try {
            int bytesRead;
            Connection.Response checkRs;
            int bytesRead2;
            Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/ml/text-logo").cookies(cookies).header("Content-Type", "multipart/form-data").method(Connection.Method.POST).data("file", jpgFile.getName(), (InputStream)jpgFs).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = (JsonObject)parser.parse(response.body());
            String resultType = jsonObject.get("resultType").getAsString();
            if (!resultType.equals("SUCCESS")) throw new Exception("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
            Connection.Response rs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products/files/upload-url").header("Content-Type", "application/json").cookies(cookies).requestBody("{\"merchantId\":" + this.merchantId + ",\"fileExtension\":\"jpeg\"}").method(Connection.Method.POST).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            jsonObject = (JsonObject)parser.parse(rs.body());
            resultType = jsonObject.get("resultType").getAsString();
            if (!resultType.equals("SUCCESS")) throw new Exception("\uc774\ubbf8\uc9c0 \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
            JsonObject success = (JsonObject)jsonObject.get("success");
            String changedImgPath = imgpath.replace(".jpg", ".jpeg");
            this.convertJpgToJpeg(imgpath, changedImgPath);
            String fileUploadUrl = success.get("fileUploadUrl").getAsString();
            File jpegFile = new File(changedImgPath);
            FileInputStream jpegFs = new FileInputStream(jpegFile);
            URL url = new URL(fileUploadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setRequestProperty("Origin", "https://shopping-seller.toss.im");
            connection.setRequestProperty("Content-Type", "image/jpeg");
            connection.setRequestProperty("Content-Length", String.valueOf(jpegFile.length()));
            OutputStream outputStream = connection.getOutputStream();
            byte[] buffer = new byte[4096];
            while ((bytesRead2 = jpegFs.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead2);
            }
            outputStream.flush();
            outputStream.close();
            jpegFs.close();
            int responseCode = connection.getResponseCode();
            YDMAStringUtil.Print("AWS \uc0c1\ud488\ub4f1\ub85d : " + responseCode);
            Image image = new Image();
            image.type = "THUMBNAIL";
            image.url = success.get("fileUrl").getAsString();
            image.order = 0;
            tosReg.images.add(image);
            if (!dtllist.getUseADImgYN().equals("Y")) {
                return;
            }
            String adImagePath = String.valueOf(imgpath.replace(".jpg", "")) + "_AD" + ".jpg";
            this.convertADImage(imgpath, adImagePath);
            File adImageFile = new File(adImagePath);
            FileInputStream adImageFs = new FileInputStream(adImageFile);
            Connection.Response adImageResponse = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/ml/text-logo").cookies(cookies).header("Content-Type", "multipart/form-data").method(Connection.Method.POST).data("file", adImageFile.getName(), (InputStream)adImageFs).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonObject adObject = (JsonObject)parser.parse(adImageResponse.body());
            if (!adObject.get("resultType").getAsString().equals("SUCCESS") || !(adObject = (JsonObject)parser.parse((checkRs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products/files/upload-url").header("Content-Type", "application/json").cookies(cookies).requestBody("{\"merchantId\":" + this.merchantId + ",\"fileExtension\":\"jpeg\"}").method(Connection.Method.POST).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute()).body())).get("resultType").getAsString().equals("SUCCESS")) return;
            JsonObject success2 = (JsonObject)adObject.get("success");
            String changedAdImgPath = adImagePath.replace(".jpg", ".jpeg");
            this.convertJpgToJpeg(adImagePath, changedAdImgPath);
            String fileUploadUrl2 = success2.get("fileUploadUrl").getAsString();
            File jpegAdFile = new File(changedAdImgPath);
            FileInputStream jpegAdFs = new FileInputStream(jpegAdFile);
            URL url2 = new URL(fileUploadUrl2);
            HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
            connection2.setDoOutput(true);
            connection2.setRequestMethod("PUT");
            connection2.setRequestProperty("Origin", "https://shopping-seller.toss.im");
            connection2.setRequestProperty("Content-Type", "image/jpeg");
            connection2.setRequestProperty("Content-Length", String.valueOf(jpegAdFile.length()));
            OutputStream outputStream2 = connection2.getOutputStream();
            byte[] buffer2 = new byte[4096];
            while ((bytesRead = jpegAdFs.read(buffer2)) != -1) {
                outputStream2.write(buffer2, 0, bytesRead);
            }
            outputStream2.flush();
            outputStream2.close();
            jpegAdFs.close();
            int responseCode2 = connection2.getResponseCode();
            YDMAStringUtil.Print("AWS \ucd94\uac00\uc0c1\ud488\ub4f1\ub85d : " + responseCode2);
            Image image2 = new Image();
            image2.type = "AD";
            image2.url = success2.get("fileUrl").getAsString();
            image2.order = 0;
            tosReg.images.add(image2);
            return;
        }
        catch (IOException iOException) {
            throw new Exception("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
    }

    private void convertJpgToJpeg(String inputImagePath, String outputImagePath) throws Exception {
        File inputFile = new File(inputImagePath);
        BufferedImage image = ImageIO.read(inputFile);
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        rgbImage.createGraphics().drawImage((java.awt.Image)image, 0, 0, null);
        File outputFile = new File(outputImagePath);
        ImageIO.write((RenderedImage)rgbImage, "jpeg", outputFile);
    }

    private void convertADImage(String inputImagePath, String adImagePath) throws Exception {
        File inputFile = new File(inputImagePath);
        BufferedImage image = ImageIO.read(inputFile);
        java.awt.Image resizeImage = image.getScaledInstance(600, 240, 4);
        BufferedImage bufferedImage = new BufferedImage(600, 240, 4);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        graphics.setBackground(Color.WHITE);
        graphics.drawImage(resizeImage, 0, 0, null);
        graphics.dispose();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", new File(adImagePath));
    }

    private void ProductNameSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) throws Exception {
        String value;
        switch (dtllist.getProdnmoutput()) {
            case "1": {
                value = dto.getGoods_nm();
                break;
            }
            case "2": {
                value = dto.getModel_nm();
                break;
            }
            case "3": {
                value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                break;
            }
            case "4": {
                value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                break;
            }
            case "5": {
                value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                break;
            }
            case "6": {
                value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                break;
            }
            default: {
                value = dto.getGoods_nm();
            }
        }
        if (!dtllist.getProdnmaddfront().equals("")) {
            value = dtllist.getProdnmaddfront().concat(value);
        }
        if (!dtllist.getProdnmaddback().equals("")) {
            value = value.concat(" ").concat(dtllist.getProdnmaddback());
        }
        if (dtllist.getProdnmafter().equals("Y")) {
            value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 99);
        }
        if (dtllist.getProdnmrand().equals("Y")) {
            value = ShopCommon.setWordRandomGenerator(value);
        }
        if (dto.getProdnmlenyn().equals("Y")) {
            tosReg.name = YDMAStringUtil.setTextStrtok(value, 99);
        } else {
            tosReg.name = value;
        }
    }

    private ResultMarketPrice PriceSetting(ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y")) {
                if (dtllist.getExpprc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpprc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = MarketPriceCalc.get().setCompliancePrice(limit_price).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcrate()).setFlatDc(dtllist.getFlatdc()).setMargin(dtllist.getMargindc()).setCommission(dtllist.getCommdc()).calculate();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\ud0dc, \ud310\ub9e4\uac00 \ub4f1\ub85d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private int getPriceAfterOptionCharges(ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, String amt, String limitPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y")) {
                if (dtllist.getExpprc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpprc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            price_cost = String.valueOf(Integer.parseInt(price_cost) + Integer.parseInt(amt));
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            ResultMarketPrice priceAfterOptionChacrge = MarketPriceCalc.get().setCompliancePrice(Integer.parseInt(limitPrice)).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcrate()).setFlatDc(dtllist.getFlatdc()).setMargin(dtllist.getMargindc()).setCommission(dtllist.getCommdc()).calculate();
            return Integer.parseInt(priceAfterOptionChacrge.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ucd94\uac00\uae08\uc561 \uc138\ud305 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void OptionSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, ResultMarketPrice resultMarketPrice) throws Exception {
        if (dto.getChar_1_nm().equals("\ub2e8\ud488")) {
            Stock stock = new Stock();
            Option option = new Option();
            option.groupName = "\uc0c1\ud488";
            option.valueName = "\ub2e8\ud488";
            stock.options.add(option);
            stock.originPrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
            stock.salePrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
            stock.remainingCount = 999;
            stock.isMainPrice = true;
            stock.order = 0;
            stock.isHide = false;
            stock.isSoldOut = false;
            tosReg.stocks.add(stock);
        } else {
            Option opt1;
            Stock stock;
            List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
            ArrayList<String> amt = new ArrayList<String>();
            ArrayList<String> option1 = new ArrayList<String>();
            ArrayList<String> option2 = new ArrayList<String>();
            ArrayList<String> option3 = new ArrayList<String>();
            ArrayList<String> limitPrice = new ArrayList<String>();
            for (ShopOptionDto opt : shopOptionDtos) {
                if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                amt.add(opt.getAmt());
                limitPrice.add(opt.getLimit_price());
                List<String> split = Arrays.asList(opt.getOptspecdes().split(":"));
                if (split.size() > 2) {
                    option1.add(split.get(0));
                    option2.add(split.get(1));
                    option3.add(split.get(2));
                    continue;
                }
                if (split.size() > 1) {
                    option1.add(split.get(0));
                    option2.add(split.get(1));
                    continue;
                }
                option1.add(split.get(0));
            }
            if (option2.size() == 0) {
                int i = 0;
                while (i < option1.size()) {
                    stock = new Stock();
                    Option option = new Option();
                    option.groupName = shopOptionDtos.get(0).getName().replaceAll("&", "");
                    option.valueName = (String)option1.get(i);
                    stock.options.add(option);
                    if (Integer.parseInt((String)amt.get(i)) > 0) {
                        stock.originPrice = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                        stock.salePrice = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                    } else {
                        stock.originPrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                        stock.salePrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                    }
                    stock.remainingCount = 999;
                    stock.isHide = false;
                    stock.isSoldOut = false;
                    stock.isMainPrice = i == 0;
                    stock.order = i;
                    tosReg.stocks.add(stock);
                    ++i;
                }
            } else if (option3.size() == 0) {
                int i = 0;
                while (i < option1.size()) {
                    stock = new Stock();
                    opt1 = new Option();
                    opt1.groupName = shopOptionDtos.get(0).getName().replaceAll("&", "").split(":")[0];
                    opt1.valueName = (String)option1.get(i);
                    Option opt2 = new Option();
                    opt2.groupName = shopOptionDtos.get(0).getName().replaceAll("&", "").split(":")[1];
                    opt2.valueName = (String)option2.get(i);
                    stock.options.add(opt1);
                    stock.options.add(opt2);
                    if (Integer.parseInt((String)amt.get(i)) > 0) {
                        stock.originPrice = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                        stock.salePrice = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                    } else {
                        stock.originPrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                        stock.salePrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                    }
                    stock.remainingCount = 999;
                    stock.isHide = false;
                    stock.isSoldOut = false;
                    stock.isMainPrice = i == 0;
                    stock.order = i;
                    tosReg.stocks.add(stock);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < option1.size()) {
                    stock = new Stock();
                    opt1 = new Option();
                    opt1.groupName = shopOptionDtos.get(0).getName().replaceAll("&", "").split(":")[0];
                    opt1.valueName = (String)option1.get(i);
                    Option opt2 = new Option();
                    opt2.groupName = shopOptionDtos.get(0).getName().replaceAll("&", "").split(":")[1];
                    opt2.valueName = (String)option2.get(i);
                    Option opt3 = new Option();
                    opt3.groupName = shopOptionDtos.get(0).getName().replaceAll("&", "").split(":")[2];
                    opt3.valueName = (String)option3.get(i);
                    if (Integer.parseInt((String)amt.get(i)) > 0) {
                        stock.originPrice = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                        stock.salePrice = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                    } else {
                        stock.originPrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                        stock.salePrice = Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                    }
                    stock.remainingCount = 999;
                    stock.isHide = false;
                    stock.isSoldOut = false;
                    stock.isMainPrice = i == 0;
                    stock.order = i;
                    tosReg.stocks.add(stock);
                    ++i;
                }
            }
        }
    }

    private void DeiliverySetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        tosReg.deliveryPolicy.deliveryMethod = "NORMAL";
        tosReg.deliveryPolicy.deliveryDeadline = "";
        tosReg.deliveryPolicy.enableGroupDelivery = dtllist.IsGroupDelivery();
        tosReg.deliveryPolicy.deliveryFeeType = "FREE";
        tosReg.deliveryPolicy.deliveryFee = 0;
        tosReg.deliveryPolicy.isJejuAndIslandsMountainsDelivery = dtllist.isCanBeDeliveredLongDistance();
        tosReg.deliveryPolicy.jejuDeliveryFee = dtllist.getJejuDeliveryFee();
        tosReg.deliveryPolicy.islandsMountainsDeliveryFee = dtllist.getLongDistanceDeliveryCost();
    }

    private void ExchangeReturnSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        tosReg.exchangeReturnPolicy.exchangeRefundLocationId = Integer.parseInt(dtllist.getRefundExchangeLocationId());
        tosReg.exchangeReturnPolicy.refundOneWayDeliveryFee = dtllist.getBothWaysDeliveryCost();
        tosReg.exchangeReturnPolicy.exchangeRoundTripDeliveryFee = dtllist.getExchangeRoundTripDeliveryFee();
        tosReg.exchangeReturnPolicy.applicationTermDescription = dtllist.getApplicationTermDescription();
        tosReg.exchangeReturnPolicy.applicationMethodDescription = dtllist.getApplicationMethodDescription();
        tosReg.exchangeReturnPolicy.applicationImpossibleCaseDescription = dtllist.getApplicationImpossibleCaseDescription();
    }

    private void ExposureSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        tosReg.exposure.description = "";
        if (!dto.getGoods_search().equals("")) {
            String[] keywords = dto.getGoods_search().split(",");
            int limit = Math.min(keywords.length, 10);
            tosReg.exposure.searchKeywords = Arrays.asList(Arrays.copyOfRange(keywords, 0, limit));
        }
    }

    private void GosiSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        tosReg.notice.categoryCode = "ETC_GOODS";
        NoticeItem item1 = new NoticeItem();
        item1.id = 397;
        item1.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item2 = new NoticeItem();
        item2.id = 399;
        item2.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item3 = new NoticeItem();
        item3.id = 401;
        item3.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item4 = new NoticeItem();
        item4.id = 403;
        item4.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item5 = new NoticeItem();
        item5.id = 405;
        item5.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        tosReg.notice.items.add(item1);
        tosReg.notice.items.add(item2);
        tosReg.notice.items.add(item3);
        tosReg.notice.items.add(item4);
        tosReg.notice.items.add(item5);
        tosReg.notice.isTemplateSaved = false;
    }

    private void GoodsRemarkSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        if (dto.getGoods_keyword().equals("shop9987")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://www.onnme.com//", "https://cafe24.poxo.com/ec01/onnme/0jJurf5+JqL2mXn6P+LWO7AOJReIvurqGIXrcbUKXpOyPc6+sV46LMYTP2N64fK/UxkTbRHFkp58If06vHlUUA==/_/"));
        } else if (dto.getGoods_keyword().equals("shop0000")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://cbw.co.kr//", "https://cafe24.poxo.com/ec01/kdh0201/EjglQcnyYl9oLKpqUS6wZgXi8sojGAGtEWIWWXL2plRUVd7qyEd9+lcioi6YTYl8+M0/iGFZrQSxc8jTkkjqtw==/_/"));
        } else if (dto.getGoods_keyword().equals("shop9986")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://xn--jt2by0pl8b7va956c.kr", "https://ydinc.cafe24.com"));
        }
        String remark = "";
        String addDetailPlus = "";
        String body = dtllist.getProddetailfront().concat(dto.getGoods_remarks()).replace("&#39;", "");
        remark = dtllist.getProddetailoutput().equals("1") ? body.concat(dtllist.getProddetailback()).replace("&#39;", "") : body;
        if (dtllist.getRemarktop().equals("Y")) {
            remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat(dto.getGoods_remarks()).replace("&#39;", "");
        }
        if (dtllist.getDetailkeywordb().equals("Y")) {
            addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
        }
        if (dtllist.getDetailproductcodeb().equals("Y")) {
            addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
        }
        if (dtllist.getDetailproductnameb().equals("Y")) {
            addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductNameL() + dto.getGoods_nm() + dtllist.getDetailProductNameR();
        }
        String headHtmlByToss = "<p id=\"companygoodsCD\" style=\"display: none;\">" + dto.getCompayny_goods_cd() + "</p>";
        Image image = new Image();
        image.type = "DESCRIPTION_HTML";
        image.html = String.valueOf(headHtmlByToss) + remark + addDetailPlus;
        image.order = 0;
        tosReg.images.add(image);
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    private static class DeliveryPolicy {
        private String deliveryMethod;
        private String deliveryDeadline;
        private boolean enableGroupDelivery;
        private String deliveryLocationId;
        private String deliveryFeeType;
        private int deliveryFee;
        private String minimumPurchasePrice;
        private boolean isJejuAndIslandsMountainsDelivery;
        private int jejuDeliveryFee;
        private int islandsMountainsDeliveryFee;

        private DeliveryPolicy() {
        }
    }

    private static class ExchangeReturnPolicy {
        private String applicationImpossibleCaseDescription;
        private int exchangeRefundLocationId;
        private int refundOneWayDeliveryFee;
        private int exchangeRoundTripDeliveryFee;
        private String applicationTermDescription;
        private String applicationMethodDescription;

        private ExchangeReturnPolicy() {
        }
    }

    private static class Exposure {
        private List<String> searchKeywords = new ArrayList<String>();
        private String description;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String serialNumber;

        private Exposure() {
        }
    }

    private static class Image {
        private String type;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String url;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String html;
        private int order;

        private Image() {
        }
    }

    private static class Notice {
        private String categoryCode;
        private List<NoticeItem> items = new ArrayList<NoticeItem>();
        private boolean isTemplateSaved;

        private Notice() {
        }
    }

    private static class NoticeItem {
        private int id;
        private String content;

        private NoticeItem() {
        }
    }

    private static class Option {
        private String groupName;
        private String valueName;

        private Option() {
        }
    }

    private static class Stock {
        private List<Option> options = new ArrayList<Option>();
        private int originPrice;
        private int salePrice;
        private int remainingCount;
        private boolean isMainPrice;
        private int order;
        private boolean isHide;
        private boolean isSoldOut;

        private Stock() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class TossProductReg {
        private String name;
        private List<Stock> stocks = new ArrayList<Stock>();
        private int categoryId;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String brandName;
        private boolean isTaxFree;
        private boolean isCultureDeduction;
        private DeliveryPolicy deliveryPolicy = new DeliveryPolicy();
        private ExchangeReturnPolicy exchangeReturnPolicy = new ExchangeReturnPolicy();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String badge;
        private Exposure exposure = new Exposure();
        private List<Object> certifications = new ArrayList<Object>();
        private Notice notice = new Notice();
        private List<Image> images = new ArrayList<Image>();

        private TossProductReg() {
        }
    }
}

