/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.wemakeprice;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.Yd.common.YDMAProgressBar;
import com.kdjsystem.mlink.Yd.common.YDMATimeUtil;
import com.kdjsystem.mlink.Yd.data.dao.QuestListDto;
import com.kdjsystem.mlink.shop.data.wemakeprice.ShopWemarketQuestionContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ShopWemarketQuestionEnrollment
extends ShopWemarketQuestionContext {
    @Override
    public boolean search(String URL2, String startdt, String enddt) throws Exception {
        return false;
    }

    @Override
    public List<QuestListDto> excute(List<QuestListDto> prodList) throws Exception {
        ArrayList<QuestListDto> dtoArray = new ArrayList<QuestListDto>();
        for (QuestListDto dto : prodList) {
            this.sendAnswer(dto, dtoArray);
        }
        return dtoArray;
    }

    private void sendAnswer(QuestListDto dto, List<QuestListDto> dtoArray) throws Exception {
        try {
            String json = "{ \"qnaSeq\": " + dto.getQnaseq() + ", \"answer\": \"" + dto.getAnsws().replace("\r\n", "\\n") + "\" }";
            Connection.Response response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/sendAnswer").header("apiKey", dto.getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = response.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            int rscode = jsonObject.get("resultCode").getAsInt();
            if (rscode == 200) {
                dto.setQnaseq(dto.getQnaseq());
                dto.setShopid(dto.getShopid());
                dto.setShopnm(dto.getShopnm());
                dto.setSenddt(YDMATimeUtil.getCurrentTime());
                dto.setCode("200");
                dtoArray.add(dto);
            } else if (rscode == 422) {
                YDMAProgressBar.get().setValue(jsonObject.get("error").getAsString(), 0);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \ubb38\uc758 \ub2f5\ubcc0 \ub4f1\ub85d \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCustomerInquiryAnswer(QuestListDto dto, List<QuestListDto> dtoArray, Map<String, String> cookies) throws IOException {
        String json = "{\"chatSeq\":\"" + dto.getQnaseq() + "\",\"comment\":\"" + dto.getAnsws() + "\",\"commentType\":\"TEXT\"}";
        JsonParser jsonParser = new JsonParser();
        Connection.Response rs = Jsoup.connect((String)"https://backoffice-gateway.wemakeprice.com/api/board/v2/wtalk/partner/chats/answers").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(json).header("Origin", "https://wpartner.wemakeprice.com").header("Content-Type", "application/json;charset=UTF-8").referrer("https://wpartner.wemakeprice.com/").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        String body = rs.body();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
        JsonObject data = (JsonObject)jsonObject.get("data");
        String replySeq = data.get("replySeq").getAsString();
        if (replySeq != null) {
            dto.setQnaseq(dto.getQnaseq());
            dto.setShopid(dto.getShopid());
            dto.setShopnm(dto.getShopnm());
            dto.setSenddt(YDMATimeUtil.getCurrentTime());
            dto.setCode("200");
            dtoArray.add(dto);
        } else {
            dto.setCode(jsonObject.get("returnMsg").getAsString());
            dto.setMessage(jsonObject.get("returnMsg").getAsString());
        }
    }

    private void setProductInquiryAnswer(QuestListDto dto, List<QuestListDto> dtoArray, Map<String, String> cookies) throws IOException {
        JsonObject obj = new JsonObject();
        obj.addProperty("comment", dto.getAnsws().replaceAll("\r\n", "\n"));
        JsonArray array = new JsonArray();
        obj.add("imageSeqs", (JsonElement)array);
        obj.addProperty("inquirySeq", dto.getQnaseq());
        String cfr_ignored_0 = "{\"comment\":\"" + dto.getAnsws().replaceAll("\r\n", "\n") + "\",\"imageSeqs\":[],\"inquirySeq\":" + dto.getQnaseq() + "}";
        Connection.Response rs = Jsoup.connect((String)"https://backoffice-gateway.wemakeprice.com/api/board/partner/inquiries/answers").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").requestBody(obj.toString()).header("Origin", "https://wpartner.wemakeprice.com").header("Content-Type", "application/json;charset=UTF-8").referrer("https://wpartner.wemakeprice.com/").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        String body = rs.body();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
        JsonObject data = (JsonObject)jsonObject.get("data");
        String inquiryAnswerSeq = data.get("inquiryAnswerSeq").getAsString();
        if (inquiryAnswerSeq != null) {
            dto.setQnaseq(dto.getQnaseq());
            dto.setShopid(dto.getShopid());
            dto.setShopnm(dto.getShopnm());
            dto.setSenddt(YDMATimeUtil.getCurrentTime());
            dto.setCode("200");
            dtoArray.add(dto);
        } else {
            dto.setCode(jsonObject.get("returnMsg").getAsString());
            dto.setMessage(jsonObject.get("returnMsg").getAsString());
        }
    }

    public static class qnaComment {
        String comment;
        List<String> imageSeqs = new ArrayList<String>();
        String inquirySeq;
    }
}

