/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.onnme;

import com.kdjsystem.mlink.shop.common.ShopCommon;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class OnnmeImageDownloader {
    private WebDriver driver;

    public OnnmeImageDownloader(WebDriver driver) {
        this.driver = driver;
    }

    public void downloadImage(String imageUrl, Label label) {
        Image imgValue = null;
        try {
            if (imageUrl != null) {
                this.driver.get(imageUrl);
                WebElement imageElement = this.driver.findElement(By.tagName((String)"img"));
                byte[] imageBytes = (byte[])imageElement.getScreenshotAs(OutputType.BYTES);
                ByteArrayInputStream in = new ByteArrayInputStream(imageBytes);
                BufferedImage image = ImageIO.read(in);
                if (image != null) {
                    image = ShopCommon.resize(image, 120, 120);
                    ImageData data = ShopCommon.convertToSWT2b(image);
                    Display display = Display.getDefault();
                    imgValue = new Image((Device)display, data);
                    label.setImage(imgValue);
                } else {
                    System.err.println("\uc774\ubbf8\uc9c0 \uac00\uc838\uc624\uae30 \uc2e4\ud328 : " + imageUrl);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

