/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.cloudinary.Cloudinary;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.api.exceptions.ApiException;
import com.cloudinary.utils.ObjectUtils;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudinaryUsageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CloudinaryUsageService.class);
    private static final String KEY_CLOUD_NAME = "cloud_name";
    private static final String KEY_API_KEY = "api_key";
    private static final String KEY_API_SECRET = "api_secret";
    private static final String KEY_SECURE = "secure";
    private static final String USAGE_KEY_CREDITS = "credits";
    private static final String CREDITS_KEY_PERCENT = "used_percent";
    private final Cloudinary cloudinary;

    public CloudinaryUsageService(String cloudName, String apiKey, String apiSecret) {
        this.cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{KEY_CLOUD_NAME, cloudName, KEY_API_KEY, apiKey, KEY_API_SECRET, apiSecret, KEY_SECURE, true}));
    }

    public Optional<Double> getUsagePercentage() {
        try {
            ApiResponse usage = this.cloudinary.api().usage(ObjectUtils.emptyMap());
            Map creditsMap = (Map)usage.get(USAGE_KEY_CREDITS);
            if (creditsMap == null) {
                LOGGER.warn("Cloudinary \uc0ac\uc6a9\ub7c9 \uc751\ub2f5\uc5d0 '{}' \ud0a4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4: {}", (Object)USAGE_KEY_CREDITS, (Object)usage);
                return Optional.of(-1.0);
            }
            Object percentObj = creditsMap.get(CREDITS_KEY_PERCENT);
            if (percentObj == null) {
                LOGGER.warn("'{}' \ud0a4\uac00 credits \ub9f5\uc5d0 \uc5c6\uc2b5\ub2c8\ub2e4: {}", (Object)CREDITS_KEY_PERCENT, (Object)creditsMap);
                return Optional.of(-1.0);
            }
            double percent = Double.parseDouble(percentObj.toString());
            return Optional.of(percent);
        }
        catch (ApiException apiEx) {
            LOGGER.error("Cloudinary API \ud638\ucd9c \uc2e4\ud328", (Throwable)apiEx);
            return Optional.of(-1.0);
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error("Cloudinary \uc124\uc815 \ud30c\ub77c\ubbf8\ud130 \uc624\ub958", (Throwable)iae);
            return Optional.of(-1.0);
        }
        catch (Exception ex) {
            LOGGER.error("Cloudinary \uc0ac\uc6a9\ub7c9 \uc870\ud68c \uc911 \uc608\uae30\uce58 \uc54a\uc740 \uc624\ub958 \ubc1c\uc0dd", (Throwable)ex);
            return Optional.of(-1.0);
        }
    }

    public void deleteImagesOlderThanTenMinutes() {
        String cutoffIso = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(10L).format(DateTimeFormatter.ISO_INSTANT);
        try {
            ApiResponse result = this.cloudinary.search().expression("resource_type:image AND created_at<\"" + cutoffIso + "\"").maxResults(Integer.valueOf(500)).execute();
            List resources = (List)result.get((Object)"resources");
            for (Map res : resources) {
                String publicId = (String)res.get("public_id");
                this.cloudinary.uploader().destroy(publicId, ObjectUtils.emptyMap());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

