/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.CloudinaryApiInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.mlink.MLinkAPI;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class EasyCloudUsageService {
    private static EasyCloudUsageService daoInstance = new EasyCloudUsageService();
    private static final String BASE_URL = "https://mypage.iteasy.co.kr/cloud/main/";
    private static final String BASE_ID = "kdjsystem";
    private static final String BASE_PW = "rnrdyd7564!!";

    public static EasyCloudUsageService get() {
        return daoInstance;
    }

    public double fetchTraffic(String ipaddr) {
        double useTraff = 0.0;
        IShopCommonLogin l = new IShopCommonLogin(){};
        Map<Object, Object> loginCookies = new HashMap();
        try {
            loginCookies = l.loginCookie(BASE_ID, BASE_PW, "EasyCloud", true, "");
            Connection.Response response1 = Jsoup.connect((String)"https://cloud.iteasy.co.kr/server/panel/list/ajax01").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36").referrer("https://cloud.iteasy.co.kr/server/panel/page01").cookies(loginCookies).data("page", "1").data("sch_col", "B.kvp_ip").data("sch_text", "").method(Connection.Method.POST).ignoreContentType(true).execute();
            String body1 = response1.body();
            String cleanHtml = "<table>" + body1.replace("\\/", "/") + "</table>";
            Document doc = Jsoup.parse((String)cleanHtml);
            Elements rows = doc.select("tr");
            String val = "";
            for (Element row : rows) {
                Matcher matcher;
                String currentIp;
                Elements cells = row.select("td");
                if (cells.size() < 8 || !(currentIp = ((Element)cells.get(2)).text().trim()).equals(ipaddr) || !(matcher = Pattern.compile("\\d+(\\.\\d+)?").matcher(((Element)cells.get(7)).text())).find()) continue;
                val = matcher.group();
            }
            if (!val.equals("")) {
                useTraff = Double.parseDouble(val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return useTraff;
    }

    public void chk_EasyCloudUsageParser() throws Exception {
        CloudinaryApiInfoDto dto = ShopCommonDao.get().getEasyCloudUsage();
        if (this.isEnabled(dto) && !dto.getCloudname().equals("mlink.kdjsystem.com")) {
            List<String> allIps = EasyCloudUsageService.resolveAllIps(dto.getCloudname());
            String ipaddr = allIps.get(0);
            double useTraff = this.fetchTraffic(ipaddr);
            String use_yn = "Y";
            if (useTraff >= (double)dto.getUse_limit()) {
                use_yn = "N";
            }
            if (useTraff == 0.0) {
                use_yn = "N";
            }
            ShopCommonDao.get().updateEasyCloudUsageApisecret(dto.getSeq(), dto.getCloudname(), Double.toString(useTraff), use_yn);
        }
    }

    public void chk_EasyCloudUsageAPI() throws Exception {
        List<CloudinaryApiInfoDto> list = ShopCommonDao.get().getEasyCloudUsage2();
        for (CloudinaryApiInfoDto dto : list) {
            CloudinaryApiInfoDto dto2;
            if (!this.isEnabled(dto) || (dto2 = MLinkAPI.get().findEasyCloudStatus(dto)).getApikey() == null) continue;
            String use_yn = "Y";
            if (Double.parseDouble(dto2.getApisecret()) >= (double)dto2.getUse_limit()) {
                use_yn = "N";
            }
            if (Double.parseDouble(dto2.getApisecret()) == 0.0) {
                use_yn = "N";
            }
            ShopCommonDao.get().updateEasyCloudUsageApisecret(dto2.getSeq(), dto2.getCloudname(), dto2.getApisecret(), use_yn);
        }
    }

    public boolean isEnabled(CloudinaryApiInfoDto dto) {
        return dto != null && dto.getCloudname() != null && !dto.getCloudname().isEmpty() && dto.getApikey() != null && !dto.getApikey().isEmpty() && dto.getApisecret() != null && !dto.getApisecret().isEmpty();
    }

    public static List<String> resolveAllIps(String urlString) throws MalformedURLException, UnknownHostException {
        String host = EasyCloudUsageService.extractHost(urlString);
        InetAddress[] addrs = InetAddress.getAllByName(host);
        return Arrays.stream(addrs).map(InetAddress::getHostAddress).collect(Collectors.toList());
    }

    private static String extractHost(String urlOrHost) throws MalformedURLException {
        URL url;
        String host;
        Object s = urlOrHost.trim();
        if (!((String)s).matches("^[a-zA-Z][a-zA-Z0-9+\\-.]*://.*")) {
            s = "http://" + (String)s;
        }
        if ((host = (url = new URL((String)s)).getHost()) == null || host.isEmpty()) {
            throw new MalformedURLException("\ud638\uc2a4\ud2b8\ub97c \ucd94\ucd9c\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + urlOrHost);
        }
        return host;
    }
}

