/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.kdjsystem.mlink.shop.ImageUpload.CleanImageService;
import com.kdjsystem.mlink.shop.ImageUpload.UploadException;
import com.kdjsystem.mlink.shop.dao.CloudinaryApiInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.tot.common.FtpUtil;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUploadService
implements CleanImageService {
    private static final Logger logger = LoggerFactory.getLogger(FtpUploadService.class);
    private static final long MONTHLY_LIMIT_BYTES = FtpUploadService.loadMonthlyLimit();
    private static final double BYTE_TO_MB = 1048576.0;
    private final ShopCommonDao dao = ShopCommonDao.get();
    private static CloudinaryApiInfoDto apiInfo = null;
    private long usedBytes;
    private long remainingBytes;

    private static long loadMonthlyLimit() {
        String raw = null;
        try {
            raw = YDMAProperties.getInstance().getAppProperty("ftp.user_limit");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (raw == null || raw.isEmpty()) {
            logger.warn("ftp.user_limit \uc124\uc815 \ub204\ub77d \uae30\ubcf8 10G \uc0ac\uc6a9");
            raw = "10G";
        }
        try {
            return FtpUploadService.parseSizeToBytes(raw);
        }
        catch (NumberFormatException nfe) {
            logger.error("ftp.user_limit='{}' \ud30c\uc2f1 \uc2e4\ud328  \uae30\ubcf8 10G \uc0ac\uc6a9", (Object)raw, (Object)nfe);
            return 0x280000000L;
        }
    }

    private static long parseSizeToBytes(String sizeStr) {
        String s = sizeStr.trim().toUpperCase();
        long multiplier = 1L;
        if (s.endsWith("G")) {
            multiplier = 0x40000000L;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("M")) {
            multiplier = 0x100000L;
            s = s.substring(0, s.length() - 1);
        } else if (s.endsWith("K")) {
            multiplier = 1024L;
            s = s.substring(0, s.length() - 1);
        }
        long value = Long.parseLong(s);
        return value * multiplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String upload(Path localFile) throws UploadException {
        FtpUploadService ftpUploadService = this;
        synchronized (ftpUploadService) {
            this.refreshUsage();
            long fileSize = this.getFileSize(localFile);
            if (fileSize > this.remainingBytes) {
                throw this.createLimitExceededException(fileSize);
            }
            String remoteDir = this.buildRemoteDir();
            String remoteName = this.uploadFileToFtp(localFile, remoteDir);
            this.deductUsage(fileSize);
            return this.buildFileUrl(remoteDir, remoteName);
        }
    }

    private void refreshUsage() throws UploadException {
        try {
            apiInfo = this.dao.getEasyCloudInfo();
            this.usedBytes = Long.parseLong(apiInfo.getApikey());
        }
        catch (Exception e) {
            logger.error("\uc0ac\uc6a9\ub7c9 \uac00\ub2a5 \uc11c\ubc84 \uc815\ubcf4 \uc870\ud68c \uc2e4\ud328 \uc5c5\ub85c\ub4dc\ub97c \uc911\ub2e8\ud569\ub2c8\ub2e4.", (Throwable)e);
            throw new UploadException("\uc0ac\uc6a9\ub7c9 \uac00\ub2a5 \uc11c\ubc84 \uc815\ubcf4 \uc870\ud68c \uc2e4\ud328 \uc5c5\ub85c\ub4dc\ub97c \uc911\ub2e8\ud569\ub2c8\ub2e4.", e);
        }
        this.remainingBytes = MONTHLY_LIMIT_BYTES - this.usedBytes;
    }

    private long getFileSize(Path file) throws UploadException {
        try {
            return Files.size(file);
        }
        catch (IOException e) {
            logger.error("\ud30c\uc77c \ud06c\uae30 \ud655\uc778 \uc2e4\ud328: {}", (Object)file, (Object)e);
            throw new UploadException("\ud30c\uc77c \ud06c\uae30 \ud655\uc778 \uc2e4\ud328: " + String.valueOf(file), e);
        }
    }

    private UploadException createLimitExceededException(long fileSize) {
        double remMb = (double)this.remainingBytes / 1048576.0;
        double reqMb = (double)fileSize / 1048576.0;
        long limitGb = MONTHLY_LIMIT_BYTES / 0x40000000L;
        YearMonth currentMonth = YearMonth.now();
        String monthStr = currentMonth.format(DateTimeFormatter.ofPattern("yyyy-MM"));
        String msg = String.format("[%s] \uc6d4 %dGB \ud55c\ub3c4 \ucd08\uacfc (\ub0a8\uc740: %,.8f MB, \uc694\uccad: %,.8f MB)", monthStr, limitGb, remMb, reqMb);
        logger.error(msg);
        return new UploadException(msg);
    }

    private String buildRemoteDir() {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        String userId = YDMASessonUtil.getUserInfo().getUserId();
        return compno + userId;
    }

    private String uploadFileToFtp(Path localFile, String remoteDir) throws UploadException {
        try {
            return FtpUtil.uploadnCreateDir(remoteDir, localFile.toString(), localFile.getFileName().toString(), apiInfo.getCloudname());
        }
        catch (Exception e) {
            logger.error("FTP \uc5c5\ub85c\ub4dc \uc2e4\ud328: {} \u2192 {}", new Object[]{localFile, remoteDir, e});
            throw new UploadException("FTP \uc5c5\ub85c\ub4dc \uc2e4\ud328: " + String.valueOf(localFile), e);
        }
    }

    private void deductUsage(long uploadedBytes) throws UploadException {
        long newTotal = this.usedBytes + uploadedBytes;
        try {
            this.dao.updateEasyCloudUsage(apiInfo.getSeq(), apiInfo.getCloudname(), Long.toString(uploadedBytes));
            this.usedBytes = newTotal;
            this.remainingBytes = MONTHLY_LIMIT_BYTES - newTotal;
        }
        catch (Exception e) {
            throw new UploadException("\uc0ac\uc6a9\ub7c9 \ucc28\uac10 \uc2e4\ud328", e);
        }
    }

    private String buildFileUrl(String remoteDir, String remoteName) {
        String ftpWebPath;
        try {
            ftpWebPath = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
        }
        catch (Exception e) {
            logger.warn("ftp.webpath \ud504\ub85c\ud37c\ud2f0 \ub85c\ub4dc \uc2e4\ud328, \uae30\ubcf8\uac12 \uc0ac\uc6a9", (Throwable)e);
            ftpWebPath = "";
        }
        return String.format("http://%s/%s/%s/%s", apiInfo.getCloudname(), ftpWebPath, remoteDir, remoteName);
    }

    public void deleteFilesFromFtp(String remoteDir, List<String> remoteFiles) throws UploadException {
        if (remoteFiles == null || remoteFiles.isEmpty()) {
            return;
        }
        String host = apiInfo.getCloudname();
        ArrayList<String> failed = new ArrayList<String>();
        for (String file : remoteFiles) {
            try {
                FtpUtil.deleteFtp(remoteDir, file, host);
            }
            catch (Exception ex) {
                logger.error("FTP \uc0ad\uc81c \uc2e4\ud328: {} \u2192 {} (host={})", new Object[]{remoteDir, file, host, ex});
                failed.add(file);
            }
        }
        if (!failed.isEmpty()) {
            String msg = String.format("FTP \uc0ad\uc81c \uc2e4\ud328 \ud30c\uc77c(%d\uac1c): %s", failed.size(), failed);
            throw new UploadException(msg);
        }
    }
}

