/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDtoList;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.swt.SWTResourceManager;

public class CallServiceStatus {
    public static final String \ubbf8\ucc98\ub9ac = "Y";
    public static final String \ucc98\ub9ac\uc644\ub8cc = "N";
    String result = "";
    private static CallServiceStatus instance = new CallServiceStatus();
    private List<OrderCodeMapperDto> items = new ArrayList<OrderCodeMapperDto>();

    private CallServiceStatus() {
    }

    public static CallServiceStatus getInstance() {
        if (CallServiceStatus.instance.items.size() == 0) {
            instance.bind();
        }
        return instance;
    }

    public static String validate(String status2, String changeStatus) {
        String ret = "0";
        return ret;
    }

    public String findCode(String code) {
        String result = "";
        return result;
    }

    public Color findColor(String code) {
        Color bgColor = null;
        switch (code) {
            case "Y": {
                bgColor = SWTResourceManager.getColor(255, 255, 0);
                break;
            }
            case "N": {
                bgColor = SWTResourceManager.getColor(255, 248, 191);
                break;
            }
            default: {
                bgColor = SWTResourceManager.getColor(1);
            }
        }
        return bgColor;
    }

    public CodeItem findCode(String shopcd, String mall_code) {
        CodeItem item = new CodeItem();
        OrderCodeMapperDto dto = (OrderCodeMapperDto)this.items.stream().filter(p -> p.getShopid().equals(shopcd) && p.mall_code.equals(mall_code)).collect(Collectors.toList()).get(0);
        item.setCode(dto.code);
        item.setName(dto.getName());
        return item;
    }

    public String findCodeString(String shopcd, String mall_code) {
        String result = "";
        for (OrderCodeMapperDto dto : this.items) {
            if (!dto.getShopid().equals(shopcd) || !dto.getMall_code().trim().equals(mall_code)) continue;
            result = dto.getCode();
            break;
        }
        if (result == "") {
            result = mall_code;
        }
        return result;
    }

    public void setStatusShopMst(String code, ShopOrderMstDtoList list) {
        for (ShopOrderMstDto dto : list.getList()) {
            dto.setOrder_status(code);
        }
    }

    public void setMappingStatusShopMst(String shopID, ShopOrderMstDtoList list) {
        for (ShopOrderMstDto dto : list.getList()) {
            String code = this.findCodeString(shopID, dto.getOrder_status());
            dto.setOrder_status(code);
        }
    }

    public CallServiceStatus bind() {
        this.items.clear();
        this.setCodeMapper();
        return this;
    }

    public void setCodeMapper() {
        block12: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append(" SELECT \r\n");
                    sql.append("IFNULL(SHOPID,  '' ) AS SHOPID,  \r\n");
                    sql.append("IFNULL(CODE,  '' ) AS CODE,  \r\n");
                    sql.append("IFNULL(MALL_CODE,  '' ) AS MALL_CODE,  \r\n");
                    sql.append("IFNULL(NAME,  '' ) AS NAME  \r\n");
                    sql.append(" FROM shopordstatus  \r\n");
                    pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    YDMAStringUtil.Print("[ShopOrderStatus]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        OrderCodeMapperDto dto = new OrderCodeMapperDto();
                        dto.setShopid(rs.getString("SHOPID"));
                        dto.setCode(rs.getString("CODE"));
                        dto.setMall_code(rs.getString("MALL_CODE"));
                        dto.setName(rs.getString("NAME"));
                        this.items.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class OrderCodeMapperDto {
        private String shopid;
        private String code;
        private String name;
        private String mall_code;

        OrderCodeMapperDto() {
        }

        public String getShopid() {
            return this.shopid;
        }

        public void setShopid(String shopid) {
            this.shopid = shopid;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMall_code() {
            return this.mall_code;
        }

        public void setMall_code(String mall_code) {
            this.mall_code = mall_code;
        }

        public CallServiceStatus getInstance() {
            return instance;
        }
    }

    public static class csDetail {
        String no;
        String name;
        String value;

        public String getNo() {
            return this.no;
        }

        public void setNo(String no) {
            this.no = no;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

