/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.ChromePath;
import com.kdjsystem.mlink.shop.common.DriverPool;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromeExtention {
    private Path downloadPath;
    private ChromeDriverService driverService = null;
    private ChromeDriver driver;
    private String tempProfileDir;
    int checkVer = ChromePath.getChromePath();
    Map<Integer, DriverPool> driverPools = new HashMap<Integer, DriverPool>();
    public static ChromeExtention instance = new ChromeExtention();

    private ChromeExtention() {
    }

    public static ChromeExtention getInstace() {
        return instance;
    }

    public ChromeExtention setHeadlessMode(boolean headless_mode) {
        return this;
    }

    public ChromeExtention setFileDown(boolean isFileDown) {
        return this;
    }

    public ChromeDriver getDriver() {
        return this.getDriver(true);
    }

    public ChromeDriver getDriverForAuctionGmarket() {
        return this.getDriverForAuctionGmarket(true);
    }

    private void setupChromeDriver() {
        if (this.checkVer > 114) {
            ChromePath.downloadDriver(this.checkVer);
        } else {
            this.downgradeCheck();
            WebDriverManager.chromedriver().setup();
        }
    }

    private void downgradeCheck() {
        File fileToDelete = new File(ChromePath.directoryCheck() + "\\chromedriver.exe");
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }

    private ChromeOptions setupChromeOptions(boolean isHeadless, boolean isEsm) {
        ChromeOptions options = new ChromeOptions();
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.setExperimentalOption("excludeSwitches", Arrays.asList("enable-automation"));
        options.addArguments(new String[]{"--emlink"});
        HashMap<String, Boolean> prefs = new HashMap<String, Boolean>();
        prefs.put("credentials_enable_service", false);
        prefs.put("profile.password_manager_enabled", false);
        options.setExperimentalOption("prefs", prefs);
        if (isEsm) {
            String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36";
            options.addArguments(new String[]{"--user-agent=" + userAgent});
            options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        }
        if (isHeadless) {
            options.addArguments(new String[]{"--headless=new"});
        } else {
            options.addArguments(new String[]{"--lang=ko_KR"});
            options.addArguments(new String[]{"--start-maximized"});
        }
        return options;
    }

    public ChromeDriver getDriver(boolean isHeadless) {
        this.setupChromeDriver();
        this.driver = new ChromeDriver(this.setupChromeOptions(isHeadless, false));
        return this.driver;
    }

    public ChromeDriver getDriverForAuctionGmarket(boolean isHeadless) {
        this.setupChromeDriver();
        this.driver = new ChromeDriver(this.setupChromeOptions(isHeadless, true));
        return this.driver;
    }

    public ChromeDriver getDriver(boolean isHeadless, boolean fileDown) {
        this.setupChromeDriver();
        HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
        chromePrefs.put("download.default_directory", this.downloadPath);
        chromePrefs.put("download.directory_upgrade", true);
        chromePrefs.put("download.prompt_for_download", false);
        chromePrefs.put("browser.set_download_behavior", "{behavior:\"allow\"}");
        ChromeOptions options = new ChromeOptions();
        options.setExperimentalOption("prefs", chromePrefs);
        options.addArguments(new String[]{"--test-type"});
        options.addArguments(new String[]{"--disable-extension"});
        options.addArguments(new String[]{"--emlink"});
        if (isHeadless) {
            options.addArguments(new String[]{"--headless=new"});
            options.addArguments(new String[]{"user-agent=Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36"});
            options.addArguments(new String[]{"--window-position=-2400,-2400"});
            options.addArguments(new String[]{"disable-gpu"});
            options.addArguments(new String[]{"disable-infobars"});
            options.addArguments(new String[]{"--disable-extensions"});
        }
        if (fileDown) {
            try {
                this.downloadPath = this.createDirectory();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.driverService = ChromeDriverService.createDefaultService();
        this.driver = new ChromeDriver(this.driverService, options);
        return this.driver;
    }

    public Path getDownloadPath() {
        return this.downloadPath;
    }

    public File getLastModifiedFile() {
        String strPath = this.getDownloadPath().toAbsolutePath().toString();
        File[] files = new File(strPath).listFiles();
        File lastFile = Arrays.stream(files).reduce((a, b) -> Long.valueOf(a.lastModified()).compareTo(b.lastModified()) > 0 ? a : b).get();
        return lastFile;
    }

    public String getLastFileAbsolutePath() {
        String strPath = this.downloadPath.toAbsolutePath().toString();
        return strPath.concat("\\").concat(this.getLastModifiedFile().getName());
    }

    public Path createDirectory() throws IOException {
        Path basePath = Paths.get("", new String[0]).toAbsolutePath();
        String currentDate = YDMATimeUtil.getCurrentTime().substring(0, 8);
        this.downloadPath = basePath.resolve("EXCEL_" + currentDate);
        if (!Files.exists(this.downloadPath, new LinkOption[0])) {
            this.downloadPath = Files.createDirectory(this.downloadPath, new FileAttribute[0]);
        }
        return this.downloadPath;
    }

    public void crome_headless_filedown(ChromeDriver driver) throws ClientProtocolException, IOException {
        this.downloadPath = this.createDirectory();
        HashMap<String, Object> commandParams = new HashMap<String, Object>();
        commandParams.put("cmd", "Page.setDownloadBehavior");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("behavior", "allow");
        params.put("downloadPath", this.downloadPath.toAbsolutePath().toString());
        params.put("cmd", "Page.setDownloadBehavior");
        commandParams.put("params", params);
        ObjectMapper objectMapper = new ObjectMapper();
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        String command = objectMapper.writeValueAsString(commandParams);
        String u = this.driverService.getUrl().toString() + "/session/" + String.valueOf(driver.getSessionId()) + "/chromium/send_command";
        HttpPost request2 = new HttpPost(u);
        request2.addHeader("content-type", "application/json");
        request2.setEntity((HttpEntity)new StringEntity(command));
        httpClient.execute((HttpUriRequest)request2);
    }

    public ChromeDriver getDriverUseTemp(boolean isHeadless) {
        this.setupChromeDriver();
        this.tempProfileDir = this.createTempProfileDirectory();
        this.setupChromeOptionsUsetemp(this.tempProfileDir, isHeadless, false);
        this.addShutdownHook(this.tempProfileDir, this.driver);
        return this.driver;
    }

    private String createTempProfileDirectory() {
        String tempProfileDir = System.getProperty("java.io.tmpdir") + "mLinkchrome\\chrome-profile-" + UUID.randomUUID().toString();
        try {
            Files.createDirectories(Paths.get(tempProfileDir, new String[0]), new FileAttribute[0]);
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131\ub428: " + tempProfileDir);
        }
        catch (IOException e) {
            YDMAStringUtil.Print("\uc784\uc2dc \ub514\ub809\ud1a0\ub9ac \uc0dd\uc131 \uc2e4\ud328: " + e.getMessage());
            e.printStackTrace();
        }
        return tempProfileDir;
    }

    private ChromeOptions setupChromeOptionsUsetemp(String tempProfileDir, boolean isHeadless, boolean isEsm) {
        ChromeOptions options = new ChromeOptions();
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.addArguments(new String[]{"--disable-gpu"});
        options.addArguments(new String[]{"--disable-extensions"});
        options.addArguments(new String[]{"--emlink"});
        options.addArguments(new String[]{"--user-data-dir=" + tempProfileDir});
        String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.128 Safari/537.36";
        options.addArguments(new String[]{"User-Agent=" + userAgent});
        if (isEsm) {
            options.addArguments(new String[]{"--disable-blink-features=AutomationControlled"});
        }
        if (isHeadless) {
            options.addArguments(new String[]{"--headless=new"});
            options.addArguments(new String[]{"--window-position=-2400,-2400"});
            this.driver = new ChromeDriver(options);
        } else {
            options.addArguments(new String[]{"--lang=ko_KR"});
            this.driver = new ChromeDriver(options);
            this.driver.manage().window().maximize();
        }
        return options;
    }

    public void addShutdownHook(String chromeProfiledeleteFolder, ChromeDriver driver) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            YDMAStringUtil.Print("\uc560\ud50c\ub9ac\ucf00\uc774\uc158 \uc885\ub8cc, chrome profile \ub514\ub809\ud1a0\ub9ac \uc815\ub9ac \uc911: " + chromeProfiledeleteFolder);
            try {
                if (driver != null) {
                    driver.quit();
                    System.gc();
                    YDMAStringUtil.Print("ChromeDriver \uc815\uc0c1 \uc885\ub8cc\ub428.");
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print("ChromeDriver \uc885\ub8cc \uc911 \uc624\ub958: " + e.getMessage());
            }
            try {
                ChromeExtention.deleteDirectoryRecursively(Paths.get(chromeProfiledeleteFolder, new String[0]));
            }
            catch (IOException e) {
                YDMAStringUtil.Print("\ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
            }
        }));
    }

    private static void deleteDirectoryRecursively(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            YDMAStringUtil.Print("\uc784\uc2dc chrome profile \ub514\ub809\ud1a0\ub9ac \uc0ad\uc81c\ub428: " + path.toString());
        }
    }
}

