/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.google.gson.JsonElement;
import com.kdjsystem.mlink.shop.common.CaffeineCategoryCache;
import com.kdjsystem.mlink.shop.common.CommonCodeDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.imgscalr.Scalr;

public class ShopCommon {
    public static final String MLink = "mlink000";
    public static final String \uc790\uccb4\ubab0 = "shop0000";
    public static final String \uc778\ud130\ud30c\ud06c = "shop0004";
    public static final String \ubc14\uc774\uc990 = "shop0004";
    public static final String \uc2ed\uc77c\ubc88\uac00 = "shop0003";
    public static final String \uc625\uc158 = "shop0067";
    public static final String \uc9c0\ub9c8\ucf13 = "shop0068";
    public static final String \uc704\uba54\ud504 = "shop0287";
    public static final String \uc2a4\ud1a0\uc5b4\ud31c = "shop0055";
    public static final String \ub124\uc774\ubc84\ud398\uc774 = "shop0041";
    public static final String \ucfe0\ud321 = "shop0075";
    public static final String \uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 = "shop0273";
    public static final String \uce74\ud39824 = "shop0110";
    public static final String \ud2f0\ubaac = "shop0076";
    public static final String \ud6c4\uc774\uc988 = "shop9999";
    public static final String \uc2ed\uc77c\ubc88\uac002 = "shop00031";
    public static final String \uc625\uc1582 = "shop00671";
    public static final String \uc9c0\ub9c8\ucf132 = "shop00681";
    public static final String SSG\ub2f7\ucef4 = "shop0411";
    public static final String \ub86f\ub370\uc628 = "shop0372";
    public static final String \uba78\uce58\uc1fc\ud551 = "shop0106";
    public static final String \uce60\uc774\ud0c0\uc784 = "shop0233";
    public static final String \ub3c4\ub9e4\uc758\uc2e0 = "shop0283";
    public static final String \ub3c4\ub9e4\uc758\uc2e02 = "shop0284";
    public static final String \ub3c4\ub9e4\ucc3d\uace0 = "shop0203";
    public static final String \ud380\uc564\uc1fc\ud551 = "shop0286";
    public static final String \uc624\ub108\ud074\ub79c = "shop0120";
    public static final String \ub3c4\ub9e4\ub9e4 = "shop0319";
    public static final String \ud22c\ube44\uc988\uc628 = "shop0316";
    public static final String \ub354\ube14\uc720\ud2b8\ub808\uc774\ub529 = "shop9992";
    public static final String \uc4f0\ub9ac\uc5e0\uc54c\uc624 = "shop9994";
    public static final String \uc820\ud2b8\ub808\uc774\ub4dc = "shop9995";
    public static final String \uc628\ucc44\ub110 = "shop9996";
    public static final String \uc774\uc140\ub7ec\uc2a4 = "shop9997";
    public static final String \ud5c8\ube0c\uc140\ub7ec = "shop5001";
    public static final String \uc140\ubab0 = "shop7777";
    public static final String \uace0\ub3c4\ubab0 = "shop0211";
    public static final String \ub3c4\ub9e4\uc544\ud1a0\uc988 = "shop9991";
    public static final String \ud544\uc6b0\ucee4\uba38\uc2a4 = "shop9990";
    public static final String \uc140\ub7ec\ud504\ub80c\ub4dc = "shop9989";
    public static final String \uc9c0\uc5d0\uc774\uae00\ub85c\ubc8c = "shop9988";
    public static final String \uc628\ubbf8 = "shop9987";
    public static final String \ub8f8\uc564\uc624\ud53c\uc2a4 = "shop9986";
    public static final String \ub3c4\ub9e4\ub9c8\ud2b8 = "shop9985";
    public static final String \uc624\ub108\ud074\ub79c\uacf5\uae09\uc790 = "shop0119";
    public static final String \uc62c\uc6e8\uc774\uc988 = "shop9984";
    public static final String \uc5d0\uc774\ube14\ub9ac = "shop9983";
    public static final String \ud1a0\uc2a4\uc1fc\ud551 = "shop9982";
    public static final String WEMARTET_HOST = "http://api.kdjsystem.com:8082/";
    public static final String COUPANG_HOST = "api-gateway.coupang.com";
    public static final int COUPANG_PORT = 443;
    public static final String COUPANG_SCHEMA = "https";
    public static final String \ub370\uc774\ud0c0\uc5c6\uc74c = "0";
    public static final String \uc5d0\ub7ec\ubc1c\uc0dd = "-1";
    public static final String \uc815\uc0c1\ucc98\ub9ac = "1";
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String PATCH = "PATCH";
    public static final String DELETE = "DELETE";
    public static final String \uc0c1\ud488\uc0c1\ud0dc_\uacf5\uae09\uc911 = "9";
    public static final String \uc0c1\ud488\uc0c1\ud0dc_\uc77c\uc2dc\uc911\uc9c0 = "8";
    public static final String \uc0c1\ud488\uc0c1\ud0dc_\uc644\uc804\ud488\uc808 = "7";
    public static final String \uc0c1\ud488\uc0ad\uc81c\ud6c4_\ub4f1\ub85d = "6";
    public static final String \uc0c1\ud488\uba85\uc218\uc815 = "5";
    public static final String \uc0c1\ud488\ud310\ub9e4\uac00\uc218\uc815 = "4";
    public static final String \uc0c1\ud488\uce74\ud14c\uace0\ub9ac\uc218\uc815 = "3";
    public static final String \uc0c1\ud488\uc774\ubbf8\uc9c0\uc218\uc815 = "2";
    public static final String \uc0c1\ud488\uc0c1\uc138\uc124\uba85\uc218\uc815 = "1";
    public static final String \uc0c1\ud488\uc804\uccb4\uc218\uc815 = "0";
    public static final String \uc0c1\ud488\uc804\uc1a1\uc0c1\ud0dc = "PRODUCT_SEND";
    public static final String \ub178\ucd9cSHOPCD = "PRODUCT_SHOP";
    public static final String \uc0c1\ud488\uc218\uc2e0 = "PRODREGIS";
    public static final String \uc0c1\ud488\ub4f1\ub85d = "PRODREGIS";
    public static final String \uc0c1\ud488\uc218\uc815 = "PRODMODIFY";
    public static final String \uc7ac\uace0\uc1a1\uc2e0 = "STOCKSEND";
    public static final String \uc8fc\ubb38\uc218\uc9d1 = "ORDERCOLLECT";
    public static final String \uc1a1\uc7a5\uc1a1\uc2e0 = "INVOICSEND";
    public static final String \ubb38\uc758\ucc98\ub9ac = "QUESTION";
    private static final Set<String> LOCAL_DOWNLOAD_SHOPS = new HashSet<String>(Arrays.asList("shop9982", "shop9984", "shop0055", "shop00671", "shop00681"));
    private static final Set<String> FTP_UPLOAD_SHOPS = new HashSet<String>(Arrays.asList("shop00031", "shop0075", "shop0273", "shop0372", "shop0110", "shop0076", "shop0004", "shop0287", "shop0106"));
    private static final Set<String> FTP_UPLOAD_SHOPS_EXCL_COUPANG = new HashSet<String>(Arrays.asList("shop00031", "shop0273", "shop0372", "shop0110", "shop0076", "shop0004", "shop0287", "shop0106"));
    private static final Set<String> DELETE_IMAGE_THAN_TENMINUTES = new HashSet<String>(Arrays.asList("shop0075", "shop0372"));
    private static Map<String, String> productPreviewMap = new HashMap<String, String>();
    private static Map<String, String> productPreviewMap1 = new HashMap<String, String>();
    private static Map<String, String> productEditMap = new HashMap<String, String>();

    public static boolean requiresLocalDownload(String shopCd, String domeCd) {
        if (LOCAL_DOWNLOAD_SHOPS.contains(shopCd)) {
            return true;
        }
        return \ub3c4\ub9e4\ub9e4.contains(domeCd) && !shopCd.equals(\ucfe0\ud321);
    }

    public static boolean requiresFtpUpload(String shopCd) {
        return FTP_UPLOAD_SHOPS.contains(shopCd);
    }

    public static boolean requiresFtpUploadExclCoupang(String shopCd) {
        return FTP_UPLOAD_SHOPS_EXCL_COUPANG.contains(shopCd);
    }

    public static boolean isHighResThumbnailShop(String shopCd) {
        return \uc625\uc158.equals(shopCd) || \uc9c0\ub9c8\ucf13.equals(shopCd) || \uc625\uc1582.equals(shopCd) || \uc9c0\ub9c8\ucf132.equals(shopCd);
    }

    public static boolean deleteimagesolderthantenminutes(String shopCd) {
        return DELETE_IMAGE_THAN_TENMINUTES.contains(shopCd);
    }

    public static List<CommonCodeDto> getCommonCodeList(String mngCode) {
        return YDMASessonUtil.getCommoncodelist().stream().filter(p -> p.getMngCode().equals(mngCode)).collect(Collectors.toList());
    }

    public static String getProductUrl(String shopcd, String prodID, String skuid, String uesrId) {
        if (productPreviewMap.size() == 0) {
            ShopCommon.initProductPreviewMap();
        }
        String url = productPreviewMap.get(shopcd);
        switch (shopcd) {
            case "shop0075": {
                url = String.format(url, prodID, skuid);
                break;
            }
            case "shop0055": {
                url = String.format(url, uesrId, prodID);
                break;
            }
            case "shop0273": {
                url = String.format(url, skuid, prodID);
                break;
            }
            default: {
                url = String.format(url, prodID);
            }
        }
        return url;
    }

    public static String jsonElementNullStr(JsonElement val) {
        if (val == null || val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    public static String jsonElementNullInt(JsonElement val) {
        if (val == null || val.isJsonNull()) {
            return "0";
        }
        return String.format("%.0f", Double.parseDouble(val.getAsString()));
    }

    public static String getNullAsEmptyString(String val) {
        return val == null ? "" : val;
    }

    public static String getNullAsEmptyInt(String val) {
        if (val == null) {
            return "0";
        }
        return String.format("%.0f", Double.parseDouble(val));
    }

    private static void initProductPreviewMap() {
        productPreviewMap.put(\uc2ed\uc77c\ubc88\uac00, "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s");
        productPreviewMap.put(\uc2ed\uc77c\ubc88\uac002, "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s");
        productPreviewMap.put("shop0004", "http://shopping.buyzle.co.kr/product/productInfo.do?prdNo=%s");
        productPreviewMap.put(\uc2a4\ud1a0\uc5b4\ud31c, "https://smartstore.naver.com/%s/products/%s");
        productPreviewMap.put(\uc625\uc158, "http://itempage3.auction.co.kr/DetailView.aspx?ItemNo=%s&frm3=V2");
        productPreviewMap.put(\uc625\uc1582, "http://itempage3.auction.co.kr/DetailView.aspx?ItemNo=%s&frm3=V2");
        productPreviewMap.put(\uc9c0\ub9c8\ucf13, "http://item.gmarket.co.kr/challenge/neo_goods/goods.asp?goodscode=%s");
        productPreviewMap.put(\uc9c0\ub9c8\ucf132, "http://item.gmarket.co.kr/challenge/neo_goods/goods.asp?goodscode=%s");
        productPreviewMap.put(\ucfe0\ud321, "https://www.coupang.com/vp/products/%s?vendorItemId=%s&isAddedCart=");
        productPreviewMap.put(\ud2f0\ubaac, "http://www.tmon.co.kr/deal/%s");
        productPreviewMap.put(\uce74\ud39824, "http://%s.cafe24.com/product/detail.html?product_no=%s");
        productPreviewMap.put(\uc624\ub108\ud074\ub79c, "https://ownerclan.com/V2/product/view.php?selfcode=%s");
        productPreviewMap.put(\ub3c4\ub9e4\ucc3d\uace0, "http://www.wholesaledepot.co.kr/shop/goods/goods_view.php?goodsno=%s");
        productPreviewMap.put(\ub3c4\ub9e4\uc758\uc2e0, "https://www.domesin.com/shop.html?p=view.html&iid=%s");
        productPreviewMap.put(\ub3c4\ub9e4\uc758\uc2e02, "https://www.domesin.com/shop.html?p=view.html&iid=%s");
        productPreviewMap.put(\ud380\uc564\uc1fc\ud551, "http://b2b.funn.co.kr/goods/content.asp?guid=%s");
        productPreviewMap.put(\uc704\uba54\ud504, "https://front.wemakeprice.com/product/%s");
        productPreviewMap.put(\ub3c4\ub9e4\ub9e4, "http://domeggook.com/%s");
        productPreviewMap.put(\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4, "https://store.kakao.com/%s/products/%s");
        productPreviewMap.put(SSG\ub2f7\ucef4, "http://ssg.com/item/itemView.ssg?itemId=%s");
        productPreviewMap.put(\ud6c4\uc774\uc988, "http://www.skytea.net/src/products/products_detail.php?product_mst_id=%s");
        productPreviewMap.put(\ub86f\ub370\uc628, "https://www.lotteon.com/p/product/%s");
        productPreviewMap.put(\uba78\uce58\uc1fc\ud551, "https://www.smelchi.com/product/detail?productCd=%s");
        productPreviewMap.put(\uce60\uc774\ud0c0\uc784, "https://www.72time.kr/goods/content.asp?guid=%s");
        productPreviewMap1.put(\uace0\ub3c4\ubab0, "http://%s.godomall.com/goods/goods_view.php?goodsNo=%s");
        productPreviewMap.put(\uc62c\uc6e8\uc774\uc988, "https://alwayzweb.ilevit.com/?alwayzItemId=%s");
        productPreviewMap.put(\uc624\ub108\ud074\ub79c\uacf5\uae09\uc790, "https://ownerclan.com/V2/product/view.php?selfcode=%s");
        productPreviewMap.put("shop0262", "http://lut0001.firstmall.kr/goods/view?no=%s");
        productPreviewMap.put("shop0026", "http://under10.co.kr/product/detail.html?product_no=%s");
    }

    public static String ProductUrl(String shopcd, String shopprodno) {
        if (productPreviewMap1.size() == 0) {
            ShopCommon.initProductPreviewMap1();
        }
        String url = productPreviewMap1.get(shopcd);
        url = String.format(url, shopprodno);
        return url;
    }

    public static String ProductUrl1(String shopcd, String shopprodno, String vendorItemId) {
        if (productPreviewMap1.size() == 0) {
            ShopCommon.initProductPreviewMap1();
        }
        String url = "";
        if (shopcd.equals(\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4)) {
            url = productPreviewMap1.get(shopcd);
            url = String.format(url, vendorItemId.replace("\"", ""), shopprodno);
        } else {
            url = productPreviewMap1.get(shopcd);
            url = String.format(url, shopprodno, vendorItemId);
        }
        return url;
    }

    public static String ProductUrl2(String shopcd, String shopprodno, String shopid) {
        if (productPreviewMap1.size() == 0) {
            ShopCommon.initProductPreviewMap1();
        }
        String url = productPreviewMap1.get(shopcd);
        url = String.format(url, shopid, shopprodno);
        return url;
    }

    private static void initProductPreviewMap1() {
        productPreviewMap1.put(\uc2ed\uc77c\ubc88\uac00, "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s");
        productPreviewMap1.put(\uc2ed\uc77c\ubc88\uac002, "http://www.11st.co.kr/product/SellerProductDetail.tmall?method=getSellerProductDetail&prdNo=%s");
        productPreviewMap1.put("shop0004", "http://shopping.buyzle.co.kr/product/productInfo.do?prdNo=%s");
        productPreviewMap1.put(\uc2a4\ud1a0\uc5b4\ud31c, "https://smartstore.naver.com/%s/products/%s");
        productPreviewMap1.put(\uc625\uc158, "http://itempage3.auction.co.kr/DetailView.aspx?ItemNo=%s&frm3=V2");
        productPreviewMap1.put(\uc625\uc1582, "http://itempage3.auction.co.kr/DetailView.aspx?ItemNo=%s&frm3=V2");
        productPreviewMap1.put(\uc9c0\ub9c8\ucf13, "http://item.gmarket.co.kr/challenge/neo_goods/goods.asp?goodscode=%s");
        productPreviewMap1.put(\uc9c0\ub9c8\ucf132, "http://item.gmarket.co.kr/challenge/neo_goods/goods.asp?goodscode=%s");
        productPreviewMap1.put(\ucfe0\ud321, "https://www.coupang.com/vp/products/%s?vendorItemId=%s&isAddedCart=");
        productPreviewMap1.put(\ud2f0\ubaac, "http://www.tmon.co.kr/deal/%s");
        productPreviewMap1.put(\uce74\ud39824, "http://%s.cafe24.com/product/detail.html?product_no=%s");
        productPreviewMap1.put(\uc624\ub108\ud074\ub79c, "https://ownerclan.com/V2/product/view.php?selfcode=%s");
        productPreviewMap1.put(\ub3c4\ub9e4\ucc3d\uace0, "http://www.wholesaledepot.co.kr/shop/goods/goods_view.php?goodsno=%s");
        productPreviewMap1.put(\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4, "https://store.kakao.com/%s/products/%s");
        productPreviewMap1.put(\ub86f\ub370\uc628, "https://www.lotteon.com/p/product/%s");
        productPreviewMap1.put(SSG\ub2f7\ucef4, "http://emart.ssg.com/item/itemView.ssg?itemId=%s");
        productPreviewMap1.put(\uba78\uce58\uc1fc\ud551, "http://www.smelchi.com/product/detail?productCd=%s");
        productPreviewMap1.put(\uce60\uc774\ud0c0\uc784, "https://www.72time.kr/goods/content.asp?guid=%s");
        productPreviewMap1.put(\ub3c4\ub9e4\uc758\uc2e0, "https://www.domesin.com/shop.html?p=view.html&iid=%s");
        productPreviewMap1.put(\ud380\uc564\uc1fc\ud551, "http://b2b.funn.co.kr/goods/content.asp?guid=%s");
        productPreviewMap1.put(\uc704\uba54\ud504, "https://front.wemakeprice.com/product/%s");
        productPreviewMap1.put(\ud22c\ube44\uc988\uc628, "http://www.tobizon.co.kr/mall/goods/goods_view.php?goodscd=%s");
        productPreviewMap1.put(\ub3c4\ub9e4\ub9e4, "http://domeme.domeggook.com/%s");
        productPreviewMap1.put(\ud5c8\ube0c\uc140\ub7ec, "http://www.hubseller.co.kr/?menuType=product&mode=view&prodCode=%s");
        productPreviewMap1.put(\uc140\ubab0, "https://sellmall.co.kr/product/productView.php?proSeq=%s");
        productPreviewMap1.put(\uc4f0\ub9ac\uc5e0\uc54c\uc624, "http://3mro.co.kr/shop/item.php?it_id=%s");
        productPreviewMap1.put(\uc820\ud2b8\ub808\uc774\ub4dc, "https://www.zentrade.co.kr/shop/goods/goods_view.php?goodsno=%s");
        productPreviewMap1.put(\uc628\ucc44\ub110, "https://www.onch3.co.kr/onch_view.html?num=%s");
        productPreviewMap1.put(\ud6c4\uc774\uc988, "http://www.skytea.net/src/products/products_detail.php?product_mst_id=%s");
        productPreviewMap1.put(\uace0\ub3c4\ubab0, "http://%s.godomall.com/goods/goods_view.php?goodsNo=%s");
        productPreviewMap1.put(\uc62c\uc6e8\uc774\uc988, "https://alwayzweb.ilevit.com/?alwayzItemId=%s");
        productPreviewMap1.put(\ub8f8\uc564\uc624\ud53c\uc2a4, "https://ydinc.cafe24.com/product/detail.html?product_no=%s");
        productPreviewMap1.put("shop0262", "http://lut0001.firstmall.kr/goods/view?no=%s");
        productPreviewMap1.put("shop0026", "http://under10.co.kr/product/detail.html?product_no=%s");
    }

    public static String ProductEditUrl(String shopcd, String shopprodno, String shopid) {
        if (productEditMap.size() == 0) {
            ShopCommon.initProductEditMap();
        }
        String url = productEditMap.get(shopcd);
        url = shopcd.equals(\uce74\ud39824) ? String.format(url, shopid, shopprodno) : String.format(url, shopprodno);
        return url;
    }

    public static String getProductID(String shopcd, String prodcd) {
        switch (shopcd) {
            case "shop0283": {
                return prodcd.substring(3, prodcd.length());
            }
            case "shop0120": {
                return prodcd;
            }
            case "shop0286": {
                return prodcd.substring(1, prodcd.length());
            }
            case "shop9994": {
                return prodcd.substring(4, prodcd.length());
            }
            case "shop9995": {
                return prodcd.substring(3, prodcd.length());
            }
            case "shop0203": {
                return prodcd.substring(3, prodcd.length());
            }
            case "shop9996": {
                return prodcd.substring(2, prodcd.length());
            }
            case "shop0319": {
                return prodcd.substring(3, prodcd.length());
            }
            case "shop7777": {
                return prodcd.substring(3, prodcd.length());
            }
            case "shop0316": {
                return prodcd;
            }
            case "shop5001": {
                return prodcd;
            }
            case "shop9992": {
                return prodcd;
            }
            case "shop9986": 
            case "shop9987": {
                return prodcd.substring(2, prodcd.length());
            }
        }
        return prodcd;
    }

    private static void initProductEditMap() {
        productEditMap.put(\uc2ed\uc77c\ubc88\uac00, "http://soffice.11st.co.kr/product/UnitProductRegAction.tmall?method=viewForm&cellClickRowIdx=&prdNo=%s&reRegYn=&popYn=&formType=U&urlType=SO");
        productEditMap.put(\uc2ed\uc77c\ubc88\uac002, "http://soffice.11st.co.kr/product/UnitProductRegAction.tmall?method=viewForm&cellClickRowIdx=&prdNo=%s&reRegYn=&popYn=&formType=U&urlType=SO");
        productEditMap.put("shop0004", "https://seller.buyzle.co.kr/views/products/modify/%s");
        productEditMap.put(\uc2a4\ud1a0\uc5b4\ud31c, "https://sell.smartstore.naver.com/#/products/edit/%s");
        productEditMap.put(\uc625\uc158, "https://www.esmplus.com/Home/v2/goods-edit?seq=%s");
        productEditMap.put(\uc625\uc1582, "https://www.esmplus.com/Home/v2/goods-edit?seq=%s");
        productEditMap.put(\uc9c0\ub9c8\ucf13, "https://www.esmplus.com/Home/v2/goods-edit?seq=%s");
        productEditMap.put(\uc9c0\ub9c8\ucf132, "https://www.esmplus.com/Home/v2/goods-edit?seq=%s");
        productEditMap.put(\ucfe0\ud321, "https://wing.coupang.com/tenants/seller-web/vendor-inventory/modify?vendorInventoryId=%s&page=&countPerPage=&statusSearch=&vendorInventoryIdSearch=&productNameSearch=&brandNameSearch=&productIdSearch=&mdNameSearch=&mdIdSearch=&createdAtSearchFrom=&createdAtSearchTo=&registrationType=&hasNotNewProduct=#/");
        productEditMap.put(\ud2f0\ubaac, "https://spc-om.tmon.co.kr/#/deals/%s");
        productEditMap.put(\uce74\ud39824, "http://%s.cafe24.com/disp/admin/product/ProductRegister?product_no=%s");
        productEditMap.put(\uc624\ub108\ud074\ub79c, "");
        productEditMap.put(\ub3c4\ub9e4\ucc3d\uace0, "");
        productEditMap.put(\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4, "https://shopping-seller.kakao.com/product/store-seller/modify/%s");
        productEditMap.put(\ub86f\ub370\uc628, "");
        productEditMap.put(SSG\ub2f7\ucef4, "http://po.ssgadm.com/om/itemEdit/itemMain.ssg?itemId=%s&from=po&menuId=5000004436&pageNo=2");
        productEditMap.put(\ub3c4\ub9e4\uc758\uc2e0, "");
        productEditMap.put(\uc704\uba54\ud504, "https://wpartner.wemakeprice.com/product/prodSet?setType=update&prodNo=%s");
        productEditMap.put(\ub3c4\ub9e4\ub9e4, "");
        productEditMap.put(\ud6c4\uc774\uc988, "");
        productEditMap.put(\uce60\uc774\ud0c0\uc784, "");
        productEditMap.put(\uace0\ub3c4\ubab0, "");
        productEditMap.put(\uc62c\uc6e8\uc774\uc988, "https://alwayzseller.ilevit.com/items");
        productEditMap.put(\ud1a0\uc2a4\uc1fc\ud551, "https://shopping-seller.toss.im/products/%s");
        productEditMap.put("shop0262", "");
        productEditMap.put("shop0026", "");
    }

    public static String getImgPath() throws Exception {
        String img_path = String.format("%s\\%s", YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("Product.image.shopImage")), YDMASessonUtil.getImageFolderName());
        return img_path;
    }

    public static String getImgPath2() throws Exception {
        String img_path = String.format("%s\\%s", YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("Product.image.shopImage2")), YDMASessonUtil.getImageFolderName());
        return img_path;
    }

    public static String getImgPathLocalThumnail() throws Exception {
        String basePath = YDMASessonUtil.getAppPath("");
        String exePath = basePath + YDMAProperties.getInstance().getAppProperty("Product.imageChangePath").replace("/", File.separator);
        return exePath;
    }

    public static boolean isUrlFileExits(String url) throws Exception {
        String name = url.substring(url.lastIndexOf(47) + 1, url.length());
        Path path = Paths.get(ShopCommon.getImgPath(), name);
        return Files.exists(path, new LinkOption[0]);
    }

    public static String getImgLocalPath(String url) throws Exception {
        if (url.startsWith("http") || url.startsWith(COUPANG_SCHEMA)) {
            String name = url.substring(url.indexOf(47) + 2, url.length());
            name = name.replaceAll("/", "-");
            Path path = Paths.get(ShopCommon.getImgPath(), name);
            return path.toAbsolutePath().toString();
        }
        return url.toString();
    }

    public static String getImgLocalPath2(String url) throws Exception {
        String name = url.substring(url.indexOf(47) + 2, url.length());
        name = name.replaceAll("/", "-");
        if (url.contains("C:")) {
            Path path = Paths.get(ShopCommon.getImgPath2(), new String[0]);
            return path.toAbsolutePath().toString();
        }
        Path path = Paths.get(ShopCommon.getImgPath2(), name);
        return path.toAbsolutePath().toString();
    }

    public static InputStream getImageInputStream(String str_url) throws IOException {
        String file_ext = str_url.substring(str_url.lastIndexOf(46) + 1, str_url.length());
        URL url = new URL(str_url);
        BufferedImage image = ImageIO.read(url);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, file_ext, os);
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        return is;
    }

    public static void downloadImgFile(String url, int width, int height) throws Exception {
        String localPath = width > 600 ? ShopCommon.getImgPath2() : (width == 600 ? ShopCommon.getImgPath() : (width == 460 ? ShopCommon.getImgPath2() : ShopCommon.getImgPath()));
        String name = url.substring(url.indexOf(47) + 2, url.length()).replaceAll("/", "-");
        BufferedImage image = null;
        try {
            File folder = width > 600 ? new File(ShopCommon.getImgPath2()) : (width == 600 ? new File(ShopCommon.getImgPath()) : (width == 460 ? new File(ShopCommon.getImgPath2()) : new File(ShopCommon.getImgPath())));
            if (!folder.exists()) {
                folder.mkdirs();
            }
            if (url.startsWith("http") || url.startsWith(COUPANG_SCHEMA)) {
                URL imageUrl = new URL(url);
                image = ImageIO.read(imageUrl);
                Image resizeImage = image.getScaledInstance(width, height, 4);
                BufferedImage bufferedImage = new BufferedImage(width, height, 4);
                Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
                graphics.setBackground(Color.WHITE);
                graphics.drawImage(resizeImage, 0, 0, null);
                graphics.dispose();
                ImageIO.write((RenderedImage)bufferedImage, "jpeg", new File(localPath + "/" + name));
                YDMAStringUtil.Print("\ub2e4\uc6b4\ub85c\ub4dc \uc644\ub8cc");
            } else {
                Path sourceDirectory = Paths.get(url, new String[0]);
                Path targetDirectory = Paths.get(localPath + "/" + String.valueOf(sourceDirectory.getFileName()), new String[0]);
                try {
                    Files.copy(sourceDirectory, targetDirectory, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    YDMAStringUtil.Print(e.toString());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static String[] writeImageLocalFolder(String code, String[] imageUrls, String exeDirectory) throws Exception {
        String[] imagePaths = new String[imageUrls.length];
        try {
            int i = 0;
            while (i < imageUrls.length) {
                String imageUrl = imageUrls[i];
                BufferedImage image = null;
                if (imageUrl.startsWith("http") || imageUrl.startsWith(COUPANG_SCHEMA)) {
                    URL url = new URL(imageUrl);
                    URLConnection connection = url.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                    connection.connect();
                    try {
                        Throwable throwable = null;
                        Object var10_13 = null;
                        try (InputStream in = connection.getInputStream();){
                            image = ImageIO.read(in);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    File file = new File(imageUrl);
                    image = ImageIO.read(file);
                }
                if (image != null) {
                    if (image.getType() != 1) {
                        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                        Graphics2D g = rgbImage.createGraphics();
                        g.drawImage((Image)image, 0, 0, null);
                        g.dispose();
                        image = rgbImage;
                    }
                    String fileName = code + Integer.toString(i) + ".jpg";
                    File outputfile = new File(exeDirectory + File.separator + fileName);
                    ImageIO.write((RenderedImage)image, "jpg", outputfile);
                    imagePaths[i] = fileName;
                }
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return imagePaths;
    }

    public static void downloadImgFile(String url) throws Exception {
        ShopCommon.downloadImgFile(url, 600, 600);
    }

    public static void downloadImgFile_ad(String url) throws Exception {
        ShopCommon.downloadImgFile(url, 600, 240);
    }

    public static void downloadOrgImgFile(String url) throws Exception {
        String localPath = ShopCommon.getImgPath();
        String file_ext = url.substring(url.lastIndexOf(46) + 1, url.length());
        String name = url.substring(url.lastIndexOf(47) + 1, url.length());
        BufferedImage bufferedImage = null;
        try {
            File folder = new File(ShopCommon.getImgPath());
            if (!folder.exists()) {
                folder.mkdirs();
            }
            bufferedImage = ImageIO.read(new URL(url));
            ImageIO.write((RenderedImage)bufferedImage, file_ext, new File(localPath + "/" + name));
            Thread.sleep(2000L);
            YDMAStringUtil.Print("\ub2e4\uc6b4\ub85c\ub4dc \uc644\ub8cc");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fileUploadAutoIt(String imgpath) throws Exception {
        String execute = YDMASessonUtil.getAppPath() + String.format("\\YDwmsData\\FileUpload.exe %s", imgpath);
        Process process = Runtime.getRuntime().exec(execute);
        process.getErrorStream().close();
        process.getInputStream().close();
        process.getOutputStream().close();
        process.waitFor();
    }

    public static String getImgLocalPathDosin(String url, String prodcd) throws Exception {
        Path path = Paths.get(ShopCommon.getImgPathDosin(), prodcd);
        return path.toAbsolutePath().toString();
    }

    public static String getImgPathDosin() throws Exception {
        String img_path = String.format("%s\\%s", YDMASessonUtil.getAppPath(YDMAProperties.getInstance().getAppProperty("Product.image.productImage2")), YDMASessonUtil.getImageFolderName());
        return img_path;
    }

    public static boolean isUrlFileExitsDosin(String url, String prodcd) throws Exception {
        if (url.equals("")) {
            return true;
        }
        Path path = Paths.get(ShopCommon.getImgPathDosin(), prodcd);
        return Files.exists(path, new LinkOption[0]);
    }

    public static BufferedImage resize(BufferedImage img, int height, int width) {
        int dw = height;
        int dh = width;
        int ow = img.getWidth();
        int oh = img.getHeight();
        int nw = ow;
        int nh = ow * dh / dw;
        if (nh > oh) {
            nw = oh * dw / dh;
            nh = oh;
        }
        BufferedImage cropImg = Scalr.crop((BufferedImage)img, (int)((ow - nw) / 2), (int)((oh - nh) / 2), (int)nw, (int)nh, (BufferedImageOp[])new BufferedImageOp[0]);
        return Scalr.resize((BufferedImage)cropImg, (int)dw, (int)dh, (BufferedImageOp[])new BufferedImageOp[0]);
    }

    public static ImageData convertToSWT2(BufferedImage bufferedImage) throws IOException {
        int[] data2 = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
        ImageData imageData = new ImageData(80, 80, 24, new PaletteData(0xFF0000, 65280, 255));
        imageData.setPixels(0, 0, data2.length, data2, 0);
        if (bufferedImage.getColorModel().hasAlpha()) {
            int[] alpha = ((DataBufferInt)bufferedImage.getAlphaRaster().getDataBuffer()).getData();
            byte[] alphaBytes = new byte[alpha.length];
            int i = 0;
            while (i < alpha.length) {
                alphaBytes[i] = (byte)(alpha[i] >> 24 & 0xFF);
                ++i;
            }
            imageData.setAlphas(0, 0, alphaBytes.length, alphaBytes, 0);
        }
        return imageData;
    }

    public static ImageData convertToSWT2a(BufferedImage bufferedImage) throws IOException {
        int[] data2 = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
        ImageData imageData = new ImageData(300, 300, 24, new PaletteData(0xFF0000, 65280, 255));
        imageData.setPixels(0, 0, data2.length, data2, 0);
        if (bufferedImage.getColorModel().hasAlpha()) {
            int[] alpha = ((DataBufferInt)bufferedImage.getAlphaRaster().getDataBuffer()).getData();
            byte[] alphaBytes = new byte[alpha.length];
            int i = 0;
            while (i < alpha.length) {
                alphaBytes[i] = (byte)(alpha[i] >> 24 & 0xFF);
                ++i;
            }
            imageData.setAlphas(0, 0, alphaBytes.length, alphaBytes, 0);
        }
        return imageData;
    }

    public static ImageData convertToSWT2b(BufferedImage bufferedImage) throws IOException {
        int[] data2 = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
        ImageData imageData = new ImageData(120, 120, 24, new PaletteData(0xFF0000, 65280, 255));
        imageData.setPixels(0, 0, data2.length, data2, 0);
        if (bufferedImage.getColorModel().hasAlpha()) {
            int[] alpha = ((DataBufferInt)bufferedImage.getAlphaRaster().getDataBuffer()).getData();
            byte[] alphaBytes = new byte[alpha.length];
            int i = 0;
            while (i < alpha.length) {
                alphaBytes[i] = (byte)(alpha[i] >> 24 & 0xFF);
                ++i;
            }
            imageData.setAlphas(0, 0, alphaBytes.length, alphaBytes, 0);
        }
        return imageData;
    }

    public static ImageData imagePreView(BufferedImage bufferedImage) throws IOException {
        int[] data2 = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
        ImageData imageData = new ImageData(400, 400, 24, new PaletteData(0xFF0000, 65280, 255));
        imageData.setPixels(0, 0, data2.length, data2, 0);
        if (bufferedImage.getColorModel().hasAlpha()) {
            int[] alpha = ((DataBufferInt)bufferedImage.getAlphaRaster().getDataBuffer()).getData();
            byte[] alphaBytes = new byte[alpha.length];
            int i = 0;
            while (i < alpha.length) {
                alphaBytes[i] = (byte)(alpha[i] >> 24 & 0xFF);
                ++i;
            }
            imageData.setAlphas(0, 0, alphaBytes.length, alphaBytes, 0);
        }
        return imageData;
    }

    public static String downloadImgFileDosin(String imagename, int width, int height) throws Exception {
        String path = imagename;
        try {
            BufferedImage originalImage = ImageIO.read(new File(imagename));
            Scalr.resize((BufferedImage)originalImage, (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])new BufferedImageOp[0]);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)originalImage, "jpg", baos);
            baos.flush();
            baos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    public static <T> Map<Integer, List<T>> getBlockGroup(int blockSize, int totalSize, List<T> list) {
        int block = totalSize / blockSize;
        int mod = totalSize % blockSize;
        int k = 0;
        HashMap<Integer, List<T>> listGroup = new HashMap<Integer, List<T>>();
        if (blockSize >= totalSize) {
            listGroup.put(1, list);
        } else {
            Integer i = 0;
            i = 0;
            while (i < block) {
                k = i * blockSize;
                listGroup.put(i + 1, list.stream().skip(k).limit(blockSize).collect(Collectors.toList()));
                i = i + 1;
            }
            if (mod > 0) {
                listGroup.put(i + 1, list.stream().skip(k += blockSize).collect(Collectors.toList()));
            }
        }
        return listGroup;
    }

    public static String getUUID() {
        String nowTime = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(System.currentTimeMillis());
        UUID uuid = UUID.randomUUID();
        String uid = nowTime + uuid.toString().replaceAll("-", "");
        return uid;
    }

    public static String downloadImgFileCheck(String url) throws Exception {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(url);
            int p = url.indexOf(".jpg");
            sb.insert(p, "c");
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(sb.toString());
            int returncode = client.executeMethod((HttpMethod)method);
            if (returncode == 200) {
                return sb.toString();
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String downloadImgFileJPG(String url, int width, int height, ShopProductDto dto, int i) throws Exception {
        File imageFile;
        File file;
        BufferedImage image;
        String name;
        String path;
        String localPath;
        block22: {
            String imagename;
            localPath = ShopCommon.getImgPath();
            path = "";
            name = dto.getCompayny_goods_cd() + "_" + i;
            image = null;
            file = new File(localPath + File.separator + dto.getCompayny_goods_cd() + "_" + i + ".jpg");
            File folder = new File(ShopCommon.getImgPath());
            if (!folder.exists()) {
                folder.mkdirs();
            }
            String string = imagename = url.contains(".webp") ? url.replace(".webp", ".gif") : url;
            if (imagename.contains(".gif")) {
                URL u = new URL(imagename);
                HttpURLConnection connection = (HttpURLConnection)u.openConnection();
                connection.setRequestMethod(GET);
                SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
                HttpConnectionManagerParams params = connectionManager.getParams();
                params.setConnectionTimeout(120000);
                params.setSoTimeout(120000);
                GetMethod method = new GetMethod(imagename);
                method.setRequestHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64)");
                method.setRequestHeader("Referer", "https://www.google.com");
                try {
                    Throwable throwable = null;
                    Object var18_32 = null;
                    try (InputStream inputStream = connection.getInputStream();){
                        BufferedInputStream bis = new BufferedInputStream(method.getResponseBodyAsStream());
                        image = ImageIO.read(inputStream);
                        Image resizeImage = image.getScaledInstance(width, height, 4);
                        BufferedImage newImage = new BufferedImage(width, height, 1);
                        Graphics g = newImage.getGraphics();
                        g.drawImage(resizeImage, 0, 0, null);
                        g.dispose();
                        ImageIO.write((RenderedImage)newImage, "jpg", file);
                        bis.close();
                        return localPath + File.separator + name + ".jpg";
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        } else {
                            if (throwable == throwable2) throw throwable;
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return localPath + File.separator + name + ".jpg";
            }
            if (url.startsWith("http") || url.startsWith(COUPANG_SCHEMA)) {
                SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
                HttpConnectionManagerParams params = connectionManager.getParams();
                params.setConnectionTimeout(120000);
                params.setSoTimeout(120000);
                HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
                GetMethod method = new GetMethod(url);
                method.setRequestHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64)");
                method.setRequestHeader("Referer", "https://www.google.com");
                try {
                    try {
                        int returncode = client.executeMethod((HttpMethod)method);
                        if (returncode == 200) {
                            BufferedInputStream bis = new BufferedInputStream(method.getResponseBodyAsStream());
                            image = ImageIO.read(method.getResponseBodyAsStream());
                            Image resizeImage = image.getScaledInstance(width, height, 4);
                            BufferedImage newImage = new BufferedImage(width, height, 1);
                            Graphics g = newImage.getGraphics();
                            g.drawImage(resizeImage, 0, 0, null);
                            g.dispose();
                            ImageIO.write((RenderedImage)newImage, "jpg", file);
                            bis.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        method.releaseConnection();
                        return localPath + File.separator + name + ".jpg";
                    }
                }
                catch (Throwable throwable) {
                    method.releaseConnection();
                    throw throwable;
                }
                method.releaseConnection();
                return localPath + File.separator + name + ".jpg";
            }
            imageFile = new File(url);
            if (imageFile.exists()) break block22;
            YDMAStringUtil.Print("\ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: " + url);
            return "";
        }
        try {
            image = ImageIO.read(imageFile);
            Image resizeImage = image.getScaledInstance(width, height, 4);
            BufferedImage newImage = new BufferedImage(width, height, 1);
            Graphics g = newImage.getGraphics();
            g.drawImage(resizeImage, 0, 0, null);
            g.dispose();
            ImageIO.write((RenderedImage)newImage, "jpg", file);
            return localPath + File.separator + name + ".jpg";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return path;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkDownloadImgFileJPG(String url) throws Exception {
        try {
            String imagename;
            String string = imagename = url.contains(".webp") ? url.replace(".webp", ".gif") : url;
            if (imagename.contains(".gif")) {
                URL u = new URL(imagename);
                HttpURLConnection connection = (HttpURLConnection)u.openConnection();
                connection.setRequestMethod(GET);
                SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
                HttpConnectionManagerParams params = connectionManager.getParams();
                params.setConnectionTimeout(60000);
                params.setSoTimeout(50000);
                try {
                    Throwable throwable = null;
                    Object var7_17 = null;
                    try (InputStream inputStream = connection.getInputStream();){
                        ImageIO.read(inputStream);
                        return true;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (url.startsWith("http") || url.startsWith(COUPANG_SCHEMA)) {
                SimpleHttpConnectionManager connectionManager = new SimpleHttpConnectionManager();
                HttpConnectionManagerParams params = connectionManager.getParams();
                params.setConnectionTimeout(60000);
                params.setSoTimeout(50000);
                HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
                GetMethod method = new GetMethod(url);
                try {
                    int returncode = client.executeMethod((HttpMethod)method);
                    if (returncode != 200) return false;
                    ImageIO.read(method.getResponseBodyAsStream());
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                finally {
                    method.releaseConnection();
                }
            }
            File imageFile = new File(url);
            if (!imageFile.exists()) {
                YDMAStringUtil.Print("\ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: " + url);
                return false;
            }
            ImageIO.read(imageFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String isNullCheck(JsonElement jsonElement) {
        YDMAStringUtil.Print();
        String value = jsonElement == null ? "" : (jsonElement.isJsonNull() ? "" : (jsonElement.getAsString().isEmpty() ? "" : jsonElement.getAsString()));
        return value;
    }

    public static String getShoppingMallName(String shopcd) {
        switch (shopcd) {
            case "shop0003": {
                return "11\ubc88\uac00";
            }
            case "shop00031": {
                return "11\ubc88\uac00 2.0";
            }
            case "shop0004": {
                return "\ubc14\uc774\uc990";
            }
            case "shop0055": {
                return "\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4";
            }
            case "shop0041": {
                return "\ub124\uc774\ubc84\ud398\uc774";
            }
            case "shop0067": {
                return "ESM\uc625\uc158";
            }
            case "shop00671": {
                return "ESM\uc625\uc158 2.0";
            }
            case "shop0068": {
                return "ESM\uc9c0\ub9c8\ucf13";
            }
            case "shop00681": {
                return "ESM\uc9c0\ub9c8\ucf13 2.0";
            }
            case "shop0075": {
                return "\ucfe0\ud321";
            }
            case "shop0076": {
                return "\ud2f0\ubaac";
            }
            case "shop0106": {
                return "melchi";
            }
            case "shop0110": {
                return "Cafe24 v1.9";
            }
            case "shop0233": {
                return "72\ud0c0\uc784";
            }
            case "shop0273": {
                return "\uce74\uce74\uc624\ud1a1\uc2a4\ud1a0\uc5b4";
            }
            case "shop0287": {
                return "\uc704\uba54\ud504(\uc2e0)";
            }
            case "shop0372": {
                return "\ub86f\ub370ON";
            }
            case "shop0411": {
                return "SSG\ub2f7\ucef4";
            }
            case "shop0211": {
                return "\uace0\ub3c4\ubab0";
            }
            case "shop9982": {
                return "\ud1a0\uc2a4\uc1fc\ud551";
            }
            case "shop9984": {
                return "\uc62c\uc6e8\uc774\uc988";
            }
            case "shop9983": {
                return "\uc5d0\uc774\ube14\ub9ac";
            }
            case "shop0119": {
                return "\uc624\ub108\ud074\ub79c\uacf5\uae09\uc790";
            }
        }
        return "";
    }

    public static String getShopCd(String shopnm) {
        switch (shopnm) {
            case "\uc790\uccb4\uc1fc\ud551\ubab0": {
                return \uc790\uccb4\ubab0;
            }
            case "11\ubc88\uac00": {
                return \uc2ed\uc77c\ubc88\uac00;
            }
            case "11\ubc88\uac00 2.0": {
                return \uc2ed\uc77c\ubc88\uac002;
            }
            case "\ubc14\uc774\uc990": 
            case "\uc778\ud130\ud30c\ud06c": {
                return "shop0004";
            }
            case "\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4": {
                return \uc2a4\ud1a0\uc5b4\ud31c;
            }
            case "ESM\uc625\uc158": {
                return \uc625\uc158;
            }
            case "ESM\uc625\uc158 2.0": {
                return \uc625\uc1582;
            }
            case "ESM\uc9c0\ub9c8\ucf13": {
                return \uc9c0\ub9c8\ucf13;
            }
            case "ESM\uc9c0\ub9c8\ucf13 2.0": {
                return \uc9c0\ub9c8\ucf132;
            }
            case "\uc704\uba54\ud504": {
                return \uc704\uba54\ud504;
            }
            case "\ucfe0\ud321": {
                return \ucfe0\ud321;
            }
            case "\ud2f0\ubaac": {
                return \ud2f0\ubaac;
            }
            case "melchi": {
                return \uba78\uce58\uc1fc\ud551;
            }
            case "\uce74\ud39824 @": {
                return \uce74\ud39824;
            }
            case "\uc624\ub108\ud074\ub79c": {
                return \uc624\ub108\ud074\ub79c;
            }
            case "\ub3c4\ub9e4\ucc3d\uace0": {
                return \ub3c4\ub9e4\ucc3d\uace0;
            }
            case "72\ud0c0\uc784": {
                return \uce60\uc774\ud0c0\uc784;
            }
            case "\uce74\uce74\uc624\ud1a1\uc2a4\ud1a0\uc5b4": {
                return \uce74\uce74\uc624\uc2a4\ud1a0\uc5b4;
            }
            case "\ub3c4\ub9e4\uc758\uc2e0": {
                return \ub3c4\ub9e4\uc758\uc2e0;
            }
            case "\ub3c4\ub9e4\uc758\uc2e02": {
                return \ub3c4\ub9e4\uc758\uc2e02;
            }
            case "\ud380\uc564\uc1fc\ud551": {
                return \ub3c4\ub9e4\uc758\uc2e0;
            }
            case "\uc704\uba54\ud504(\uc2e0)": {
                return \uc704\uba54\ud504;
            }
            case "\ud22c\ube44\uc988\uc628": {
                return \ud22c\ube44\uc988\uc628;
            }
            case "\ub3c4\ub9e4\uafb9": {
                return \ub3c4\ub9e4\ub9e4;
            }
            case "\ub86f\ub370ON": {
                return \ub86f\ub370\uc628;
            }
            case "SSG\ub2f7\ucef4": {
                return SSG\ub2f7\ucef4;
            }
            case "\ud5c8\ube0c\uc140\ub7ec": {
                return \ud5c8\ube0c\uc140\ub7ec;
            }
            case "\uc820\ud2b8\ub808\uc774\ub4dc": {
                return \uc820\ud2b8\ub808\uc774\ub4dc;
            }
            case "\uace0\ub3c4\ubab0": {
                return \uace0\ub3c4\ubab0;
            }
            case "\ud1a0\uc2a4\uc1fc\ud551": {
                return \ud1a0\uc2a4\uc1fc\ud551;
            }
            case "\uc62c\uc6e8\uc774\uc988": {
                return \uc62c\uc6e8\uc774\uc988;
            }
            case "3MRO": {
                return \uc4f0\ub9ac\uc5e0\uc54c\uc624;
            }
            case "\ub124\uc774\ubc84\ud398\uc774": {
                return "shop0057";
            }
            case "GS shop": {
                return "shop0007";
            }
            case "\ub86f\ub370\ub2f7\ucef4": {
                return "shop0010";
            }
            case "Cafe24 v1.9": {
                return \uce74\ud39824;
            }
            case "cafe24": {
                return "shop0026";
            }
            case "\uc624\ub108\ud074\ub79c\uacf5\uae09\uc790": {
                return \uc624\ub108\ud074\ub79c\uacf5\uae09\uc790;
            }
        }
        return "UNKNOWN";
    }

    public static boolean checkSizeProdName(ArrayList<String> tageList, String addStr, String sizeType, int len) {
        ArrayList<String> checktageList = new ArrayList<String>();
        checktageList.addAll(tageList);
        if (!addStr.equals("")) {
            checktageList.add(addStr);
        }
        String name = String.join((CharSequence)" ", checktageList);
        boolean result = true;
        if (sizeType == "B") {
            byte[] strByte = name.getBytes();
            if (strByte.length > len) {
                result = false;
            }
        } else if (sizeType == "L" && name.length() > len) {
            result = false;
        }
        return result;
    }

    public static String setAddKeywordInProdName(String value, String keyword, String sizeType, int len) {
        ArrayList<String> tageList = new ArrayList<String>(Arrays.asList(value.split(" ")));
        int i = 0;
        while (i < tageList.size()) {
            int j = 0;
            while (j < i) {
                if (tageList.get(i).equals(tageList.get(j))) {
                    tageList.remove(j);
                    break;
                }
                ++j;
            }
            ++i;
        }
        String[] spKeyword = keyword.split(",");
        int i2 = 0;
        while (i2 < spKeyword.length) {
            boolean f = true;
            int j = 0;
            while (j < tageList.size()) {
                if (tageList.get(j).equals(spKeyword[i2])) {
                    f = false;
                    break;
                }
                ++j;
            }
            if (f) {
                if (!ShopCommon.checkSizeProdName(tageList, spKeyword[i2], sizeType, len)) break;
                tageList.add(spKeyword[i2]);
            }
            ++i2;
        }
        return String.join((CharSequence)" ", tageList);
    }

    public static String setWordRandomGenerator(String value) {
        int j;
        String[] spKeyword;
        ArrayList<String> tageList = new ArrayList<String>(Arrays.asList(value.split(" ")));
        String keyword1 = "EA,ea,ml,ML,cc,CC,kg,KG,m,cm,CM,mm,MM,\uac1c";
        String keyword2 = "S,s,M,L,l,XL,xl,XXL,xxl,XXXL,xxxl,3XL,3xl,2XL,2xl,\uc18c,\uc911,\ub300,\ud2b9\ub300";
        String keyword3 = "+,X,x,-";
        String[] stringArray = spKeyword = keyword1.split(",");
        int n = spKeyword.length;
        int n2 = 0;
        while (n2 < n) {
            String kw = stringArray[n2];
            j = 1;
            while (j < tageList.size()) {
                String current = tageList.get(j);
                if (current.matches("^" + kw + "(\\b|[^a-zA-Z0-9]).*") || current.equals(kw)) {
                    String str = tageList.get(j - 1).concat(current);
                    tageList.set(j - 1, str);
                    tageList.remove(j);
                    break;
                }
                ++j;
            }
            ++n2;
        }
        String keyword = keyword1.concat(keyword2).concat(keyword3);
        ArrayList<String> tageList2 = new ArrayList<String>();
        Collections.shuffle(tageList);
        spKeyword = keyword.split(",");
        int i = 0;
        while (i < spKeyword.length) {
            int jj = tageList.size();
            j = 0;
            while (j < jj) {
                if (tageList.get(j).contains(spKeyword[i])) {
                    tageList2.add(tageList.get(j));
                    tageList.remove(j);
                    --jj;
                }
                ++j;
            }
            ++i;
        }
        int j2 = 0;
        while (j2 < tageList.size()) {
            tageList2.add(0, tageList.get(j2));
            ++j2;
        }
        return String.join((CharSequence)" ", tageList2);
    }

    public static String setAddKeywordAdd(String value, String keyword, String add) {
        if (value.equals("")) {
            return keyword;
        }
        ArrayList<String> tageList = new ArrayList<String>(Arrays.asList(value.split(",")));
        String[] spKeyword = keyword.split(",");
        int i = 0;
        while (i < spKeyword.length) {
            boolean f = true;
            int j = 0;
            while (j < tageList.size()) {
                if (tageList.get(j).equals(spKeyword[i])) {
                    f = false;
                    break;
                }
                ++j;
            }
            if (f && add.equals(\uc0c1\ud488\uc774\ubbf8\uc9c0\uc218\uc815)) {
                tageList.add(spKeyword[i]);
            } else if (f && add.equals("1")) {
                tageList.add(0, spKeyword[i]);
            }
            ++i;
        }
        return String.join((CharSequence)",", tageList);
    }

    public static String getDayString(String day) {
        switch (day) {
            case "MON": {
                return "\uc6d4";
            }
            case "TUE": {
                return "\ud654";
            }
            case "WED": {
                return "\uc218";
            }
            case "THU": {
                return "\ubaa9";
            }
            case "FRI": {
                return "\uae08";
            }
            case "SAT": {
                return "\ud1a0";
            }
            case "SUN": {
                return "\uc77c";
            }
        }
        return "";
    }

    public static String getDomeMallName(String shopcd) {
        switch (shopcd) {
            case "shop0000": {
                return "\uc790\uccb4\ubab0";
            }
            case "shop0120": {
                return "\uc624\ub108\ud074\ub79c";
            }
            case "shop0203": {
                return "\ub3c4\ub9e4\ucc3d\uace0";
            }
            case "shop0283": {
                return "\ub3c4\ub9e4\uc758\uc2e0";
            }
            case "shop0286": {
                return "\ud380\uc564\uc1fc\ud551";
            }
            case "shop0316": {
                return "\ud22c\ube44\uc988\uc628";
            }
            case "shop0319": {
                return "\ub3c4\ub9e4\uafb9";
            }
            case "shop9995": {
                return "\uc820\ud2b8\ub808\uc774\ub4dc";
            }
            case "shop9994": {
                return "\uc4f0\ub9ac\uc5e0\uc54c\uc624";
            }
            case "shop5001": {
                return "\ud5c8\ube0c\uc140\ub7ec";
            }
            case "shop9985": {
                return "\ub3c4\ub9e4\ub9c8\ud2b8";
            }
            case "shop9986": {
                return "\ub8f8\uc564\uc624\ud53c\uc2a4";
            }
            case "shop9987": {
                return "\uc628\ubbf8";
            }
            case "shop9996": {
                return "\uc628\ucc44\ub110";
            }
        }
        return "";
    }

    public static String findSearchGubun(String input) {
        switch (input) {
            case "COMPAYNY_GOODS_CD": {
                return "\uc0c1\ud488\ucf54\ub4dc";
            }
            case "GOODS_NM": {
                return "\uc0c1\ud488\uba85\uce6d";
            }
            case "PARTNER_ID": {
                return "\uc5c5\uccb4\ucf54\ub4dc";
            }
            case "GOODS_SEARCH": {
                return "\ud0a4\uc6cc\ub4dc";
            }
            case "STATUS": {
                return "\uc0c1\ud0dc\ucf54\ub4dc";
            }
            case "SHOPMODIFYCONTENT": {
                return "\uc218\uc815\ub0b4\uc6a9";
            }
            case "GMCATEGNM": {
                return "\uce74\ud14c\uace0\ub9ac";
            }
            case "DELV_TYPE": {
                return "\ubc30\uc1a1\ud0c0\uc785";
            }
            case "IS_OVERSEAS": {
                return "\ud574\uc678\uc9c1\ubc30\uc1a1";
            }
            case "ADULT": {
                return "\uc131\uc778\uc0c1\ud488\uc5ec\ubd80";
            }
            case "GOODS_COST": {
                return "\uc6d0\uac00";
            }
            case "DESCRITION": {
                return "\ud310\ub9e4\ub7c9";
            }
            case "IMG_PATH22": {
                return "\ucfe0\ud321\ub178\ucd9c\uc0c1\ud488ID";
            }
            case "CHAR_1_NM": {
                return "\uc635\uc158\uc5ec\ubd80";
            }
            case "GOODS_SEARCH_CNT": {
                return "\ud0a4\uc6cc\ub4dc\uac1c\uc218";
            }
            case "EXISTS_SHOPPING": {
                return "\uc1fc\ud551\ubab0 \ub4f1\ub85d\uc5ec\ubd80";
            }
            case "DELV_COST": {
                return "\ubc30\uc1a1\ube44";
            }
            case "RETURN_DELV_COST": {
                return "\ubc18\ud488\ube44";
            }
        }
        return "";
    }

    public static String findCateName(String input) {
        if (input == null) {
            return "";
        }
        try {
            String categoryId = String.format("%-9s", input).replace(' ', '0');
            return CaffeineCategoryCache.getInstance().getFullCategoryName(categoryId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String findDome(String input) {
        String val = "";
        switch (input) {
            case "shop0120": {
                val = "W";
                break;
            }
            case "shop0283": {
                val = "TS";
                break;
            }
            case "shop0284": {
                val = "TS";
                break;
            }
            case "shop0286": {
                val = "F";
                break;
            }
            case "shop0316": {
                val = "DS";
                break;
            }
            case "shop5001": {
                val = "HS";
                break;
            }
            case "shop9996": {
                val = "CH";
                break;
            }
            case "shop0203": {
                val = "OH";
                break;
            }
            case "shop0319": {
                val = "DMM";
                break;
            }
            case "shop9995": {
                val = "ZEN";
                break;
            }
            case "shop9994": {
                val = "3MRO";
                break;
            }
        }
        return val;
    }
}

