/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ShopRadioButton {
    ButtonGroup group = null;
    JPanel panel;
    List<CodeItem> items;
    List<JRadioButton> radios = new ArrayList<JRadioButton>();
    String code = "";

    public ShopRadioButton(List<CodeItem> items, JPanel panel, int selectIndex, String code) {
        this.group = new ButtonGroup();
        this.items = items;
        int idx = 0;
        for (CodeItem item : items) {
            JRadioButton radio = new JRadioButton(item.getName());
            radio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShopRadioButton.this.radio_SelectChanged(e);
                }
            });
            String[] bounds = item.getFieldName().split(",");
            radio.setBounds(YDMAStringUtil.convertToInt(bounds[0]), YDMAStringUtil.convertToInt(bounds[1]), YDMAStringUtil.convertToInt(bounds[2]), YDMAStringUtil.convertToInt(bounds[3]));
            radio.setFont(new Font("\ub9d1\uc740 \uace0\ub515", 0, 15));
            if (idx == selectIndex) {
                radio.setSelected(true);
                this.code = code;
            }
            ++idx;
            this.radios.add(radio);
            panel.add(radio);
            this.group.add(radio);
        }
    }

    private int getIndex(String code) {
        int idx = -1;
        int i = 0;
        while (i < this.items.size()) {
            if (this.items.get(i).getCode().equals(code)) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    public void setSelectValue(String code) {
        int oldIdx = this.getIndex(this.code);
        int idx = this.getIndex(code);
        if (idx == -1) {
            return;
        }
        this.radios.get(oldIdx).setSelected(false);
        this.radios.get(idx).setSelected(true);
        this.code = code;
    }

    public void radio_SelectChanged(ActionEvent e) {
        String command = e.getActionCommand();
        this.code = this.items.stream().filter(p -> p.getName().equals(command)).findFirst().orElse(new CodeItem("", "")).getCode();
        for (JRadioButton radio : this.radios) {
            if (command.equals(radio.getText())) {
                radio.setSelected(true);
                continue;
            }
            radio.setSelected(false);
        }
    }

    public String getSelectCode() {
        return this.code;
    }

    public void setEnableFalse(List<CodeItem> items, JPanel panel) {
        this.items = items;
        this.panel = panel;
        for (JRadioButton radio : this.radios) {
            radio.setEnabled(false);
        }
    }
}

