/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.coupang;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.coupang.IShopOrderCoupangCommand;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.function.Predicate;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CoupangOrderSearchCommand
extends IShopOrderCoupangCommand {
    private static IShopOrderCommand instance = new CoupangOrderSearchCommand();
    private String dateFrom;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private CoupangOrderSearchCommand() {
    }

    private int findIndex(List<ShopOrderMstDto> list, Predicate<ShopOrderMstDto> predicate) {
        int i = 0;
        while (i < list.size()) {
            ShopOrderMstDto dto = list.get(i);
            if (predicate.test(dto)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private List<ShopOrderMstDto> ExchangeGetApiList(List<ShopOrderMstDto> param) throws Exception {
        CloseableHttpClient client;
        CloseableHttpResponse response;
        block37: {
            response = null;
            client = null;
            try {
                String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/exchangeRequests";
                String acessKey = param.get(0).getAuthkey1();
                String secretKey = param.get(0).getAuthKey2();
                String vendorid = param.get(0).getVendorId();
                ShopPreferencesDto dto1 = ShopCommonDao.get().getSystemConf();
                Calendar calender_dateTime_from = Calendar.getInstance();
                if (Integer.parseInt(dto1.getOrdimptper()) > 7) {
                    calender_dateTime_from.add(5, -6);
                    this.dateFrom = new SimpleDateFormat("yyyy-MM-dd").format(calender_dateTime_from.getTime());
                } else {
                    calender_dateTime_from.add(5, -(Integer.parseInt(dto1.getOrdimptper()) - 1));
                    this.dateFrom = new SimpleDateFormat("yyyy-MM-dd").format(calender_dateTime_from.getTime());
                }
                String startdt = this.dateFrom + "T00:00:00";
                String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false) + "T23:59:59";
                URL2 = String.format(URL2, vendorid);
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("createdAtFrom", startdt).addParameter("createdAtTo", enddt);
                HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
                client = HttpClients.createDefault();
                response = client.execute((HttpUriRequest)get);
                int status2 = response.getStatusLine().getStatusCode();
                if (status2 != 200) break block37;
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                YDMAStringUtil.Print(resObject);
                JsonArray datas = (JsonArray)resObject.get("data");
                int i = 0;
                while (i < datas.size()) {
                    block38: {
                        String mall_exp_cd;
                        JsonObject data2 = (JsonObject)datas.get(i);
                        JsonArray items = (JsonArray)data2.get("exchangeItemDtoV1s");
                        JsonObject exchangeItemDtoV1s = (JsonObject)items.get(0);
                        String orderid = this.jsonElementNullStr(data2.get("orderId"));
                        String exchangeStatus = this.jsonElementNullStr(data2.get("exchangeStatus"));
                        String mallid = exchangeItemDtoV1s.get("orderItemId").getAsString();
                        int index = this.findIndex(param, arg_0 -> CoupangOrderSearchCommand.lambda$0(orderid, mallid, mall_exp_cd = exchangeItemDtoV1s.get("originalShipmentBoxId").getAsString(), arg_0));
                        if (index <= -1) break block38;
                        ShopOrderMstDto dto = param.get(index);
                        switch (exchangeStatus) {
                            case "PROGRESS": 
                            case "RECEIPT": {
                                dto.setResult_code("1");
                                dto.setOrder_status("E01");
                                break;
                            }
                            case "SUCCESS": {
                                dto.setResult_code("1");
                                dto.setOrder_status(this.getStatus("ORDER", this.jsonElementNullStr(data2.get("orderDeliveryStatusCode"))));
                                ShopOrderMstDto temp = dto.clone("E02");
                                temp.setOrder_date(this.jsonElementNullStr(data2.get("modifiedAt")).replace("T", " "));
                                param.add(temp);
                                break;
                            }
                            case "REJECT": {
                                dto.setResult_code("1");
                                dto.setOrder_status("E01");
                                break;
                            }
                            case "CANCEL": {
                                dto.setResult_code("1");
                                dto.setOrder_status("E01");
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (IOException iOException) {}
                }
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
        return param;
    }

    private List<ShopOrderMstDto> ReturnGetApiList(List<ShopOrderMstDto> param) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v6/vendors/%s/returnRequests";
            String acessKey = param.get(0).getAuthkey1();
            String secretKey = param.get(0).getAuthKey2();
            String vendorid = param.get(0).getVendorId();
            String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getStartDt(), false);
            String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false);
            URL2 = String.format(URL2, vendorid);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("searchType", "timeFrame").addParameter("createdAtFrom", startdt.concat("T01:00")).addParameter("createdAtTo", enddt.concat("T23:59"));
            HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
            client = HttpClients.createDefault();
            response = client.execute((HttpUriRequest)get);
            int status2 = response.getStatusLine().getStatusCode();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                JsonArray datas = (JsonArray)resObject.get("data");
                int i = 0;
                while (i < datas.size()) {
                    JsonObject data2 = (JsonObject)datas.get(i);
                    String orderid = data2.get("orderId").getAsString();
                    String receiptType = data2.get("receiptType").getAsString();
                    String receiptStatus = data2.get("receiptStatus").getAsString();
                    JsonArray returnItems = (JsonArray)data2.get("returnItems");
                    int j = 0;
                    while (j < returnItems.size()) {
                        JsonObject ret = (JsonObject)returnItems.get(j);
                        String mallid = ret.get("sellerProductId").getAsString();
                        String shipmentId = ret.get("shipmentBoxId").getAsString();
                        int returnqty = ret.get("cancelCount").getAsInt();
                        int k = 0;
                        while (k < param.size()) {
                            if (receiptType.equals("RETURN") && receiptStatus.equals("RETURNS_COMPLETED")) {
                                if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                    String stats = param.get(k).getOrder_status();
                                    param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                    ShopOrderMstDto temp = param.get(k).clone("R02");
                                    if (data2.get("releaseStopStatus").getAsString().equals("\ucc98\ub9ac(\ucd9c\uace0\uc911\uc9c0)")) {
                                        param.get(k).setOrder_status("C02");
                                        temp = param.get(k).clone("C02");
                                    }
                                    param.get(k).setResult_code("1");
                                    temp.setOrder_date(this.jsonElementNullStr(data2.get("modifiedAt")).replace("T", " "));
                                    temp.setCopy_idx("");
                                    if (YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) > returnqty) {
                                        int cost = YDMAStringUtil.convertToInt(param.get(k).getSale_cost()) * -1;
                                        int cnt = returnqty * -1;
                                        int woncost = YDMAStringUtil.convertToInt(param.get(k).getWon_cost()) / YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) * returnqty;
                                        temp.setSale_cnt(String.valueOf(cnt));
                                        temp.setSale_cost(String.valueOf(cost));
                                        temp.setTotal_cost(String.valueOf(cost));
                                        temp.setWon_cost(String.valueOf(woncost));
                                        param.get(k).setOrder_status(stats);
                                    }
                                    param.add(temp);
                                }
                            } else if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                if (receiptType.equals("CALCEL") && receiptStatus.equals("RETURNS_COMPLETED")) {
                                    ShopOrderMstDto temp = param.get(k).clone("C02");
                                    temp.setOrder_date(this.jsonElementNullStr(data2.get("modifiedAt")).replace("T", " "));
                                    param.add(temp);
                                }
                                param.get(k).setResult_code("1");
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
        return param;
    }

    private List<ShopOrderMstDto> CancelGetApiList(List<ShopOrderMstDto> param) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v6/vendors/%s/returnRequests";
            String acessKey = param.get(0).getAuthkey1();
            String secretKey = param.get(0).getAuthKey2();
            String vendorid = param.get(0).getVendorId();
            String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getStartDt(), false);
            String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false);
            URL2 = String.format(URL2, vendorid);
            URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("searchType", "timeFrame").addParameter("createdAtFrom", startdt.concat("T01:00")).addParameter("createdAtTo", enddt.concat("T23:59")).addParameter("cancelType", "CANCEL");
            client = HttpClients.createDefault();
            HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
            response = client.execute((HttpUriRequest)get);
            int status2 = response.getStatusLine().getStatusCode();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonParser parser = new JsonParser();
                JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                JsonArray datas = (JsonArray)resObject.get("data");
                int i = 0;
                while (i < datas.size()) {
                    JsonObject data2 = (JsonObject)datas.get(i);
                    String orderid = data2.get("orderId").getAsString();
                    String receiptType = data2.get("receiptType").getAsString();
                    String receiptStatus = data2.get("receiptStatus").getAsString();
                    JsonArray returnItems = (JsonArray)data2.get("returnItems");
                    int j = 0;
                    while (j < returnItems.size()) {
                        JsonObject ret = (JsonObject)returnItems.get(j);
                        String mallid = ret.get("sellerProductId").getAsString();
                        String shipmentId = ret.get("shipmentBoxId").getAsString();
                        int returnqty = ret.get("cancelCount").getAsInt();
                        int k = 0;
                        while (k < param.size()) {
                            if (receiptType.equals("CANCEL") && receiptStatus.equals("RETURNS_COMPLETED")) {
                                if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                    String stats = param.get(k).getOrder_status();
                                    param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                    param.get(k).setResult_code("1");
                                    ShopOrderMstDto temp = param.get(k).clone("C02");
                                    temp.setOrder_date(this.jsonElementNullStr(data2.get("modifiedAt")).replace("T", " "));
                                    temp.setCopy_idx("");
                                    if (YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) > returnqty) {
                                        int cost = YDMAStringUtil.convertToInt(param.get(k).getSale_cost()) * -1;
                                        int cnt = returnqty * -1;
                                        int woncost = YDMAStringUtil.convertToInt(param.get(k).getWon_cost()) / YDMAStringUtil.convertToInt(param.get(k).getSale_cnt()) * returnqty;
                                        temp.setSale_cnt(String.valueOf(cnt));
                                        temp.setSale_cost(String.valueOf(cost));
                                        temp.setTotal_cost(String.valueOf(cost));
                                        temp.setWon_cost(String.valueOf(woncost));
                                        param.get(k).setOrder_status(stats);
                                    }
                                    param.add(temp);
                                }
                            } else if (param.get(k).getOrder_id().equals(orderid) && param.get(k).getMall_product_id().equals(mallid) && param.get(k).getMall_exp_cd().equals(shipmentId)) {
                                param.get(k).setOrder_status(this.getStatus(receiptType, receiptStatus));
                                param.get(k).setResult_code("1");
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
        return param;
    }

    private List<ShopOrderMstDto> getApiList(List<ShopOrderMstDto> param) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL1 = "/v2/providers/openapi/apis/api/v5/vendors/%s/ordersheets/%s/history";
            String acessKey = param.get(0).getAuthkey1();
            String secretKey = param.get(0).getAuthKey2();
            String vendorid = param.get(0).getVendorId();
            for (ShopOrderMstDto dto : param) {
                HttpGet get;
                if (dto.getCopy_idx().isEmpty()) continue;
                String URL2 = String.format(URL1, vendorid, dto.getCopy_idx());
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                client = HttpClients.createDefault();
                response = client.execute((HttpUriRequest)(get = this.getHttp(uriBuilder, secretKey, acessKey)));
                int status2 = response.getStatusLine().getStatusCode();
                if (status2 == 200) {
                    JsonObject ret;
                    String deliveryStatus;
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonParser parser = new JsonParser();
                    JsonObject resObject = (JsonObject)parser.parse((Reader)br);
                    YDMAStringUtil.Print(resObject);
                    JsonObject data2 = (JsonObject)resObject.get("data");
                    JsonArray detail = (JsonArray)data2.get("details");
                    if (detail.size() <= 0 || !dto.getMall_exp_cd().equals(data2.get("shipmentBoxId").getAsString()) || (deliveryStatus = this.jsonElementNullStr((ret = (JsonObject)detail.get(0)).get("deliveryStatus"))).equals("INSTRUCT") || deliveryStatus.equals("ACCEPT")) continue;
                    dto.setOrder_status(this.getStatus("ORDER", deliveryStatus));
                    dto.setResult_code("1");
                    continue;
                }
                dto.setResult_code("0");
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
        return param;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        List<ShopOrderMstDto> result_dto = this.getApiList(param);
        result_dto = this.ReturnGetApiList(result_dto);
        result_dto = this.ExchangeGetApiList(result_dto);
        result_dto = this.CancelGetApiList(result_dto);
        return result_dto;
    }

    private static /* synthetic */ boolean lambda$0(String string, String string2, String string3, ShopOrderMstDto d) {
        return d.getOrder_id().equals(string) && d.getSku_id().equals(string2) && d.getMall_exp_cd().equals(string3);
    }
}

