/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.kdjsystem.mlink.shop.dao.UserExcelFormDetailDto;
import com.kdjsystem.mlink.shop.dao.UserExcelFormMasterDto;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class UserExcelFormDao {
    private static UserExcelFormDao instance = new UserExcelFormDao();

    public static UserExcelFormDao get() {
        return instance;
    }

    public List<UserExcelFormMasterDto> getExcelFormMasterAll() throws Exception {
        ArrayList<UserExcelFormMasterDto> contents = new ArrayList<UserExcelFormMasterDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT  \r\n");
            sql.append("IFNULL(SEQ,  '' ) AS SEQ,  \r\n");
            sql.append("IFNULL(EXCELFORMNAME,  '' ) AS EXCELFORMNAME,  \r\n");
            sql.append("IFNULL(USEYN,  '' ) AS USEYN,  \r\n");
            sql.append("IFNULL(REGISTRANT,  '' ) AS REGISTRANT,  \r\n");
            sql.append("IFNULL(REGISTRATIONDT,  '' ) AS REGISTRATIONDT,  \r\n");
            sql.append("IFNULL(MODIFIER,  '' ) AS MODIFIER,  \r\n");
            sql.append("IFNULL(MODIFICATIONDT,  '' ) AS MODIFICATIONDT  \r\n");
            sql.append("FROM EXCELFORMMASTER  \r\n");
            sql.append("ORDER BY seq");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            YDMAStringUtil.Print("[UserExcelFormMasterDto]" + pstmt.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserExcelFormMasterDto dto = new UserExcelFormMasterDto();
                dto.setSeq(rs.getInt("SEQ"));
                dto.setExcelFormName(rs.getString("EXCELFORMNAME"));
                dto.setUseYN(rs.getString("USEYN"));
                dto.setRegistrant(rs.getString("REGISTRANT"));
                dto.setRegistrationDt(rs.getDate("REGISTRATIONDT"));
                dto.setModifier(rs.getString("MODIFIER"));
                dto.setModificationDt(rs.getDate("MODIFICATIONDT"));
                contents.add(dto);
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int deleteExcelMaster(int inSeq) throws Exception {
        Connection connection = null;
        CallableStatement callableStatement = null;
        int result = -1;
        try {
            connection = DBCPInit.getInstance().getConnection();
            callableStatement = connection.prepareCall("{call DELETE_EXCELMASTER(?)}");
            callableStatement.setInt(1, inSeq);
            boolean hasResult = callableStatement.execute();
            result = !hasResult ? 1 : -1;
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection);
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        return result;
    }

    public int callInsertCopyExcelMaster(int inSeq) {
        Connection connection = null;
        CallableStatement callableStatement = null;
        ResultSet rs = null;
        int newSequence = -1;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                callableStatement = connection.prepareCall("{call INSERT_COPY_EXCELMASTER(?)}");
                callableStatement.setInt(1, inSeq);
                callableStatement.execute();
                rs = callableStatement.getResultSet();
                if (rs != null && rs.next()) {
                    newSequence = rs.getInt("NewSequence");
                }
            }
            catch (Exception exception) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                    DBCPInit.getInstance().freeConnection(connection);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (callableStatement != null) {
                    callableStatement.close();
                }
                DBCPInit.getInstance().freeConnection(connection);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newSequence;
    }

    public List<UserExcelFormDetailDto> getExcelFormDetailAll(int masterSeq) throws Exception {
        ArrayList<UserExcelFormDetailDto> contents = new ArrayList<UserExcelFormDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT  \r\n");
            sql.append("IFNULL(SEQ,  '' ) AS SEQ,  \r\n");
            sql.append("IFNULL(MASTERSEQ,  '' ) AS MASTERSEQ,  \r\n");
            sql.append("IFNULL(EXCELCOLUMNNAME,  '' ) AS EXCELCOLUMNNAME,  \r\n");
            sql.append("IFNULL(EXCELCOLUMNINDEX,  '' ) AS EXCELCOLUMNINDEX,  \r\n");
            sql.append("IFNULL(EXCELCOLUMNVALUE,  '' ) AS EXCELCOLUMNVALUE,  \r\n");
            sql.append("IFNULL(EXCELCOLUMNMEMO,  '' ) AS EXCELCOLUMNMEMO  \r\n");
            sql.append("FROM EXCELFORMDETAIL  \r\n");
            sql.append("WHERE MASTERSEQ = ?");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            YDMAStringUtil.Print("[UserExcelFormDetailDto]" + pstmt.toString());
            pstmt.setInt(1, masterSeq);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserExcelFormDetailDto dto = new UserExcelFormDetailDto();
                dto.setSeq(rs.getInt("SEQ"));
                dto.setExcelColumnName(rs.getString("EXCELCOLUMNNAME"));
                dto.setExcelColumnIndex(rs.getInt("EXCELCOLUMNINDEX"));
                dto.setExcelColumnValue(rs.getString("EXCELCOLUMNVALUE"));
                dto.setExcelColumnMemo(rs.getString("EXCELCOLUMNMEMO"));
                contents.add(dto);
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int isExistMasterFormName(String excelFormName) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        int cnt = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT  \r\n");
                sql.append("COUNT(*) AS CNT  \r\n");
                sql.append("FROM excelformmaster  \r\n");
                sql.append("WHERE excelFormName  = ?  \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int i = 0;
                pstmt.setString(++i, excelFormName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    cnt = rs.getInt("CNT");
                }
                rs.close();
                pstmt.close();
                connection.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        return cnt;
    }

    public List<UserExcelFormMasterDto> getMasterData(int masterSeq) throws Exception {
        ArrayList<UserExcelFormMasterDto> contents = new ArrayList<UserExcelFormMasterDto>();
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT  \r\n");
            sql.append("IFNULL(EXCELFORMNAME,  '') AS EXCELFORMNAME,  \r\n");
            sql.append("IFNULL(USEYN,  '') AS USEYN  \r\n");
            sql.append("FROM EXCELFORMMASTER  \r\n");
            sql.append("WHERE SEQ = ?");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            int i = 0;
            pstmt.setInt(++i, masterSeq);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserExcelFormMasterDto dto = new UserExcelFormMasterDto();
                dto.setSeq(masterSeq);
                dto.setExcelFormName(rs.getString("EXCELFORMNAME"));
                dto.setUseYN(rs.getString("USEYN"));
                contents.add(dto);
            }
            rs.close();
            pstmt.close();
            connection.close();
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        return contents;
    }

    public int getMasterSeq(String name) throws Exception {
        int masterSeq = 0;
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT  \r\n");
            sql.append("IFNULL(SEQ,  '') AS SEQ  \r\n");
            sql.append("FROM EXCELFORMMASTER  \r\n");
            sql.append("WHERE EXCELFORMNAME = ?");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            int i = 0;
            pstmt.setString(++i, name);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                masterSeq = rs.getInt("SEQ");
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        return masterSeq;
    }

    public List<UserExcelFormMasterDto> getUserExcelFormMasterAll() throws Exception {
        ArrayList<UserExcelFormMasterDto> contents = new ArrayList<UserExcelFormMasterDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT SEQ,  \n");
            sql.append("\t   NAME,  \n");
            sql.append("       ROW_NUMBER() OVER (ORDER BY SEQ) AS ROW_NO, \n ");
            sql.append("\t   USE_YN,  \n");
            sql.append("\t   IFNULL(CREATE_USER,  '' ) AS CREATE_USER,  \n");
            sql.append("\t   IFNULL(CREATE_DT,  '' ) AS CREATE_DT,  \n");
            sql.append("\t   IFNULL(MODIFY_USER,  '' ) AS MODIFY_USER,  \n");
            sql.append("       CASE WHEN MODIFY_DT = CREATE_DT THEN '' ELSE IFNULL(MODIFY_DT, '') END AS MODIFY_DT, \n");
            sql.append(" \t   IFNULL(TOP_INSERT_ROW,  1 ) AS TOP_INSERT_ROW, \n");
            sql.append(" \t   IFNULL(GUBUN1,  '' ) AS GUBUN1,  \n");
            sql.append(" \t   IFNULL(GUBUN2,  '' ) AS GUBUN2,  \n");
            sql.append(" \t   IFNULL(GUBUN3,  '' ) AS GUBUN3,  \n");
            sql.append(" \t   IFNULL(GUBUN4,  '' ) AS GUBUN4  \n");
            sql.append("  FROM user_excel_form_master \n");
            sql.append(" ORDER BY SEQ");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserExcelFormMasterDto dto = new UserExcelFormMasterDto();
                dto.setSeq(rs.getInt("SEQ"));
                dto.setExcelFormName(rs.getString("NAME"));
                dto.setUseYN(rs.getString("USE_YN"));
                dto.setRegistrant(rs.getString("CREATE_USER"));
                dto.setRegistrationDt(rs.getDate("CREATE_DT"));
                dto.setModifier(rs.getString("MODIFY_USER"));
                dto.setModificationDt(rs.getDate("MODIFY_DT"));
                dto.setTop_insert_row(rs.getInt("TOP_INSERT_ROW"));
                dto.setRowNo(rs.getInt("ROW_NO"));
                dto.setGubun1(rs.getString("GUBUN1"));
                dto.setGubun2(rs.getString("GUBUN2"));
                dto.setGubun3(rs.getString("GUBUN3"));
                dto.setGubun4(rs.getString("GUBUN4"));
                contents.add(dto);
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<UserExcelFormMasterDto> getUserExcelFormMasterUsed() throws Exception {
        ArrayList<UserExcelFormMasterDto> contents = new ArrayList<UserExcelFormMasterDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT SEQ,  \n");
            sql.append("\t   NAME,  \n");
            sql.append("       ROW_NUMBER() OVER (ORDER BY SEQ) AS ROW_NO, \n ");
            sql.append("\t   USE_YN,  \n");
            sql.append("\t   IFNULL(CREATE_USER,  '' ) AS CREATE_USER,  \n");
            sql.append("\t   IFNULL(CREATE_DT,  '' ) AS CREATE_DT,  \n");
            sql.append("\t   IFNULL(MODIFY_USER,  '' ) AS MODIFY_USER,  \n");
            sql.append("       CASE WHEN MODIFY_DT = CREATE_DT THEN '' ELSE IFNULL(MODIFY_DT, '') END AS MODIFY_DT, \n");
            sql.append(" \t   IFNULL(TOP_INSERT_ROW,  1 ) AS TOP_INSERT_ROW, \n");
            sql.append(" \t   IFNULL(GUBUN1,  '' ) AS GUBUN1,  \n");
            sql.append(" \t   IFNULL(GUBUN2,  '' ) AS GUBUN2,  \n");
            sql.append(" \t   IFNULL(GUBUN3,  '' ) AS GUBUN3,  \n");
            sql.append(" \t   IFNULL(GUBUN4,  '' ) AS GUBUN4  \n");
            sql.append("  FROM user_excel_form_master \n");
            sql.append(" WHERE USE_YN = 'Y'\t\n");
            sql.append(" ORDER BY SEQ");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserExcelFormMasterDto dto = new UserExcelFormMasterDto();
                dto.setSeq(rs.getInt("SEQ"));
                dto.setExcelFormName(rs.getString("NAME"));
                dto.setUseYN(rs.getString("USE_YN"));
                dto.setRegistrant(rs.getString("CREATE_USER"));
                dto.setRegistrationDt(rs.getDate("CREATE_DT"));
                dto.setModifier(rs.getString("MODIFY_USER"));
                dto.setModificationDt(rs.getDate("MODIFY_DT"));
                dto.setTop_insert_row(rs.getInt("TOP_INSERT_ROW"));
                dto.setRowNo(rs.getInt("ROW_NO"));
                dto.setGubun1(rs.getString("GUBUN1"));
                dto.setGubun2(rs.getString("GUBUN2"));
                dto.setGubun3(rs.getString("GUBUN3"));
                dto.setGubun4(rs.getString("GUBUN4"));
                contents.add(dto);
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<UserExcelFormDetailDto> getUserExcelFormDetailByMasterSeq(int matserSeq) throws Exception {
        ArrayList<UserExcelFormDetailDto> contents = new ArrayList<UserExcelFormDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT DETAIL_SEQ,  \n");
            sql.append("\t   COL_INDEX,  \n");
            sql.append("       COL_NAME, \n ");
            sql.append("\t   COL_VALUE,  \n");
            sql.append("\t   IFNULL(COL_MEMO,  '' ) AS COL_MEMO  \n");
            sql.append("  FROM user_excel_form_detail \n");
            sql.append(" WHERE MASTER_SEQ = ? \n");
            sql.append(" ORDER BY DETAIL_SEQ");
            pstmt = connection.prepareStatement(sql.toString().toUpperCase());
            pstmt.setInt(1, matserSeq);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                UserExcelFormDetailDto dto = new UserExcelFormDetailDto();
                dto.setSeq(rs.getInt("DETAIL_SEQ"));
                dto.setMasterSeq(matserSeq);
                dto.setColIndex(rs.getString("COL_INDEX"));
                dto.setExcelColumnName(rs.getString("COL_NAME"));
                dto.setExcelColumnValue(rs.getString("COL_VALUE"));
                dto.setExcelColumnMemo(rs.getString("COL_MEMO"));
                contents.add(dto);
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    /*
     * Loose catch block
     */
    public int initializeExcelForm(UserExcelFormMasterDto mstDto, List<UserExcelFormDetailDto> detailList) throws Exception {
        ResultSet rs;
        Statement detailPstmt;
        PreparedStatement masterPstmt;
        Connection connection;
        block15: {
            connection = null;
            masterPstmt = null;
            detailPstmt = null;
            rs = null;
            connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            String masterSql = "INSERT INTO user_excel_form_master (NAME, USE_YN, TOP_INSERT_ROW, CREATE_USER, GUBUN1, GUBUN2, GUBUN3, GUBUN4) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            masterPstmt = connection.prepareStatement(masterSql, 1);
            masterPstmt.setString(1, mstDto.getExcelFormName());
            masterPstmt.setString(2, mstDto.getUseYN());
            masterPstmt.setInt(3, mstDto.getTop_insert_row());
            masterPstmt.setString(4, YDMASessonUtil.getUserInfo().getUserId());
            masterPstmt.setString(5, mstDto.getGubun1());
            masterPstmt.setString(6, mstDto.getGubun2());
            masterPstmt.setString(7, mstDto.getGubun3());
            masterPstmt.setString(8, mstDto.getGubun4());
            masterPstmt.executeUpdate();
            rs = masterPstmt.getGeneratedKeys();
            int masterSeq = 0;
            if (rs.next()) {
                masterSeq = rs.getInt(1);
            }
            if (masterSeq == 0) {
                throw new SQLException("\ub9c8\uc2a4\ud130 SEQ \uc0dd\uc131 \uc2e4\ud328");
            }
            String detailSql = "INSERT INTO user_excel_form_detail (MASTER_SEQ, COL_INDEX, COL_NAME, COL_VALUE, COL_MEMO) VALUES (?, ?, ?, ?, ?)";
            detailPstmt = connection.prepareStatement(detailSql);
            for (UserExcelFormDetailDto dto : detailList) {
                detailPstmt.setInt(1, masterSeq);
                detailPstmt.setString(2, dto.getColIndex());
                detailPstmt.setString(3, dto.getExcelColumnName());
                detailPstmt.setString(4, dto.getExcelColumnValue());
                detailPstmt.setString(5, dto.getExcelColumnMemo());
                detailPstmt.addBatch();
            }
            detailPstmt.executeBatch();
            connection.commit();
            DBCPInit.getInstance().freeConnection(connection, masterPstmt, rs);
            if (detailPstmt == null) break block15;
            try {
                detailPstmt.close();
            }
            catch (SQLException sQLException) {}
        }
        return 1;
        catch (Exception exception) {
            block16: {
                try {
                    if (connection != null) {
                        connection.rollback();
                    }
                    DBCPInit.getInstance().freeConnection(connection, masterPstmt, rs);
                    if (detailPstmt == null) break block16;
                }
                catch (Throwable throwable) {
                    DBCPInit.getInstance().freeConnection(connection, masterPstmt, rs);
                    if (detailPstmt != null) {
                        try {
                            detailPstmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                try {
                    detailPstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            return -99;
        }
    }

    /*
     * Loose catch block
     */
    public int initializeExcelForm2(UserExcelFormMasterDto mstDto, List<UserExcelFormDetailDto> detailList, int masterSeq) throws Exception {
        Statement deletepstmt;
        Statement detailPstmt;
        PreparedStatement masterPstmt;
        Connection connection;
        block22: {
            connection = null;
            masterPstmt = null;
            detailPstmt = null;
            deletepstmt = null;
            connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE user_excel_form_master \n");
            sql.append("   SET NAME = ?, \n");
            sql.append("       USE_YN = ?, \n");
            sql.append("       TOP_INSERT_ROW = ?, \n");
            sql.append("       MODIFY_USER = ?, \n");
            sql.append("       GUBUN1 = ?, \n");
            sql.append("       GUBUN2 = ?, \n");
            sql.append("       GUBUN3 = ?, \n");
            sql.append("       GUBUN4 = ? \n");
            sql.append(" WHERE SEQ = ?");
            masterPstmt = connection.prepareStatement(sql.toString());
            masterPstmt.setString(1, mstDto.getExcelFormName());
            masterPstmt.setString(2, mstDto.getUseYN());
            masterPstmt.setInt(3, mstDto.getTop_insert_row());
            masterPstmt.setString(4, YDMASessonUtil.getUserInfo().getUserId());
            masterPstmt.setString(5, mstDto.getGubun1());
            masterPstmt.setString(6, mstDto.getGubun2());
            masterPstmt.setString(7, mstDto.getGubun3());
            masterPstmt.setString(8, mstDto.getGubun4());
            masterPstmt.setInt(9, masterSeq);
            masterPstmt.executeUpdate();
            deletepstmt = connection.prepareStatement("DELETE FROM user_excel_form_detail WHERE MASTER_SEQ = ?");
            deletepstmt.setInt(1, masterSeq);
            deletepstmt.executeUpdate();
            String detailSql = "INSERT INTO user_excel_form_detail (MASTER_SEQ, COL_INDEX, COL_NAME, COL_VALUE, COL_MEMO) VALUES (?, ?, ?, ?, ?)";
            detailPstmt = connection.prepareStatement(detailSql);
            for (UserExcelFormDetailDto dto : detailList) {
                detailPstmt.setInt(1, masterSeq);
                detailPstmt.setString(2, dto.getColIndex());
                detailPstmt.setString(3, dto.getExcelColumnName());
                detailPstmt.setString(4, dto.getExcelColumnValue());
                detailPstmt.setString(5, dto.getExcelColumnMemo());
                detailPstmt.addBatch();
            }
            detailPstmt.executeBatch();
            connection.commit();
            DBCPInit.getInstance().freeConnection(connection, masterPstmt, null);
            if (detailPstmt == null) break block22;
            try {
                detailPstmt.close();
            }
            catch (SQLException sQLException) {}
        }
        if (deletepstmt != null) {
            try {
                deletepstmt.close();
            }
            catch (SQLException sQLException) {}
        }
        return 1;
        catch (Exception e) {
            block23: {
                try {
                    if (connection != null) {
                        connection.rollback();
                    }
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, masterPstmt, null);
                    if (detailPstmt == null) break block23;
                }
                catch (Throwable throwable) {
                    DBCPInit.getInstance().freeConnection(connection, masterPstmt, null);
                    if (detailPstmt != null) {
                        try {
                            detailPstmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (deletepstmt != null) {
                        try {
                            deletepstmt.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    throw throwable;
                }
                try {
                    detailPstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (deletepstmt != null) {
                try {
                    deletepstmt.close();
                }
                catch (SQLException sQLException) {}
            }
            return -99;
        }
    }

    public int deleteExcelForm(int seq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        try {
            connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            String sql = "DELETE FROM user_excel_form_master WHERE SEQ = ?";
            pstmt = connection.prepareStatement(sql);
            pstmt.setInt(1, seq);
            int result = pstmt.executeUpdate();
            connection.commit();
            int n = result;
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
            return n;
        }
        catch (Exception e) {
            try {
                if (connection != null) {
                    connection.rollback();
                }
                throw e;
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
        }
    }
}

