/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.kdjsystem.mlink.shop.common.QueryStringUtils;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopOptionProductInDao;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class WorkMngDao {
    static WorkMngDao instance = new WorkMngDao();

    public String getInsertQueryMapper(List<String> lstInsert, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("INSERT INTO %s ", tableName));
        String head = lstInsert.stream().collect(Collectors.joining(",", "(", ") "));
        String bottom = lstInsert.stream().map(p -> String.valueOf("?")).collect(Collectors.joining(",", " VALUES (", ") "));
        sb_result.append(head);
        sb_result.append(bottom);
        return sb_result.toString();
    }

    public String getUpdateQueryMapper(List<String> lstUpdate, String tableName) {
        StringBuilder sb_result = new StringBuilder();
        sb_result.append(String.format("UPDATE  %s  SET ", tableName));
        String str_update = lstUpdate.stream().map(p -> p.concat(" = ?")).collect(Collectors.joining(","));
        sb_result.append(str_update);
        return sb_result.toString();
    }

    public static WorkMngDao get() {
        return instance;
    }

    public List<WorkMngDto> getMaster() throws Exception {
        ArrayList<WorkMngDto> list = new ArrayList<WorkMngDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "\tSELECT \r\n\t\tWORKGRP AS WORKGRP, \r\n\t\tSHOPCD AS SHOPCD,\r\n\t\tSHOPSEQ AS SHOPSEQ,\r\n\t\tCOMPNO  AS COMPNO, \r\n\t\tWORKCD  AS WORKCD, \r\n\t\tWORK_STATUS  AS WORK_STATUS, \r\n\t\tSHOP_USER_ID  AS SHOP_USER_ID, \r\n\t\tWORK_USERID  AS WORK_USERID, \r\n\t\tWORK_STARTDATE  AS WORK_STARTDATE, \r\n\t\tWORK_ENDDATE  AS WORK_ENDDATE, \r\n\t\tWORK_DLAPSED  AS WORK_DLAPSED, \r\n\t\tPROGRESS_RATE  AS PROGRESS_RATE\r\n\t FROM workmgrmaster\r\n where compno = ?\tORDER BY WORKGRP DESC";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getMaster]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    WorkMngDto dto = new WorkMngDto();
                    dto.setWorkgrp(rs.getString("WORKGRP"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setWorkcd(rs.getString("WORKCD"));
                    dto.setWork_status(rs.getString("WORK_STATUS"));
                    dto.setShop_user_id(rs.getString("SHOP_USER_ID"));
                    dto.setWork_userid(rs.getString("WORK_USERID"));
                    dto.setWork_startdate(rs.getString("WORK_STARTDATE"));
                    dto.setWork_enddate(rs.getString("WORK_ENDDATE"));
                    dto.setWorkdlapsed(rs.getString("WORK_DLAPSED"));
                    dto.setProgress_rate(rs.getInt("PROGRESS_RATE"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<WorkMngDetailDto> getChild() throws Exception {
        ArrayList<WorkMngDetailDto> list = new ArrayList<WorkMngDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "\tSELECT \r\n\t\ta.WORKGRP AS WORKGRP, \r\n\t\tb.SEQ  AS  SEQ, \r\n\t\tb.PRODSEQ  AS PRODSEQ, \r\n\t\tb.STATUS AS STATUS, \r\n\t\tb.MESSAGE  AS MESSAGE\r\n   FROM WORKMGRMASTER AS a JOIN WORKMGRDETAIL AS b ON a.WORKGRP=b.WORKGRP \r\n  where a.WORKGRP <> '' \r\n\t ORDER BY a.WORKGRP DESC";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                YDMAStringUtil.Print("[workmgrdetail]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    WorkMngDetailDto dto = new WorkMngDetailDto();
                    dto.setWorkgrp(rs.getString("WORKGRP"));
                    dto.setSeq(rs.getString("SEQ"));
                    dto.setProdseq(rs.getString("PRODSEQ"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setMessage(rs.getString("MESSAGE"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<WorkMngDto> search() throws Exception {
        List<WorkMngDto> masters = this.getMaster();
        List<WorkMngDetailDto> childs = this.getChild();
        for (WorkMngDto master : masters) {
            List<WorkMngDetailDto> child_list = childs.stream().filter(p -> p.getWorkgrp().equals(master.getWorkgrp())).collect(Collectors.toList());
            master.setWork_detail(child_list);
        }
        return masters;
    }

    public int deleteWorkMng(String uuid) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from workmgrmaster where WORKGRP = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, uuid);
                result = pstmt.executeUpdate();
                YDMAStringUtil.Print("[deleteWorkMngMaster]" + pstmt.toString());
                String sql2 = "delete from workmgrdetail where WORKGRP = ?";
                sql2 = sql2.toUpperCase();
                pstmt = connection.prepareStatement(sql2);
                pstmt.setString(1, uuid);
                result = pstmt.executeUpdate();
                YDMAStringUtil.Print("[deleteWorkMngDetail]" + pstmt.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int saveMst(String uuid, WorkMngDto workMngDto) throws Exception {
        int cnt = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("WORKGRP");
                lstInsert.add("SHOPCD");
                lstInsert.add("SHOPSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("WORKCD");
                lstInsert.add("WORK_STATUS");
                lstInsert.add("SHOP_USER_ID");
                lstInsert.add("WORK_USERID");
                lstInsert.add("WORK_STARTDATE");
                lstInsert.add("WORK_ENDDATE");
                lstInsert.add("WORK_DLAPSED");
                lstInsert.add("PROGRESS_RATE");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("WORK_STARTDATE");
                lstUpdate.add("WORK_ENDDATE");
                lstUpdate.add("WORK_DLAPSED");
                lstUpdate.add("PROGRESS_RATE");
                DomesinShopDao.get();
                String sql = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "workmgrmaster");
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, uuid);
                pstmt.setString(++rowIdx, workMngDto.getShopcd());
                pstmt.setString(++rowIdx, workMngDto.getShopseq());
                pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(workMngDto.getCompno()));
                pstmt.setString(++rowIdx, workMngDto.getWorkcd());
                pstmt.setString(++rowIdx, workMngDto.getWork_status());
                pstmt.setString(++rowIdx, workMngDto.getShop_user_id());
                pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(++rowIdx, workMngDto.getWork_startdate());
                pstmt.setString(++rowIdx, workMngDto.getWork_enddate());
                pstmt.setString(++rowIdx, workMngDto.getWork_dlapsed());
                pstmt.setInt(++rowIdx, workMngDto.getProgress_rate());
                pstmt.setString(++rowIdx, workMngDto.getWork_startdate());
                pstmt.setString(++rowIdx, workMngDto.getWork_enddate());
                pstmt.setString(++rowIdx, YDMATimeUtil.getOffset(workMngDto.getWork_startdate(), workMngDto.getWork_enddate()));
                pstmt.setInt(++rowIdx, workMngDto.getProgress_rate());
                pstmt.addBatch();
                pstmt.clearParameters();
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[workmgrmaster]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                cnt = -1;
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return cnt;
    }

    public boolean isExistWork(String compayny_goods_cd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT SEQ  \r\n");
                sql.append("  FROM workmgrdetail  \r\n");
                sql.append(" WHERE PRODSEQ = ?  \r\n");
                pstmt = connection.prepareStatement(sql.toString());
                pstmt.setString(1, compayny_goods_cd);
                YDMAStringUtil.Print("[isExistWork]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public int saveDtl(String uuid, WorkMngDetailDto workMngDetailDto) throws Exception {
        int cnt = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("WORKGRP");
                lstInsert.add("SEQ");
                lstInsert.add("PRODSEQ");
                lstInsert.add("STATUS");
                lstInsert.add("MESSAGE");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("STATUS");
                lstUpdate.add("MESSAGE");
                DomesinShopDao.get();
                String sql = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "workmgrdetail");
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, uuid);
                pstmt.setInt(++rowIdx, YDMAStringUtil.convertToInt(workMngDetailDto.getSeq()));
                pstmt.setString(++rowIdx, workMngDetailDto.getProdseq());
                pstmt.setString(++rowIdx, workMngDetailDto.getStatus());
                pstmt.setString(++rowIdx, workMngDetailDto.getMessage());
                pstmt.setString(++rowIdx, workMngDetailDto.getStatus());
                pstmt.setString(++rowIdx, workMngDetailDto.getMessage());
                pstmt.addBatch();
                pstmt.clearParameters();
                ++cnt;
                YDMAStringUtil.Print("[setworkmgrdetail]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                cnt = -1;
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return cnt;
    }

    public int deleteOptProductIn(String sendseq, int skuseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete \t from shop_optprodin  where sendseq = ?   and skuseq > ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, sendseq);
                pstmt.setInt(2, skuseq);
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return 1;
    }

    public int saveOptProductIn(ShopProductDto prodto, List<ShopOptionDto> optdto, List<ShopProductOptionDto> ItemList2) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("SENDSEQ");
                lstInsert.add("SKUSEQ");
                lstInsert.add("COMPNO");
                lstInsert.add("SHOPPRODNO");
                lstInsert.add("SHOPPRODSKU");
                lstInsert.add("OPTSPECDES");
                lstInsert.add("OPTVERTSTOCK");
                lstInsert.add("OPTSAFESTOCK");
                lstInsert.add("OPTADDAMT");
                lstInsert.add("SHOPPRODSKU_NM");
                lstInsert.add("PRODSEQ");
                lstInsert.add("OPTPRODCD");
                lstInsert.add("OPTPRODNM");
                lstInsert.add("OPTEA");
                lstInsert.add("OPTSALE");
                lstInsert.add("OPTSALEOUT");
                lstInsert.add("OPTNOTUSE");
                lstInsert.add("OPTDELYN");
                lstInsert.add("BARCODE");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("COMPNO");
                lstUpdate.add("SHOPPRODNO");
                lstUpdate.add("SHOPPRODSKU");
                lstUpdate.add("OPTSPECDES");
                lstUpdate.add("OPTVERTSTOCK");
                lstUpdate.add("OPTSAFESTOCK");
                lstUpdate.add("OPTADDAMT");
                lstUpdate.add("SHOPPRODSKU_NM");
                lstUpdate.add("PRODSEQ");
                lstUpdate.add("OPTPRODCD");
                lstUpdate.add("OPTPRODNM");
                lstUpdate.add("OPTEA");
                lstUpdate.add("OPTSALE");
                lstUpdate.add("OPTSALEOUT");
                lstUpdate.add("OPTNOTUSE");
                lstUpdate.add("OPTDELYN");
                lstUpdate.add("BARCODE");
                lstUpdate.add("INSERTDT");
                lstUpdate.add("INSERTID");
                DomesinShopDao.get();
                String sql = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shop_optprodin");
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                ShopOptionProductInDao dao = new ShopOptionProductInDao();
                String sendseq = dao.getShopOptProdInListBySendseq(prodto);
                int cnt = 0;
                for (ShopOptionDto dto : optdto) {
                    cnt = 0;
                    pstmt.setString(++cnt, sendseq);
                    pstmt.setString(++cnt, dto.getSkuseq());
                    pstmt.setString(++cnt, YDMASessonUtil.getUserInfo().getCompno());
                    pstmt.setString(++cnt, prodto.getShopprodno());
                    String optionName = Arrays.asList(dto.getOptspecdes().split(":")).stream().collect(Collectors.joining(" - "));
                    String optionName2 = Arrays.asList(dto.getOptspecdes().split(":")).stream().collect(Collectors.joining(" "));
                    String optionName3 = Arrays.asList(dto.getOptspecdes().split(":")).stream().collect(Collectors.joining(" / "));
                    String optionName4 = Arrays.asList(dto.getOptspecdes().split(":")).stream().collect(Collectors.joining(":"));
                    ShopProductOptionDto venderItem = ItemList2.stream().filter(p -> p.getOptspecdes().contains(optionName)).findAny().orElse(null);
                    ShopProductOptionDto venderItem2 = ItemList2.stream().filter(p -> p.getOptspecdes().contains(optionName2)).findAny().orElse(null);
                    ShopProductOptionDto venderItem3 = ItemList2.stream().filter(p -> p.getOptspecdes().contains(optionName3)).findAny().orElse(null);
                    ShopProductOptionDto venderItem4 = ItemList2.stream().filter(p -> p.getOptspecdes().contains(optionName4)).findAny().orElse(null);
                    if (venderItem != null) {
                        pstmt.setString(++cnt, venderItem.getShopprodsku());
                        pstmt.setString(++cnt, venderItem.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem.getOptaddamt());
                    } else if (venderItem2 != null) {
                        pstmt.setString(++cnt, venderItem2.getShopprodsku());
                        pstmt.setString(++cnt, venderItem2.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem2.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem2.getOptaddamt());
                    } else if (venderItem3 != null) {
                        pstmt.setString(++cnt, venderItem3.getShopprodsku());
                        pstmt.setString(++cnt, venderItem3.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem3.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem3.getOptaddamt());
                    } else if (venderItem4 != null) {
                        pstmt.setString(++cnt, venderItem4.getShopprodsku());
                        pstmt.setString(++cnt, venderItem4.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem4.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem4.getOptaddamt());
                    } else {
                        pstmt.setString(++cnt, "");
                        pstmt.setString(++cnt, "");
                        pstmt.setString(++cnt, "0");
                        pstmt.setString(++cnt, "0");
                        pstmt.setInt(++cnt, 0);
                    }
                    pstmt.setString(++cnt, prodto.getGoods_nm());
                    pstmt.setString(++cnt, prodto.getProdseq());
                    pstmt.setString(++cnt, dto.getOptcompanycd() == "\ucf54\ub4dc\uc5c6\uc74c" ? prodto.getCompayny_goods_cd() : dto.getOptcompanycd());
                    pstmt.setString(++cnt, dto.getName());
                    pstmt.setString(++cnt, "0");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    if (venderItem != null) {
                        pstmt.setString(++cnt, venderItem.getBarcode());
                    } else if (venderItem2 != null) {
                        pstmt.setString(++cnt, venderItem2.getBarcode());
                    } else if (venderItem3 != null) {
                        pstmt.setString(++cnt, venderItem3.getBarcode());
                    } else if (venderItem4 != null) {
                        pstmt.setString(++cnt, venderItem4.getBarcode());
                    } else {
                        pstmt.setString(++cnt, "");
                    }
                    pstmt.setString(++cnt, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++cnt, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++cnt, YDMASessonUtil.getUserInfo().getCompno());
                    pstmt.setString(++cnt, prodto.getShopprodno());
                    if (venderItem != null) {
                        pstmt.setString(++cnt, venderItem.getShopprodsku());
                        pstmt.setString(++cnt, venderItem.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem.getOptaddamt());
                    } else if (venderItem2 != null) {
                        pstmt.setString(++cnt, venderItem2.getShopprodsku());
                        pstmt.setString(++cnt, venderItem2.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem2.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem2.getOptaddamt());
                    } else if (venderItem3 != null) {
                        pstmt.setString(++cnt, venderItem3.getShopprodsku());
                        pstmt.setString(++cnt, venderItem3.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem3.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem3.getOptaddamt());
                    } else if (venderItem4 != null) {
                        pstmt.setString(++cnt, venderItem4.getShopprodsku());
                        pstmt.setString(++cnt, venderItem4.getOptspecdes());
                        pstmt.setString(++cnt, dto.getCnt());
                        pstmt.setString(++cnt, venderItem4.getOptsafestock());
                        pstmt.setInt(++cnt, venderItem4.getOptaddamt());
                    } else {
                        pstmt.setString(++cnt, "");
                        pstmt.setString(++cnt, "");
                        pstmt.setString(++cnt, "0");
                        pstmt.setString(++cnt, "0");
                        pstmt.setInt(++cnt, 0);
                    }
                    pstmt.setString(++cnt, prodto.getGoods_nm());
                    pstmt.setString(++cnt, prodto.getProdseq());
                    pstmt.setString(++cnt, dto.getOptcompanycd() == "\ucf54\ub4dc\uc5c6\uc74c" ? prodto.getCompayny_goods_cd() : dto.getOptcompanycd());
                    pstmt.setString(++cnt, dto.getName());
                    pstmt.setString(++cnt, "0");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    if (venderItem != null) {
                        pstmt.setString(++cnt, venderItem.getBarcode());
                    } else if (venderItem2 != null) {
                        pstmt.setString(++cnt, venderItem2.getBarcode());
                    } else if (venderItem3 != null) {
                        pstmt.setString(++cnt, venderItem3.getBarcode());
                    } else if (venderItem4 != null) {
                        pstmt.setString(++cnt, venderItem4.getBarcode());
                    } else {
                        pstmt.setString(++cnt, "");
                    }
                    pstmt.setString(++cnt, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++cnt, YDMASessonUtil.getUserInfo().getUserId());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                result = this.deleteOptProductIn(sendseq, optdto.size());
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int saveProductIn(ShopProductSendDto dtos) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                ArrayList<String> lstInsert = new ArrayList<String>();
                lstInsert.add("COMPNO");
                lstInsert.add("SHOPCD");
                lstInsert.add("SHOPSEQ");
                lstInsert.add("PRODSEQ");
                lstInsert.add("SHOPPRODNO");
                lstInsert.add("SEQ");
                lstInsert.add("SHOPCATNO");
                lstInsert.add("SHOP_USERID");
                lstInsert.add("GOODS_NM");
                lstInsert.add("GOODS_KEYWORD");
                lstInsert.add("MODEL_NM");
                lstInsert.add("BRAND_NM");
                lstInsert.add("COMPAYNY_GOODS_CD");
                lstInsert.add("GOODS_SEARCH");
                lstInsert.add("GOODS_GUBUN");
                lstInsert.add("SHOP_CID_INFO");
                lstInsert.add("SELECT_OPTION");
                lstInsert.add("TEXT_OPTION");
                lstInsert.add("CLASS_CD1");
                lstInsert.add("CLASS_CD2");
                lstInsert.add("CLASS_CD3");
                lstInsert.add("CLASS_CD4");
                lstInsert.add("PARTNER_ID");
                lstInsert.add("DPARTNER_ID");
                lstInsert.add("MAKER");
                lstInsert.add("ORIGIN");
                lstInsert.add("MAKE_YEAR");
                lstInsert.add("MAKE_DM");
                lstInsert.add("GOODS_SEASON");
                lstInsert.add("SEX");
                lstInsert.add("STATUS");
                lstInsert.add("DELIV_ABLE_REGION");
                lstInsert.add("TAX_YN");
                lstInsert.add("DELV_TYPE");
                lstInsert.add("DELV_COST");
                lstInsert.add("RETURN_DELV_COST");
                lstInsert.add("DELV_QTY");
                lstInsert.add("BANPUM_AREA");
                lstInsert.add("GOODS_COST");
                lstInsert.add("GOODS_PRICE");
                lstInsert.add("MARKET_PRICE");
                lstInsert.add("GOODS_CONSUMER_PRICE");
                lstInsert.add("ISLIMIT");
                lstInsert.add("LIMIT_PRICE");
                lstInsert.add("IS_OVERSEAS");
                lstInsert.add("ADULT");
                lstInsert.add("ISRETURN");
                lstInsert.add("ITYPE");
                lstInsert.add("CHAR_1_NM");
                lstInsert.add("CHAR_1_VAL");
                lstInsert.add("CHAR_2_NM");
                lstInsert.add("CHAR_2_VAL");
                lstInsert.add("IMG_PATH");
                lstInsert.add("IMG_PATH1");
                lstInsert.add("IMG_PATH2");
                lstInsert.add("IMG_PATH3");
                lstInsert.add("IMG_PATH4");
                lstInsert.add("IMG_PATH5");
                lstInsert.add("IMG_PATH6");
                lstInsert.add("IMG_PATH7");
                lstInsert.add("IMG_PATH8");
                lstInsert.add("IMG_PATH9");
                lstInsert.add("IMG_PATH10");
                lstInsert.add("IMG_PATH11");
                lstInsert.add("IMG_PATH12");
                lstInsert.add("IMG_PATH13");
                lstInsert.add("IMG_PATH14");
                lstInsert.add("IMG_PATH15");
                lstInsert.add("IMG_PATH16");
                lstInsert.add("IMG_PATH17");
                lstInsert.add("IMG_PATH18");
                lstInsert.add("IMG_PATH19");
                lstInsert.add("IMG_PATH20");
                lstInsert.add("IMG_PATH21");
                lstInsert.add("IMG_PATH22");
                lstInsert.add("IMG_PATH23");
                lstInsert.add("IMG_PATH24");
                lstInsert.add("GOODS_REMARKS");
                lstInsert.add("CERT_TYPE");
                lstInsert.add("CERT");
                lstInsert.add("CERTNO");
                lstInsert.add("AVLST_DM");
                lstInsert.add("AVLED_DM");
                lstInsert.add("ISSUEDATE");
                lstInsert.add("CERTDATE");
                lstInsert.add("CERT_AGENCY");
                lstInsert.add("CERTFIELD");
                lstInsert.add("MATERIAL");
                lstInsert.add("STOCK_USE_YN");
                lstInsert.add("OPT_TYPE");
                lstInsert.add("PROP_EDIT_YN");
                lstInsert.add("PROP1_CD");
                lstInsert.add("PROP_VAL1");
                lstInsert.add("PROP_VAL2");
                lstInsert.add("PROP_VAL3");
                lstInsert.add("PROP_VAL4");
                lstInsert.add("PROP_VAL5");
                lstInsert.add("PROP_VAL6");
                lstInsert.add("PROP_VAL7");
                lstInsert.add("PROP_VAL8");
                lstInsert.add("PROP_VAL9");
                lstInsert.add("PROP_VAL10");
                lstInsert.add("PROP_VAL11");
                lstInsert.add("PROP_VAL12");
                lstInsert.add("PROP_VAL13");
                lstInsert.add("PROP_VAL14");
                lstInsert.add("PROP_VAL15");
                lstInsert.add("PROP_VAL16");
                lstInsert.add("PROP_VAL17");
                lstInsert.add("PROP_VAL18");
                lstInsert.add("PROP_VAL19");
                lstInsert.add("PROP_VAL20");
                lstInsert.add("PROP_VAL21");
                lstInsert.add("PROP_VAL22");
                lstInsert.add("PROP_VAL23");
                lstInsert.add("PROP_VAL24");
                lstInsert.add("PROP_VAL25");
                lstInsert.add("PROP_VAL26");
                lstInsert.add("PROP_VAL27");
                lstInsert.add("PROP_VAL28");
                lstInsert.add("PACK_CODE_STR");
                lstInsert.add("GOODS_NM_EN");
                lstInsert.add("GOODS_NM_PR");
                lstInsert.add("GOODS_REMARKS2");
                lstInsert.add("GOODS_REMARKS3");
                lstInsert.add("GOODS_REMARKS4");
                lstInsert.add("IMPORTNO");
                lstInsert.add("GOODS_COST2");
                lstInsert.add("ORIGIN2");
                lstInsert.add("EXPIRE_DM");
                lstInsert.add("SUPPLY_SAVE_YN");
                lstInsert.add("DESCRITION");
                lstInsert.add("INSERTDT");
                lstInsert.add("INSERTID");
                lstInsert.add("MODIFYDT");
                lstInsert.add("MODIFYID");
                lstInsert.add("SALEENDDT");
                lstInsert.add("SHOPSENDSTATUS");
                lstInsert.add("GMCATEGNM");
                lstInsert.add("SHOPMODIFYCONTENT");
                lstInsert.add("SELFMOD_NO");
                ArrayList<String> lstUpdate = new ArrayList<String>();
                lstUpdate.add("SHOPPRODNO");
                lstUpdate.add("SEQ");
                lstUpdate.add("SHOPCATNO");
                lstUpdate.add("GOODS_NM");
                lstUpdate.add("GOODS_KEYWORD");
                lstUpdate.add("MODEL_NM");
                lstUpdate.add("BRAND_NM");
                lstUpdate.add("COMPAYNY_GOODS_CD");
                lstUpdate.add("GOODS_SEARCH");
                lstUpdate.add("GOODS_GUBUN");
                lstUpdate.add("SHOP_CID_INFO");
                lstUpdate.add("SELECT_OPTION");
                lstUpdate.add("TEXT_OPTION");
                lstUpdate.add("CLASS_CD1");
                lstUpdate.add("CLASS_CD2");
                lstUpdate.add("CLASS_CD3");
                lstUpdate.add("CLASS_CD4");
                lstUpdate.add("PARTNER_ID");
                lstUpdate.add("DPARTNER_ID");
                lstUpdate.add("MAKER");
                lstUpdate.add("ORIGIN");
                lstUpdate.add("MAKE_YEAR");
                lstUpdate.add("MAKE_DM");
                lstUpdate.add("GOODS_SEASON");
                lstUpdate.add("SEX");
                lstUpdate.add("STATUS");
                lstUpdate.add("DELIV_ABLE_REGION");
                lstUpdate.add("TAX_YN");
                lstUpdate.add("DELV_TYPE");
                lstUpdate.add("DELV_COST");
                lstUpdate.add("RETURN_DELV_COST");
                lstUpdate.add("DELV_QTY");
                lstUpdate.add("BANPUM_AREA");
                lstUpdate.add("GOODS_COST");
                lstUpdate.add("GOODS_PRICE");
                lstUpdate.add("MARKET_PRICE");
                lstUpdate.add("GOODS_CONSUMER_PRICE");
                lstUpdate.add("ISLIMIT");
                lstUpdate.add("LIMIT_PRICE");
                lstUpdate.add("IS_OVERSEAS");
                lstUpdate.add("ADULT");
                lstUpdate.add("ISRETURN");
                lstUpdate.add("ITYPE");
                lstUpdate.add("CHAR_1_NM");
                lstUpdate.add("CHAR_1_VAL");
                lstUpdate.add("CHAR_2_NM");
                lstUpdate.add("CHAR_2_VAL");
                lstUpdate.add("IMG_PATH");
                lstUpdate.add("IMG_PATH1");
                lstUpdate.add("IMG_PATH2");
                lstUpdate.add("IMG_PATH3");
                lstUpdate.add("IMG_PATH4");
                lstUpdate.add("IMG_PATH5");
                lstUpdate.add("IMG_PATH6");
                lstUpdate.add("IMG_PATH7");
                lstUpdate.add("IMG_PATH8");
                lstUpdate.add("IMG_PATH9");
                lstUpdate.add("IMG_PATH10");
                lstUpdate.add("IMG_PATH11");
                lstUpdate.add("IMG_PATH12");
                lstUpdate.add("IMG_PATH13");
                lstUpdate.add("IMG_PATH14");
                lstUpdate.add("IMG_PATH15");
                lstUpdate.add("IMG_PATH16");
                lstUpdate.add("IMG_PATH17");
                lstUpdate.add("IMG_PATH18");
                lstUpdate.add("IMG_PATH19");
                lstUpdate.add("IMG_PATH20");
                lstUpdate.add("IMG_PATH21");
                lstUpdate.add("IMG_PATH22");
                lstUpdate.add("IMG_PATH23");
                lstUpdate.add("IMG_PATH24");
                lstUpdate.add("GOODS_REMARKS");
                lstUpdate.add("CERT_TYPE");
                lstUpdate.add("CERT");
                lstUpdate.add("CERTNO");
                lstUpdate.add("AVLST_DM");
                lstUpdate.add("AVLED_DM");
                lstUpdate.add("ISSUEDATE");
                lstUpdate.add("CERTDATE");
                lstUpdate.add("CERT_AGENCY");
                lstUpdate.add("CERTFIELD");
                lstUpdate.add("MATERIAL");
                lstUpdate.add("STOCK_USE_YN");
                lstUpdate.add("OPT_TYPE");
                lstUpdate.add("PROP_EDIT_YN");
                lstUpdate.add("PROP1_CD");
                lstUpdate.add("PROP_VAL1");
                lstUpdate.add("PROP_VAL2");
                lstUpdate.add("PROP_VAL3");
                lstUpdate.add("PROP_VAL4");
                lstUpdate.add("PROP_VAL5");
                lstUpdate.add("PROP_VAL6");
                lstUpdate.add("PROP_VAL7");
                lstUpdate.add("PROP_VAL8");
                lstUpdate.add("PROP_VAL9");
                lstUpdate.add("PROP_VAL10");
                lstUpdate.add("PROP_VAL11");
                lstUpdate.add("PROP_VAL12");
                lstUpdate.add("PROP_VAL13");
                lstUpdate.add("PROP_VAL14");
                lstUpdate.add("PROP_VAL15");
                lstUpdate.add("PROP_VAL16");
                lstUpdate.add("PROP_VAL17");
                lstUpdate.add("PROP_VAL18");
                lstUpdate.add("PROP_VAL19");
                lstUpdate.add("PROP_VAL20");
                lstUpdate.add("PROP_VAL21");
                lstUpdate.add("PROP_VAL22");
                lstUpdate.add("PROP_VAL23");
                lstUpdate.add("PROP_VAL24");
                lstUpdate.add("PROP_VAL25");
                lstUpdate.add("PROP_VAL26");
                lstUpdate.add("PROP_VAL27");
                lstUpdate.add("PROP_VAL28");
                lstUpdate.add("PACK_CODE_STR");
                lstUpdate.add("GOODS_NM_EN");
                lstUpdate.add("GOODS_NM_PR");
                lstUpdate.add("GOODS_REMARKS2");
                lstUpdate.add("GOODS_REMARKS3");
                lstUpdate.add("GOODS_REMARKS4");
                lstUpdate.add("IMPORTNO");
                lstUpdate.add("GOODS_COST2");
                lstUpdate.add("ORIGIN2");
                lstUpdate.add("EXPIRE_DM");
                lstUpdate.add("SUPPLY_SAVE_YN");
                lstUpdate.add("DESCRITION");
                lstUpdate.add("INSERTDT");
                lstUpdate.add("INSERTID");
                lstUpdate.add("MODIFYDT");
                lstUpdate.add("MODIFYID");
                lstUpdate.add("SALEENDDT");
                lstUpdate.add("SHOPSENDSTATUS");
                lstUpdate.add("GMCATEGNM");
                lstUpdate.add("SHOPMODIFYCONTENT");
                lstUpdate.add("SELFMOD_NO");
                DomesinShopDao.get();
                String sql = DomesinShopDao.getInsertOrUpdateQueryMapper(lstInsert, lstUpdate, "shopprodin");
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                List<ShopProductDto> prodList = dtos.getShopProductDto();
                ShopProductAdditionDto shopProductAdditionDto = dtos.getProductAdditionDto();
                ShoppingMallDetailDto shoppingMallDetailDto = dtos.getShoppingMallDetailDto();
                int cnt = 0;
                for (ShopProductDto dto : prodList) {
                    cnt = 0;
                    pstmt.setString(++cnt, YDMASessonUtil.getUserInfo().getCompno());
                    pstmt.setString(++cnt, dto.getShopcd());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(shoppingMallDetailDto.getShopseq()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getProdseq()));
                    pstmt.setString(++cnt, dto.getShopprodno());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(shopProductAdditionDto == null ? "0" : shopProductAdditionDto.getSeq()));
                    YDMAStringUtil.Print("test:\ube48\uac12" + dto.getShopcatno());
                    pstmt.setString(++cnt, dto.getCatno());
                    pstmt.setString(++cnt, dto.getShopuserid());
                    pstmt.setString(++cnt, dto.getGoods_nm());
                    pstmt.setString(++cnt, dto.getGoods_keyword());
                    pstmt.setString(++cnt, dto.getModel_nm());
                    pstmt.setString(++cnt, dto.getBrand_nm());
                    pstmt.setString(++cnt, dto.getCompayny_goods_cd());
                    pstmt.setString(++cnt, dto.getGoods_search());
                    pstmt.setString(++cnt, dto.getGoods_gubun());
                    if (dto.getShop_cid_info().equals("")) {
                        pstmt.setNull(++cnt, 0);
                    } else {
                        pstmt.setString(++cnt, dto.getShop_cid_info());
                    }
                    pstmt.setString(++cnt, dto.getSelect_option());
                    pstmt.setString(++cnt, dto.getText_option());
                    pstmt.setString(++cnt, dto.getClass_cd1());
                    pstmt.setString(++cnt, dto.getClass_cd2());
                    pstmt.setString(++cnt, dto.getClass_cd3());
                    pstmt.setString(++cnt, dto.getClass_cd4());
                    pstmt.setString(++cnt, dto.getPartner_id());
                    pstmt.setString(++cnt, dto.getDpartner_id());
                    pstmt.setString(++cnt, dto.getMaker());
                    pstmt.setString(++cnt, dto.getOrigin());
                    pstmt.setString(++cnt, dto.getMake_year());
                    pstmt.setString(++cnt, dto.getMake_dm());
                    pstmt.setString(++cnt, dto.getGoods_season());
                    pstmt.setString(++cnt, dto.getSex());
                    pstmt.setString(++cnt, dto.getStatus());
                    pstmt.setString(++cnt, dto.getDeliv_able_region());
                    pstmt.setString(++cnt, dto.getTax_yn());
                    pstmt.setString(++cnt, dto.getDelv_type());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getDelv_cost()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getDelv_r_cost()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getDelivery_qty()));
                    pstmt.setString(++cnt, dto.getBanpum_area());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getGoods_cost()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getGoods_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getMarket_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getGoods_consumer_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getIslimit()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getLimit_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getIs_overseas()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getAdult()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getIsreturn()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getItype()));
                    pstmt.setString(++cnt, dto.getChar_1_nm());
                    pstmt.setString(++cnt, dto.getChar_1_val());
                    pstmt.setString(++cnt, dto.getChar_2_nm());
                    pstmt.setString(++cnt, dto.getChar_2_val());
                    pstmt.setString(++cnt, dto.getImg_path());
                    pstmt.setString(++cnt, dto.getImg_path1());
                    pstmt.setString(++cnt, dto.getImg_path2());
                    pstmt.setString(++cnt, dto.getImg_path3());
                    pstmt.setString(++cnt, dto.getImg_path4());
                    pstmt.setString(++cnt, dto.getImg_path5());
                    pstmt.setString(++cnt, dto.getImg_path6());
                    pstmt.setString(++cnt, dto.getImg_path7());
                    pstmt.setString(++cnt, dto.getImg_path8());
                    pstmt.setString(++cnt, dto.getImg_path9());
                    pstmt.setString(++cnt, dto.getImg_path10());
                    pstmt.setString(++cnt, dto.getImg_path11());
                    pstmt.setString(++cnt, dto.getImg_path12());
                    pstmt.setString(++cnt, dto.getImg_path13());
                    pstmt.setString(++cnt, dto.getImg_path14());
                    pstmt.setString(++cnt, dto.getImg_path15());
                    pstmt.setString(++cnt, dto.getImg_path16());
                    pstmt.setString(++cnt, dto.getImg_path17());
                    pstmt.setString(++cnt, dto.getImg_path18());
                    pstmt.setString(++cnt, dto.getImg_path19());
                    pstmt.setString(++cnt, dto.getImg_path20());
                    pstmt.setString(++cnt, dto.getImg_path21());
                    pstmt.setString(++cnt, dto.getImg_path22());
                    pstmt.setString(++cnt, dto.getImg_path23());
                    pstmt.setString(++cnt, dto.getImg_path24());
                    pstmt.setString(++cnt, dto.getGoods_remarks());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getCert_type()));
                    pstmt.setString(++cnt, dto.getCert());
                    pstmt.setString(++cnt, dto.getCertno());
                    pstmt.setString(++cnt, dto.getAvlst_dm());
                    pstmt.setString(++cnt, dto.getAvled_dm());
                    pstmt.setString(++cnt, dto.getIssuedate());
                    pstmt.setString(++cnt, dto.getCertdate());
                    pstmt.setString(++cnt, dto.getCert_agency());
                    pstmt.setString(++cnt, dto.getCertfield());
                    pstmt.setString(++cnt, dto.getMaterial());
                    pstmt.setString(++cnt, dto.getStock_use_yn());
                    pstmt.setString(++cnt, dto.getOpt_type());
                    pstmt.setString(++cnt, dto.getProp_edit_yn());
                    pstmt.setString(++cnt, dto.getProp1_cd());
                    pstmt.setString(++cnt, dto.getProp_val1());
                    pstmt.setString(++cnt, dto.getProp_val2());
                    pstmt.setString(++cnt, dto.getProp_val3());
                    pstmt.setString(++cnt, dto.getProp_val4());
                    pstmt.setString(++cnt, dto.getProp_val5());
                    pstmt.setString(++cnt, dto.getProp_val6());
                    pstmt.setString(++cnt, dto.getProp_val7());
                    pstmt.setString(++cnt, dto.getProp_val8());
                    pstmt.setString(++cnt, dto.getProp_val9());
                    pstmt.setString(++cnt, dto.getProp_val10());
                    pstmt.setString(++cnt, dto.getProp_val11());
                    pstmt.setString(++cnt, dto.getProp_val12());
                    pstmt.setString(++cnt, dto.getProp_val13());
                    pstmt.setString(++cnt, dto.getProp_val14());
                    pstmt.setString(++cnt, dto.getProp_val15());
                    pstmt.setString(++cnt, dto.getProp_val16());
                    pstmt.setString(++cnt, dto.getProp_val17());
                    pstmt.setString(++cnt, dto.getProp_val18());
                    pstmt.setString(++cnt, dto.getProp_val19());
                    pstmt.setString(++cnt, dto.getProp_val20());
                    pstmt.setString(++cnt, dto.getProp_val21());
                    pstmt.setString(++cnt, dto.getProp_val22());
                    pstmt.setString(++cnt, dto.getProp_val23());
                    pstmt.setString(++cnt, dto.getProp_val24());
                    pstmt.setString(++cnt, dto.getProp_val25());
                    pstmt.setString(++cnt, dto.getProp_val26());
                    pstmt.setString(++cnt, dto.getProp_val27());
                    pstmt.setString(++cnt, dto.getProp_val28());
                    pstmt.setString(++cnt, dto.getPack_code_str());
                    pstmt.setString(++cnt, dto.getGoods_nm_en());
                    pstmt.setString(++cnt, dto.getGoods_nm_pr());
                    pstmt.setString(++cnt, dto.getGoods_remarks2());
                    pstmt.setString(++cnt, dto.getGoods_remarks3());
                    pstmt.setString(++cnt, dto.getGoods_remarks4());
                    pstmt.setString(++cnt, dto.getImportno());
                    pstmt.setString(++cnt, dto.getGoods_cost2());
                    pstmt.setString(++cnt, dto.getOrigin2());
                    pstmt.setString(++cnt, dto.getExpire_dm());
                    pstmt.setString(++cnt, dto.getSupply_save_yn());
                    pstmt.setString(++cnt, dto.getDescrition());
                    pstmt.setString(++cnt, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++cnt, YDMASessonUtil.getCompnoInfo().getUserId());
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, dto.getSaleenddt());
                    int val = Integer.valueOf(dto.getSendstats());
                    switch (val) {
                        case 6000: 
                        case 6100: 
                        case 7000: 
                        case 9000: 
                        case 9100: {
                            pstmt.setInt(++cnt, 8000);
                            break;
                        }
                        default: {
                            pstmt.setInt(++cnt, val);
                        }
                    }
                    pstmt.setString(++cnt, dto.getGmcategnm());
                    pstmt.setString(++cnt, dto.getShopmodifycontent());
                    pstmt.setString(++cnt, dto.getSelfmod_no());
                    pstmt.setString(++cnt, dto.getShopprodno());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(shopProductAdditionDto == null ? "0" : shopProductAdditionDto.getSeq()));
                    pstmt.setString(++cnt, dto.getCatno());
                    pstmt.setString(++cnt, dto.getGoods_nm());
                    pstmt.setString(++cnt, dto.getGoods_keyword());
                    pstmt.setString(++cnt, dto.getModel_nm());
                    pstmt.setString(++cnt, dto.getBrand_nm());
                    pstmt.setString(++cnt, dto.getCompayny_goods_cd());
                    pstmt.setString(++cnt, dto.getGoods_search());
                    pstmt.setString(++cnt, dto.getGoods_gubun());
                    if (dto.getShop_cid_info().equals("")) {
                        pstmt.setNull(++cnt, 0);
                    } else {
                        pstmt.setString(++cnt, dto.getShop_cid_info());
                    }
                    pstmt.setString(++cnt, dto.getSelect_option());
                    pstmt.setString(++cnt, dto.getText_option());
                    pstmt.setString(++cnt, dto.getClass_cd1());
                    pstmt.setString(++cnt, dto.getClass_cd2());
                    pstmt.setString(++cnt, dto.getClass_cd3());
                    pstmt.setString(++cnt, dto.getClass_cd4());
                    pstmt.setString(++cnt, dto.getPartner_id());
                    pstmt.setString(++cnt, dto.getDpartner_id());
                    pstmt.setString(++cnt, dto.getMaker());
                    pstmt.setString(++cnt, dto.getOrigin());
                    pstmt.setString(++cnt, dto.getMake_year());
                    pstmt.setString(++cnt, dto.getMake_dm());
                    pstmt.setString(++cnt, dto.getGoods_season());
                    pstmt.setString(++cnt, dto.getSex());
                    pstmt.setString(++cnt, dto.getStatus());
                    pstmt.setString(++cnt, dto.getDeliv_able_region());
                    pstmt.setString(++cnt, dto.getTax_yn());
                    pstmt.setString(++cnt, dto.getDelv_type());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getDelv_cost()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getDelv_r_cost()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getDelivery_qty()));
                    pstmt.setString(++cnt, dto.getBanpum_area());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getGoods_cost()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getGoods_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getMarket_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getGoods_consumer_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getIslimit()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getLimit_price()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getIs_overseas()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getAdult()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getIsreturn()));
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getItype()));
                    pstmt.setString(++cnt, dto.getChar_1_nm());
                    pstmt.setString(++cnt, dto.getChar_1_val());
                    pstmt.setString(++cnt, dto.getChar_2_nm());
                    pstmt.setString(++cnt, dto.getChar_2_val());
                    pstmt.setString(++cnt, dto.getImg_path());
                    pstmt.setString(++cnt, dto.getImg_path1());
                    pstmt.setString(++cnt, dto.getImg_path2());
                    pstmt.setString(++cnt, dto.getImg_path3());
                    pstmt.setString(++cnt, dto.getImg_path4());
                    pstmt.setString(++cnt, dto.getImg_path5());
                    pstmt.setString(++cnt, dto.getImg_path6());
                    pstmt.setString(++cnt, dto.getImg_path7());
                    pstmt.setString(++cnt, dto.getImg_path8());
                    pstmt.setString(++cnt, dto.getImg_path9());
                    pstmt.setString(++cnt, dto.getImg_path10());
                    pstmt.setString(++cnt, dto.getImg_path11());
                    pstmt.setString(++cnt, dto.getImg_path12());
                    pstmt.setString(++cnt, dto.getImg_path13());
                    pstmt.setString(++cnt, dto.getImg_path14());
                    pstmt.setString(++cnt, dto.getImg_path15());
                    pstmt.setString(++cnt, dto.getImg_path16());
                    pstmt.setString(++cnt, dto.getImg_path17());
                    pstmt.setString(++cnt, dto.getImg_path18());
                    pstmt.setString(++cnt, dto.getImg_path19());
                    pstmt.setString(++cnt, dto.getImg_path20());
                    pstmt.setString(++cnt, dto.getImg_path21());
                    pstmt.setString(++cnt, dto.getImg_path22());
                    pstmt.setString(++cnt, dto.getImg_path23());
                    pstmt.setString(++cnt, dto.getImg_path24());
                    pstmt.setString(++cnt, dto.getGoods_remarks());
                    pstmt.setInt(++cnt, YDMAStringUtil.convertToInt(dto.getCert_type()));
                    pstmt.setString(++cnt, dto.getCert());
                    pstmt.setString(++cnt, dto.getCertno());
                    pstmt.setString(++cnt, dto.getAvlst_dm());
                    pstmt.setString(++cnt, dto.getAvled_dm());
                    pstmt.setString(++cnt, dto.getIssuedate());
                    pstmt.setString(++cnt, dto.getCertdate());
                    pstmt.setString(++cnt, dto.getCert_agency());
                    pstmt.setString(++cnt, dto.getCertfield());
                    pstmt.setString(++cnt, dto.getMaterial());
                    pstmt.setString(++cnt, dto.getStock_use_yn());
                    pstmt.setString(++cnt, dto.getOpt_type());
                    pstmt.setString(++cnt, dto.getProp_edit_yn());
                    pstmt.setString(++cnt, dto.getProp1_cd());
                    pstmt.setString(++cnt, dto.getProp_val1());
                    pstmt.setString(++cnt, dto.getProp_val2());
                    pstmt.setString(++cnt, dto.getProp_val3());
                    pstmt.setString(++cnt, dto.getProp_val4());
                    pstmt.setString(++cnt, dto.getProp_val5());
                    pstmt.setString(++cnt, dto.getProp_val6());
                    pstmt.setString(++cnt, dto.getProp_val7());
                    pstmt.setString(++cnt, dto.getProp_val8());
                    pstmt.setString(++cnt, dto.getProp_val9());
                    pstmt.setString(++cnt, dto.getProp_val10());
                    pstmt.setString(++cnt, dto.getProp_val11());
                    pstmt.setString(++cnt, dto.getProp_val12());
                    pstmt.setString(++cnt, dto.getProp_val13());
                    pstmt.setString(++cnt, dto.getProp_val14());
                    pstmt.setString(++cnt, dto.getProp_val15());
                    pstmt.setString(++cnt, dto.getProp_val16());
                    pstmt.setString(++cnt, dto.getProp_val17());
                    pstmt.setString(++cnt, dto.getProp_val18());
                    pstmt.setString(++cnt, dto.getProp_val19());
                    pstmt.setString(++cnt, dto.getProp_val20());
                    pstmt.setString(++cnt, dto.getProp_val21());
                    pstmt.setString(++cnt, dto.getProp_val22());
                    pstmt.setString(++cnt, dto.getProp_val23());
                    pstmt.setString(++cnt, dto.getProp_val24());
                    pstmt.setString(++cnt, dto.getProp_val25());
                    pstmt.setString(++cnt, dto.getProp_val26());
                    pstmt.setString(++cnt, dto.getProp_val27());
                    pstmt.setString(++cnt, dto.getProp_val28());
                    pstmt.setString(++cnt, dto.getPack_code_str());
                    pstmt.setString(++cnt, dto.getGoods_nm_en());
                    pstmt.setString(++cnt, dto.getGoods_nm_pr());
                    pstmt.setString(++cnt, dto.getGoods_remarks2());
                    pstmt.setString(++cnt, dto.getGoods_remarks3());
                    pstmt.setString(++cnt, dto.getGoods_remarks4());
                    pstmt.setString(++cnt, dto.getImportno());
                    pstmt.setString(++cnt, dto.getGoods_cost2());
                    pstmt.setString(++cnt, dto.getOrigin2());
                    pstmt.setString(++cnt, dto.getExpire_dm());
                    pstmt.setString(++cnt, dto.getSupply_save_yn());
                    pstmt.setString(++cnt, dto.getDescrition());
                    pstmt.setString(++cnt, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++cnt, YDMASessonUtil.getCompnoInfo().getUserId());
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, "");
                    pstmt.setString(++cnt, dto.getSaleenddt());
                    switch (val) {
                        case 6000: 
                        case 6100: 
                        case 7000: 
                        case 9000: 
                        case 9100: {
                            pstmt.setInt(++cnt, 8000);
                            break;
                        }
                        default: {
                            pstmt.setInt(++cnt, val);
                        }
                    }
                    pstmt.setString(++cnt, dto.getGmcategnm());
                    pstmt.setString(++cnt, dto.getShopmodifycontent());
                    pstmt.setString(++cnt, dto.getSelfmod_no());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setShopProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int saveProdLog(ShopProductDto dto, String json) throws Exception {
        int cnt = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into shopprodinlog (sendseq,compno,shopcd,shopprodno,prodno,json)values (?,?,?,?,?,?)";
                ShopOptionProductInDao dao = new ShopOptionProductInDao();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                String sendseq = dao.getShopOptProdInListBySendseq(dto);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, sendseq);
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++rowIdx, dto.getShopcd());
                pstmt.setString(++rowIdx, dto.getShopprodno());
                pstmt.setString(++rowIdx, dto.getCompayny_goods_cd());
                pstmt.setString(++rowIdx, json);
                pstmt.addBatch();
                pstmt.clearParameters();
                pstmt.executeBatch();
                pstmt.clearParameters();
                YDMAStringUtil.Print("[saveProdLog]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                cnt = -1;
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return cnt;
    }

    public int insertOptprodin(List<ShopProductOptionDto> options) throws Exception {
        int result;
        block7: {
            result = 0;
            Connection connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            PreparedStatement pstmt = null;
            try {
                try {
                    ArrayList<String> fileds = new ArrayList<String>();
                    fileds.add("SENDSEQ");
                    fileds.add("SKUSEQ");
                    fileds.add("COMPNO");
                    fileds.add("SHOPPRODNO");
                    fileds.add("SHOPPRODSKU");
                    fileds.add("SHOPPRODSKU_NM");
                    fileds.add("PRODSEQ");
                    fileds.add("OPTPRODCD");
                    fileds.add("OPTPRODNM");
                    fileds.add("OPTSPECDES");
                    fileds.add("OPTSAFESTOCK");
                    fileds.add("OPTVERTSTOCK");
                    fileds.add("OPTADDAMT");
                    fileds.add("INSERTDT");
                    fileds.add("INSERTID");
                    for (ShopProductOptionDto option2 : options) {
                        pstmt = connection.prepareStatement(QueryStringUtils.queryStringInsert(fileds, "shop_optprodin"));
                        int i = 0;
                        pstmt.setInt(++i, option2.getSendseq());
                        pstmt.setInt(++i, option2.getSkuseq());
                        pstmt.setString(++i, Integer.toString(option2.getCompno()));
                        pstmt.setString(++i, option2.getShopprodno());
                        pstmt.setString(++i, option2.getShopprodsku());
                        pstmt.setString(++i, option2.getShopprodsku_nm());
                        pstmt.setInt(++i, option2.getProdseq());
                        pstmt.setString(++i, option2.getOptprodcd());
                        pstmt.setString(++i, option2.getOptprodnm());
                        pstmt.setString(++i, option2.getOptspecdes());
                        pstmt.setInt(++i, Integer.parseInt(option2.getOptsafestock()));
                        pstmt.setInt(++i, Integer.parseInt(option2.getOptvertstock()));
                        pstmt.setInt(++i, option2.getOptaddamt());
                        pstmt.setString(++i, option2.getInsertdt());
                        pstmt.setString(++i, option2.getInsertid());
                        result += pstmt.executeUpdate();
                    }
                    if (result == options.size()) {
                        connection.commit();
                        break block7;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    connection.rollback();
                    e.printStackTrace();
                    connection.close();
                }
            }
            finally {
                connection.close();
            }
        }
        return result;
    }

    public int updateOptprodin(List<ShopProductOptionDto> options) throws Exception {
        int result;
        block7: {
            result = 0;
            Connection connection = DBCPInit.getInstance().getConnection();
            connection.setAutoCommit(false);
            PreparedStatement pstmt = null;
            try {
                try {
                    ArrayList<String> fileds = new ArrayList<String>();
                    fileds.add("SHOPPRODNO");
                    fileds.add("SHOPPRODSKU");
                    fileds.add("SHOPPRODSKU_NM");
                    fileds.add("OPTPRODCD");
                    fileds.add("OPTPRODNM");
                    fileds.add("OPTSPECDES");
                    fileds.add("OPTSAFESTOCK");
                    fileds.add("OPTVERTSTOCK");
                    fileds.add("OPTADDAMT");
                    fileds.add("MODIFYDT");
                    fileds.add("MODIFYID");
                    for (ShopProductOptionDto option2 : options) {
                        StringBuilder sql = new StringBuilder();
                        sql.append(QueryStringUtils.queryStringUpdate(fileds, "shop_optprodin"));
                        sql.append(" WHERE SENDSEQ=" + option2.getSendseq());
                        sql.append(" AND SKUSEQ=" + option2.getSkuseq());
                        sql.append(" AND COMPNO='" + option2.getCompno() + "'");
                        sql.append(" AND SHOPPRODNO='" + option2.getShopprodno() + "'");
                        pstmt = connection.prepareStatement(sql.toString());
                        int i = 0;
                        pstmt.setString(++i, option2.getShopprodno());
                        pstmt.setString(++i, option2.getShopprodsku());
                        pstmt.setString(++i, option2.getShopprodsku_nm());
                        pstmt.setString(++i, option2.getOptprodcd());
                        pstmt.setString(++i, option2.getOptprodnm());
                        pstmt.setString(++i, option2.getOptspecdes());
                        pstmt.setInt(++i, Integer.parseInt(option2.getOptsafestock()));
                        pstmt.setInt(++i, Integer.parseInt(option2.getOptvertstock()));
                        pstmt.setInt(++i, option2.getOptaddamt());
                        pstmt.setString(++i, option2.getModifydt());
                        pstmt.setString(++i, option2.getModifyid());
                        result += pstmt.executeUpdate();
                    }
                    if (result == options.size()) {
                        connection.commit();
                        break block7;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    connection.rollback();
                    e.printStackTrace();
                    connection.close();
                }
            }
            finally {
                connection.close();
            }
        }
        return result;
    }
}

