/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class AlwayzAccessToken {
    private static AlwayzAccessToken context = new AlwayzAccessToken();
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    private static final OkHttpClient hostNameVerifierClinet = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).hostnameVerifier((hostname, session) -> true).build();
    private static Map<String, String> tokenMap = new HashMap<String, String>();
    public static final String USERAGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36";

    private AlwayzAccessToken() {
    }

    public static AlwayzAccessToken get() {
        return context;
    }

    public static OkHttpClient getOkhttpClient() {
        return client;
    }

    public static OkHttpClient hostNameIgnoreClinet() {
        return hostNameVerifierClinet;
    }

    public String getAccessToken(String loginID, String password) {
        String key = loginID + "_" + password;
        String token = tokenMap.get(key);
        if (token == null) {
            YDMAStringUtil.Print("\uc62c\uc6e8\uc774\uc988 \ud1a0\ud070 \uc5c6\uc5b4\uc11c \ubc1c\uae09");
            token = this.refreshAccessToken(loginID, password, key);
        } else if (!this.isTokenValid(token)) {
            YDMAStringUtil.Print("\uc62c\uc6e8\uc774\uc988 \ud1a0\ud070 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc544\uc11c \uc7ac\ubc1c\uae09");
            token = this.refreshAccessToken(loginID, password, key);
        }
        return token;
    }

    private boolean isTokenValid(String token) {
        try {
            URL url = new URL("https://alwayz-seller-back.ilevit.com/sellers/orders/status-counts");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("x-access-token", token);
            connection.setRequestProperty("User-Agent", USERAGENT);
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            StringBuilder responseBuilder = new StringBuilder();
            Throwable throwable = null;
            Object var6_7 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    responseBuilder.append(inputLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(responseBuilder.toString());
            return jsonObject.get("status").getAsInt() == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private String refreshAccessToken(String loginID, String password, String key) {
        Map<Object, Object> loginInfo = new HashMap();
        try {
            loginInfo = IShopCommonLogin.loginAlwayzInfo(loginID, password, "shop9984");
            String newToken = (String)loginInfo.get("token");
            tokenMap.put(key, newToken);
            return newToken;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void clearTokenMap(String loginID, String password) {
        String key = loginID + "_" + password;
        tokenMap.remove(key);
    }
}

