/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.shop.data.alwayz.IShopOrderAlwayzCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class AlwayzLiteOrderCommand
extends IShopOrderAlwayzCommand {
    private static IShopOrderCommand instance = new AlwayzLiteOrderCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AlwayzLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> ret = new ArrayList<ShopOrderMstNewDto>();
        try {
            String inputLine;
            String token = AlwayzAccessToken.get().getAccessToken(dto.getShop_userid(), dto.getShopPw());
            URL url = new URL("https://alwayz-seller-back.ilevit.com/sellers/orders/status");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
            connection.setRequestProperty("x-access-token", token);
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(response.toString());
            int status2 = jsonObject.get("status").getAsInt();
            if (status2 == 200) {
                String[] newOrderState = this.getOrderStatus(dto.getSpecificStatus());
                if (newOrderState.length == 0) {
                    return ret;
                }
                List<String> statusList = Arrays.asList(newOrderState);
                String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
                String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
                JsonArray dataArray = jsonObject.get("data").getAsJsonArray();
                for (JsonElement data2 : dataArray) {
                    JsonArray topKOrderArrays;
                    JsonObject obj = data2.getAsJsonObject();
                    String dataStatus = obj.get("status").getAsString();
                    if (!statusList.contains(dataStatus) || (topKOrderArrays = obj.get("topKOrders").getAsJsonArray()).size() <= 0) continue;
                    List<Object> orderList = new ArrayList();
                    JsonArray comparedOrderArrays = new JsonArray();
                    for (JsonElement ele : topKOrderArrays) {
                        JsonObject object = ele.getAsJsonObject();
                        String preShippingTimeStamp = object.get("preShippingTimeStamp").getAsString().substring(0, 10);
                        if (enddt.compareTo(preShippingTimeStamp) < 0) continue;
                        if (startdt.compareTo(preShippingTimeStamp) > 0) break;
                        comparedOrderArrays.add((JsonElement)object);
                    }
                    if (comparedOrderArrays.size() > 0) {
                        orderList = this.setData(comparedOrderArrays, dto, this.getOrderStat(dataStatus));
                        orderList.forEach(d -> d.setResult_code("1"));
                    }
                    ret.addAll(orderList);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private List<ShopOrderMstNewDto> setData(JsonArray orderArrys, ShopOrderMstNewDto ordDto, String orderStatus) throws Exception {
        ArrayList<ShopOrderMstNewDto> orderList = new ArrayList<ShopOrderMstNewDto>();
        try {
            for (JsonElement ele : orderArrys) {
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setBasicInfo(ordDto);
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setResult_code("1");
                dto.setOrder_status(orderStatus);
                dto.setDelivery_method_str2("\ubb34\ub8cc");
                dto.setWon_cost("0");
                dto.setBox_ea("0");
                dto.setUser_email("");
                dto.setUser_tel("");
                dto.setUser_cel("");
                dto.setReceive_email("");
                JsonObject object = ele.getAsJsonObject();
                dto.setOrder_id(this.jsonElementNullStr(object.get("_id")));
                dto.setOrder_date(this.dateFormat(this.jsonElementNullStr(object.get("preShippingTimeStamp"))));
                dto.setUser_id(this.jsonElementNullStr(object.get("userId")));
                if (object.has("teamDealInfo")) {
                    JsonObject teamDealInfo = object.get("teamDealInfo").getAsJsonObject();
                    JsonArray membersInfo = teamDealInfo.get("membersInfo").getAsJsonArray();
                    for (JsonElement member : membersInfo) {
                        JsonObject memberInfo = member.getAsJsonObject();
                        if (!this.jsonElementNullStr(memberInfo.get("userId")).equals(dto.getUser_id())) continue;
                        dto.setUser_name(this.jsonElementNullStr(memberInfo.get("userName")));
                        break;
                    }
                }
                JsonObject itemInfo = object.get("itemInfo").getAsJsonObject();
                String productName = this.jsonElementNullStr(itemInfo.get("itemTitle"));
                dto.setP_product_name(productName);
                dto.setProduct_name(productName);
                JsonObject selectedOption = object.get("selectedOption").getAsJsonObject();
                dto.setP_sku_value(this.setOption(object, itemInfo, selectedOption));
                dto.setSku_value(dto.getP_sku_value());
                dto.setP_sku_id(dto.getSku_value());
                dto.setMall_product_id(this.jsonElementNullStr(itemInfo.get("itemId")));
                dto.setMall_exp_cd(this.jsonElementNullStr(selectedOption.get("optionCode")));
                try {
                    String optionCode = this.jsonElementNullStr(selectedOption.get("optionCode"));
                    if (optionCode.contains("_")) {
                        optionCode = optionCode.split("_")[0];
                    }
                    dto.setCompayny_goods_cd(optionCode);
                }
                catch (Exception exception) {
                    dto.setCompayny_goods_cd("");
                }
                JsonObject addressInfo = object.get("addressInfo").getAsJsonObject();
                dto.setReceive_name(addressInfo.get("recipient").getAsString());
                dto.setReceive_zipcode(this.jsonElementNullStr(addressInfo.get("postcode")));
                String address = this.jsonElementNullStr(addressInfo.get("postcodeAddress")) + " " + this.jsonElementNullStr(addressInfo.get("detailAddress"));
                dto.setReceive_addr(address);
                String recipientPhoneNumber = this.formatPhoneNumber(this.jsonElementNullStr(addressInfo.get("recipientPhoneNumber")));
                dto.setReceive_tel(recipientPhoneNumber);
                dto.setReceive_cel(recipientPhoneNumber);
                String receivingMethod = addressInfo.get("receivingMethod").getAsString();
                String frontDoorPassword = addressInfo.get("frontDoorPassword").getAsString();
                StringBuilder sb = new StringBuilder();
                if (receivingMethod.equals("door")) {
                    sb.append("\ubb38 \uc55e");
                } else if (receivingMethod.equals("etc")) {
                    sb.append(addressInfo.get("detailForReceivingMethod").getAsString());
                }
                if (!frontDoorPassword.equals("")) {
                    sb.append(", \uacf5\ub3d9\ud604\uad00 \ube44\ubc00\ubc88\ud638 : ").append(frontDoorPassword);
                }
                dto.setDelv_msg(sb.toString());
                if (object.has("shippingInfo")) {
                    JsonObject shippingInfo = object.get("shippingInfo").getAsJsonObject();
                    dto.setDeliveryName(this.jsonElementNullStr(shippingInfo.get("shippingCompanyName")));
                    dto.setDelivery_id(this.jsonElementNullStr(shippingInfo.get("shippingCompanyCode")));
                    dto.setInvoice_no(this.jsonElementNullStr(shippingInfo.get("shippingNumber")));
                }
                dto.setPay_date(this.dateFormat(this.jsonElementNullStr(object.get("payedAt"))));
                if (object.has("paymentInfo")) {
                    JsonObject paymentInfo = object.get("paymentInfo").getAsJsonObject();
                    dto.setPay_method(this.jsonElementNullStr(paymentInfo.get("paymentMethodType")));
                }
                if (object.has("cancelInfo")) {
                    JsonObject cancelInfo = object.get("cancelInfo").getAsJsonObject();
                    Object cancelReason = this.jsonElementNullStr(cancelInfo.get("cancelReason"));
                    if (cancelInfo.has("cancelDetailedReason")) {
                        cancelReason = (String)cancelReason + "[ " + this.jsonElementNullStr(cancelInfo.get("cancelDetailedReason")) + "]";
                    }
                    dto.setClaim_reason((String)cancelReason);
                    dto.setClaim_reg_date(this.dateFormat(this.jsonElementNullStr(cancelInfo.get("cancelRequestedAt"))));
                    if (cancelInfo.has("cancelApprovedAt") && this.jsonElementNullStr(cancelInfo.get("cancelApprovedAt")).isEmpty()) {
                        dto.setClaim_comp_date(this.dateFormat(this.jsonElementNullStr(cancelInfo.get("cancelApprovedAt"))));
                    }
                }
                dto.setProduct_url(ShopCommon.getProductUrl(dto.getShopid(), dto.getMall_product_id(), "", ""));
                int disCountCost = 0;
                int optAddCost = 0;
                int totalPrice = object.get("totalPrice").getAsInt();
                int saleCnt = object.get("quantity").getAsInt();
                int saleCost = totalPrice / saleCnt;
                int payCost = totalPrice - disCountCost;
                double commissionRate = 0.035;
                int mallFee = (int)Math.floor((double)totalPrice * commissionRate);
                int mallFeeWithVat = (int)Math.floor((double)mallFee * 1.1);
                int supplyCost = totalPrice - mallFeeWithVat;
                int mallWonCost = supplyCost - disCountCost;
                int delvCost = object.get("shippingFee").getAsInt();
                dto.setTotal_cost(String.valueOf(totalPrice));
                dto.setSale_cnt(this.fmtInt(saleCnt));
                dto.setSale_cost(this.fmtInt(saleCost));
                dto.setDiscount_cost(this.fmtInt(disCountCost));
                dto.setMall_fee(this.fmtInt(mallFeeWithVat));
                dto.setOpt_add_cost(this.fmtInt(optAddCost));
                dto.setSupply_cost(this.fmtInt(supplyCost));
                dto.setMall_won_cost(this.fmtInt(mallWonCost));
                dto.setPay_cost(this.fmtInt(payCost));
                dto.setDelv_cost(this.fmtInt(delvCost));
                dto.setRate(this.percentOf(mallFeeWithVat, totalPrice, 2));
                dto.setReal_rate(this.percentOf(mallFeeWithVat, payCost, 2));
                dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
                dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
                orderList.add(dto);
            }
        }
        catch (Exception exception) {}
        return orderList;
    }

    private String[] getOrderStatus(String specificStatus) {
        switch (specificStatus) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                return new String[]{"pre-shipping-pre-excel", "pre-shipping-pre-excel-delayed"};
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                return new String[]{"pre-shipping-post-excel", "pre-shipping-post-excel-delayed"};
            }
            case "\ubc30\uc1a1\uc911": {
                return new String[]{"shipping-sending", "shipping"};
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return new String[]{"arrived"};
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                return new String[]{"reviewed"};
            }
            case "\ucde8\uc18c": {
                return new String[]{"canceling-pre-shipping-post-excel", "canceled-pre-shipping"};
            }
            case "\ubc18\ud488": {
                return new String[]{"refunding", "canceling-shipping", "refunded", "canceled-shipping"};
            }
            case "\ud1b5\ud569": {
                return new String[]{"pre-shipping-pre-excel", "pre-shipping-pre-excel-delayed", "pre-shipping-post-excel", "pre-shipping-post-excel-delayed", "shipping-sending", "shipping", "arrived", "reviewed", "canceling-pre-shipping-post-excel", "canceled-pre-shipping", "refunding", "canceling-shipping", "refunded", "canceled-shipping"};
            }
        }
        return new String[0];
    }

    private String getOrderStat(String alwayzStat) {
        String orderStat = "";
        switch (alwayzStat) {
            case "pre-shipping-pre-excel-delayed": 
            case "pre-shipping-pre-excel": {
                orderStat = "100";
                break;
            }
            case "pre-shipping-post-excel": 
            case "pre-shipping-post-excel-delayed": {
                orderStat = "100";
                break;
            }
            case "shipping-sending": 
            case "shipping": {
                orderStat = "403";
                break;
            }
            case "arrived": 
            case "reviewed": {
                orderStat = "410";
                break;
            }
            case "canceling-pre-shipping-post-excel": {
                orderStat = "C01";
                break;
            }
            case "canceled-pre-shipping": {
                orderStat = "C02";
                break;
            }
            case "refunding": 
            case "canceling-shipping": {
                orderStat = "R01";
                break;
            }
            case "refunded": 
            case "canceled-shipping": {
                orderStat = "R02";
            }
        }
        return orderStat;
    }

    private String dateFormat(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }

    private String setOption(JsonObject object, JsonObject itemInfo, JsonObject selectedOption) {
        JsonObject optionsInfo = (JsonObject)itemInfo.get("optionsInfo");
        JsonArray optionNames = (JsonArray)optionsInfo.get("optionNames");
        JsonArray totalOptions = (JsonArray)optionsInfo.get("totalOptions");
        Object option2 = "";
        int selectedValue1 = 0;
        if (optionNames.size() == 2) {
            List optionNameList = IntStream.range(0, optionNames.size()).mapToObj(arg_0 -> ((JsonArray)optionNames).get(arg_0)).map(element -> element.getAsString()).collect(Collectors.toList());
            ArrayList option1 = new ArrayList();
            ArrayList option22 = new ArrayList();
            JsonArray totalOptionsArray1 = totalOptions.get(0).getAsJsonArray();
            IntStream.range(0, totalOptionsArray1.size()).forEach(t -> {
                boolean bl = option1.add(totalOptionsArray1.get(t).getAsJsonObject().get("name").getAsString());
            });
            JsonArray totalOptionsArray2 = totalOptions.get(1).getAsJsonArray();
            IntStream.range(0, totalOptionsArray2.size()).forEach(q -> {
                boolean bl = option22.add(totalOptionsArray2.get(q).getAsJsonObject().get("name").getAsString());
            });
            selectedValue1 = selectedOption.get("0").getAsInt();
            int selectedValue2 = selectedOption.get("1").getAsInt();
            String optionValue1 = (String)option1.get(selectedValue1);
            String optionValue2 = (String)option22.get(selectedValue2);
            option2 = "0. " + (String)optionNameList.get(0) + ": " + optionValue1 + "\n1. " + (String)optionNameList.get(1) + ": " + optionValue2;
        } else if (optionNames.size() == 1) {
            selectedValue1 = selectedOption.get("0").getAsInt();
            String optionName = optionNames.get(0).getAsString();
            String optionValue = totalOptions.get(0).getAsJsonArray().get(selectedValue1).getAsJsonObject().get("name").getAsString();
            option2 = "0. " + optionName + ": " + optionValue;
        }
        return option2;
    }

    private String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber.length() == 11) {
            String part1 = phoneNumber.substring(0, 3);
            String part2 = phoneNumber.substring(3, 7);
            String part3 = phoneNumber.substring(7);
            return part1 + "-" + part2 + "-" + part3;
        }
        return "Invalid phone number length!";
    }
}

