/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.shop.data.alwayz.IShopOrderAlwayzCommand;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AlwayzOrderCancelApprovalCommand
extends IShopOrderAlwayzCommand {
    private static AlwayzOrderCancelApprovalCommand instance = new AlwayzOrderCancelApprovalCommand();
    ObjectMapper mapper = new ObjectMapper();
    JsonParser parser = new JsonParser();

    public static AlwayzOrderCancelApprovalCommand getInstance() {
        return instance;
    }

    private AlwayzOrderCancelApprovalCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(param.get(0).getShop_userid(), param.get(0).getShopPw());
            for (ShopOrderMstDto dto : param) {
                AlwayzOrderCancelApprovalRequest request2 = new AlwayzOrderCancelApprovalRequest();
                request2.setOrderId(dto.getOrder_id());
                request2.setTotalPrice(Integer.parseInt(dto.getTotal_cost()));
                request2.setShippingFee(0);
                request2.setReturnFee(4000);
                request2.setTotalReturnFee(0);
                String json = this.mapper.writeValueAsString((Object)request2);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)json);
                Request req = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/orders").header("x-access-token", token).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").delete(requestBody).build();
                Throwable throwable = null;
                Object var10_11 = null;
                try (Response response = AlwayzAccessToken.getOkhttpClient().newCall(req).execute();){
                    if (response.isSuccessful()) {
                        JsonObject jsonObject = this.parser.parse(response.body().string()).getAsJsonObject();
                        int status2 = jsonObject.get("status").getAsInt();
                        if (status2 == 2000) {
                            dto.setResult_code("1");
                            dto.setResult_text("\uc815\uc0c1\uc801\uc73c\ub85c \ucde8\uc18c\uc2b9\uc778 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                            continue;
                        }
                        dto.setResult_code("-1");
                        dto.setResult_text("\ucde8\uc18c\uc2b9\uc778 \uc751\ub2f5\uc740 \uc788\uc5c8\uc73c\ub098 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        continue;
                    }
                    dto.setResult_code("-1");
                    dto.setResult_text("\ucde8\uc18c\uc2b9\uc778 \ucc98\ub9ac\uc911\uc5d0 \uc751\ub2f5 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc62c\uc6e8\uc774\uc988 \ucde8\uc18c\uc2b9\uc778 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4..");
        }
        return param;
    }

    class AlwayzOrderCancelApprovalRequest {
        @JsonProperty(value="orderId")
        private String orderId;
        @JsonProperty(value="totalPrice")
        private int totalPrice;
        @JsonProperty(value="shippingFee")
        private int shippingFee;
        @JsonProperty(value="returnFee")
        private int returnFee;
        @JsonProperty(value="totalReturnFee")
        private int totalReturnFee;

        AlwayzOrderCancelApprovalRequest() {
        }

        public String getOrderId() {
            return this.orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        public int getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(int totalPrice) {
            this.totalPrice = totalPrice;
        }

        public int getShippingFee() {
            return this.shippingFee;
        }

        public void setShippingFee(int shippingFee) {
            this.shippingFee = shippingFee;
        }

        public int getReturnFee() {
            return this.returnFee;
        }

        public void setReturnFee(int returnFee) {
            this.returnFee = returnFee;
        }

        public int getTotalReturnFee() {
            return this.totalReturnFee;
        }

        public void setTotalReturnFee(int totalReturnFee) {
            this.totalReturnFee = totalReturnFee;
        }
    }
}

