/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAlwayzAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.shop.dao.WorkmgrlogDao;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzExitsProductCd;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import gui.ava.html.image.generator.HtmlImageGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class AlwayzProductRegService
implements IProduct {
    private static final int TIMEOUT = 15000;
    private static final int CATEGORY_RESPONSE_LIMIT = 10;
    JsonParser jsonParser = new JsonParser();
    private static final MediaType MEDIA_TYPE_OCTET = MediaType.get((String)"application/octet-stream");

    @Override
    public synchronized ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShopProductAlwayzAdditionDto dtllist = (ShopProductAlwayzAdditionDto)sendProdList.getProductAdditionDto();
        ShoppingMallDetailDto shoppingMallDetailDto = sendProdList.getShoppingMallDetailDto();
        List<ShopProductDto> prodList = sendProdList.getShopProductDto();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        workMngDto.setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        String uuid = sendProdList.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        double mod = 0.0;
        double rate = 0.0;
        try {
            String loginID = shoppingMallDetailDto.getShoppingid();
            String password = shoppingMallDetailDto.getPassword();
            String shopcd = shoppingMallDetailDto.getShopcd();
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            mod = sendProdList.isManual() ? (double)conf.getProccnt() / (double)prodList.size() : 100.0 / (double)prodList.size();
            int progress = workMngDto.getProgress_rate();
            List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ShopProductDto dto : prodList) {
                if ((int)(rate += mod) > 0) {
                    progress += (int)rate;
                    rate = 0.0;
                }
                workMngDto.setProgress_rate(progress);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        String matched = IProduct.findFirstForbiddenKeyword(dto, shoppingMallDetailDto.getForbiddenKeywords());
                        if (matched != null) {
                            throw new IllegalArgumentException(String.format("\uae08\uc9c0 \ud0a4\uc6cc\ub4dc '%s'\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc0c1\ud488\uba85=\"%s\", \uac80\uc0c9 \ud0a4\uc6cc\ub4dc=\"%s\"", matched, dto.getGoods_nm(), dto.getGoods_search()));
                        }
                        String ProdNo = AlwayzExitsProductCd.get().getIsExistProdNo(dto.getCompayny_goods_cd(), loginID, password, shopcd);
                        if (!ProdNo.equals("")) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        if (ProdNo.contains("ERROR")) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328 : \uc0c1\ud488 \uc911\ubcf5 \uccb4\ud06c \uc911\uc5d0 \uc5d0\ub7ec \ubc1c\uc0dd [" + ProdNo.substring(5) + "]");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328 : \uc0c1\ud488 \uc911\ubcf5 \uccb4\ud06c \uc911\uc5d0 \uc5d0\ub7ec \ubc1c\uc0dd [" + ProdNo.substring(5) + "]");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        ArrayList<String> strImages = new ArrayList();
                        ImageTransformParams params = new ImageTransformParams();
                        params.setShopProductDto(dto);
                        params.setChangesize(dtllist.getChangesize());
                        params.setChangeSizeX(dtllist.getChangeSizeX());
                        params.setChangeSizeY(dtllist.getChangeSizeY());
                        params.setChangeSizeW(dtllist.getChangeSizeW());
                        params.setChangeSizeH(dtllist.getChangeSizeH());
                        params.setAngle(dtllist.getAngle());
                        params.setScalePercent(dtllist.getScalePercent());
                        params.setImgThreeOnFour(dtllist.getImgThreeOnFour());
                        params.setRemoveImgTextYN("");
                        params.setMirrorImgYN(dtllist.getMirrorImgYN());
                        params.setImageresize(dtllist.getImageResize());
                        params.setImageresize1("");
                        UnifiedUploadManager manager = new UnifiedUploadManager();
                        strImages = manager.processAndUploadImages(params);
                        this.DownLoadDetailImage(dto, dtllist);
                        String json = this.MakeProductJson(dto, dtllist, loginID, password, shoppingMallDetailDto);
                        json = json.replaceAll("\"optionPrice\"", "\"optionPrices\"");
                        String token = this.ProductRegSend(json, dto, dtllist, loginID, password);
                        this.RegImage(strImages, dto, dtllist, token);
                        if (!dto.getShopprodno().equals("")) {
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            String message = shoppingMallDetailDto.getShopnm() + "\uc5d0 \uc0c1\ud488\uc774 \ub4f1\ub85d\ub418\uc5c8\uc2b5\ub2c8\ub2e4. [" + dto.getShopprodno() + "]";
                            workMngDetailDto.setMessage(message);
                            dto.setShopprodno(dto.getShopprodno());
                            dto.setResult_text(message);
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                        } else {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(dto.getResult_text());
                            dto.setResult_code("-1");
                            dto.setResult_text(dto.getResult_text());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    InterruptSource.Thread.sleep((long)5000L);
                    if (!conf.getSaveproductlogyn().equals("Y")) continue;
                    ArrayList<String> sendList = new ArrayList<String>();
                    sendList.add(uuid);
                    sendList.add(dto.getShopcd());
                    sendList.add(shoppingMallDetailDto.getShopnm());
                    sendList.add(dto.getShopseq());
                    sendList.add(loginID);
                    sendList.add(shoppingMallDetailDto.getNicknm1());
                    sendList.add(workMngDetailDto.getSeq());
                    sendList.add(dto.getCompayny_goods_cd());
                    sendList.add(workMngDetailDto.getStatus());
                    sendList.add(workMngDetailDto.getMessage());
                    sendList.add(dtllist.getSeq());
                    sendList.add(dtllist.getTitle());
                    sendList.add(dtllist.getImgOneOnOne());
                    sendList.add(String.valueOf(dtllist.getSellerDc()));
                    sendList.add(String.valueOf(dtllist.getMargin()));
                    sendList.add(String.valueOf(dtllist.getCommDC()));
                    sendList.add(dtllist.getChangeSizeX());
                    sendList.add(dtllist.getChangeSizeY());
                    sendList.add(dtllist.getChangeSizeW());
                    sendList.add(dtllist.getChangeSizeH());
                    sendList.add(String.valueOf(dtllist.getAngle()));
                    sendList.add(String.valueOf(dtllist.getScalePercent()));
                    sendList.add(dtllist.getMirrorImgYN());
                    sendList.add(dto.getGoods_keyword());
                    sendList.add(dto.getClass_cd3());
                    sendList.add(dto.getClass_nm1());
                    sendList.add(YDMATimeUtil.getCurrentTimeByYDFormat());
                    sendList.add(dto.getGoods_cost());
                    sendList.add(dto.getDelv_cost());
                    sendList.add(dto.getGoods_search());
                    sendList.add("0");
                    WorkmgrlogDao.get().insertWorkLog(sendList);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            workMngDto.setWork_enddate(YDMATimeUtil.getCurrentTimeByYDFormat());
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    private void DownLoadDetailImage(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist) throws IOException {
        Path imgDir = this.prepareImageFolder();
        String normalizedHtml = this.replaceBaseUrl(dto.getGoods_keyword(), dto.getGoods_remarks());
        dto.setGoods_remarks(normalizedHtml);
        if (StringUtils.isNotBlank((CharSequence)dtllist.getProddetailfront())) {
            this.saveHtmlAsImage(dtllist.getProddetailfront(), imgDir.resolve(dto.getCompayny_goods_cd() + "-alwayzRegDetailFront.png"));
        }
        if (StringUtils.isNotBlank((CharSequence)dtllist.getProddetailback()) && "1".equals(dtllist.getProddetailoutput())) {
            this.saveHtmlAsImage(dtllist.getProddetailback(), imgDir.resolve(dto.getCompayny_goods_cd() + "-alwayzRegDetailBack.png"));
        }
        String fullHtml = this.buildDetailTableHtml(IProduct.removeBrokenImgTag(normalizedHtml));
        this.saveHtmlAsImage(fullHtml, imgDir.resolve(dto.getCompayny_goods_cd() + "-alwayzRegDetail.png"));
    }

    private Path prepareImageFolder() throws IOException {
        String imgPath = null;
        try {
            imgPath = ShopCommon.getImgPath();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Path dir = Paths.get(imgPath, new String[0]);
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                YDMAStringUtil.Print(String.format("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \ud3f4\ub354 \uc0dd\uc131: %s", dir));
            }
            catch (IOException e) {
                YDMAStringUtil.Print(String.format("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \ud3f4\ub354 \uc0dd\uc131 \uc2e4\ud328: %s,%s", dir, e));
                throw e;
            }
        }
        return dir;
    }

    private String replaceBaseUrl(String keyword, String html) {
        if (html == null) {
            return "";
        }
        switch (keyword) {
            case "shop9987": {
                return html.replace("https://www.onnme.com//", "https://cafe24.poxo.com/ec01/onnme/0jJurf5+JqL2mXn6P+LWO7AOJReIvurqGIXrcbUKXpOyPc6+sV46LMYTP2N64fK/UxkTbRHFkp58If06vHlUUA==/_/");
            }
            case "shop0000": {
                return html.replace("https://cbw.co.kr//", "https://cafe24.poxo.com/ec01/kdh0201/EjglQcnyYl9oLKpqUS6wZgXi8sojGAGtEWIWWXL2plRUVd7qyEd9+lcioi6YTYl8+M0/iGFZrQSxc8jTkkjqtw==/_/");
            }
            case "shop9986": {
                return html.replace("https://xn--jt2by0pl8b7va956c.kr", "https://ydinc.cafe24.com");
            }
        }
        return html;
    }

    private void saveHtmlAsImage(String html, Path outputFile) throws IOException {
        YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \ubcc0\ud658 \uc2dc\uc791: " + String.valueOf(outputFile.getFileName()));
        HtmlImageGenerator hig = new HtmlImageGenerator();
        hig.loadHtml(html);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(() -> hig.saveAsImage(outputFile.toString()));
        try {
            try {
                future.get(60L, TimeUnit.SECONDS);
                YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \uc131\uacf5: " + String.valueOf(outputFile));
            }
            catch (TimeoutException e) {
                future.cancel(true);
                YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \ud0c0\uc784\uc544\uc6c3: " + String.valueOf(outputFile));
                throw new IOException("\uc774\ubbf8\uc9c0 \uc800\uc7a5\uc774 \uc9c0\uc815 \uc2dc\uac04(60\ucd08)\uc744 \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4.", e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof UncheckedIOException) {
                    throw ((UncheckedIOException)cause).getCause();
                }
                throw new IOException("\uc774\ubbf8\uc9c0 \uc800\uc7a5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", cause);
            }
            catch (InterruptedException e) {
                InterruptSource.Thread.currentThread().interrupt();
                throw new IOException("\uc774\ubbf8\uc9c0 \uc800\uc7a5\uc774 \uc778\ud130\ub7fd\ud2b8\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", e);
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private String buildDetailTableHtml(String html) {
        if (StringUtils.containsIgnoreCase((CharSequence)html, (CharSequence)"<img")) {
            Document doc = Jsoup.parse((String)html);
            Elements imgs = doc.select("img");
            StringBuilder sb = new StringBuilder().append("<div align=\"center\">\n").append("  <table style=\"text-align:center;margin:auto;\">\n");
            imgs.forEach(img -> {
                String src = img.attr("src");
                sb.append("    <tr><td><img src='").append(src).append("' style=\"display:block;\"></td></tr>\n");
            });
            sb.append("  </table>\n</div>");
            return sb.toString();
        }
        return html;
    }

    private void RegImage(List<String> strImages, ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String token) throws Exception {
        this.uploadMainImages(strImages, dto, token);
        this.uploadDetailImages(dto, dtllist, token);
    }

    private void uploadMainImages(List<String> imagePaths, ShopProductDto dto, String token) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("itemId", dto.getShopprodno());
        int index = 1;
        for (String path : imagePaths) {
            File file = new File(path);
            if (file.exists()) {
                String fileName = "main" + index + ".jpg";
                builder.addFormDataPart("image", fileName, this.createRequestBody(file));
                ++index;
                continue;
            }
            YDMAStringUtil.Print("\uba54\uc778 \uc774\ubbf8\uc9c0 \ud30c\uc77c \uc5c6\uc74c: " + path);
        }
        Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/main-images").put((RequestBody)builder.build()).addHeader("x-access-token", token).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").build();
        Object object = null;
        Object var8_9 = null;
        try (Response response = AlwayzAccessToken.hostNameIgnoreClinet().newCall(request2).execute();){
            YDMAStringUtil.Print(response.body().string());
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    private void uploadDetailImages(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String token) throws Exception {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("itemId", dto.getShopprodno());
        if (!dtllist.getProddetailfront().isEmpty()) {
            File front = this.getImageFile(dto.getCompayny_goods_cd(), "DetailFront");
            this.addImagePart(builder, "detailFront.png", front);
        }
        File detail = this.getImageFile(dto.getCompayny_goods_cd(), "Detail");
        this.addImagePart(builder, "detail.png", detail);
        if (!dtllist.getProddetailback().isEmpty() && "1".equals(dtllist.getProddetailoutput())) {
            File back = this.getImageFile(dto.getCompayny_goods_cd(), "DetailBack");
            this.addImagePart(builder, "detailBack.png", back);
        }
        Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items/detail-images").put((RequestBody)builder.build()).addHeader("x-access-token", token).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").build();
        Throwable throwable = null;
        Object var8_9 = null;
        try (Response response = AlwayzAccessToken.hostNameIgnoreClinet().newCall(request2).execute();){
            YDMAStringUtil.Print(response.body().string());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void addImagePart(MultipartBody.Builder builder, String partName, File file) {
        if (file.exists()) {
            builder.addFormDataPart("image", partName, this.createRequestBody(file));
        } else {
            YDMAStringUtil.Print("\uc0c1\uc138 \uc774\ubbf8\uc9c0 \ud30c\uc77c \uc5c6\uc74c: " + file.getAbsolutePath());
        }
    }

    private File getImageFile(String code, String suffix) throws Exception {
        String path = ShopCommon.getImgPath() + "/" + code + "-alwayzReg" + suffix + ".png";
        return new File(path);
    }

    private RequestBody createRequestBody(File file) {
        return RequestBody.create((MediaType)MEDIA_TYPE_OCTET, (File)file);
    }

    private String ProductRegSend(String json, ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(loginID, password);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)json);
            Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/items").addHeader("Connection", "keep-alive").addHeader("x-access-token", token).addHeader("Content-Type", "application/json").addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").post(requestBody).build();
            Throwable throwable = null;
            Object var10_12 = null;
            try (Response response = AlwayzAccessToken.getOkhttpClient().newCall(request2).execute();){
                if (!response.isSuccessful()) {
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \uc694\uccad \uc2e4\ud328: HTTP " + response.code());
                }
                String body = response.body().string();
                if (body.contains("wrong")) {
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328: " + body);
                }
                JsonObject jsonObject = (JsonObject)this.jsonParser.parse(body);
                int status2 = jsonObject.get("status").getAsInt();
                if (status2 != 2000) {
                    String msg = jsonObject.has("msg") ? jsonObject.get("msg").getAsString() : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958";
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328: " + msg + " [CODE: " + status2 + "]");
                }
                if (!jsonObject.has("data") || jsonObject.get("data").isJsonNull()) {
                    throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \uc131\uacf5 \uc751\ub2f5\uc5d0 'data'\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                dto.setShopprodno(jsonObject.get("data").getAsString());
                return token;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("\uc0c1\ud488 \ub4f1\ub85d \uc911 \uc608\uc678 \ubc1c\uc0dd: " + e.getMessage(), e);
        }
    }

    private String MakeProductJson(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String json = "";
        try {
            int salePrice;
            int individualPurchasePrice;
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            ObjectMapper mapper = new ObjectMapper();
            AlwayzProductReg azReg = new AlwayzProductReg();
            String token = this.CategorySetting(azReg, dto, dtllist, loginID, password);
            this.ProductNameSetting(azReg, dtllist, dto);
            resultMarketPrice = this.PriceSetting(dto, dtllist, resultMarketPrice);
            int teamPurchasePrice = Integer.parseInt(dto.getGoods_price());
            if (dtllist.getTeamPurchasePriceUnit().equals("percent")) {
                individualPurchasePrice = (int)(Math.ceil((double)teamPurchasePrice / (1.0 - 0.01 * (double)dtllist.getTeamPurchasePrice()) / 10.0) * 10.0);
                salePrice = individualPurchasePrice - teamPurchasePrice;
            } else {
                salePrice = dtllist.getTeamPurchasePrice();
                individualPurchasePrice = teamPurchasePrice + salePrice;
            }
            azReg.itemInfo.individualPurchasePrice = individualPurchasePrice;
            azReg.itemInfo.teamPurchasePrice = teamPurchasePrice;
            azReg.itemInfo.discountRate = (double)salePrice / (double)individualPurchasePrice;
            TestingSkuGroupLogs testingGroupLog = new TestingSkuGroupLogs();
            this.OptionSetting(azReg, dtllist, dto, individualPurchasePrice, teamPurchasePrice, testingGroupLog);
            this.DeliverySetting(azReg, dtllist, dto);
            this.GosiSetting(azReg, dtllist, dto);
            azReg.itemInfo.soldOut = false;
            azReg.itemInfo.hurryUp = false;
            azReg.itemInfo.totalOrderQuantity = 0;
            azReg.itemInfo.totalRatingCount = 0;
            azReg.itemInfo.totalRatingScore = 0.0;
            azReg.itemInfo.hideSellerInfo = false;
            azReg.itemInfo.vectorWeights = 1;
            this.SellerInfoSetting(azReg, dtllist, token, loginID, password);
            azReg.itemInfo.teamDealThreshold = dtllist.getTeamDealthReshold();
            azReg.itemInfo.purchaseLimits = dtllist.getPurchaseLimits();
            azReg.itemInfo.testingSkuGroup = "aperion";
            testingGroupLog.testingSkuGroup = "aperion";
            testingGroupLog.teamPurchasePrice = teamPurchasePrice;
            testingGroupLog.individualPurchasePrice = individualPurchasePrice;
            testingGroupLog.soldOut = false;
            azReg.itemInfo.testingSkuGroupLogs.add(testingGroupLog);
            azReg.itemInfo.sellerType = "inboundSeller";
            azReg.itemInfo.itemRankTestingSku = true;
            azReg.itemInfo.alfarmPhotoReviewMode = true;
            azReg.itemInfo.recommendItemCode = dto.getCompayny_goods_cd();
            if (dto.getGoods_search().equals("")) {
                azReg.itemInfo.textForQuery = "";
            } else {
                String result;
                String goodsSearch = dto.getGoods_search();
                Pattern specialCharPattern = Pattern.compile("[^\\uAC00-\\uD7A3A-Za-z0-9\\s]");
                Pattern hanjaPattern = Pattern.compile("[\\u2E80-\\u2EFF\\u31C0-\\u31EF\\u3200-\\u32FF\\u3400-\\u4DBF\\u4E00-\\u9FBF\\uF900-\\uFAFF]");
                ArrayList<String> cleanKeywords = new ArrayList<String>();
                String[] stringArray = goodsSearch.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String rawTag = stringArray[n2];
                    String tag = rawTag.trim();
                    if (!tag.isEmpty()) {
                        Matcher specialCharMatcher = specialCharPattern.matcher(tag);
                        Matcher hanjaMatcher = hanjaPattern.matcher(tag);
                        if (!specialCharMatcher.find() && !hanjaMatcher.find()) {
                            cleanKeywords.add(tag);
                        }
                    }
                    ++n2;
                }
                azReg.itemInfo.textForQuery = result = cleanKeywords.stream().limit(5L).collect(Collectors.joining(","));
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            json = mapper.writeValueAsString((Object)azReg);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private void SellerInfoSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, String token, String loginID, String password) throws Exception {
        try {
            URL url = new URL("https://alwayz-seller-back.ilevit.com/sellers");
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("x-access-token", token);
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            StringBuilder responseBuilder = new StringBuilder();
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    responseBuilder.append(inputLine);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            JsonObject jsonObject = (JsonObject)this.jsonParser.parse(responseBuilder.toString());
            if (jsonObject.get("status").getAsInt() == 200) {
                JsonObject item = (JsonObject)jsonObject.get("data");
                azReg.itemInfo.sellerInfo.sellerId = item.get("_id").getAsString();
                azReg.itemInfo.sellerInfo.address = item.get("address").getAsString();
                azReg.itemInfo.sellerInfo.businessRegistrationNumber = item.get("businessRegistrationNumber").getAsString();
                azReg.itemInfo.sellerInfo.contactNumber = item.get("contactNumber").getAsString();
                azReg.itemInfo.sellerInfo.email = item.get("email").getAsString();
                azReg.itemInfo.sellerInfo.mailOrderBusinessNumber = item.get("mailOrderBusinessNumber").getAsString();
                azReg.itemInfo.sellerInfo.sellerDisplayName = item.get("sellerDisplayName").getAsString();
            }
        }
        catch (Exception e) {
            AlwayzAccessToken.get().clearTokenMap(loginID, password);
            throw new Exception("\ud310\ub9e4\uc790 \uc815\ubcf4 \uc870\ud68c \uc2e4\ud328: " + e.getMessage(), e);
        }
    }

    private String CategorySetting(AlwayzProductReg azReg, ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String loginID, String password) throws Exception {
        try {
            String token = AlwayzAccessToken.get().getAccessToken(loginID, password);
            if (MLinkCommon.get().isNotNullEmpty(dtllist.getShopcatno())) {
                azReg.itemInfo.categoryInfo.minimumCategoryId = Integer.parseInt(dtllist.getShopcatno());
                return token;
            }
            if (MLinkCommon.get().isNotNullEmpty(dto.getShopCid())) {
                azReg.itemInfo.categoryInfo.minimumCategoryId = Integer.parseInt(dto.getShopCid());
                return token;
            }
            String[] parts = dto.getGmcategnm().split(">");
            if (parts.length == 0) {
                throw new Exception("[\ud0a4\uc6cc\ub4dc \uc5c6\uc74c]");
            }
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                try {
                    JsonArray categories = this.fetchCategoryData(element, token);
                    if (categories != null && categories.size() != 0) {
                        int count = Math.min(categories.size(), 10);
                        int i = 0;
                        while (i < count) {
                            JsonObject obj = categories.get(i).getAsJsonObject();
                            if (obj.has("endNode") && !obj.get("endNode").isJsonNull()) {
                                azReg.itemInfo.categoryInfo.minimumCategoryId = obj.get("_id").getAsInt();
                                return token;
                            }
                            ++i;
                        }
                        InterruptSource.Thread.sleep((long)500L);
                    }
                }
                catch (Exception e) {
                    throw new Exception("\uce74\ud14c\uace0\ub9ac \uc870\ud68c \uc624\ub958: " + e.getMessage());
                }
                ++n2;
            }
            return token;
        }
        catch (Exception e) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc218\uc9d1 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd" + e.getMessage());
        }
    }

    private JsonArray fetchCategoryData(String keyword, String token) throws IOException {
        String encodedKeyword = URLEncoder.encode(keyword, "UTF-8");
        URL url = new URL("https://alwayz-seller-back.ilevit.com/items/item-category/query?q=" + encodedKeyword);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("x-access-token", token);
        connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36");
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder responseBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                responseBuilder.append(line);
            }
            JsonObject jsonObject = this.jsonParser.parse(responseBuilder.toString()).getAsJsonObject();
            int status2 = jsonObject.get("status").getAsInt();
            if (status2 == 200) {
                return jsonObject.getAsJsonArray("data");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private void ProductNameSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto) {
        String value = IProduct.formatProductNameByCode(dtllist.getProdnmoutput(), dto);
        if (dtllist.getProdnmafter().equals("Y")) {
            value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 99);
        }
        if (dtllist.getProdnmrand().equals("Y")) {
            value = ShopCommon.setWordRandomGenerator(value);
        }
        if (!dtllist.getProdnmaddfront().equals("")) {
            value = dtllist.getProdnmaddfront().concat(value);
        }
        if (!dtllist.getProdnmaddback().equals("")) {
            value = value.concat(" ").concat(dtllist.getProdnmaddback());
        }
        azReg.itemInfo.itemTitle = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 99) : value;
    }

    private ResultMarketPrice PriceSetting(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y")) {
                if (dtllist.getExpPrc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpPrc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = MarketPriceCalc.get().setCompliancePrice(limit_price).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDC()).setDc(dtllist.getDcRate()).setFlatDc(dtllist.getFlatDC()).setMargin(dtllist.getMarginDC()).setCommission(dtllist.getCommDC()).calculate();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\ud0dc, \ud310\ub9e4\uac00 \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private int getPriceAfterOptionCharges(ShopProductDto dto, ShopProductAlwayzAdditionDto dtllist, String amt, String limitPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y")) {
                if (dtllist.getExpPrc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpPrc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            price_cost = String.valueOf(Integer.parseInt(price_cost) + Integer.parseInt(amt));
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            ResultMarketPrice priceAfterOptionCharge = MarketPriceCalc.get().setCompliancePrice(Integer.parseInt(limitPrice)).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcRate()).setFlatDc(dtllist.getFlatDC()).setMargin(dtllist.getMarginDC()).setCommission(dtllist.getCommDC()).calculate();
            return Integer.parseInt(priceAfterOptionCharge.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ucd94\uac00\uae08\uc561 \uc138\ud305 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void OptionSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto, int individualPurchasePrice, int teamPurchasePrice, TestingSkuGroupLogs testingGroupLog) throws Exception {
        ArrayList<OptionsInfo.Option> listOpt = new ArrayList<OptionsInfo.Option>();
        ArrayList<OptionsInfo.OptionPrice> ListOptPrice = new ArrayList<OptionsInfo.OptionPrice>();
        if (dto.getChar_1_nm().equals("\ub2e8\ud488")) {
            azReg.itemInfo.optionsInfo.optionNames.add("\ub2e8\ud488");
            testingGroupLog.optionsInfo.optionNames.add("\ub2e8\ud488");
            OptionsInfo.Option option2 = new OptionsInfo.Option();
            option2.name = "\ubcf8\ud488";
            option2.img = null;
            listOpt.add(option2);
            OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
            optPrice.individualPurchasePrice = individualPurchasePrice;
            optPrice.teamPurchasePrice = teamPurchasePrice;
            optPrice.aiPrice = 0;
            optPrice.stockNumber = 999;
            optPrice.sold_out = false;
            optPrice.hurry_up = false;
            optPrice.optionCode = dto.getCompayny_goods_cd();
            ListOptPrice.add(optPrice);
            azReg.itemInfo.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
            testingGroupLog.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
            azReg.itemInfo.optionsInfo.optionPrice = ListOptPrice;
            testingGroupLog.optionsInfo.optionPrice = ListOptPrice;
        } else {
            List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
            ArrayList<String> amt = new ArrayList<String>();
            ArrayList<String> option1 = new ArrayList<String>();
            ArrayList<String> option2 = new ArrayList<String>();
            ArrayList<String> limitPrice = new ArrayList<String>();
            ArrayList<String> secondOptionCheck = new ArrayList<String>();
            for (ShopOptionDto opt : shopOptionDtos) {
                if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                amt.add(opt.getAmt());
                limitPrice.add(opt.getLimit_price());
                List<String> split = Arrays.asList(opt.getOptspecdes().split(":"));
                if (split.size() > 1) {
                    if (!option1.contains(split.get(0))) {
                        option1.add(split.get(0));
                    }
                    if (!option2.contains(split.get(1))) {
                        option2.add(split.get(1));
                    }
                } else {
                    option1.add(split.get(0));
                }
                secondOptionCheck.add(opt.getOptspecdes());
            }
            if (option2.size() == 0) {
                azReg.itemInfo.optionsInfo.optionNames.add(shopOptionDtos.get(0).getName());
                testingGroupLog.optionsInfo.optionNames.add(shopOptionDtos.get(0).getName());
                int i = 0;
                while (i < option1.size()) {
                    OptionsInfo.Option option3 = new OptionsInfo.Option();
                    option3.name = (String)option1.get(i);
                    option3.img = null;
                    listOpt.add(option3);
                    OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
                    if (Integer.parseInt((String)amt.get(i)) > 0) {
                        int individualPurchasePriceAddAmt = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(i), (String)limitPrice.get(i));
                        int teamPurchasePriceAddAmt = dtllist.getTeamPurchasePriceUnit().equals("percent") ? individualPurchasePriceAddAmt - individualPurchasePriceAddAmt * dtllist.getTeamPurchasePrice() / 100 : individualPurchasePriceAddAmt - dtllist.getTeamPurchasePrice();
                        optPrice.individualPurchasePrice = individualPurchasePriceAddAmt;
                        optPrice.teamPurchasePrice = teamPurchasePriceAddAmt;
                    } else {
                        optPrice.individualPurchasePrice = individualPurchasePrice;
                        optPrice.teamPurchasePrice = teamPurchasePrice;
                    }
                    optPrice.aiPrice = 0;
                    optPrice.stockNumber = 999;
                    optPrice.sold_out = false;
                    optPrice.hurry_up = false;
                    optPrice.optionCode = dto.getCompayny_goods_cd() + "_" + (i + 1);
                    ListOptPrice.add(optPrice);
                    ++i;
                }
                azReg.itemInfo.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
                testingGroupLog.optionsInfo.optionPrice = new ArrayList<OptionsInfo.OptionPrice>();
                azReg.itemInfo.optionsInfo.optionPrice = ListOptPrice;
                testingGroupLog.optionsInfo.optionPrice = ListOptPrice;
            } else {
                OptionsInfo.Option option4;
                List<String> split = Arrays.asList(shopOptionDtos.get(0).getName().split(":"));
                azReg.itemInfo.optionsInfo.optionNames.add(split.get(0));
                azReg.itemInfo.optionsInfo.optionNames.add(split.get(1));
                testingGroupLog.optionsInfo.optionNames.add(split.get(0));
                testingGroupLog.optionsInfo.optionNames.add(split.get(1));
                ArrayList<OptionsInfo.Option> listOpt2 = new ArrayList<OptionsInfo.Option>();
                azReg.itemInfo.optionsInfo.optionPrices = new ArrayList<List<OptionsInfo.OptionPrice>>();
                testingGroupLog.optionsInfo.optionPrices = new ArrayList<List<OptionsInfo.OptionPrice>>();
                int count = 1;
                int i = 0;
                while (i < option1.size()) {
                    option4 = new OptionsInfo.Option();
                    option4.name = (String)option1.get(i);
                    option4.img = null;
                    listOpt.add(option4);
                    ArrayList<OptionsInfo.OptionPrice> ListOptPrice2 = new ArrayList<OptionsInfo.OptionPrice>();
                    int j = 0;
                    while (j < option2.size()) {
                        OptionsInfo.OptionPrice optPrice = new OptionsInfo.OptionPrice();
                        if (secondOptionCheck.contains((String)option1.get(i) + ":" + (String)option2.get(j))) {
                            optPrice.stockNumber = 999;
                            optPrice.sold_out = false;
                            int index = secondOptionCheck.indexOf((String)option1.get(i) + ":" + (String)option2.get(j));
                            if (Integer.parseInt((String)amt.get(index)) > 0) {
                                int individualPurchasePriceAddAmt = this.getPriceAfterOptionCharges(dto, dtllist, (String)amt.get(index), (String)limitPrice.get(index));
                                int teamPurchasePriceAddAmt = dtllist.getTeamPurchasePriceUnit().equals("percent") ? individualPurchasePriceAddAmt - individualPurchasePriceAddAmt * dtllist.getTeamPurchasePrice() / 100 : individualPurchasePriceAddAmt - dtllist.getTeamPurchasePrice();
                                optPrice.individualPurchasePrice = individualPurchasePriceAddAmt;
                                optPrice.teamPurchasePrice = teamPurchasePriceAddAmt;
                            } else {
                                optPrice.individualPurchasePrice = individualPurchasePrice;
                                optPrice.teamPurchasePrice = teamPurchasePrice;
                            }
                        } else {
                            optPrice.stockNumber = 0;
                            optPrice.sold_out = true;
                            optPrice.individualPurchasePrice = individualPurchasePrice;
                            optPrice.teamPurchasePrice = teamPurchasePrice;
                        }
                        optPrice.aiPrice = 0;
                        optPrice.hurry_up = false;
                        optPrice.optionCode = dto.getCompayny_goods_cd() + "_" + count++;
                        ListOptPrice2.add(optPrice);
                        ++j;
                    }
                    azReg.itemInfo.optionsInfo.optionPrices.add(ListOptPrice2);
                    testingGroupLog.optionsInfo.optionPrices.add(ListOptPrice2);
                    ++i;
                }
                i = 0;
                while (i < option2.size()) {
                    option4 = new OptionsInfo.Option();
                    option4.name = (String)option2.get(i);
                    option4.img = null;
                    listOpt2.add(option4);
                    ++i;
                }
                azReg.itemInfo.optionsInfo.totalOptions.add(listOpt2);
                testingGroupLog.optionsInfo.totalOptions.add(listOpt2);
            }
        }
        azReg.itemInfo.optionsInfo.totalOptions.add(0, listOpt);
        testingGroupLog.optionsInfo.totalOptions.add(0, listOpt);
    }

    private void DeliverySetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto) {
        azReg.itemInfo.shippingInfo.freeShipping = true;
        azReg.itemInfo.shippingInfo.shippingMethod = "\uc21c\ucc28\ubc30\uc1a1";
        azReg.itemInfo.shippingInfo.shippingFee = 0;
        azReg.itemInfo.shippingInfo.shippingFeeInfo = dtllist.getShippingFeeInfo().equals("") ? "\ubb34\ub8cc\ubc30\uc1a1, \ub3c4\uc11c\uc0b0\uac04 \ucd94\uac00 \ubc30\uc1a1\ube44 -\uc81c\uc8fc \uc9c0\uc5ed: 3,000\uc6d0 -\ub3c4\uc11c\uc0b0\uac04 \uc9c0\uc5ed: 5,000\uc6d0" : dtllist.getShippingFeeInfo();
        azReg.itemInfo.shippingInfo.returnFee = dtllist.getReturnFee();
        azReg.itemInfo.shippingInfo.returnFeeInfo = dtllist.getReturnFeeInfo().equals("") ? "5,000\uc6d0 -\ub2e8, \uace0\uac1d \ub2e8\uc21c \ubcc0\uc2ec\uc758 \uacbd\uc6b0\uc5d0\ub9cc \ubc1c\uc0dd -\ub3c4\uc11c\uc0b0\uac04 \ubc0f \uc77c\ubd80 \uc9c0\uc5ed \ucd94\uac00\ube44\uc6a9 \ubc1c\uc0dd" : dtllist.getReturnFeeInfo();
        azReg.itemInfo.shippingInfo.shippingCompany = dtllist.getShippingCompany();
        azReg.itemInfo.shippingInfo.shippingDays = Integer.parseInt(dtllist.getShippingDays().replace("\uc77c", ""));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc911\uad6c \uc12c\uc9c0\uc5ed", "22386", "22388", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uac15\ud654 \uc12c\uc9c0\uc5ed", "23004", "23010", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc639\uc9c4 \uc12c\uc9c0\uc5ed1", "23100", "23116", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc778\ucc9c \uc639\uc9c4 \uc12c\uc9c0\uc5ed2", "23124", "23136", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ub2f9\uc9c4 \uc12c\uc9c0\uc5ed", "31708", "31708", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ud0dc\uc548 \uc12c\uc9c0\uc5ed", "32133", "32133", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ucda9\ub0a8 \ubcf4\ub839 \uc12c\uc9c0\uc5ed", "33411", "33411", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ubd81 \uc6b8\ub989\ub3c4 \uc804\uc9c0\uc5ed", "40200", "40240", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\ubd80\uc0b0 \uac15\uc11c\uad6c \uc12c\uc9c0\uc5ed", "46768", "46771", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \uc0ac\ucc9c \uc12c\uc9c0\uc5ed", "52570", "52571", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed1", "53031", "53033", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed2", "53089", "53104", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uacbd\ub0a8 \ud1b5\uc601 \uc12c\uc9c0\uc5ed3", "54000", "54000", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ubd81 \ubd80\uc548 \uc12c\uc9c0\uc5ed", "56347", "56349", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc601\uad11 \uc12c\uc9c0\uc5ed", "57068", "57069", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \ubaa9\ud3ec \uc12c\uc9c0\uc5ed", "58760", "58762", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed1", "58800", "58810", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed2", "58816", "58818", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed3", "58826", "58826", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc2e0\uc548 \uc12c\uc9c0\uc5ed4", "58828", "58866", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc9c4\ub3c4 \uc12c\uc9c0\uc5ed", "58953", "58958", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed1", "59102", "59103", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed2", "59106", "59106", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed3", "59127", "59127", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed4", "59129", "59129", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc644\ub3c4 \uc12c\uc9c0\uc5ed5", "59137", "59166", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \ubcf4\uc131 \uc12c\uc9c0\uc5ed", "59421", "59421", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed1", "59531", "59531", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed2", "59551", "59551", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed3", "59563", "59563", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uace0\ud765 \uc12c\uc9c0\uc5ed4", "59568", "59568", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed1", "59650", "59650", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed2", "59766", "59766", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc804\ub0a8 \uc5ec\uc218 \uc12c\uc9c0\uc5ed3", "59781", "59790", dtllist.getDeliveryFeeExJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc81c\uc8fc \uc6b0\ub3c4", "63365", "63365", dtllist.getDeliveryFeeInJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uc81c\uc8fc \ucd94\uc790\uba74", "63000", "63001", dtllist.getDeliveryFeeInJeju()));
        azReg.itemInfo.shippingInfo.ruralAreaShippingFeeInfo.add(this.CreateRuralAreaShipInfo("\uadf8 \uc678 \uc81c\uc8fc \uc804\uc9c0\uc5ed", "63000", "63644", dtllist.getDeliveryFeeInJeju()));
    }

    private ShippingInfo.RuralAreaShippingFeeInfo CreateRuralAreaShipInfo(String ruralAreaName, String startPostNumber, String endPostNumber, int shippingFee) {
        ShippingInfo.RuralAreaShippingFeeInfo metaData = new ShippingInfo.RuralAreaShippingFeeInfo();
        metaData.ruralAreaName = ruralAreaName;
        metaData.startPostNumber = startPostNumber;
        metaData.endPostNumber = endPostNumber;
        metaData.shippingFee = shippingFee;
        return metaData;
    }

    private void GosiSetting(AlwayzProductReg azReg, ShopProductAlwayzAdditionDto dtllist, ShopProductDto dto) {
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uc790", "\uc218\uc785\ud488\uc758 \uacbd\uc6b0 \uc218\uc785\uc790 \uad04\ud638\ub85c \ud568\uaed8 \ud45c\uae30", true, dto.getMaker()));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uad6d(\uc6d0\uc0b0\uc9c0)", "", true, dto.getOrigin()));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\ucde8\uae09\uc2dc \uc8fc\uc758\uc0ac\ud56d(\uc120\ud0dd)", "", false, null));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\uc81c\uc870\uc5f0\uc6d4(\uc0dd\uc0b0\uc5f0\uc6d4)", "", true, "2402"));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("\ud488\uc9c8\ubcf4\uc99d\uae30\uc900(\uc120\ud0dd)", "", false, null));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("A/S \ucc45\uc784\uc790", "", true, ""));
        azReg.itemInfo.commonMetaDataInfoList.add(this.createCommonMetaData("A/S \uc804\ud654\ubc88\ud638", "", true, ""));
    }

    private CommonMetaDataInfo createCommonMetaData(String title, String placeholder, boolean isNecessary, String contents) {
        CommonMetaDataInfo metaData = new CommonMetaDataInfo();
        metaData.title = title;
        metaData.placeholder = placeholder;
        metaData.isNecessary = isNecessary;
        metaData.contents = contents;
        return metaData;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class AlwayzProductReg {
        private ItemInfo itemInfo = new ItemInfo();

        private AlwayzProductReg() {
        }
    }

    private static class CategoryInfo {
        private int minimumCategoryId;

        private CategoryInfo() {
        }
    }

    private static class CommonMetaDataInfo {
        public String title;
        public String placeholder;
        public boolean isNecessary;
        public String contents;

        private CommonMetaDataInfo() {
        }
    }

    private static class ItemInfo {
        private CategoryInfo categoryInfo = new CategoryInfo();
        private String itemTitle;
        private OptionsInfo optionsInfo = new OptionsInfo();
        private List<String> mainImageUris = new ArrayList<String>();
        private List<String> detailImageUris = new ArrayList<String>();
        private ShippingInfo shippingInfo = new ShippingInfo();
        private List<CommonMetaDataInfo> commonMetaDataInfoList = new ArrayList<CommonMetaDataInfo>();
        private List<ProductMetaDataInfo> productMetaDataInfoList = new ArrayList<ProductMetaDataInfo>();
        private boolean soldOut;
        private boolean hurryUp;
        private int totalOrderQuantity;
        private int totalRatingCount;
        private double totalRatingScore;
        private int teamPurchasePrice;
        private int individualPurchasePrice;
        private double discountRate;
        private List<PurchasingUsersInfo> purchasingUsersInfo = new ArrayList<PurchasingUsersInfo>();
        private boolean hideSellerInfo;
        private int vectorWeights;
        private SellerInfo sellerInfo = new SellerInfo();
        private int teamDealThreshold;
        private int purchaseLimits;
        private String testingSkuGroup;
        private List<TestingSkuGroupLogs> testingSkuGroupLogs = new ArrayList<TestingSkuGroupLogs>();
        private String sellerType;
        private boolean itemRankTestingSku;
        private boolean alfarmPhotoReviewMode;
        private String recommendItemCode;
        private String textForQuery;

        private ItemInfo() {
        }
    }

    private static class OptionsInfo {
        private List<String> optionNames = new ArrayList<String>();
        private List<List<Option>> totalOptions = new ArrayList<List<Option>>();
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<OptionPrice> optionPrice;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private List<List<OptionPrice>> optionPrices;

        private OptionsInfo() {
        }

        private static class Option {
            private String name;
            private String img;

            private Option() {
            }
        }

        private static class OptionMetaDataInfo {
            private OptionMetaDataInfo() {
            }
        }

        private static class OptionPrice {
            private int individualPurchasePrice;
            private int teamPurchasePrice;
            private int aiPrice;
            private int stockNumber;
            private boolean sold_out;
            private boolean hurry_up;
            private List<OptionMetaDataInfo> optionMetaDataInfoList = new ArrayList<OptionMetaDataInfo>();
            private String optionCode;

            private OptionPrice() {
            }
        }
    }

    private static class ProductMetaDataInfo {
        private ProductMetaDataInfo() {
        }
    }

    private static class PurchasingUsersInfo {
        private PurchasingUsersInfo() {
        }
    }

    private static class SellerInfo {
        private String sellerId;
        private String address;
        private String businessRegistrationNumber;
        private String contactNumber;
        private String email;
        private String mailOrderBusinessNumber;
        private String sellerDisplayName;

        private SellerInfo() {
        }
    }

    private static class ShippingInfo {
        private boolean freeShipping;
        private String shippingMethod;
        private int shippingFee;
        private String shippingFeeInfo;
        private int returnFee;
        private String returnFeeInfo;
        private List<RuralAreaShippingFeeInfo> ruralAreaShippingFeeInfo = new ArrayList<RuralAreaShippingFeeInfo>();
        private String shippingCompany;
        private int shippingDays;

        private ShippingInfo() {
        }

        private static class RuralAreaShippingFeeInfo {
            private String ruralAreaName;
            private String startPostNumber;
            private String endPostNumber;
            private int shippingFee;

            private RuralAreaShippingFeeInfo() {
            }
        }
    }

    private static class TestingSkuGroupLogs {
        private OptionsInfo optionsInfo = new OptionsInfo();
        private String testingSkuGroup;
        private int teamPurchasePrice;
        private int individualPurchasePrice;
        private boolean soldOut;

        private TestingSkuGroupLogs() {
        }
    }
}

