/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.auction;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.auction.IShopOrderAuctionCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class AuctionLiteOrderCommand
extends IShopOrderAuctionCommand {
    private static IShopOrderCommand instance = new AuctionLiteOrderCommand();
    IShopCommonLogin i = new IShopCommonLogin(){};
    JsonParser jsonparser = new JsonParser();
    private String cachedHddSearchAccount;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AuctionLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> ret = new ArrayList<ShopOrderMstNewDto>();
        switch (dto.getSpecificStatus()) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                this.getNewOrder(dto, ret);
                break;
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                this.getConfirmOrder(dto, ret);
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                this.getDelvieryOrder(dto, ret, false);
                break;
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                this.getDelvieryOrder(dto, ret, true);
                break;
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                this.getDelvieryCompletedOrder(dto, ret);
                break;
            }
            case "\ucde8\uc18c": {
                this.getCancelOrder(dto, ret);
                break;
            }
            case "\ubc18\ud488": {
                this.getReturnOrder(dto, ret);
                break;
            }
            case "\uad50\ud658": {
                this.getExchangeOrder(dto, ret);
                break;
            }
            case "\ud1b5\ud569": {
                this.getNewOrder(dto, ret);
                this.getConfirmOrder(dto, ret);
                this.getDelvieryOrder(dto, ret, false);
                this.getDelvieryOrder(dto, ret, true);
                this.getDelvieryCompletedOrder(dto, ret);
                this.getCancelOrder(dto, ret);
                this.getReturnOrder(dto, ret);
                this.getExchangeOrder(dto, ret);
            }
        }
        return ret;
    }

    private void getNewOrder(ShopOrderMstNewDto orderDto, List<ShopOrderMstNewDto> ret) throws Exception {
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        Map<String, String> cookies = this.getLoginCookieLite(orderDto);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        String url = "https://www.esmplus.com/Escrow/Order/NewOrderSearch";
        String referrer = "https://www.esmplus.com/Escrow/Order/NewOrder?menuCode=TDM105";
        Connection.Response rs = Jsoup.connect((String)url).cookies(cookies).referrer(referrer).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", this.gethddSearchAccount(cookies) + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchDistrType", "AL").data("searchAllYn", "N").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchTransPolicyType", "").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
        JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
        List<ShopOrderMstNewDto> params = this.getJsonManager(jsonArray, orderDto, "100", cookies);
        Map<String, List<ShopOrderMstNewDto>> grouped = params.stream().collect(Collectors.groupingBy(dto -> dto.getMall_product_id() + "_" + dto.getUser_name() + "_" + dto.getUser_tel()));
        for (List<ShopOrderMstNewDto> group : grouped.values()) {
            if (group.size() <= 1) continue;
            int deliveryFee = this.calculateDeliveryFee(group);
            for (ShopOrderMstNewDto dto2 : group) {
                dto2.setDelv_cost(String.valueOf(deliveryFee));
                if (deliveryFee <= 0) continue;
                dto2.setDelivery_method_str2("\uc120\ubd88");
            }
        }
        if (params != null) {
            ret.addAll(params);
        }
    }

    private void getConfirmOrder(ShopOrderMstNewDto orderDto, List<ShopOrderMstNewDto> ret) {
        try {
            String shopid = orderDto.getShopid();
            String site = shopid.equals("shop00671") ? "1" : "2";
            String id = orderDto.getShop_userid();
            Map<String, String> cookies = this.getLoginCookieLite(orderDto);
            String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
            String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
            String searchAcoount = this.gethddSearchAccount(cookies);
            StringBuilder referrerUrl = new StringBuilder();
            referrerUrl.append("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery").append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append(searchAcoount).append("^").append(id).append("^").append(site).append("&searchDateType=ODD").append("&searchSDT=").append(startdate).append("&searchEDT=").append(enddate).append("&searchKey=ON").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=false").append("&totalAccumulate=-").append("&listAllView=false").append("&searchDistrType=AL").append("&searchTransPolicyType=");
            String refferer = referrerUrl.toString();
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/GeneralDeliverySearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", searchAcoount + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(refferer).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
            rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/OverseasDeliverySearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", searchAcoount + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(refferer).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject1 = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray1 = jsonobject1.get("data").getAsJsonArray();
            List<ShopOrderMstNewDto> params = this.getJsonManager(jsonArray, orderDto, "100", cookies);
            List<ShopOrderMstNewDto> params1 = this.getJsonManager(jsonArray1, orderDto, "100", cookies);
            if (params != null || params1 != null) {
                ret.addAll(params);
                ret.addAll(params1);
            }
        }
        catch (Exception exception) {}
    }

    private void getDelvieryOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret, boolean isCompleted) throws Exception {
        List<ShopOrderMstNewDto> params;
        String shopcd = dto.getShopid();
        String site = shopcd.equals("shop00671") ? "1" : "2";
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        Map<String, String> cookies = this.getLoginCookieLite(dto);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        String searchType = isCompleted ? "1050" : "1040";
        String orderStatus = isCompleted ? "410" : "403";
        Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/GetSendingSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "1").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", searchType).data("searchKey", "ON").data("searchKeyword", "").data("excelInfo", "undefined").data("searchStatus", searchType).data("searchAllYn", "N").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").referrer("https://www.esmplus.com/Escrow/Delivery/Sending?menuCode=TDM111").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
        JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
        if (jsonArray.size() > 0 && (params = this.getJsonManager2(jsonArray, dto, orderStatus, cookies)) != null) {
            ret.addAll(params);
        }
    }

    private void getDelvieryCompletedOrder(ShopOrderMstNewDto orderDto, List<ShopOrderMstNewDto> ret) throws Exception {
        List<ShopOrderMstNewDto> params;
        Connection.Response rs;
        JsonObject jsonobject;
        JsonArray jsonArray;
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        Map<String, String> cookies = this.getLoginCookieLite(orderDto);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdate);
        Date edate = formatter.parse(enddate);
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            startdate = formatter.format(cal2.getTime());
        }
        if ((jsonArray = (jsonobject = this.jsonparser.parse((rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/BuyDecisionSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").referrer("https://www.esmplus.com/Escrow/Delivery/BuyDecision?").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", this.gethddSearchAccount(cookies) + "^" + id + "^" + site).data("searchDateType", "TRD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchStatus", "").data("searchAllYn", "N").data("SortFeild", "TransDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").data("searchGlobalShopType", "").data("searchOverseaDeliveryYn", "").execute()).body()).getAsJsonObject()).get("data").getAsJsonArray()).size() > 0 && (params = this.getJsonManager2(jsonArray, orderDto, "901", cookies)) != null) {
            ret.addAll(params);
        }
    }

    private void getCancelOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret) throws Exception {
        String shopcd = dto.getShopid();
        String site = shopcd.equals("shop00671") ? "1" : "2";
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        Map<String, String> cookies = this.getLoginCookieLite(dto);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("CR", "C01");
        map_parmeters.put("CI", "C01");
        map_parmeters.put("CC", "C02");
        for (String key_param : map_parmeters.keySet()) {
            List<ShopOrderMstNewDto> params;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/CancelManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", key_param).data("searchKey", "ON").data("searchKeyword", "").data("orderByType", "").data("excelInfo", "").data("searchStatus", key_param).data("searchAllYn", "N").data("tabGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchTransPolicyType", "AL").referrer("https://www.esmplus.com/Escrow/Claim/CancelRequestManagement?menuCode=TDM115").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
            if (jsonArray.size() <= 0 || (params = this.getJsonManager2(jsonArray, dto, (String)map_parmeters.get(key_param), cookies)) == null) continue;
            ret.addAll(params);
        }
    }

    private void getReturnOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret) throws Exception {
        String shopcd = dto.getShopid();
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        Map<String, String> cookies = this.getLoginCookieLite(dto);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("RR", "R01");
        map_parmeters.put("RP", "R01");
        map_parmeters.put("RH", "R01");
        map_parmeters.put("RF", "R02");
        for (String key_param : map_parmeters.keySet()) {
            List<ShopOrderMstNewDto> params;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/ReturnManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "1").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", key_param).data("searchKey", "ON").data("searchKeyword", "").data("orderByType", "").data("excelInfo", "").data("searchStatus", "RR").data("searchAllYn", "N").data("tabGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").data("searchRewardStatus", "NN").data("searchFastRefundYn", "").referrer("https://www.esmplus.com/Escrow/Claim/ReturnRequestManagement?menuCode=TDM118").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
            if (jsonArray.size() <= 0 || (params = this.getJsonManager2(jsonArray, dto, (String)map_parmeters.get(key_param), cookies)) == null) continue;
            ret.addAll(params);
        }
    }

    private void getExchangeOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret) throws Exception {
        String shopcd = dto.getShopid();
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        Map<String, String> cookies = this.getLoginCookieLite(dto);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("ER", "E01");
        map_parmeters.put("EP", "E02");
        map_parmeters.put("EH", "E01");
        String searchStatus = "";
        for (String key_param : map_parmeters.keySet()) {
            List<ShopOrderMstNewDto> params;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/ExchangeManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("claimCount", "-").data("excelInfo", "").data("limit", "500").data("orderByType", "").data("page", "1").data("searchAccount", site1 + "^" + id).data("searchAllYn", "N").data("searchDateType", "ODD").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchSDT", startdate).data("searchStatus", searchStatus).data("searchType", key_param).data("siteGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("tabGbn", "1").referrer("https://www.esmplus.com/Escrow/Claim/ExchangeRequestManagement?menuCode=TDM123").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            searchStatus = key_param;
            JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
            if (jsonArray.size() <= 0 || (params = this.getJsonManager2(jsonArray, dto, (String)map_parmeters.get(key_param), cookies)) == null) continue;
            ret.addAll(params);
        }
    }

    private List<ShopOrderMstNewDto> getJsonManager(JsonArray jsonArray, ShopOrderMstNewDto orderDto, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstNewDto> dtolist = new ArrayList<ShopOrderMstNewDto>();
        try {
            for (JsonElement ele : jsonArray) {
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setBasicInfo(orderDto);
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setResult_code("1");
                dto.setOrder_status(orderStatus);
                dto.setWon_cost("0");
                dto.setMall_exp_cd("");
                dto.setBox_ea("0");
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                dto.setProduct_id("");
                dto.setUser_email("");
                dto.setReceive_email("");
                JsonObject object = ele.getAsJsonObject();
                dto.setOrder_date(object.get("OrderDate").getAsString());
                dto.setPay_date(this.jsonElementNullStr(object.get("PayDate")));
                dto.setOrder_id(object.get("SiteOrderNo").getAsString());
                dto.setLabel(object.get("OrderNo").getAsString());
                dto.setUser_id(this.jsonElementNullStr(object.get("BuyerID")));
                dto.setUser_name(this.jsonElementNullStr(object.get("BuyerName")));
                dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                dto.setReceive_name(object.get("RcverName").getAsString());
                dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                dto.setReceive_zipcode(this.jsonElementNullStr(object.get("ZipCode")));
                dto.setReceive_addr(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("RcverInfoAd"))));
                dto.setMall_product_id(object.get("GoodsNo").getAsString());
                dto.setCompayny_goods_cd(this.setHtmlTagDelete(object.get("SellerMngCode").getAsString()));
                dto.setP_product_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                dto.setProduct_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                String selOption = this.setHtmlTagDelete(object.get("SelOption").getAsString());
                String addOption = this.setHtmlTagDelete(object.get("AddOption").getAsString());
                dto.setP_sku_value(selOption + "," + addOption);
                dto.setP_sku_value2(addOption);
                dto.setSku_value(selOption);
                dto.setCopy_idx(this.jsonElementNullStr(object.get("CartNo")));
                dto.setDelv_msg(this.setHtmlTagDelete(object.get("DeliveryMemo").getAsString()));
                String fee = this.setHtmlTagDelete(object.get("DeliveryFee").getAsString());
                String deleveryfee = "";
                deleveryfee = fee.equals("\uc0c1\uc138\ubcf4\uae30") ? this.getDeliveryFee(orderDto.getShop_userid(), object.get("SiteOrderNo").getAsString(), cookies) : object.get("DeliveryFee").getAsString();
                if (object.get("DeliveryFeeType").getAsString().equals("\uc120\ubd88") && deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                    dto.setDelivery_method_str2("\ubb34\ub8cc");
                } else {
                    dto.setDelivery_method_str2(object.get("DeliveryFeeType").getAsString());
                }
                dto.setProduct_url(ShopCommon.getProductUrl(dto.getShopid(), dto.getMall_product_id(), "", ""));
                int optAddPrice = 0;
                int saleCost = this.parseIntSafe(this.jsonElementNullStr(object.get("SellPrice")));
                int saleCnt = object.get("OrderQty").getAsInt();
                int totalCost = this.parseIntSafe(this.jsonElementNullStr(object.get("OrderAmnt")));
                int mallWonCost = 0;
                if (object.has("SttlExpectedAmnt")) {
                    mallWonCost = this.parseIntSafe(this.jsonElementNullStr(object.get("SttlExpectedAmnt")));
                }
                int mallFee = this.parseIntSafe(this.jsonElementNullStr(object.get("ServiceUseAmnt")));
                int supplyCost = totalCost - mallFee;
                int discountPrice = this.parseIntSafe(this.jsonElementNullStr(object.get("BuyerDCAmnt")));
                int payCost = totalCost - discountPrice;
                int delvCost = this.parseIntSafe(deleveryfee);
                dto.setTotal_cost(String.valueOf(totalCost));
                dto.setSale_cnt(this.fmtInt(saleCnt));
                dto.setSale_cost(this.fmtInt(saleCost));
                dto.setMall_fee(this.fmtInt(mallFee));
                dto.setSupply_cost(this.fmtInt(supplyCost));
                dto.setPay_cost(this.fmtInt(payCost));
                dto.setMall_won_cost(this.fmtInt(mallWonCost));
                dto.setOpt_add_cost(this.fmtInt(optAddPrice));
                dto.setDiscount_cost(this.fmtInt(discountPrice));
                dto.setRate(this.percentOf(mallFee, totalCost, 2));
                dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
                dto.setDelv_cost(this.fmtInt(delvCost));
                dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
                dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
                dtolist.add(dto);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158 \uc2e0\uaddc \uac00\uc838\uc624\uae30 \ub370\uc774\ud130 \ubc14\uc778\ub529 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private List<ShopOrderMstNewDto> getJsonManager2(JsonArray jsonArray, ShopOrderMstNewDto orderDto, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstNewDto> dtolist = new ArrayList<ShopOrderMstNewDto>();
        try {
            for (JsonElement ele : jsonArray) {
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setBasicInfo(orderDto);
                dto.setOrder_status(orderStatus);
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setResult_code("1");
                dto.setWon_cost("0");
                dto.setMall_exp_cd("");
                dto.setBox_ea("0");
                dto.setUser_email("");
                dto.setReceive_email("");
                dto.setReceive_zipcode("");
                dto.setReceive_addr("");
                dto.setProduct_id("");
                JsonObject object = ele.getAsJsonObject();
                dto.setOrder_id(object.get("SiteOrderNo").getAsString());
                dto.setLabel(object.get("OrderNo").getAsString());
                dto.setPay_date(this.jsonElementNullStr(object.get("PayDate")));
                dto.setOrder_date(this.jsonElementNullStr(object.get("OrderDate")));
                if (dto.getOrder_date().equals("")) {
                    dto.setOrder_date(dto.getPay_date());
                }
                String userId = "";
                userId = object.has("BuyerID") ? object.get("BuyerID").getAsString() : object.get("BuyerId").getAsString();
                dto.setUser_id(userId);
                dto.setUser_name(this.jsonElementNullStr(object.get("BuyerName")));
                if (object.has("BuyerHt")) {
                    dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                    dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                } else {
                    dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerInfoHt")));
                    dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerInfoCp")));
                }
                dto.setReceive_name(object.get("RcverName").getAsString());
                dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                dto.setMall_product_id(object.get("GoodsNo").getAsString());
                dto.setProduct_name(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("GoodsName"))));
                dto.setP_product_name(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("GoodsName"))));
                dto.setCompayny_goods_cd(this.setHtmlTagDelete(object.get("SellerMngCode").getAsString()));
                String addOption = "";
                if (object.has("AddOption")) {
                    addOption = this.setHtmlTagDelete(object.get("AddOption").getAsString());
                }
                String selOption = "";
                if (object.has("SelOption")) {
                    selOption = this.setHtmlTagDelete(object.get("SelOption").getAsString());
                }
                dto.setP_sku_value(selOption + "," + addOption);
                dto.setSku_value(selOption);
                String cartNo = this.jsonElementNullStr(object.get("CartNo"));
                dto.setCopy_idx(cartNo);
                dto.setEsm_payment_id(cartNo);
                dto.setDelv_msg(this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DeliveryMemo"))));
                if (object.has("DeliveryComp")) {
                    String deliveryId = this.jsonElementNullStr(object.get("DeliveryComp"));
                    if (deliveryId.equals("") && object.has("DeliveryCompCode")) {
                        deliveryId = this.jsonElementNullStr(object.get("DeliveryCompCode"));
                    }
                    dto.setDelivery_id(deliveryId);
                }
                if (object.has("InvoiceNo")) {
                    String invoiceNo = this.jsonElementNullStr(object.get("InvoiceNo"));
                    if (invoiceNo.contains("<input type")) {
                        invoiceNo = "";
                    }
                    dto.setInvoice_no(invoiceNo);
                }
                if (object.has("DeliveryCompNm")) {
                    dto.setDeliveryName(this.jsonElementNullStr(object.get("DeliveryCompNm")));
                }
                String deleveryfee = "";
                String fee = "";
                fee = object.has("DeliveryFee") ? this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DeliveryFee"))) : this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DomstDeliveryFee")));
                deleveryfee = fee.equals("\uc0c1\uc138\ubcf4\uae30") ? this.getDeliveryFee(orderDto.getShop_userid(), object.get("SiteOrderNo").getAsString(), cookies) : fee;
                if (deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                    dto.setDelivery_method_str2("\ubb34\ub8cc");
                } else {
                    dto.setDelivery_method_str2("\uc120\ubd88");
                }
                dto.setProduct_url(ShopCommon.getProductUrl(dto.getShopid(), dto.getMall_product_id(), "", ""));
                int optAddPrice = 0;
                int saleCost = this.parseIntSafe(this.jsonElementNullStr(object.get("SellPrice")));
                int saleCnt = object.get("OrderQty").getAsInt();
                int totalCost = this.parseIntSafe(this.jsonElementNullStr(object.get("OrderAmnt")));
                int supplyCost = 0;
                if (object.has("SupplyPrice")) {
                    supplyCost = this.parseIntSafe(this.jsonElementNullStr(object.get("SupplyPrice")));
                }
                int mallWonCost = 0;
                if (object.has("SttlExpectedAmnt")) {
                    mallWonCost = this.parseIntSafe(this.jsonElementNullStr(object.get("SttlExpectedAmnt")));
                }
                int mallFee = totalCost - supplyCost;
                int discountPrice = supplyCost - mallWonCost;
                int payCost = totalCost - discountPrice;
                int delvCost = this.parseIntSafe(deleveryfee);
                dto.setTotal_cost(String.valueOf(totalCost));
                dto.setSale_cnt(this.fmtInt(saleCnt));
                dto.setSale_cost(this.fmtInt(saleCost));
                dto.setMall_fee(this.fmtInt(mallFee));
                dto.setSupply_cost(this.fmtInt(supplyCost));
                dto.setPay_cost(this.fmtInt(payCost));
                dto.setMall_won_cost(this.fmtInt(mallWonCost));
                dto.setOpt_add_cost(this.fmtInt(optAddPrice));
                dto.setDiscount_cost(this.fmtInt(discountPrice));
                dto.setRate(this.percentOf(mallFee, totalCost, 2));
                dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
                dto.setDelv_cost(this.fmtInt(delvCost));
                dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
                dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
                dto.setClaim_reason(this.jsonElementNullStr(object.get("ClaimReason")) + " " + this.setHtmlTagDelete(this.jsonElementNullStr(object.get("ClaimDetailReason"))));
                if (object.has("ClaimRegDate")) {
                    dto.setClaim_reg_date(this.jsonElementNullStr(object.get("ClaimRegDate")));
                }
                dtolist.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uc625\uc158 \uc8fc\ubb38\uc218\uc9d1 \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private String setHtmlTagDelete(String value) {
        return value.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
    }

    private String getDeliveryFee(String sellerID, String siteOrderNo, Map<String, String> cookies) throws Exception {
        String refferUrl = String.format("https://www.esmplus.com/Home/SSO?id=%s&code=%s&Param=OrderNo%%3D%s", sellerID, "TDP132", siteOrderNo);
        Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Member/SignIn/GetCoreAuthToken").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("SellerId", sellerID).data("MenuCode", "TDP132").data("Param", "OrderNo=" + siteOrderNo).referrer(refferUrl).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        String url = URLDecoder.decode(rs.body(), "UTF-8");
        url = url.replaceAll("\"", "");
        Thread.sleep(1500L);
        Document doc = Jsoup.connect((String)url).cookies(cookies).followRedirects(true).ignoreContentType(true).get();
        Elements ele = doc.select("td").eq(2);
        return ele.text();
    }

    private String gethddSearchAccount(Map<String, String> cookies) throws Exception {
        if (this.cachedHddSearchAccount != null) {
            return this.cachedHddSearchAccount;
        }
        StringBuilder urlBuilder = new StringBuilder("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery");
        urlBuilder.append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append("&searchDateType=").append("&searchSDT=").append("&searchEDT=").append("&searchKey=").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=").append("&totalAccumulate=-").append("&searchTransPolicyType=");
        Document doc = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).get();
        Elements hiddens = doc.select("input[type=hidden]");
        Map<String, String> datas = ChromeScript.get().getElementIdOrValue(hiddens);
        this.cachedHddSearchAccount = datas.get("hddSearchAccount");
        return this.cachedHddSearchAccount;
    }

    private int calculateDeliveryFee(List<ShopOrderMstNewDto> group) {
        return group.stream().mapToInt(dto -> {
            String cost = dto.getDelv_cost().replaceAll(",", "").trim();
            if ("\ubb34\ub8cc".equals(cost)) {
                return 0;
            }
            try {
                return Integer.parseInt(cost);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }).max().orElse(0);
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        return null;
    }
}

