/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.auction;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.auction.IShopOrderAuctionCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class AuctionOrderSearchCommand
extends IShopOrderAuctionCommand {
    private static IShopOrderCommand instance = new AuctionOrderSearchCommand();
    JsonParser jsonparser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AuctionOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        try {
            ShopOrderMstDto dto = param.get(0);
            String shopcd = dto.getShopid();
            String site = shopcd.equals("shop00671") ? "1" : "2";
            String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
            String id = dto.getShop_userid();
            String pw = dto.getShopPw();
            String shopid = dto.getShopid();
            String authKey = dto.getAuthkey1();
            IShopCommonLogin is = new IShopCommonLogin(){};
            Map<String, String> cookies = is.loginCookie(id, pw, shopid, true, authKey);
            String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
            String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
            this.searchDeliveryOrder(param, list, site, site1, startdate, enddate, cookies);
            this.searchCancelOrder(param, list, site, site1, startdate, enddate, cookies);
            this.searchReturnOrder(param, list, site1, startdate, enddate, cookies);
            this.searchExchangeOrder(param, list, site1, startdate, enddate, cookies);
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158/\uc9c0\ub9c8\ucf13 \uc0c1\ud0dc\uac12 \uac00\uc838\uc624\ub294\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4. ");
        }
        return list;
    }

    private void searchExchangeOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> list, String site1, String startdate, String enddate, Map<String, String> cookies) throws Exception {
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("ER", "E01");
        map_parmeters.put("EP", "E02");
        map_parmeters.put("EH", "E01");
        String searchStatus = "";
        String id = param.get(0).getShop_userid();
        for (String key_param : map_parmeters.keySet()) {
            String expid;
            String mallid;
            String orderid;
            JsonObject object;
            int i;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/ExchangeManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("claimCount", "-").data("excelInfo", "").data("limit", "500").data("orderByType", "").data("page", "1").data("searchAccount", site1 + "^" + id).data("searchAllYn", "N").data("searchDateType", "ODD").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchSDT", startdate).data("searchStatus", searchStatus).data("searchType", key_param).data("siteGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("tabGbn", "1").referrer("https://www.esmplus.com/Escrow/Claim/ExchangeRequestManagement?menuCode=TDM123").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            searchStatus = key_param;
            JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
            JsonArray jsonArray = (JsonArray)jsonobject.get("data");
            if (((String)map_parmeters.get(key_param)).equals("E02")) {
                i = 0;
                while (i < jsonArray.size()) {
                    object = (JsonObject)jsonArray.get(i);
                    orderid = object.get("SiteOrderNo").getAsString();
                    mallid = object.get("GoodsNo").getAsString();
                    expid = "0";
                    for (ShopOrderMstDto dto : param) {
                        if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("E02");
                        dto.setOrder_status("403");
                        ShopOrderMstDto temp = dto.clone("E02");
                        list.add(dto);
                        list.add(temp);
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < jsonArray.size()) {
                object = (JsonObject)jsonArray.get(i);
                orderid = object.get("SiteOrderNo").getAsString();
                mallid = object.get("GoodsNo").getAsString();
                expid = "0";
                for (ShopOrderMstDto dto : param) {
                    if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status("E01");
                    dto.setResult_code("1");
                    list.add(dto);
                }
                ++i;
            }
        }
    }

    private void searchReturnOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> list, String site1, String startdate, String enddate, Map<String, String> cookies) throws Exception {
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("RR", "R01");
        map_parmeters.put("RP", "R01");
        map_parmeters.put("RH", "R01");
        map_parmeters.put("RF", "R02");
        String id = param.get(0).getShop_userid();
        for (String key_param : map_parmeters.keySet()) {
            String expid;
            String mallid;
            String orderid;
            JsonObject object;
            int i;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/ReturnManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "1").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", key_param).data("searchKey", "ON").data("searchKeyword", "").data("orderByType", "").data("excelInfo", "").data("searchStatus", "RR").data("searchAllYn", "N").data("tabGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").data("searchRewardStatus", "NN").data("searchFastRefundYn", "").referrer("https://www.esmplus.com/Escrow/Claim/ReturnRequestManagement?menuCode=TDM118").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
            JsonArray jsonArray = (JsonArray)jsonobject.get("data");
            if (((String)map_parmeters.get(key_param)).equals("R02")) {
                i = 0;
                while (i < jsonArray.size()) {
                    object = (JsonObject)jsonArray.get(i);
                    orderid = object.get("SiteOrderNo").getAsString();
                    mallid = object.get("GoodsNo").getAsString();
                    expid = "0";
                    for (ShopOrderMstDto dto : param) {
                        if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("R02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("R02");
                        temp.setOrder_date(object.get("ClaimProcDate").getAsString());
                        list.add(dto);
                        list.add(temp);
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < jsonArray.size()) {
                object = (JsonObject)jsonArray.get(i);
                orderid = object.get("SiteOrderNo").getAsString();
                mallid = object.get("GoodsNo").getAsString();
                expid = "0";
                for (ShopOrderMstDto dto : param) {
                    if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setDelv_msg(this.setHtmlTagDelete(object.get("ClaimDetailReason").getAsString()));
                    dto.setOrder_status("R01");
                    dto.setResult_code("1");
                    list.add(dto);
                }
                ++i;
            }
        }
    }

    private void searchCancelOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> list, String site, String site1, String startdate, String enddate, Map<String, String> cookies) throws Exception {
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("CR", "C01");
        map_parmeters.put("CI", "C01");
        map_parmeters.put("CC", "C02");
        for (String key_param : map_parmeters.keySet()) {
            String expid;
            String mallid;
            String orderid;
            JsonObject object;
            int i;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/CancelManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + param.get(0).getShop_userid() + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", key_param).data("searchKey", "ON").data("searchKeyword", "").data("orderByType", "").data("excelInfo", "").data("searchStatus", key_param).data("searchAllYn", "N").data("tabGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchTransPolicyType", "AL").referrer("https://www.esmplus.com/Escrow/Claim/CancelRequestManagement?menuCode=TDM115").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
            JsonArray jsonArray = (JsonArray)jsonobject.get("data");
            if (((String)map_parmeters.get(key_param)).equals("C02")) {
                i = 0;
                while (i < jsonArray.size()) {
                    object = (JsonObject)jsonArray.get(i);
                    orderid = object.get("SiteOrderNo").getAsString();
                    mallid = object.get("GoodsNo").getAsString();
                    expid = "0";
                    for (ShopOrderMstDto dto : param) {
                        if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("C02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("C02");
                        temp.setOrder_date(object.get("ClaimProcDate").getAsString());
                        list.add(dto);
                        list.add(temp);
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < jsonArray.size()) {
                object = (JsonObject)jsonArray.get(i);
                orderid = object.get("SiteOrderNo").getAsString();
                mallid = object.get("GoodsNo").getAsString();
                expid = "0";
                for (ShopOrderMstDto dto : param) {
                    if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setDelv_msg(this.setHtmlTagDelete(object.get("ClaimDetailReason").getAsString()));
                    dto.setOrder_status("C01");
                    dto.setResult_code("1");
                    list.add(dto);
                }
                ++i;
            }
        }
    }

    private void searchDeliveryOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> list, String site, String site1, String startdate, String enddate, Map<String, String> cookies) throws Exception {
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("1040", "403");
        map_parmeters.put("1050", "410");
        String id = param.get(0).getShop_userid();
        for (String key_param : map_parmeters.keySet()) {
            String expid;
            String mallid;
            String orderid;
            JsonObject object;
            int i;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/GetSendingSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "1").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", key_param).data("searchKey", "ON").data("searchKeyword", "").data("excelInfo", "undefined").data("searchStatus", key_param).data("searchAllYn", "N").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").referrer("https://www.esmplus.com/Escrow/Delivery/Sending?menuCode=TDM111").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
            JsonArray jsonArray = (JsonArray)jsonobject.get("data");
            if (((String)map_parmeters.get(key_param)).equals("403")) {
                i = 0;
                while (i < jsonArray.size()) {
                    object = (JsonObject)jsonArray.get(i);
                    orderid = object.get("SiteOrderNo").getAsString();
                    mallid = object.get("GoodsNo").getAsString();
                    expid = "0";
                    String exchange = object.get("RedeliveryStatus").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (exchange.equals("\uad50\ud658")) {
                            if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                            dto.setOrder_status("403");
                            dto.setInvoice_no(object.get("ReInvoiceNo").getAsString());
                            dto.setResult_code("1");
                            ShopOrderMstDto temp = dto.clone("E02");
                            temp.setOrder_date(object.get("ClaimDate").isJsonNull() ? YDMATimeUtil.getCurrentTimeByYDFormat() : object.get("ClaimDate").getAsString());
                            list.add(temp);
                            list.add(dto);
                            continue;
                        }
                        if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status("403");
                        dto.setInvoice_no(object.get("InvoiceNo").getAsString());
                        dto.setDelivery_id(object.get("DeliveryComp").getAsString());
                        dto.setResult_code("1");
                        list.add(dto);
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < jsonArray.size()) {
                object = (JsonObject)jsonArray.get(i);
                orderid = object.get("SiteOrderNo").getAsString();
                mallid = object.get("GoodsNo").getAsString();
                expid = "0";
                for (ShopOrderMstDto dto : param) {
                    if (!this.isOrderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status("410");
                    dto.setResult_code("1");
                    list.add(dto);
                }
                ++i;
            }
        }
    }

    private String setHtmlTagDelete(String value) {
        return value.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
    }

    private boolean isOrderCheck(ShopOrderMstDto dto, String orderid, String mallid, String expid) {
        return dto.getOrder_id().equals(orderid) && dto.getMall_product_id().equals(mallid) && dto.getMall_exp_cd().equals(expid);
    }
}

