/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.auction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCategoryCommand;
import com.kdjsystem.mlink.shop.dao.ShopCategoryDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public abstract class IShopCategoryAuctionCommand
implements IShopCategoryCommand {
    public static Map<String, String> loginCookie;
    ChromeExtention chrome = ChromeExtention.getInstace();
    ChromeDriver driver = null;
    WebDriverWait wait = null;
    boolean isFileDown = false;
    boolean isHeadlessMode = false;

    public static List<ShopCategoryDto> getSDCategoryMatchingList(String categoryCode, String shopcd) throws Exception {
        Connection.Response response = Jsoup.connect((String)"https://www.esmplus.com/Sell/SingleGoods/GetSDCategoryMatchingList").data("sdCategoryCode", categoryCode).cookies(loginCookie).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36").referrer("http://www.esmplus.com/Sell/SingleGoods?menuCode=TDM395").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
        String body = response.body();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SDCategoryMatchings sdCategoryMatchings = (SDCategoryMatchings)mapper.readValue(body, SDCategoryMatchings.class);
        List<Object> list_scode = new ArrayList();
        if (shopcd.equals("shop0067") || shopcd.equals("shop00671")) {
            list_scode = sdCategoryMatchings.result.stream().distinct().filter(p -> p.SiteId == 1).collect(Collectors.toList());
            ArrayList<ShopCategoryDto.SDCategMatch> list_scode2 = new ArrayList<ShopCategoryDto.SDCategMatch>();
            for (SDCategoryMatching sDCategoryMatching : list_scode) {
                ShopCategoryDto.SDCategMatch dto2 = new ShopCategoryDto.SDCategMatch();
                dto2.setSiteCategoryDCode(sDCategoryMatching.SiteCategoryDCode);
                dto2.setSiteCategoryLCode(sDCategoryMatching.SiteCategoryLCode);
                dto2.setSiteCategoryMCode(sDCategoryMatching.SiteCategoryMCode);
                dto2.setSiteCategorySCode(sDCategoryMatching.SiteCategorySCode);
                list_scode2.add(dto2);
            }
            return IShopCategoryAuctionCommand.GetChildSiteCategories("", "1", 1, list_scode2);
        }
        list_scode = sdCategoryMatchings.result.stream().distinct().filter(p -> p.SiteId == 2).collect(Collectors.toList());
        ArrayList<ShopCategoryDto.SDCategMatch> list_scode2 = new ArrayList<ShopCategoryDto.SDCategMatch>();
        for (SDCategoryMatching sDCategoryMatching : list_scode) {
            ShopCategoryDto.SDCategMatch dto2 = new ShopCategoryDto.SDCategMatch();
            dto2.setSiteCategoryDCode(sDCategoryMatching.SiteCategoryDCode);
            dto2.setSiteCategoryLCode(sDCategoryMatching.SiteCategoryLCode);
            dto2.setSiteCategoryMCode(sDCategoryMatching.SiteCategoryMCode);
            dto2.setSiteCategorySCode(sDCategoryMatching.SiteCategorySCode);
            list_scode2.add(dto2);
        }
        return IShopCategoryAuctionCommand.GetChildSiteCategories("", "2", 1, list_scode2);
    }

    public static List<ShopCategoryDto> GetChildSiteCategories(String code, String siteId, int level, List<ShopCategoryDto.SDCategMatch> filter) throws Exception {
        return IShopCategoryAuctionCommand.GetChildSiteCategories(code, siteId, level, filter, loginCookie);
    }

    public static List<ShopCategoryDto> GetChildSiteCategories(String code, String siteId, int level, List<ShopCategoryDto.SDCategMatch> filter, Map<String, String> cookies) throws Exception {
        if (filter == null) {
            filter = new ArrayList<ShopCategoryDto.SDCategMatch>();
        }
        Connection.Response response = Jsoup.connect((String)"https://www.esmplus.com/Sell/SYI/GetChildSiteCategories").data("code", code).data("siteId", siteId).data("version", "2.0").cookies(cookies).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36").referrer("http://www.esmplus.com/Sell/SingleGoods?menuCode=TDM395").followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
        ArrayList<ShopCategoryDto> list = new ArrayList<ShopCategoryDto>();
        try {
            String body = response.body();
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            ChildSiteCategories childSiteCategories = (ChildSiteCategories)mapper.readValue(body, ChildSiteCategories.class);
            if (level == 1) {
                for (ShopCategoryDto.SDCategMatch k : filter) {
                    ChildSiteCategorie cat = childSiteCategories.result.stream().distinct().filter(d -> d.Code.equals(k.getSiteCategoryLCode())).findAny().orElse(null);
                    if (cat == null) continue;
                    ShopCategoryDto dto = new ShopCategoryDto();
                    dto.setLast(true);
                    dto.setCatlrgcd(cat.Code);
                    dto.setCatlrgnm(cat.Name);
                    dto.setSdcatemath(filter);
                    if (list.stream().anyMatch(s -> s.getCatlrgcd().equals(childSiteCategorie.Code))) continue;
                    list.add(dto);
                }
            } else if (level == 2) {
                if (filter.size() == 0) {
                    childSiteCategories.result.stream().distinct().forEach(d -> {
                        ShopCategoryDto dto = new ShopCategoryDto();
                        dto.setCatmidcd(d.Code);
                        dto.setCatmidnm(d.Name);
                        list.add(dto);
                    });
                } else {
                    for (ShopCategoryDto.SDCategMatch k : filter) {
                        ChildSiteCategorie cat;
                        if (k.getSiteCategoryMCode() == null || !k.getSiteCategoryLCode().equals(code) || (cat = (ChildSiteCategorie)childSiteCategories.result.stream().distinct().filter(d -> d.Code.equals(k.getSiteCategoryMCode())).findAny().orElse(null)) == null) continue;
                        ShopCategoryDto dto = new ShopCategoryDto();
                        dto.setLast(true);
                        dto.setCatmidcd(cat.Code);
                        dto.setCatmidnm(cat.Name);
                        if (list.stream().anyMatch(s -> s.getCatmidcd().equals(childSiteCategorie.Code))) continue;
                        list.add(dto);
                    }
                }
            } else if (level == 3) {
                if (filter.size() == 0) {
                    childSiteCategories.result.stream().distinct().forEach(d -> {
                        ShopCategoryDto dto = new ShopCategoryDto();
                        dto.setCatsmacd(d.Code);
                        dto.setCatsmanm(d.Name);
                        list.add(dto);
                    });
                } else {
                    for (ShopCategoryDto.SDCategMatch k : filter) {
                        ChildSiteCategorie cat;
                        if (k.getSiteCategorySCode() == null || !k.getSiteCategoryMCode().equals(code) || (cat = (ChildSiteCategorie)childSiteCategories.result.stream().distinct().filter(d -> d.Code.equals(k.getSiteCategorySCode())).findAny().orElse(null)) == null) continue;
                        ShopCategoryDto dto = new ShopCategoryDto();
                        dto.setLast(true);
                        dto.setCatsmacd(cat.Code);
                        dto.setCatsmanm(cat.Name);
                        if (list.stream().anyMatch(s -> s.getCatsmacd().equals(childSiteCategorie.Code))) continue;
                        list.add(dto);
                    }
                }
            } else if (level == 4) {
                if (filter.size() == 0) {
                    childSiteCategories.result.stream().distinct().forEach(d -> {
                        ShopCategoryDto dto = new ShopCategoryDto();
                        dto.setCatdtlnm(d.Code);
                        dto.setCatdtlnm(d.Name);
                        list.add(dto);
                    });
                } else {
                    for (ShopCategoryDto.SDCategMatch k : filter) {
                        ChildSiteCategorie cat;
                        if (k.getSiteCategoryDCode() == null || !k.getSiteCategorySCode().equals(code) || (cat = (ChildSiteCategorie)childSiteCategories.result.stream().distinct().filter(d -> d.Code.equals(k.getSiteCategoryDCode())).findAny().orElse(null)) == null) continue;
                        ShopCategoryDto dto = new ShopCategoryDto();
                        dto.setLast(true);
                        dto.setCatdtlcd(cat.Code);
                        dto.setCatdtlnm(cat.Name);
                        if (list.stream().anyMatch(s -> s.getCatdtlcd().equals(childSiteCategorie.Code))) continue;
                        list.add(dto);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return list;
    }

    public ChromeDriver getDriver() {
        return this.driver;
    }

    public boolean isFileDown() {
        return this.isFileDown;
    }

    public void setFileDown(boolean isFileDown) {
        this.isFileDown = isFileDown;
    }

    public boolean isHeadlessMode() {
        return this.isHeadlessMode;
    }

    public void setHeadlessMode(boolean isHeadlessMode) {
        this.isHeadlessMode = isHeadlessMode;
    }

    @Override
    public void Login(String loginID, String loginPw, String shopcd, String authkey) throws Exception {
        try {
            String URL2 = "https://www.esmplus.com/Member/SignIn/LogOn";
            this.driver = ChromeExtention.getInstace().getDriverForAuctionGmarket();
            new WebDriverWait((WebDriver)this.driver, 10L);
            this.driver.get(URL2);
            if (shopcd.equals("shop0067")) {
                ChromeScript.get().addScript(String.format("$('input:radio[name=rdoSiteSelect]:eq(0)').trigger('click');", new Object[0])).addScript(String.format("$('#SiteId').val('%s');", loginID)).addScript(String.format("$('#SitePassword').val('%s');", loginPw)).addScript("$('#btnSiteLogOn').trigger('click'); ").executeScripter(this.driver);
            } else {
                ChromeScript.get().addScript(String.format("$('input:radio[name=rdoSiteSelect]:eq(1)').trigger('click');", new Object[0])).addScript(String.format("$('#SiteId').val('%s');", loginID)).addScript(String.format("$('#SitePassword').val('%s');", loginPw)).addScript("$('#btnSiteLogOn').trigger('click'); ").executeScripter(this.driver);
            }
        }
        catch (Exception exception) {
            String message = String.format("\uc0ac\uc6a9\uc790 \uc544\uc774\ub514 : %s , \ud328\uc2a4\uc6cc\ub4dc : %s \ub85c\uadf8\uc778\uc774  \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.", loginID, loginPw);
            throw new Exception(message);
        }
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return 1;
    }

    @Override
    public List<ShopCategoryDto> Completed(List<ShopCategoryDto> param) throws Exception {
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ChildSiteCategorie {
        @JsonProperty(value="Code")
        private String Code;
        @JsonProperty(value="Name")
        private String Name;

        private ChildSiteCategorie() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ChildSiteCategories {
        @JsonProperty(value="Message")
        String message;
        @JsonProperty(value="Result")
        private List<ChildSiteCategorie> result;

        private ChildSiteCategories() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SDCategoryMatching {
        @JsonProperty(value="SiteCategoryLCode")
        private String SiteCategoryLCode;
        @JsonProperty(value="SiteCategoryMCode")
        private String SiteCategoryMCode;
        @JsonProperty(value="SiteCategorySCode")
        private String SiteCategorySCode;
        @JsonProperty(value="SiteCategoryDCode")
        private String SiteCategoryDCode;
        @JsonProperty(value="SiteId")
        private Integer SiteId;

        private SDCategoryMatching() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class SDCategoryMatchings {
        @JsonProperty(value="Message")
        String message;
        @JsonProperty(value="Result")
        private List<SDCategoryMatching> result;

        private SDCategoryMatchings() {
        }
    }
}

