/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.auction;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopProductSync;
import com.kdjsystem.mlink.shop.common.ProductSyncService;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ShopProductAuctionSync
extends ProductSyncService
implements IShopProductSync {
    public ShopProductAuctionSync(IShopProductSync productsync) {
        super(productsync);
    }

    @Override
    public List<ShopProductDto> excute(ShoppingMallDetailDto dto, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        return null;
    }

    @Override
    public List<ShopProductDto> complate(ShoppingMallDetailDto dto, Map<String, String> cookies, List<String> prodlist, IProgressMonitor monitor) throws Exception {
        ArrayList<ShopProductDto> syncList = new ArrayList<ShopProductDto>();
        ArrayList<ShopProductDto> totlaSyncList = new ArrayList<ShopProductDto>();
        boolean flag = true;
        int idx = 1;
        int saveTotal = 0;
        int start = 0;
        int limit = 100;
        int progress = 0;
        String site = dto.getShopcd().equals("shop0067") ? "1" : "2";
        while (flag) {
            String param = this.SetStringParam(start, idx, site, dto);
            new ArrayList();
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Sell/Items/GetItemMngList?_dc=").timeout(300000).cookies(cookies).header("Host", "www.esmplus.com").header("Origin", "https://www.esmplus.com").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").header("Content-Length", Integer.toString(param.length())).requestBody(param).referrer("https://www.esmplus.com/Sell/Items/ItemsMng?menuCode=TDM100").method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            String body = rs.body();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = null;
            try {
                jsonobject = (JsonObject)jsonparser.parse(body);
            }
            catch (Exception exception) {
                break;
            }
            JsonArray playListInformationArray = jsonobject.getAsJsonArray("data");
            if (playListInformationArray == null || playListInformationArray.size() == 0) break;
            saveTotal = jsonobject.get("total").getAsInt();
            JsonArray jsonArray = (JsonArray)jsonobject.get("data");
            start += limit;
            if (jsonArray == null || jsonArray.size() == 0) {
                flag = false;
            }
            if (idx == 1) {
                monitor.beginTask("\ub370\uc774\ud130 \uac00\uc9c0\uace0 \uc624\ub294\uc911\uc785\ub2c8\ub2e4.", saveTotal);
            }
            ++idx;
            syncList = new ArrayList();
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject data2 = (JsonObject)jsonArray.get(i);
                ShopProductDto syncDto = new ShopProductDto();
                syncDto.setGoods_nm(ShopCommon.jsonElementNullStr(data2.get("GoodsName")));
                syncDto.setShopprodno(ShopCommon.jsonElementNullStr(data2.get("SiteGoodsNo")));
                String time = ShopCommon.jsonElementNullStr(data2.get("DispStartDate"));
                time = time.substring(time.indexOf("(") + 1, time.indexOf(")"));
                Object end = ShopCommon.jsonElementNullStr(data2.get("DispEndDate"));
                end = ((String)end).substring(((String)end).indexOf("(") + 1, ((String)end).indexOf(")"));
                syncDto.setInsertdt(YDMATimeUtil.getLondtoDate(time.equals("") ? YDMATimeUtil.getCurrentTimeByYDFormat() : time));
                syncDto.setSaleenddt(YDMATimeUtil.getDate1((String)end));
                syncDto.setSaleStatusCd(ShopCommon.jsonElementNullStr(data2.get("StatusCode")));
                syncDto.setMarket_price(ShopCommon.jsonElementNullInt(data2.get("SellPrice")));
                syncDto.setGoods_price(ShopCommon.jsonElementNullInt(data2.get("SellPrice")));
                syncDto.setGoods_consumer_price(ShopCommon.jsonElementNullInt(data2.get("SellPrice")));
                syncDto.setCompayny_goods_cd(ShopCommon.jsonElementNullStr(data2.get("SellManageCode")));
                syncDto.setQty(ShopCommon.jsonElementNullInt(data2.get("StockQty")));
                ++progress;
                if (saveTotal > 0) {
                    try {
                        monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \uac00\uc838\uc624\ub294\uc911...] " + syncDto.getCompayny_goods_cd() + " " + progress + " of " + saveTotal + "...");
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            monitor.done();
                            break;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                syncList.add(syncDto);
                if (monitor.isCanceled()) {
                    monitor.done();
                    break;
                }
                ++i;
            }
            ArrayList<ShopProductDto> total = new ArrayList<ShopProductDto>();
            saveTotal += syncList.size();
            try {
                monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \uc800\uc7a5\uc911\uc785\ub2c8\ub2e4...]");
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    monitor.done();
                    break;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ArrayList<ProductItemDto> infoTotal = new ArrayList<ProductItemDto>();
            ArrayList<ShopProductDto> inTotal = new ArrayList<ShopProductDto>();
            for (ShopProductDto sync : syncList) {
                ShopProductDto infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", sync.getCompayny_goods_cd());
                if (infoDto != null) {
                    ShopProductDto find = total.stream().filter(d -> d.getCompayny_goods_cd().equals(infoDto.getCompayny_goods_cd())).findAny().orElse(null);
                    if (find != null) continue;
                    infoDto.setGoods_nm(sync.getGoods_nm());
                    infoDto.setGoods_price(sync.getGoods_price());
                    infoDto.setMarket_price(sync.getGoods_price());
                    infoDto.setGoods_consumer_price(sync.getGoods_price());
                    infoDto.setShopprodno(sync.getShopprodno());
                    infoDto.setInsertdt(sync.getInsertdt());
                    infoDto.setSaleenddt(sync.getSaleenddt());
                    infoDto.setShopcd(dto.getShopcd());
                    infoDto.setShopseq(dto.getShopseq());
                    infoDto.setShopuserid(dto.getShoppingid());
                    infoDto.setSendstats(this.getStatusCd(sync.getSaleStatusCd()));
                    total.add(infoDto);
                    if (!monitor.isCanceled()) continue;
                    monitor.done();
                    break;
                }
                if (!this.getStatusCd(sync.getSaleStatusCd()).equals(Integer.toString(8000))) continue;
                ShopProductDto inDto = new ShopProductDto();
                inDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                inDto.setCompayny_goods_cd(sync.getCompayny_goods_cd());
                inDto.setGoods_nm(sync.getGoods_nm());
                inDto.setGoods_price(sync.getGoods_price());
                inDto.setGoods_cost(sync.getGoods_price());
                inDto.setMarket_price(sync.getGoods_price());
                inDto.setShopprodno(sync.getShopprodno());
                inDto.setInsertdt(sync.getInsertdt());
                inDto.setSaleenddt(sync.getSaleenddt());
                inDto.setShopcd(dto.getShopcd());
                inDto.setShopseq(dto.getShopseq());
                inDto.setShopuserid(dto.getShoppingid());
                inDto.setSendstats(Integer.toString(2000));
                inDto.setStatus("1");
                inDto.setClass_cd3("999999999");
                ProductItemDto newInfoDto = new ProductItemDto();
                newInfoDto.setIcode(sync.getCompayny_goods_cd());
                newInfoDto.setIname(sync.getGoods_nm());
                newInfoDto.setPrice(sync.getGoods_price());
                newInfoDto.setPrice_consumer(sync.getGoods_price());
                newInfoDto.setStatus("3");
                newInfoDto.setClass_cd3("999999999");
                newInfoDto.setDelivery_qty("0");
                newInfoDto.setIslimit("0");
                newInfoDto.setCate_depth("3");
                newInfoDto.setCert_type("0");
                newInfoDto.setSearch("shop0000");
                String[] image = new String[24];
                int i2 = 0;
                while (i2 < image.length) {
                    image[i2] = "";
                    ++i2;
                }
                newInfoDto.setImg(image);
                newInfoDto.setDelivery_amount("0");
                infoTotal.add(newInfoDto);
                inTotal.add(inDto);
                try {
                    monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \uc800\uc7a5 \uc900\ube44\uc911 \uc785\ub2c8\ub2e4...] " + inDto.getCompayny_goods_cd() + "...");
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    monitor.done();
                    break;
                }
                catch (Exception ex) {
                    YDMAStringUtil.Print();
                    ex.printStackTrace();
                }
            }
            if (monitor.isCanceled()) {
                monitor.done();
                break;
            }
            if (total.size() > 0) {
                ShopProductDao.get().setProductInfoInsertNUpdate(total);
            }
            if (infoTotal != null && infoTotal.size() > 0) {
                DomesinShopDao.get().saveInfoReverse(infoTotal, monitor);
                ArrayList<ShopProductDto> ItemList2 = new ArrayList<ShopProductDto>();
                for (ShopProductDto inList1 : inTotal) {
                    ShopProductDto infoDto = ShopProductDao.get().getShopInfOne("COMPAYNY_GOODS_CD", inList1.getCompayny_goods_cd());
                    infoDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
                    infoDto.setCompayny_goods_cd(inList1.getCompayny_goods_cd());
                    infoDto.setGoods_nm(inList1.getGoods_nm());
                    infoDto.setGoods_price(inList1.getGoods_price());
                    infoDto.setGoods_cost(inList1.getGoods_price());
                    infoDto.setMarket_price(inList1.getGoods_price());
                    infoDto.setShopprodno(inList1.getShopprodno());
                    infoDto.setInsertdt(inList1.getInsertdt());
                    infoDto.setSaleenddt(inList1.getSaleenddt());
                    infoDto.setShopcd(dto.getShopcd());
                    infoDto.setShopseq(dto.getShopseq());
                    infoDto.setShopuserid(dto.getShoppingid());
                    infoDto.setSendstats(Integer.toString(2000));
                    infoDto.setStatus("1");
                    ItemList2.add(infoDto);
                    try {
                        monitor.subTask("[\uc0c1\ud488\uc815\ubcf4 \uc800\uc7a5\uc911\uc785\ub2c8\ub2e4...] " + inList1.getCompayny_goods_cd() + " " + progress + " of " + saveTotal + "...");
                        monitor.worked(1);
                        if (!monitor.isCanceled()) continue;
                        monitor.done();
                        break;
                    }
                    catch (Exception ex) {
                        YDMAStringUtil.Print();
                        ex.printStackTrace();
                    }
                }
                ShopProductDao.get().setProductInfoInsertNUpdate(ItemList2);
            }
            Thread.sleep(30000L);
        }
        return totlaSyncList;
    }

    private String SetStringParam(int start, int page, String site, ShoppingMallDetailDto dto) {
        StringBuilder sb = new StringBuilder();
        sb.append("paramsData=");
        sb.append("{\"Keyword\":\"\",");
        sb.append("\"SiteId\":\"" + site + "\",");
        sb.append("\"SellType\":0,");
        sb.append("\"CategoryCode\":\"\",");
        sb.append("\"CustCategoryCode\":0,");
        sb.append("\"TransPolicyNo\":0,");
        sb.append("\"StatusCode\":\"\",");
        sb.append("\"SearchDateType\":2,");
        sb.append("\"StartDate\":\"" + dto.getDatefrom() + "\",");
        sb.append("\"EndDate\":\"" + dto.getDateto() + "\",");
        sb.append("\"SellerId\":\"" + dto.getShoppingid() + "\",");
        sb.append("\"StockQty\":-1,");
        sb.append("\"SellPeriod\":0,");
        sb.append("\"DeliveryFeeApplyType\":0,");
        sb.append("\"OptAddDeliveryType\":0,");
        sb.append("\"SellMinPrice\":0,");
        sb.append("\"SellMaxPrice\":0,");
        sb.append("\"OptSelUseIs\":-1,");
        sb.append("\"PremiumEnd\":0,");
        sb.append("\"PremiumPlusEnd\":0,");
        sb.append("\"FocusEnd\":0,");
        sb.append("\"FocusPlusEnd\":0,");
        sb.append("\"GoodsIds\":\"\",");
        sb.append("\"SellMngCode\":\"\",");
        sb.append("\"OrderByType\":11,");
        sb.append("\"NotiItemReg\":-1,");
        sb.append("\"EpinMatch\":-1,");
        sb.append("\"UserEvaluate\":\"\",");
        sb.append("\"ShopCateReg\":-1,");
        sb.append("\"IsTPLUse\":\"\",");
        sb.append("\"GoodsName\":\"\",");
        sb.append("\"SdBrandId\":0,");
        sb.append("\"SdBrandName\":\"\",");
        sb.append("\"IsGiftUse\":\"\"}");
        sb.append("&page=" + String.valueOf(page));
        sb.append("&start=" + String.valueOf(start));
        sb.append("&limit=100");
        return sb.toString();
    }

    private String getStatusCd(String saleStatusCd) {
        String value = "";
        switch (saleStatusCd) {
            case "11": {
                value = String.valueOf(8000);
                break;
            }
            case "22": {
                value = String.valueOf(3000);
                break;
            }
            case "21": {
                value = String.valueOf(3000);
                break;
            }
            case "01": {
                value = String.valueOf(9000);
                break;
            }
            case "31": {
                value = String.valueOf(4000);
            }
        }
        return value;
    }
}

