/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.elevenst;

import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.elevenst.IShopOrderElevenstCommand;
import com.kdjsystem.mlink.shop.data.elevenst.RequestOrderDto;
import com.kdjsystem.mlink.tot.common.YDMAHttpUtil;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;

public class ElevenstOrderConfirmCommand
extends IShopOrderElevenstCommand {
    private static IShopOrderCommand instance = new ElevenstOrderConfirmCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private ElevenstOrderConfirmCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        try {
            RequestOrderDto list = null;
            for (ShopOrderMstDto dto : param) {
                String url = String.format("https://api.11st.co.kr/rest/ordservices/reqpackaging/%s/%s/%s/%s/%s", dto.getOrder_id(), dto.getMall_exp_cd(), dto.getOrder_gubun(), dto.getSku_value(), dto.getCopy_idx());
                Hashtable<String, String> htRequestProperty = new Hashtable<String, String>();
                htRequestProperty.put("Content-Type", "text/xml");
                htRequestProperty.put("openapikey", param.get(0).getApikey());
                String response = YDMAHttpUtil.get(url, htRequestProperty);
                response = response.replaceAll("ns2:", "");
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RequestOrderDto.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                StringReader reader = new StringReader(response.toString());
                list = (RequestOrderDto)jaxbUnmarshaller.unmarshal((Reader)reader);
                if (list.getResult_code().equals("0")) {
                    dto.setOrder_status("100");
                    dto.setResult_code("1");
                    dto.setResult_text("\uc815\uc0c1\uc801\uc73c\ub85c \uc8fc\ubb38\ud655\uc778\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    continue;
                }
                dto.setResult_code("-1");
                dto.setResult_text(list.getResult_text());
            }
        }
        catch (Exception exception) {
            throw new Exception("11\ubc88\uac00 \uc8fc\ubb38\ud655\uc778\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return param;
    }
}

