/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.interpark;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.interpark.IShopOrderInterParkCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class BuyzleLiteOrderCommand
extends IShopOrderInterParkCommand {
    private static IShopOrderCommand instance = new BuyzleLiteOrderCommand();
    JsonParser parser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private BuyzleLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> ret = new ArrayList<ShopOrderMstNewDto>();
        try {
            String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
            String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date sdate = formatter.parse(startdt);
            Date edate = formatter.parse(enddt);
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(edate);
            cal2.add(1, -1);
            if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
                startdt = formatter.format(cal2.getTime());
            }
            Map<String, String> cookies = this.getLoginCookieLite(dto);
            if (dto.getSpecificStatus().equals("\uc2e0\uaddc\uc8fc\ubb38")) {
                this.getNewOrder(dto, ret, cookies, startdt, enddt, "40");
            } else {
                this.getNewOrder(dto, ret, cookies, startdt, enddt, "50");
            }
        }
        catch (Exception exception) {}
        return ret;
    }

    private void getNewOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret, Map<String, String> cookies, String startdt, String enddt, String orderStatus) throws Exception {
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://seller.buyzle.co.kr/api/orders/acknowledge").append("?orderSendStep=").append("&orderStatus=").append(orderStatus).append("&detailedSearchType=").append("&detailedSearchValue=").append("&searchPeriodType=orderDate").append("&startDate=").append(startdt).append("T15%3A00%3A00Z").append("&endDate=").append(enddt).append("T14%3A59%3A00Z").append("&page=1").append("&size=50");
        try {
            Connection.Response rs = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).method(Connection.Method.GET).timeout(20000).ignoreContentType(true).followRedirects(true).execute();
            String body = rs.body();
            if (body.contains("200")) {
                JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
                JsonArray jsonArray = (jsonobject = jsonobject.get("data").getAsJsonObject()).get("orders").getAsJsonArray();
                if (jsonArray.size() > 0) {
                    List<ShopOrderMstNewDto> param = this.setNewOrdersData(dto, "100", jsonArray, cookies);
                    param.forEach(d -> d.setResult_code("1"));
                    ret.addAll(param);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ubc14\uc774\uc990 \uc8fc\ubb38 \uc218\uc9d1 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<ShopOrderMstNewDto> setNewOrdersData(ShopOrderMstNewDto ordDto, String orderStatus, JsonArray jsonArray, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstNewDto> dtolist = new ArrayList<ShopOrderMstNewDto>();
        try {
            for (JsonElement ele : jsonArray) {
                JsonObject object = ele.getAsJsonObject();
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setCompno(ordDto.getCompno());
                dto.setShopid(ordDto.getShopid());
                dto.setShop_userid(ordDto.getShop_userid());
                dto.setAuthkey1(ordDto.getAuthkey1());
                dto.setOrder_id(object.get("ordclmNo").getAsString());
                dto.setOrder_status(orderStatus);
                dto.setP_product_name(object.get("prdNm").getAsString());
                String ordDt = dto.getOrder_id().substring(0, 4) + "-" + dto.getOrder_id().substring(4, 6) + "-" + dto.getOrder_id().substring(6, 8) + " " + dto.getOrder_id().substring(8, 10) + ":" + dto.getOrder_id().substring(10, 12) + ":" + dto.getOrder_id().substring(12, 14);
                dto.setOrder_date(ordDt);
                dto.setProduct_name(object.get("prdNm").getAsString());
                dto.setP_sku_value(this.jsonElementNullStr(object.get("optFnm")));
                dto.setSku_value(dto.getSku_value());
                dto.setSale_cnt(object.get("ordCnt").getAsString());
                dto.setUser_name(object.get("ordNm").getAsString());
                dto.setUser_id(this.jsonElementNullStr(object.get("ordId")));
                dto.setUser_tel(object.get("ordTelno").getAsString());
                dto.setUser_cel(object.get("ordMpno").getAsString());
                dto.setReceive_name(object.get("rcvrNm").getAsString());
                dto.setDelivery_method_str2(object.get("delvAmtPayTpNm").getAsString());
                dto.setMall_won_cost(object.get("expectedSettlementAmt").getAsString());
                dto.setTotal_cost(object.get("totalPrice").getAsString());
                dto.setDelv_cost(object.get("delvAmt").isJsonNull() ? "0" : object.get("delvAmt").getAsString());
                int totalcost = Integer.parseInt(dto.getTotal_cost()) + Integer.parseInt(dto.getDelv_cost());
                dto.setPay_cost(String.valueOf(totalcost));
                dto.setSale_cost(object.get("saleUnitcost").getAsString());
                dto.setMall_product_id(object.get("prdNo").getAsString());
                dto.setMall_exp_cd(object.get("optParentSeq").getAsString());
                dto.setP_sku_id(dto.getSku_value());
                dto.setReceive_zipcode(object.get("zipCode").getAsString());
                dto.setReceive_addr(object.get("address").getAsString());
                dto.setReceive_tel(object.get("rcvrTelno").getAsString());
                dto.setReceive_cel(object.get("rcvrMpno").getAsString());
                dto.setDelv_msg(this.jsonElementNullStr(object.get("delvMsg")));
                dto.setUser_email("");
                dto.setReceive_email("");
                dto.setWon_cost("0");
                dto.setBox_ea("0");
                dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("externalParentPrdNo")));
                dto.setResult_code("1");
                dto.setDelivery_method(this.jsonElementNullStr(object.get("delvAttbtNm")));
                dto.setPay_method(this.jsonElementNullStr(object.get("payMthdTp")));
                dto.setPay_date(this.jsonElementNullStr(object.get("paidDate")).replace("T", " "));
                dto.setMall_fee(this.jsonElementNullStr(object.get("totalFee")));
                dtolist.add(dto);
            }
        }
        catch (Exception exception) {
            throw new Exception("\ubc14\uc774\uc990 \uc8fc\ubb38 \uc218\uc9d1 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }
}

