/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.kakaostore;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.kakaostore.IShopOrderKakaoStoreCommand;
import java.util.ArrayList;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class KakaoStoreOrderSearchCommand
extends IShopOrderKakaoStoreCommand {
    private static IShopOrderCommand instance = new KakaoStoreOrderSearchCommand();
    boolean flag;
    JsonParser jsonParser = new JsonParser();

    private KakaoStoreOrderSearchCommand() {
    }

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        try {
            for (ShopOrderMstDto dto : param) {
                this.syncOrderWithcomplete(dto, retList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return retList;
    }

    public void syncOrderWithcomplete(ShopOrderMstDto dto, List<ShopOrderMstDto> dtolist) throws Exception {
        Connection.Response response_order = Jsoup.connect((String)("https://kapi.kakao.com/v1/shopping/order?order_id=" + dto.getOrder_id())).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + dto.getApikey()).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
        JsonObject jsonObject = (JsonObject)this.jsonParser.parse(response_order.body());
        JsonObject prdinfo = (JsonObject)jsonObject.get("orderBase");
        Object reqDate = prdinfo.getAsJsonObject().get("modifiedAt").getAsString();
        reqDate = ((String)reqDate).substring(0, 4) + "-" + ((String)reqDate).substring(4, 6) + "-" + ((String)reqDate).substring(6, 8) + " " + ((String)reqDate).substring(8, 10) + ":" + ((String)reqDate).substring(10, 12) + ":" + ((String)reqDate).substring(12, 14);
        switch (prdinfo.getAsJsonObject().get("status").getAsString()) {
            case "ShippingCancelRequest": 
            case "TicketRefundRequest": 
            case "TicketRefundWaiting": 
            case "PayCancelRequest": 
            case "RefundFailed": 
            case "ShippingRefundRequest": 
            case "ShippingCancelRequestBuyer": 
            case "ShippingRefundWaiting": 
            case "ShippingRefundFailed": 
            case "RefundRequest": 
            case "RefundWaiting": 
            case "ShippingCancelRequestSeller": {
                this.orderUpdate(dto, "C01", dtolist);
                break;
            }
            case "ShippingCancelComplete": 
            case "TicketRefundComplete": 
            case "RefundComplete": 
            case "PayCancelComplete": {
                this.orderUpdate(dto, "C02", dtolist, (String)reqDate);
                break;
            }
            case "ReturnApproved": 
            case "ReturnRequest": 
            case "ReturnPending": {
                this.orderUpdate(dto, "R01", dtolist);
                break;
            }
            case "ReturnCancelComplete": 
            case "ReturnRefundComplete": 
            case "ReturnShippingComplete": 
            case "ShippingRefundComplete": {
                this.orderUpdate(dto, "R02", dtolist, (String)reqDate);
                break;
            }
            case "ExchangePending": 
            case "ExchangeReturnComplete": 
            case "ExchangeRequest": 
            case "ExchangeApproved": 
            case "ExchangeReturning": 
            case "ExchangeShippingProgress": {
                this.orderUpdate(dto, "E01", dtolist);
                break;
            }
            case "ExchangeShippingComplete": {
                this.orderUpdate(dto, "E02", dtolist, (String)reqDate);
                break;
            }
            case "ShippingComplete": 
            case "BuyDecision": {
                this.orderUpdate(dto, "410", dtolist);
            }
        }
    }

    public void orderUpdate(ShopOrderMstDto dto, String status2, List<ShopOrderMstDto> dtolist) throws Exception {
        dto.setOrder_status(status2);
        dto.setResult_code("1");
        dtolist.add(dto);
    }

    public void orderUpdate(ShopOrderMstDto dto, String status2, List<ShopOrderMstDto> dtolist, String reqDate) throws Exception {
        dto.setOrder_status(status2);
        dto.setResult_code("1");
        ShopOrderMstDto temp = dto.clone(status2);
        temp.setOrder_date(reqDate);
        temp.setOrder_status(status2);
        dtolist.add(dto);
        dtolist.add(temp);
    }
}

