/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.lotteon;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.lotteon.IShopLotteOnOrderCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class LotteOnLiteOrderCommand
extends IShopLotteOnOrderCommand {
    private static IShopOrderCommand instance = new LotteOnLiteOrderCommand();
    JsonParser jsonParser = new JsonParser();
    ObjectMapper mapper = new ObjectMapper();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private LotteOnLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> ret_list = new ArrayList<ShopOrderMstNewDto>();
        try {
            String startdt = dto.getStartDt().substring(0, 8);
            String enddt = dto.getEndDt().substring(0, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(startdt);
            Date edate = formatter.parse(enddt);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(sdate);
            int i = 0;
            while (i < (int)range) {
                this.processOrders(dto, ret_list, startdt);
                cal1.add(5, 1);
                startdt = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \uc2e0\uaddc \uc8fc\ubb38 \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return ret_list;
    }

    private void processOrders(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret_list, String startdt) throws Exception {
        switch (dto.getSpecificStatus()) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                this.getOrder(dto, ret_list, startdt, "11", "100");
                break;
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                this.getOrder(dto, ret_list, startdt, "12", "100");
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                this.getOrder(dto, ret_list, startdt, "13", "403");
                break;
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                this.getOrder(dto, ret_list, startdt, "14", "410");
                break;
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                this.getOrder(dto, ret_list, startdt, "15", "410");
                break;
            }
            case "\ucde8\uc18c": {
                this.getClaimList(dto, ret_list, startdt, "cancellationOpenApi/getCancellationRequestAndComplateList", "C01");
                this.getOrder(dto, ret_list, startdt, "21", "C02");
                break;
            }
            case "\ubc18\ud488": {
                this.getClaimList(dto, ret_list, startdt, "returningOpenApi/returnRequestSearch", "R01");
                this.getOrder(dto, ret_list, startdt, "27", "R02");
                break;
            }
            case "\uad50\ud658": {
                this.getClaimList(dto, ret_list, startdt, "exchangeOpenApi/exchangeSearch", "E01");
                break;
            }
            case "\ud1b5\ud569": {
                this.getOrder(dto, ret_list, startdt, "11", "100");
                this.getOrder(dto, ret_list, startdt, "12", "100");
                this.getOrder(dto, ret_list, startdt, "13", "403");
                this.getOrder(dto, ret_list, startdt, "14", "410");
                this.getOrder(dto, ret_list, startdt, "15", "410");
                this.getClaimList(dto, ret_list, startdt, "cancellationOpenApi/getCancellationRequestAndComplateList", "C01");
                this.getOrder(dto, ret_list, startdt, "21", "C02");
                this.getClaimList(dto, ret_list, startdt, "returningOpenApi/returnRequestSearch", "R01");
                this.getOrder(dto, ret_list, startdt, "27", "R02");
                this.getClaimList(dto, ret_list, startdt, "exchangeOpenApi/exchangeSearch", "E01");
            }
        }
    }

    private void getOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret_list, String date, String odPrgsStepCd, String orderStatus) throws Exception {
        OrderSearchRequest request2 = new OrderSearchRequest(date + "000000", date + "235959", odPrgsStepCd);
        String json = this.mapper.writeValueAsString((Object)request2);
        Connection.Response rs = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + dto.getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.POST).execute();
        JsonObject jsonObject = this.jsonParser.parse(rs.body()).getAsJsonObject();
        jsonObject = jsonObject.get("data").getAsJsonObject();
        JsonArray jsonArray = jsonObject.get("deliveryProgressStateList").getAsJsonArray();
        this.getJsonManager(jsonArray, dto, orderStatus, ret_list);
    }

    private void getClaimList(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret_list, String date, String url, String orderStatus) throws Exception {
        String odPrgsStepCd = orderStatus.equals("C01") ? "02" : "03";
        ClaimOrderRequest request2 = new ClaimOrderRequest(date + "000000", date + "235959", odPrgsStepCd);
        String json = this.mapper.writeValueAsString((Object)request2);
        String requestURL = "https://openapi.lotteon.com/v1/openapi/claim/v1/" + url;
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost postRequest = new HttpPost(requestURL);
        postRequest.addHeader("Authorization", "Bearer " + dto.getApikey());
        postRequest.setHeader("X-Agent-Authorization", "t86ur8pop2rb");
        postRequest.setHeader("Accept", "application/json");
        postRequest.setHeader("Accept-Language", "ko");
        postRequest.setHeader("X-Timezone", "\"GMT+09:00");
        postRequest.addHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(json));
        HttpResponse response = client.execute((HttpUriRequest)postRequest);
        HttpEntity entity = response.getEntity();
        String body = EntityUtils.toString((HttpEntity)entity);
        JsonObject jsonObject = this.jsonParser.parse(body).getAsJsonObject();
        String returncode = jsonObject.get("returnCode").getAsString();
        if (returncode.equals("0000")) {
            JsonArray arr = jsonObject.get("data").getAsJsonArray();
            for (JsonElement obj : arr) {
                String ordNum = obj.getAsJsonObject().get("odNo").getAsString();
                this.getOrderByClaim(dto, ret_list, date, odPrgsStepCd, orderStatus, ordNum);
            }
        }
    }

    private void getOrderByClaim(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> ret_list, String date, String odPrgsStepCd, String orderStatus, String ordNum) throws Exception {
        OrderSearchRequest request2 = new OrderSearchRequest(date + "000000", date + "235959", odPrgsStepCd, ordNum);
        String json = this.mapper.writeValueAsString((Object)request2);
        Connection.Response rs = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + dto.getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.POST).execute();
        JsonObject jsonObject = this.jsonParser.parse(rs.body()).getAsJsonObject();
        jsonObject = jsonObject.get("data").getAsJsonObject();
        JsonArray jsonArray = jsonObject.get("deliveryProgressStateList").getAsJsonArray();
        this.getJsonManager(jsonArray, dto, orderStatus, ret_list);
    }

    private void getJsonManager(JsonArray jsonArray, ShopOrderMstNewDto ordDto, String orderStatus, List<ShopOrderMstNewDto> ret_list) throws Exception {
        try {
            int i = 0;
            while (i < jsonArray.size()) {
                ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                dto.setBasicInfo(ordDto);
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setResult_code("1");
                dto.setUser_id("");
                dto.setSku_value("");
                dto.setWon_cost("0");
                dto.setMall_won_cost("0");
                JsonObject neworder = jsonArray.get(i).getAsJsonObject();
                Object ordDt = neworder.get("odCmptDttm").getAsString();
                ordDt = ((String)ordDt).substring(0, 4) + "-" + ((String)ordDt).substring(4, 6) + "-" + ((String)ordDt).substring(6, 8) + " " + ((String)ordDt).substring(8, 10) + ":" + ((String)ordDt).substring(10, 12) + ":" + ((String)ordDt).substring(12, 14);
                dto.setOrder_date((String)ordDt);
                dto.setOrder_id(neworder.get("odNo").getAsString());
                dto.setOrder_status(orderStatus);
                dto.setUser_name(neworder.get("odrNm").getAsString());
                dto.setUser_email(this.nullcheck(neworder.get("emlAddr")));
                dto.setUser_cel(this.phonenumber_check(neworder.get("mphnNo")));
                String addr = this.nullcheck(neworder.get("dvpStnmZipAddr")) + " " + this.nullcheck(neworder.get("dvpStnmDtlAddr"));
                dto.setReceive_addr(addr);
                dto.setReceive_name(neworder.get("dvpCustNm").getAsString());
                dto.setReceive_cel(this.phonenumber_check(neworder.get("dvpMphnNo")));
                dto.setReceive_tel(this.phonenumber_check(neworder.get("dvpTelNo")));
                dto.setReceive_zipcode(neworder.get("dvpZipNo").getAsString());
                dto.setCompayny_goods_cd(neworder.get("epdNo").getAsString());
                dto.setP_product_name(neworder.get("spdNm").getAsString());
                dto.setProduct_name(neworder.get("spdNm").getAsString());
                dto.setP_sku_value(neworder.get("sitmNm").getAsString());
                dto.setMall_exp_cd(neworder.get("odSeq").getAsString());
                dto.setMall_product_id(neworder.get("spdNo").getAsString());
                dto.setSku_id(neworder.get("sitmNo").getAsString());
                dto.setP_sku_id(neworder.get("sitmNm").getAsString());
                dto.setDelv_msg(this.nullcheck(neworder.get("dvMsg")));
                dto.setEtc_msg(neworder.get("owhoDttm").getAsString());
                int expprice = (int)neworder.get("dvCst").getAsDouble();
                dto.setDelv_cost(String.valueOf(expprice));
                if (expprice > 0) {
                    dto.setDelivery_method_str2("\uc120\uacb0\uc81c");
                } else if (expprice == 0) {
                    dto.setDelivery_method_str2("\ubb34\ub8cc");
                }
                boolean discountPrice = false;
                int saleCost = neworder.get("slPrc").getAsInt();
                int saleCnt = neworder.get("odQty").getAsInt();
                int totalCost = saleCost * saleCnt;
                dto.setSale_cnt(String.valueOf(neworder.get("odQty").getAsInt()));
                dto.setSale_cost(String.valueOf(neworder.get("slPrc").getAsInt()));
                int price2 = (int)neworder.get("slAmt").getAsDouble();
                dto.setTotal_cost(String.valueOf(price2));
                dto.setPay_cost(String.valueOf(price2 + expprice));
                ret_list.add(dto);
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \uc8fc\ubb38 \uc2e0\uaddc \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    public String phonenumber_check(JsonElement ele) {
        Object num = "";
        if (ele.isJsonNull() || ele.toString().equals("null") || ele.toString().trim().equals("")) {
            return num;
        }
        if (ele.getAsString().length() == 12) {
            num = ele.getAsString();
            num = ((String)num).substring(0, 4) + "-" + ((String)num).substring(4, 8) + "-" + ((String)num).substring(8, 12);
        } else if (ele.getAsString().length() == 11) {
            num = ele.getAsString();
            num = ((String)num).substring(0, 3) + "-" + ((String)num).substring(3, 7) + "-" + ((String)num).substring(7, 11);
        } else {
            num = ele.getAsString();
        }
        return num;
    }

    public String nullcheck(JsonElement ele) {
        if (ele.isJsonNull() || ele.toString().equals("null") || ele.toString().trim().equals("")) {
            return "";
        }
        return ele.getAsString();
    }

    class ClaimOrderRequest {
        private String srchStrtDttm;
        private String srchEndDttm;
        private String odPrgsStepCd;

        public ClaimOrderRequest() {
        }

        public ClaimOrderRequest(String srchStrtDttm, String srchEndDttm, String odPrgsStepCd) {
            this.srchStrtDttm = srchStrtDttm;
            this.srchEndDttm = srchEndDttm;
            this.odPrgsStepCd = odPrgsStepCd;
        }

        public String getSrchStrtDttm() {
            return this.srchStrtDttm;
        }

        public void setSrchStrtDttm(String srchStrtDttm) {
            this.srchStrtDttm = srchStrtDttm;
        }

        public String getSrchEndDttm() {
            return this.srchEndDttm;
        }

        public void setSrchEndDttm(String srchEndDttm) {
            this.srchEndDttm = srchEndDttm;
        }

        public String getOdPrgsStepCd() {
            return this.odPrgsStepCd;
        }

        public void setOdPrgsStepCd(String odPrgsStepCd) {
            this.odPrgsStepCd = odPrgsStepCd;
        }
    }

    class OrderSearchRequest {
        private String srchStrtDt;
        private String srchEndDt;
        private String odPrgsStepCd;
        private String odNo;

        public OrderSearchRequest() {
        }

        public OrderSearchRequest(String srchStrtDt, String srchEndDt, String odPrgsStepCd) {
            this.srchStrtDt = srchStrtDt;
            this.srchEndDt = srchEndDt;
            this.odPrgsStepCd = odPrgsStepCd;
        }

        public OrderSearchRequest(String srchStrtDt, String srchEndDt, String odPrgsStepCd, String odNo) {
            this.srchStrtDt = srchStrtDt;
            this.srchEndDt = srchEndDt;
            this.odPrgsStepCd = odPrgsStepCd;
            this.odNo = odNo;
        }

        public String getSrchStrtDt() {
            return this.srchStrtDt;
        }

        public void setSrchStrtDt(String srchStrtDt) {
            this.srchStrtDt = srchStrtDt;
        }

        public String getSrchEndDt() {
            return this.srchEndDt;
        }

        public void setSrchEndDt(String srchEndDt) {
            this.srchEndDt = srchEndDt;
        }

        public String getOdPrgsStepCd() {
            return this.odPrgsStepCd;
        }

        public void setOdPrgsStepCd(String odPrgsStepCd) {
            this.odPrgsStepCd = odPrgsStepCd;
        }

        public String getOdNo() {
            return this.odNo;
        }

        public void setOdNo(String odNo) {
            this.odNo = odNo;
        }
    }
}

