/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.lotteon;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.lotteon.IShopLotteOnOrderCommand;
import java.util.Arrays;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class LotteOnOrderCancelApprovalCommand
extends IShopLotteOnOrderCommand {
    private static LotteOnOrderCancelApprovalCommand instance = new LotteOnOrderCancelApprovalCommand();
    ObjectMapper mapper = new ObjectMapper();
    JsonParser jsonParser = new JsonParser();

    public static LotteOnOrderCancelApprovalCommand getInstance() {
        return instance;
    }

    private LotteOnOrderCancelApprovalCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        try {
            for (ShopOrderMstDto dto : param) {
                LotteOnOrderCancelApprovalRequest.Item item = new LotteOnOrderCancelApprovalRequest.Item();
                item.setOdSeq(123);
                item.setProcSeq(1234);
                item.setOrglProcSeq(1234);
                item.setSlrRsnCd("101");
                LotteOnOrderCancelApprovalRequest request2 = new LotteOnOrderCancelApprovalRequest();
                request2.setOdNo(dto.getOrder_id());
                request2.setClmNo("\ud074\ub808\uc784");
                request2.setItemList(Arrays.asList(item));
                String json = this.mapper.writeValueAsString((Object)request2);
                Connection.Response response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/claim/v1/cancellationOpenApi/cnclRequestApproval").header("Authorization", "Bearer " + dto.getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
                JsonObject jsonObject = (JsonObject)this.jsonParser.parse(response.body());
                String returncode = jsonObject.get("returnCode").getAsString();
                if (returncode.equals("0000")) {
                    dto.setResult_code("1");
                    continue;
                }
                dto.setResult_code("-1");
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370 ON \ucde8\uc18c\uc2b9\uc778 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4..");
        }
        return param;
    }

    private static class LotteOnOrderCancelApprovalRequest {
        private String odNo;
        private String clmNo;
        private List<Item> itemList;

        private LotteOnOrderCancelApprovalRequest() {
        }

        public String getOdNo() {
            return this.odNo;
        }

        public void setOdNo(String odNo) {
            this.odNo = odNo;
        }

        public String getClmNo() {
            return this.clmNo;
        }

        public void setClmNo(String clmNo) {
            this.clmNo = clmNo;
        }

        public List<Item> getItemList() {
            return this.itemList;
        }

        public void setItemList(List<Item> itemList) {
            this.itemList = itemList;
        }

        private static class Item {
            private int odSeq;
            private int procSeq;
            private int orglProcSeq;
            private String slrRsnCd;

            private Item() {
            }

            public int getOdSeq() {
                return this.odSeq;
            }

            public void setOdSeq(int odSeq) {
                this.odSeq = odSeq;
            }

            public int getProcSeq() {
                return this.procSeq;
            }

            public void setProcSeq(int procSeq) {
                this.procSeq = procSeq;
            }

            public int getOrglProcSeq() {
                return this.orglProcSeq;
            }

            public void setOrglProcSeq(int orglProcSeq) {
                this.orglProcSeq = orglProcSeq;
            }

            public String getSlrRsnCd() {
                return this.slrRsnCd;
            }

            public void setSlrRsnCd(String slrRsnCd) {
                this.slrRsnCd = slrRsnCd;
            }
        }
    }
}

