/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.lotteon;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.lotteon.IShopLotteOnOrderCommand;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class LotteOnOrderSearchCommand
extends IShopLotteOnOrderCommand {
    private static IShopOrderCommand instance = new LotteOnOrderSearchCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private LotteOnOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret_list = new ArrayList<ShopOrderMstDto>();
        try {
            String startDt = param.get(0).getStartDt().substring(0, 8);
            String endDt = param.get(0).getEndDt().substring(0, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(startDt);
            Date edate = formatter.parse(endDt);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(sdate);
            int i = 0;
            while (i < (int)range) {
                this.getClaimList(param, ret_list, startDt, "exchangeOpenApi/exchangeSearch", "E01");
                this.getClaimList(param, ret_list, startDt, "returningOpenApi/returnRequestSearch", "R01");
                this.getClaimList(param, ret_list, startDt, "cancellationOpenApi/getCancellationRequestAndComplateList", "C01");
                this.DeliveryProgressStateSearch(param, ret_list, startDt);
                cal1.add(5, 1);
                startDt = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return ret_list;
    }

    private void DeliveryProgressStateSearch(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret_list, String date) throws Exception {
        try {
            String json = "{\"srchStrtDt\":\"" + date + "000000\",\"srchEndDt\":\"" + date + "235959\"}";
            Connection.Response response = Jsoup.connect((String)"https://openapi.lotteon.com/v1/openapi/delivery/v1/SellerDeliveryProgressStateSearch").header("Authorization", "Bearer " + param.get(0).getApikey()).header("X-Agent-Authorization", "t86ur8pop2rb").header("Accept", "application/json").header("Accept-Language", "ko").header("X-Timezone", "GMT+09:00").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = response.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            String returncode = jsonObject.get("returnCode").getAsString();
            JsonObject data2 = (JsonObject)jsonObject.get("data");
            if (returncode.equals("0000") && jsonObject.get("dataCount").getAsInt() > 0) {
                JsonArray arr = (JsonArray)data2.get("deliveryProgressStateList");
                for (JsonElement obj : arr) {
                    String ordNum = obj.getAsJsonObject().get("odNo").getAsString();
                    String exp_cd = obj.getAsJsonObject().get("odSeq").getAsString();
                    String product_id = obj.getAsJsonObject().get("spdNo").getAsString();
                    String odPrgsStepCd = this.getStatus(obj.getAsJsonObject().get("odPrgsStepCd").getAsString());
                    for (ShopOrderMstDto orderMstDto : param) {
                        if (!orderMstDto.getOrder_id().equals(ordNum) || !orderMstDto.getMall_exp_cd().equals(exp_cd) || !orderMstDto.getMall_product_id().equals(product_id) || odPrgsStepCd.equals("")) continue;
                        orderMstDto.setOrder_status(odPrgsStepCd);
                        orderMstDto.setResult_code("1");
                        if (odPrgsStepCd.equals("C02") || odPrgsStepCd.equals("R02")) {
                            ShopOrderMstDto temp = orderMstDto.clone(odPrgsStepCd);
                            Object req_dt = obj.getAsJsonObject().get("dvTrcStatDttm").getAsString();
                            req_dt = ((String)req_dt).substring(0, 4) + "-" + ((String)req_dt).substring(4, 6) + "-" + ((String)req_dt).substring(6, 8) + " " + ((String)req_dt).substring(8, 10) + ":" + ((String)req_dt).substring(10, 12) + ":" + ((String)req_dt).substring(12, 14);
                            temp.setOrder_date((String)req_dt);
                            temp.setResult_code("1");
                            ret_list.add(temp);
                        }
                        ret_list.add(orderMstDto);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getClaimList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret_list, String date, String url, String status2) throws Exception {
        try {
            String json = "{\"srchStrtDttm\":\"" + date + "000000\",\"srchEndDttm\":\"" + date + "235959\"}";
            String requestURL = "https://openapi.lotteon.com/v1/openapi/claim/v1/" + url;
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpPost postRequest = new HttpPost(requestURL);
            postRequest.addHeader("Authorization", "Bearer " + param.get(0).getApikey());
            postRequest.setHeader("X-Agent-Authorization", "t86ur8pop2rb");
            postRequest.setHeader("Accept", "application/json");
            postRequest.setHeader("Accept-Language", "ko");
            postRequest.setHeader("X-Timezone", "\"GMT+09:00");
            postRequest.addHeader("Content-Type", "application/json");
            postRequest.setEntity((HttpEntity)new StringEntity(json));
            HttpResponse response = client.execute((HttpUriRequest)postRequest);
            HttpEntity entity = response.getEntity();
            String body = EntityUtils.toString((HttpEntity)entity);
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            String returncode = jsonObject.get("returnCode").getAsString();
            if (returncode.equals("0000") && jsonObject.get("dataCount").getAsInt() > 0) {
                JsonArray arr = (JsonArray)jsonObject.get("data");
                for (JsonElement obj : arr) {
                    String ordNum = obj.getAsJsonObject().get("odNo").getAsString();
                    JsonArray objarr = obj.getAsJsonObject().get("itemList").getAsJsonArray();
                    for (JsonElement item_obj : objarr) {
                        String exp_cd = item_obj.getAsJsonObject().get("odSeq").getAsString();
                        String product_id = item_obj.getAsJsonObject().get("spdNo").getAsString();
                        for (ShopOrderMstDto orderMstDto : param) {
                            if (!orderMstDto.getOrder_id().equals(ordNum) || !orderMstDto.getMall_exp_cd().equals(exp_cd) || !orderMstDto.getMall_product_id().equals(product_id)) continue;
                            String odPrgsStepCd2 = "";
                            String odTypCd = "";
                            if (status2.equals("C01") || status2.equals("R01")) {
                                odPrgsStepCd2 = this.getStatus(item_obj.getAsJsonObject().get("odPrgsStepCd").getAsString());
                                odTypCd = item_obj.getAsJsonObject().get("odTypCd").getAsString();
                            } else {
                                odPrgsStepCd2 = this.getStatus2(item_obj.getAsJsonObject().get("odPrgsStepCd").getAsString());
                                odTypCd = item_obj.getAsJsonObject().get("odTypCd").getAsString();
                            }
                            orderMstDto.setOrder_status(odPrgsStepCd2);
                            orderMstDto.setResult_code("1");
                            if (!odPrgsStepCd2.equals("C01") && (!odPrgsStepCd2.equals("R01") || !odTypCd.equals("40")) && (!odPrgsStepCd2.equals("E01") || !odTypCd.equals("30"))) continue;
                            orderMstDto.setOrder_status(odPrgsStepCd2);
                            orderMstDto.setResult_code("1");
                            ret_list.add(orderMstDto);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub86f\ub370\uc628 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    public String getStatus(String status2) {
        switch (status2) {
            case "13": {
                return "403";
            }
            case "14": 
            case "15": {
                return "410";
            }
            case "02": 
            case "20": {
                return "C01";
            }
            case "21": {
                return "C02";
            }
            case "03": 
            case "23": 
            case "40": {
                return "R01";
            }
            case "27": {
                return "R02";
            }
        }
        return "";
    }

    public String getStatus2(String status2) {
        switch (status2) {
            case "03": {
                return "E01";
            }
        }
        return "";
    }
}

