/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class NaverStoreLiteOrderCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreLiteOrderCommand();
    JsonParser parser = new JsonParser();
    ObjectMapper mapper = new ObjectMapper();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        long range;
        ArrayList<ShopOrderMstNewDto> retList = new ArrayList<ShopOrderMstNewDto>();
        String start = YDMATimeUtil.getTime(dto.getStartDt());
        String end = YDMATimeUtil.getTime(dto.getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(dto.getStartDt());
        Date edate = formatter.parse(dto.getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)(range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 90 == 0 ? (int)range / 90 : (int)range / 90 + 1;
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 89);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        int i = 0;
        while (i < num) {
            this.processOrders(dto, retList, start, end);
            cal1.add(5, 90);
            cal2.add(5, 90);
            start = String.valueOf(cal1.getTimeInMillis());
            end = String.valueOf(cal2.getTimeInMillis());
            ++i;
        }
        return retList;
    }

    private void processOrders(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end) throws Exception {
        switch (dto.getSpecificStatus()) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                this.getNewOrder(dto, retList, start, end, "WAITING_DISPATCH", "NEW_ORDER");
                break;
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                this.getNewOrder(dto, retList, start, end, "WAITING_DISPATCH", "PLACE_ORDER");
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                this.getNewOrderDelivery(dto, retList, start, end, "DELIVERING", "403");
                break;
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                this.getNewOrderDelivery(dto, retList, start, end, "DELIVERED", "410");
                break;
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                this.getPurchaseDecisionOrder(dto, retList, start, end);
                break;
            }
            case "\ucde8\uc18c": {
                this.getCancelOrder(dto, retList, start, end);
                break;
            }
            case "\ubc18\ud488": {
                this.getReturnOrder(dto, retList, start, end);
                break;
            }
            case "\uad50\ud658": {
                this.getExchangeOrder(dto, retList, start, end);
                break;
            }
            case "\ud1b5\ud569": {
                this.getNewOrder(dto, retList, start, end, "WAITING_DISPATCH", "NEW_ORDER");
                this.getNewOrder(dto, retList, start, end, "WAITING_DISPATCH", "PLACE_ORDER");
                this.getNewOrderDelivery(dto, retList, start, end, "DELIVERING", "403");
                this.getNewOrderDelivery(dto, retList, start, end, "DELIVERED", "410");
                this.getPurchaseDecisionOrder(dto, retList, start, end);
                this.getCancelOrder(dto, retList, start, end);
                this.getReturnOrder(dto, retList, start, end);
                this.getExchangeOrder(dto, retList, start, end);
            }
        }
    }

    private void getNewOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end, String orderStatus, String detaliOrderStatus) throws Exception {
        try {
            Map<String, String> cookies = this.getLoginCookieLite(dto);
            String merchantNo = this.getMerchantNo(cookies);
            String strParam = this.getNewOrderStringParam(merchantNo, start, end, orderStatus, detaliOrderStatus);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject object = this.parser.parse(body).getAsJsonObject();
            JsonObject data2 = object.get("data").getAsJsonObject();
            JsonObject deliveryList = data2.get("deliveryList").getAsJsonObject();
            JsonArray elements = deliveryList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                List<ShopOrderMstNewDto> param = this.setData(dto, elements, cookies);
                param.forEach(d -> d.setResult_code("1"));
                retList.addAll(param);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void getNewOrderDelivery(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end, String orderStatus, String status2) throws Exception {
        try {
            Map<String, String> cookies = this.getLoginCookieLite(dto);
            String merchantNo = this.getMerchantNo(cookies);
            String strParam = this.getNewOrderStringParam(merchantNo, start, end, orderStatus, "ALL");
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject object = this.parser.parse(body).getAsJsonObject();
            JsonObject data2 = object.get("data").getAsJsonObject();
            JsonObject deliveryList = data2.get("deliveryList").getAsJsonObject();
            JsonArray elements = deliveryList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                List<ShopOrderMstNewDto> param = this.setDataDelivery(dto, elements, cookies, status2);
                param.forEach(d -> d.setResult_code("1"));
                retList.addAll(param);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void getPurchaseDecisionOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end) throws Exception {
        try {
            Map<String, String> cookies = this.getLoginCookieLite(dto);
            String merchantNo = this.getMerchantNo(cookies);
            int page = 1;
            boolean isContinue = true;
            while (isContinue) {
                String json = this.getPurchaseDecisionOrderStringParam(merchantNo, start, end, page);
                String body = this.postSmartStoreGraphQL(cookies, json).body();
                JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
                JsonObject data2 = jsonobject.get("data").getAsJsonObject();
                JsonObject purchaseDecisionList = data2.get("purchaseDecisionList").getAsJsonObject();
                JsonObject pagination = purchaseDecisionList.get("pagination").getAsJsonObject();
                if (page < pagination.get("totalPages").getAsInt()) {
                    ++page;
                } else {
                    isContinue = false;
                }
                JsonArray elements = purchaseDecisionList.get("elements").getAsJsonArray();
                if (elements.size() <= 0) continue;
                List<ShopOrderMstNewDto> param = this.setDataByDelivery(dto, elements, cookies);
                param.forEach(d -> d.setResult_code("1"));
                retList.addAll(param);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void getCancelOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end) throws Exception {
        try {
            Map<String, String> cookies = this.getLoginCookieLite(dto);
            String merchantNo = this.getMerchantNo(cookies);
            int k = 0;
            while (k < 2) {
                String status2 = this.getStatusCancel(k);
                String strParam = this.getCancelOrderStringParam(merchantNo, status2, start, end);
                String body = this.postSmartStoreGraphQL(cookies, strParam).body();
                JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
                JsonObject data2 = jsonobject.get("data").getAsJsonObject();
                JsonObject cancelList = data2.get("cancelListMp").getAsJsonObject();
                JsonArray elements = cancelList.get("elements").getAsJsonArray();
                if (elements.size() > 0) {
                    this.setDataByClaim(dto, elements, cookies, retList);
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void getReturnOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end) throws Exception {
        try {
            Map<String, String> cookies = this.getLoginCookieLite(dto);
            String merchantNo = this.getMerchantNo(cookies);
            int k = 0;
            while (k < 4) {
                String status2 = this.getStatusReturn(k);
                String strParam = this.getReturnOrderStringParam(merchantNo, status2, start, end);
                String body = this.postSmartStoreGraphQL(cookies, strParam).body();
                JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
                JsonObject data2 = jsonobject.get("data").getAsJsonObject();
                JsonObject returnList = data2.get("returnList").getAsJsonObject();
                JsonArray elements = returnList.get("elements").getAsJsonArray();
                if (elements.size() > 0) {
                    this.setDataByClaim(dto, elements, cookies, retList);
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void getExchangeOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end) throws Exception {
        try {
            Map<String, String> cookies = this.getLoginCookieLite(dto);
            String merchantNo = this.getMerchantNo(cookies);
            int k = 0;
            while (k < 4) {
                String status2 = this.getStatusExchange(k);
                String strParam = this.getExchangeOrderStringParam(merchantNo, status2, start, end);
                String body = this.postSmartStoreGraphQL(cookies, strParam).body();
                JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
                JsonObject data2 = jsonobject.get("data").getAsJsonObject();
                JsonObject exchangeList = data2.get("exchangeList").getAsJsonObject();
                JsonArray elements = exchangeList.get("elements").getAsJsonArray();
                if (elements.size() > 0) {
                    this.setDataByClaim(dto, elements, cookies, retList);
                }
                ++k;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private List<ShopOrderMstNewDto> setData(ShopOrderMstNewDto ordDto, JsonArray order_arr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstNewDto> list = new ArrayList<ShopOrderMstNewDto>();
        for (JsonElement order : order_arr) {
            ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
            dto.setBasicInfo(ordDto);
            dto.setResult_code("1");
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setP_sku_id("");
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setUser_email("");
            JsonObject object = order.getAsJsonObject();
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setOrder_status(this.getStatus(object.get("productOrderStatus").getAsString()));
            dto.setOrder_date(YDMATimeUtil.getDate(object.get("orderDateTime").getAsString()));
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            String receiverAddr = this.jsonElementNullStr(object.get("receiverDisplayBaseAddress")).concat(" ").concat(this.jsonElementNullStr(object.get("receiverDisplayDetailAddress")));
            dto.setReceive_addr(receiverAddr);
            dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
            dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setP_product_name(object.get("productName").getAsString());
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            String code = super.getCode(object.get("productNo").getAsString(), cookies);
            dto.setMall_product_id(code + "," + object.get("productNo").getAsString());
            dto.setCopy_idx(this.jsonElementNullStr(object.get("deliveryNo")));
            dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            dto.setNaver_delivery_attribute(this.jsonElementNullStr(object.get("deliveryAttributeText")));
            dto.setProduct_url(this.jsonElementNullStr(object.get("productUrl")));
            dto.setPay_method(this.jsonElementNullStr(object.get("payMeansClass")));
            dto.setPay_date(YDMATimeUtil.getDate(object.get("payDateTime").getAsString()));
            dto.setNaver_order_id(this.jsonElementNullStr(object.get("orderNo")));
            dto.setNaver_product_order_id(this.jsonElementNullStr(object.get("productOrderNo")));
            dto.setLast_referral_path(this.jsonElementNullStr(object.get("inflowPath")));
            dto.setIs_naver_login(ordDto.getAuthkey1().equals("Y") ? "\uc544\ub2c8\uc624" : "\uc608");
            int optAddPrice = object.get("productOptionAmt").getAsInt();
            int discountPrice = object.get("sellerDiscountAmt").getAsInt();
            int saleCnt = object.get("orderQuantity").getAsInt();
            int saleCost = object.get("productUnitPrice").getAsInt();
            int totalCost = saleCnt * saleCost + optAddPrice;
            int payCost = object.get("productPayAmt").getAsInt();
            int mallWonCost = object.get("settlementExpectAmt").getAsInt();
            int supplyCost = mallWonCost + discountPrice;
            int mallFee = totalCost - supplyCost;
            int delvCost = this.parseIntSafe(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setTotal_cost(String.valueOf(totalCost));
            dto.setSale_cnt(this.fmtInt(saleCnt));
            dto.setSale_cost(this.fmtInt(saleCost));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setMall_won_cost(this.fmtInt(mallWonCost));
            dto.setOpt_add_cost(this.fmtInt(optAddPrice));
            dto.setDiscount_cost(this.fmtInt(discountPrice));
            dto.setRate(this.percentOf(mallFee, totalCost, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setDelv_cost(this.fmtInt(delvCost));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
            list.add(dto);
        }
        return list;
    }

    private List<ShopOrderMstNewDto> setDataDelivery(ShopOrderMstNewDto ordDto, JsonArray order_arr, Map<String, String> cookies, String status2) throws Exception {
        ArrayList<ShopOrderMstNewDto> list = new ArrayList<ShopOrderMstNewDto>();
        for (JsonElement order : order_arr) {
            ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
            dto.setBasicInfo(ordDto);
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_status(status2);
            dto.setResult_code("1");
            dto.setP_sku_id("");
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setUser_email("");
            JsonObject object = order.getAsJsonObject();
            String orddt = YDMATimeUtil.getDate(object.get("orderDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            String receiverAddr = this.jsonElementNullStr(object.get("receiverDisplayBaseAddress")).concat(" ").concat(this.jsonElementNullStr(object.get("receiverDisplayDetailAddress")));
            dto.setReceive_addr(receiverAddr);
            dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
            dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setP_product_name(object.get("productName").getAsString());
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            String code = super.getCode(object.get("productNo").getAsString(), cookies);
            dto.setMall_product_id(code + "," + object.get("productNo").getAsString());
            dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            dto.setInvoice_no(this.jsonElementNullStr(object.get("deliveryInvoiceNo")));
            dto.setDelivery_id(this.jsonElementNullStr(object.get("deliveryCompanyCode")));
            dto.setCopy_idx(this.jsonElementNullStr(object.get("deliveryNo")));
            dto.setPay_date(YDMATimeUtil.getDate(object.get("payDateTime").getAsString()));
            dto.setProduct_url(this.jsonElementNullStr(object.get("productUrl")));
            dto.setPay_method(this.jsonElementNullStr(object.get("payMeansClass")));
            dto.setNaver_order_id(this.jsonElementNullStr(object.get("orderNo")));
            dto.setNaver_product_order_id(this.jsonElementNullStr(object.get("productOrderNo")));
            dto.setNaver_delivery_attribute(this.jsonElementNullStr(object.get("deliveryAttributeText")));
            dto.setIs_naver_login(ordDto.getAuthkey1().equals("Y") ? "\uc544\ub2c8\uc624" : "\uc608");
            dto.setLast_referral_path(this.jsonElementNullStr(object.get("inflowPath")));
            dto.setExpress_deadline(YDMATimeUtil.getDate(object.get("dispatchDueDateTime").getAsString()));
            if (!this.jsonElementNullStr(object.get("dispatchDateTime")).equals("")) {
                dto.setExpress_date(YDMATimeUtil.getDate(object.get("dispatchDateTime").getAsString()));
            }
            if (!this.jsonElementNullStr(object.get("deliveryDateTime")).equals("")) {
                dto.setDelivery_comp_date(YDMATimeUtil.getDate(object.get("deliveryDateTime").getAsString()));
            }
            int optAddPrice = object.get("productOptionAmt").getAsInt();
            int discountPrice = object.get("sellerDiscountAmt").getAsInt();
            int saleCnt = object.get("orderQuantity").getAsInt();
            int saleCost = object.get("productUnitPrice").getAsInt();
            int totalCost = saleCnt * saleCost;
            int payCost = object.get("productPayAmt").getAsInt();
            int mallWonCost = object.get("settlementExpectAmt").getAsInt();
            int supplyCost = mallWonCost + discountPrice;
            int mallFee = totalCost - supplyCost;
            int delvCost = this.parseIntSafe(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setTotal_cost(String.valueOf(totalCost));
            dto.setSale_cnt(this.fmtInt(saleCnt));
            dto.setSale_cost(this.fmtInt(saleCost));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setMall_won_cost(this.fmtInt(mallWonCost));
            dto.setOpt_add_cost(this.fmtInt(optAddPrice));
            dto.setDiscount_cost(this.fmtInt(discountPrice));
            dto.setRate(this.percentOf(mallFee, totalCost, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setDelv_cost(this.fmtInt(delvCost));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
            list.add(dto);
        }
        return list;
    }

    private List<ShopOrderMstNewDto> setDataByDelivery(ShopOrderMstNewDto ordDto, JsonArray order_arr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstNewDto> dtolist = new ArrayList<ShopOrderMstNewDto>();
        for (JsonElement order : order_arr) {
            ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
            dto.setBasicInfo(ordDto);
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setResult_code("1");
            dto.setOrder_status("901");
            dto.setUser_email("");
            dto.setReceive_zipcode("");
            dto.setReceive_addr("");
            dto.setUser_tel("");
            dto.setUser_cel("");
            dto.setReceive_tel("");
            dto.setReceive_cel("");
            dto.setDelv_msg("");
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setDelivery_id("");
            JsonObject object = order.getAsJsonObject();
            dto.setOrder_id(object.get("orderNo").getAsString());
            String orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setPay_date(orddt);
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setP_product_name(object.get("productName").getAsString());
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setMall_product_id(object.get("productNo").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            dto.setInvoice_no(this.jsonElementNullStr(object.get("deliveryInvoiceNo")));
            dto.setDeliveryName(this.jsonElementNullStr(object.get("deliveryCompanyName")));
            dto.setCopy_idx(this.jsonElementNullStr(object.get("deliveryNo")));
            dto.setProduct_url(this.jsonElementNullStr(object.get("productUrl")));
            dto.setPay_method(this.jsonElementNullStr(object.get("payMeansClass")));
            dto.setNaver_order_id(this.jsonElementNullStr(object.get("orderNo")));
            dto.setNaver_product_order_id(this.jsonElementNullStr(object.get("productOrderNo")));
            dto.setLast_referral_path(this.jsonElementNullStr(object.get("inflowPath")));
            dto.setNaver_delivery_attribute(this.jsonElementNullStr(object.get("deliveryAttributeText")));
            dto.setIs_naver_login(ordDto.getAuthkey1().equals("Y") ? "\uc544\ub2c8\uc624" : "\uc608");
            dto.setPurchase_confirm_date(YDMATimeUtil.getDate(object.get("purchaseDecisionCompleteDateTime").getAsString()));
            dto.setDelivery_comp_date(YDMATimeUtil.getDate(object.get("deliveryCompleteDateTime").getAsString()));
            int optAddPrice = object.get("productOptionAmt").getAsInt();
            int discountPrice = object.get("sellerDiscountAmt").getAsInt();
            int saleCnt = object.get("orderQuantity").getAsInt();
            int saleCost = object.get("productUnitPrice").getAsInt();
            int totalCost = saleCnt * saleCost;
            int payCost = object.get("productPayAmt").getAsInt();
            int mallWonCost = object.get("settlementExpectAmt").getAsInt();
            int supplyCost = mallWonCost + discountPrice;
            int mallFee = totalCost - supplyCost;
            int delvCost = this.parseIntSafe(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setTotal_cost(String.valueOf(totalCost));
            dto.setSale_cnt(this.fmtInt(saleCnt));
            dto.setSale_cost(this.fmtInt(saleCost));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setMall_won_cost(this.fmtInt(mallWonCost));
            dto.setOpt_add_cost(this.fmtInt(optAddPrice));
            dto.setDiscount_cost(this.fmtInt(discountPrice));
            dto.setRate(this.percentOf(mallFee, totalCost, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setDelv_cost(this.fmtInt(delvCost));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
            dtolist.add(dto);
        }
        return dtolist;
    }

    private void setDataByClaim(ShopOrderMstNewDto ordDto, JsonArray jsonArray, Map<String, String> cookies, List<ShopOrderMstNewDto> retList) throws Exception {
        for (JsonElement ele : jsonArray) {
            ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
            dto.setBasicInfo(ordDto);
            dto.setResult_code("1");
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setReceive_zipcode("");
            dto.setReceive_addr("");
            dto.setUser_tel("");
            dto.setUser_cel("");
            dto.setReceive_tel("");
            dto.setReceive_cel("");
            dto.setDelv_msg("");
            dto.setUser_email("");
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setDelivery_id("");
            JsonObject object = ele.getAsJsonObject();
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setOrder_status(this.getClaimStatus(object.get("claimStatus").getAsString()));
            String orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setPay_date(orddt);
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setP_product_name(object.get("productName").getAsString());
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setMall_product_id(object.get("productNo").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            if (object.has("deliveryInvoiceNo")) {
                dto.setInvoice_no(this.jsonElementNullStr(object.get("deliveryInvoiceNo")));
            } else {
                dto.setInvoice_no("");
            }
            if (object.has("deliveryCompanyName")) {
                dto.setDeliveryName(this.jsonElementNullStr(object.get("deliveryCompanyName")));
            } else {
                dto.setDeliveryName("");
            }
            dto.setCopy_idx(this.jsonElementNullStr(object.get("deliveryBundleGroupSeq")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            dto.setProduct_url(this.jsonElementNullStr(object.get("productUrl")));
            dto.setNaver_delivery_attribute(this.jsonElementNullStr(object.get("deliveryAttributeText")));
            dto.setNaver_order_id(this.jsonElementNullStr(object.get("orderNo")));
            dto.setNaver_product_order_id(this.jsonElementNullStr(object.get("productOrderNo")));
            dto.setIs_naver_login(ordDto.getAuthkey1().equals("Y") ? "\uc544\ub2c8\uc624" : "\uc608");
            try {
                dto.setClaim_reg_date(YDMATimeUtil.getDate(object.get("clamRequestDateTime").getAsString()));
            }
            catch (Exception exception) {
                try {
                    dto.setClaim_reg_date(YDMATimeUtil.getDate(object.get("claimRequestDateTime").getAsString()));
                }
                catch (Exception exception2) {
                    dto.setClaim_reg_date(YDMATimeUtil.getDate(object.get("exchangeRequestDateTime").getAsString()));
                }
            }
            dto.setClaim_reason(this.jsonElementNullStr(object.get("claimRequestReason")));
            int optAddPrice = object.get("productOptionAmt").getAsInt();
            int discountPrice = object.get("totalDiscountAmt").getAsInt();
            int saleCnt = object.get("orderQuantity").getAsInt();
            int saleCost = object.get("productUnitPrice").getAsInt();
            int totalCost = saleCnt * saleCost;
            int payCost = totalCost - discountPrice;
            int delvCost = this.parseIntSafe(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            int mallWonCost = 0;
            int mallFee = 0;
            int supplyCost = 0;
            dto.setTotal_cost(String.valueOf(totalCost));
            dto.setSale_cnt(this.fmtInt(saleCnt));
            dto.setSale_cost(this.fmtInt(saleCost));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setMall_won_cost(this.fmtInt(mallWonCost));
            dto.setOpt_add_cost(this.fmtInt(optAddPrice));
            dto.setDiscount_cost(this.fmtInt(discountPrice));
            dto.setRate(this.percentOf(mallFee, totalCost, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setDelv_cost(this.fmtInt(delvCost));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
            retList.add(dto);
        }
    }

    private String getClaimStatus(String status2) {
        String value = "";
        switch (status2) {
            case "CANCEL_REJECT": 
            case "CANCELING": 
            case "CANCEL_REQUEST": {
                value = "C01";
                break;
            }
            case "ADMIN_CANCEL_DONE": 
            case "CANCEL_DONE": {
                value = "C02";
                break;
            }
            case "RETURN_REJECT": 
            case "RETURN_REQUEST": {
                value = "R01";
                break;
            }
            case "RETURN_DONE": {
                value = "R02";
                break;
            }
            case "EXCHANGE_REQUEST": 
            case "EXCHANGE_REJECT": {
                value = "E01";
                break;
            }
            case "EXCHANGE_REDELIVERING": 
            case "EXCHANGE_DONE": {
                value = "E02";
            }
        }
        return value;
    }

    private String getStatusCancel(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "CANCEL_REQUEST";
                break;
            }
            case 1: {
                value = "CANCEL_DONE";
            }
        }
        return value;
    }

    private String getStatusReturn(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "RETURN_REQUEST";
                break;
            }
            case 1: {
                value = "COLLECTING";
                break;
            }
            case 2: {
                value = "COLLECT_DONE";
                break;
            }
            case 3: {
                value = "RETURN_DONE";
            }
        }
        return value;
    }

    private String getStatusExchange(int i) {
        String value = "";
        switch (i) {
            case 0: {
                value = "EXCHANGE_REQUEST";
                break;
            }
            case 1: {
                value = "COLLECTING";
                break;
            }
            case 2: {
                value = "COLLECT_DONE";
                break;
            }
            case 3: {
                value = "EXCHANGE_DONE";
            }
        }
        return value;
    }

    private String getStatus(String string) {
        String value = "";
        switch (string) {
            case "PLACE_ORDER": 
            case "NEW_ORDER": 
            case "PAYED": 
            case "PLACE_ORDER_RELEASE": {
                value = "100";
                break;
            }
            case "DELIVERING": {
                value = "403";
                break;
            }
            case "DELIVERED": {
                value = "410";
            }
        }
        return value;
    }

    private String getDelivery(String jsonElementNullStr) {
        String value = "";
        switch (jsonElementNullStr) {
            case "PREPAYED": 
            case "\uc120\uacb0\uc81c": {
                value = "\uc120\uacb0\uc81c";
                break;
            }
            case "": 
            case "\ubb34\ub8cc": 
            case "FREE": {
                value = "\ubb34\ub8cc";
            }
        }
        return value;
    }

    private String getNewOrderStringParam(String merchantNo, String start, String end, String orderStatus, String detaliOrderStatus) throws Exception {
        NewOrder newOrder = new NewOrder();
        newOrder.operationName = "smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery";
        newOrder.variables.merchantNo = merchantNo;
        newOrder.variables.serviceType = "MP";
        newOrder.variables.pagingPage = 1;
        newOrder.variables.pagingSize = 100;
        newOrder.variables.sortType = "RECENTLY_ORDER_YMDT";
        newOrder.variables.sortDirection = "DESC";
        newOrder.variables.rangeType = "PAY_COMPLETED";
        newOrder.variables.dateRange_from = start;
        newOrder.variables.dateRange_to = end;
        newOrder.variables.orderStatus = orderStatus;
        newOrder.variables.detailedOrderStatus = detaliOrderStatus;
        newOrder.query = this.getBasicGraphQLQuery();
        return this.mapper.writeValueAsString((Object)newOrder);
    }

    private String getPurchaseDecisionOrderStringParam(String merchantNo, String start, String end, int page) throws Exception {
        NewOrder deliveryComplted = new NewOrder();
        deliveryComplted.operationName = "SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision";
        deliveryComplted.variables.dateRange_from = start;
        deliveryComplted.variables.dateRange_to = end;
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = page;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.rangeType = "PAY_COMPLETED";
        deliveryComplted.variables.serviceType = "MP";
        deliveryComplted.variables.sortDirection = "DESC";
        deliveryComplted.variables.sortType = "PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT";
        deliveryComplted.query = this.getPurchaseDecisionGraphqlQuery();
        return this.mapper.writeValueAsString((Object)deliveryComplted);
    }

    private String getCancelOrderStringParam(String merchantNo, String status2, String start, String end) throws Exception {
        NewOrderClaim cancelOrder = new NewOrderClaim();
        cancelOrder.operationName = "findClaimCancelsByDetailConditionsMp_ForClaimCancel";
        cancelOrder.variables.claimStatus = status2;
        cancelOrder.variables.dateRange_from = start;
        cancelOrder.variables.dateRange_to = end;
        cancelOrder.variables.merchantNo = merchantNo;
        cancelOrder.variables.serviceType = "MP";
        cancelOrder.variables.pagingPage = 1;
        cancelOrder.variables.pagingSize = 100;
        cancelOrder.variables.rangeType = "PAY_COMPLETED";
        cancelOrder.query = "query findClaimCancelsByDetailConditionsMp_ForClaimCancel($claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $merchantNo: String!, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  cancelListMp: findClaimCancelsByDetailConditionsMp_ForClaimCancel(\n    claimStatus: $claimStatus\n    dateRange_from: $dateRange_from\n    dateRange_to: $dateRange_to\n    detailSearch_keyword: $detailSearch_keyword\n    detailSearch_type: $detailSearch_type\n    merchantNo: $merchantNo\n    paging_page: $paging_page\n    paging_size: $paging_size\n    rangeType: $rangeType\n    serviceType: $serviceType\n    sort_direction: $sort_direction\n    sort_type: $sort_type\n  ) {\n    elements {\n      ...cancelElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment cancelElementField on CancelClaimSeller {\n  deliveryFeeAmt\n  deliveryFeeClass\n  biztalkAccountId\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  productUnitPrice\n  cancelDateTime\n  orderQuantity\n  productName\n  claimRequestOperatorType\n  clamRequestDateTime\n  orderMemberName\n  payDateTime\n  productOrderNo\n  productOptionContents\n  deliveryFeeRatingClass\n  orderMemberId\n  orderMemberNo\n  productOptionAmt\n  discountAmtChangedInfo\n  productNo\n  refundExpectDateTime\n  totalDiscountAmt\n  claimRequestAdmissionOperator\n  orderNo\n  productClass\n  receiverName\n  deliveryFeeChangedInfo\n  claimRequestReason\n  refundOperator\n  saleChannelType\n  receiverAddress\n  deliveryFeeDiscountAmt\n  receiverZipCode\n  sellerProductManagementCode\n  syncDateTime\n  productOrderStatus\n  sellerInternalCode2\n  claimRequestAdmissionDateTime\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  claimStatus\n  orderMemberTelNo\n  fulfillmentCompanyName\n  deliveryAttributeText\n  initTotalDiscountAmt\n  initProductPayAmt\n  quantityClaimYn\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}";
        return this.mapper.writeValueAsString((Object)cancelOrder);
    }

    private String getReturnOrderStringParam(String merchantNo, String status2, String start, String end) throws Exception {
        NewOrderClaim returnOrder = new NewOrderClaim();
        returnOrder.operationName = "findClaimReturnsByDetailConditionsMp_ForClaimReturn";
        returnOrder.variables.claimStatus = status2;
        returnOrder.variables.dateRange_from = start;
        returnOrder.variables.dateRange_to = end;
        returnOrder.variables.merchantNo = merchantNo;
        returnOrder.variables.serviceType = "MP";
        returnOrder.variables.pagingPage = 1;
        returnOrder.variables.pagingSize = 100;
        returnOrder.variables.rangeType = "PAY_COMPLETED";
        returnOrder.query = "query findClaimReturnsByDetailConditionsMp_ForClaimReturn($claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $merchantNo: String!, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  returnList: findClaimReturnsByDetailConditionsMp_ForClaimReturn(\n    claimStatus: $claimStatus\n    dateRange_from: $dateRange_from\n    dateRange_to: $dateRange_to\n    detailSearch_keyword: $detailSearch_keyword\n    detailSearch_type: $detailSearch_type\n    merchantNo: $merchantNo\n    paging_page: $paging_page\n    paging_size: $paging_size\n    rangeType: $rangeType\n    serviceType: $serviceType\n    sort_direction: $sort_direction\n    sort_type: $sort_type\n  ) {\n    elements {\n      ...returnElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment returnElementField on ClaimReturnSeller {\n  returnCareTarget\n  deliveryFeeClass\n  holdbackStatus\n  deliveryInvoiceNo\n  claimExtraFeePayAmt\n  orderQuantity\n  productName\n  payDateTime\n  deliveryFeeRatingClass\n  orderMemberId\n  discountAmtChangedInfo\n  refundExpectDateTime\n  claimCollectStatusExposureText\n  totalDiscountAmt\n  orderNo\n  productClass\n  claimCollectDateTime\n  deliveryFeeChangedInfo\n  claimRequestDateTime\n  claimRequestReason\n  backDeliveryInvoiceNo\n  refundOperator\n  saleChannelType\n  deliveryCompanyName\n  sellerProductManagementCode\n  holdbackReleaseDateTime\n  claimStatus\n  holdbackConfigDateTime\n  orderMemberTelNo\n  orderMemberNo\n  deliveryFeeAmt\n  claimNo\n  backDeliveryMethodExposureText\n  deliveryMethod\n  biztalkAccountId\n  branchDeliveryStartDateTime\n  branchDeliveryEndDateTime\n  branchId\n  merchantChannelNo\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  claimCollectStatus\n  productUnitPrice\n  claimRequestOperatorType\n  orderMemberName\n  productOrderNo\n  productOptionContents\n  claimCollectAddress\n  claimDeliveryFeeAmt\n  productOptionAmt\n  productNo\n  returnReceiveAddress\n  backDeliveryCompanyName\n  receiverName\n  deliveryNo\n  refundDateTime\n  deliveryFeeDiscountAmt\n  claimRejectDetail\n  backDeliveryMethod\n  syncDateTime\n  productOrderStatus\n  backDeliveryNo\n  sellerInternalCode2\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  claimDeliveryFeePayMethod\n  claimDeliveryFeePayMethodText\n  claimExtraFeePayMethod\n  fulfillmentCompanyName\n  collectRemoteAreaCostChargeAmt\n  claimRequestReasonCollectFail\n  deliveryAttributeText\n  initTotalDiscountAmt\n  initProductPayAmt\n  quantityClaimYn\n  membershipsArrivalGuaranteeClaimSupportTarget\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}";
        return this.mapper.writeValueAsString((Object)returnOrder);
    }

    private String getExchangeOrderStringParam(String merchantNo, String status2, String start, String end) throws Exception {
        NewOrderClaim exchangeOrder = new NewOrderClaim();
        exchangeOrder.operationName = "SmartStoreFindClaimExchangesByDetailConditions_ForClaimExchange";
        exchangeOrder.variables.claimStatus = status2;
        exchangeOrder.variables.dateRange_from = start;
        exchangeOrder.variables.dateRange_to = end;
        exchangeOrder.variables.merchantNo = merchantNo;
        exchangeOrder.variables.serviceType = "MP";
        exchangeOrder.variables.pagingPage = 1;
        exchangeOrder.variables.pagingSize = 100;
        exchangeOrder.variables.rangeType = "PAY_COMPLETED";
        exchangeOrder.query = "query SmartStoreFindClaimExchangesByDetailConditions_ForClaimExchange($claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $memberNo: String, $merchantNo: String!, $serviceType: String!, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  exchangeList: SmartStoreFindClaimExchangesByDetailConditions_ForClaimExchange(\n    claimStatus: $claimStatus\n    dateRange_from: $dateRange_from\n    dateRange_to: $dateRange_to\n    detailSearch_keyword: $detailSearch_keyword\n    detailSearch_type: $detailSearch_type\n    memberNo: $memberNo\n    serviceType: $serviceType\n    merchantNo: $merchantNo\n    paging_page: $paging_page\n    paging_size: $paging_size\n    rangeType: $rangeType\n    sort_direction: $sort_direction\n    sort_type: $sort_type\n  ) {\n    elements {\n      ...exchangeElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment exchangeElementField on ClaimExchangeSeller {\n  lastClaimNo\n  beforeClaimNo\n  reDeliveryAddress\n  returnCareTarget\n  branchId\n  merchantChannelNo\n  deliveryFeeClass\n  redeliveryOperationDateTime\n  holdbackStatus\n  deliveryInvoiceNo\n  claimExtraFeePayAmt\n  reDeliveryNo\n  orderQuantity\n  productName\n  claimType\n  payDateTime\n  deliveryFeeRatingClass\n  purchaseDecisionExtensionReasonDetailContent\n  orderMemberId\n  reDeliveryStatus\n  claimCollectStatusExposureText\n  totalDiscountAmt\n  claimRejectDetailContent\n  orderNo\n  productClass\n  claimCollectDateTime\n  reDeliveryInvoiceNo\n  purchaseDecisionExtensionReason\n  claimRequestReason\n  backDeliveryInvoiceNo\n  exchangeRequestDateTime\n  reDeliveryCompanyName\n  deliveryCompanyName\n  sellerProductManagementCode\n  holdbackReleaseDateTime\n  claimStatus\n  holdbackConfigDateTime\n  orderMemberTelNo\n  orderMemberNo\n  purchaseDecisionExtensionDateTime\n  deliveryFeeAmt\n  claimNo\n  backDeliveryMethodExposureText\n  deliveryMethod\n  biztalkAccountId\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  claimCollectStatus\n  productUnitPrice\n  claimRequestOperatorType\n  orderMemberName\n  productOrderNo\n  productOptionContents\n  claimCollectAddress\n  claimDeliveryFeeAmt\n  productOptionAmt\n  productNo\n  purchaseDecisionExpectDateTime\n  returnReceiveAddress\n  backDeliveryCompanyName\n  receiverName\n  deliveryNo\n  deliveryFeeDiscountAmt\n  reDeliveryMethod\n  syncDateTime\n  productOrderStatus\n  backDeliveryNo\n  sellerInternalCode2\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  claimDeliveryFeePayMethod\n  claimDeliveryFeePayMethodText\n  claimExtraFeePayMethod\n  fulfillmentCompanyName\n  collectRemoteAreaCostChargeAmt\n  claimRequestReasonCollectFail\n  deliveryAttributeText\n  purchaseDecisionExtensionStatusType\n  initTotalDiscountAmt\n  initProductPayAmt\n  quantityClaimYn\n  membershipsArrivalGuaranteeClaimSupportTarget\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}";
        return this.mapper.writeValueAsString((Object)exchangeOrder);
    }

    private String getBasicGraphQLQuery() {
        StringBuilder query = new StringBuilder();
        query.append("query smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery(").append("$dateRange_from: String, ").append("$dateRange_to: String, ").append("$delayDispatchGuideTreatStateType: DelayDispatchGuideTreatStateType, ").append("$deliveryDirectionClass: DeliveryDirectionClassType, ").append("$deliveryMethodType: DeliveryMethodType, ").append("$deliveryNo: String, ").append("$detailSearch_keyword: String, ").append("$detailSearch_type: DetailSearchType, ").append("$detailedOrderStatus: DetailedSearchOrderStatusType, ").append("$deviceClassType: DeviceClassType, ").append("$merchantNo: String!, ").append("$orderStatus: SearchOrderStatusType, ").append("$paging_page: Int, ").append("$paging_size: Int, ").append("$rangeType: RangeType, ").append("$serviceType: String!, ").append("$sort_direction: SortDirectionType, ").append("$sort_type: SortType").append(") {\n").append("  deliveryList: smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery(\n").append("    dateRange_from: $dateRange_from\n").append("    dateRange_to: $dateRange_to\n").append("    delayDispatchGuideTreatStateType: $delayDispatchGuideTreatStateType\n").append("    deliveryDirectionClass: $deliveryDirectionClass\n").append("    deliveryMethodType: $deliveryMethodType\n").append("    deliveryNo: $deliveryNo\n").append("    detailSearch_keyword: $detailSearch_keyword\n").append("    detailSearch_type: $detailSearch_type\n").append("    detailedOrderStatus: $detailedOrderStatus\n").append("    deviceClassType: $deviceClassType\n").append("    merchantNo: $merchantNo\n").append("    orderStatus: $orderStatus\n").append("    paging_page: $paging_page\n").append("    paging_size: $paging_size\n").append("    rangeType: $rangeType\n").append("    serviceType: $serviceType\n").append("    sort_direction: $sort_direction\n").append("    sort_type: $sort_type\n").append("  ) {\n").append("    elements {\n").append("      ...deliveryElementField\n").append("      __typename\n").append("    }\n").append("    pagination {\n").append("      ...paginationField\n").append("      __typename\n").append("    }\n").append("    __typename\n").append("  }\n").append("}\n\n").append("fragment deliveryElementField on SaleDeliverySeller {\n").append("  returnCareTarget\n").append("  branchId\n").append("  merchantChannelNo\n").append("  deliveryFeeClass\n").append("  deliveryInvoiceNo\n").append("  orderQuantity\n").append("  productName\n").append("  payDateTime\n").append("  deliveryDateTime\n").append("  deliveryFeeRatingClass\n").append("  productOrderMemo\n").append("  orderMemberId\n").append("  remoteAreaCostChargeAmt\n").append("  payLocationType\n").append("  totalDiscountAmt\n").append("  orderNo\n").append("  payMeansClass\n").append("  productClass\n").append("  oneYearOrderAmt\n").append("  saleChannelType\n").append("  oneYearOrderCount\n").append("  deliveryCompanyName\n").append("  sellerProductManagementCode\n").append("  grade\n").append("  orderMemberTelNo\n").append("  deliveryFeeAmt\n").append("  claimNo\n").append("  deliveryMethod\n").append("  deliveryMethodPay\n").append("  biztalkAccountId\n").append("  giftName\n").append("  receiverTelNo2\n").append("  productPayAmt\n").append("  receiverTelNo1\n").append("  sixMonthOrderAmt\n").append("  orderStatus\n").append("  productUnitPrice\n").append("  waybillPrintDateTime\n").append("  threeMonthOrderCount\n").append("  orderMemberName\n").append("  productOrderNo\n").append("  deliveryCompanyCode\n").append("  productOptionContents\n").append("  dispatchDueDateTime\n").append("  knowledgeShoppingCommissionAmt\n").append("  productOptionAmt\n").append("  productNo\n").append("  individualCustomUniqueCode\n").append("  orderDateTime\n").append("  placingOrderDateTime\n").append("  inflowPath\n").append("  receiverName\n").append("  settlementExpectAmt\n").append("  deliveryNo\n").append("  threeMonthOrderAmt\n").append("  sellerDiscountAmt\n").append("  deliveryFeeDiscountAmt\n").append("  dispatchDateTime\n").append("  sixMonthOrderCount\n").append("  receiverZipCode\n").append("  payCommissionAmt\n").append("  takingGoodsPlaceAddress\n").append("  syncDateTime\n").append("  productOrderStatus\n").append("  sellerInternalCode2\n").append("  sellerOptionManagementCode\n").append("  sellerInternalCode1\n").append("  deliveryBundleGroupSeq\n").append("  productUrl\n").append("  subscriptionRound\n").append("  subscriptionPeriodCount\n").append("  fulfillmentCompanyName\n").append("  receiverIntegratedAddress\n").append("  receiverDisplayBaseAddress\n").append("  receiverDisplayDetailAddress\n").append("  deliveryAttributeText\n").append("  hopeDelivery\n").append("  initTotalDiscountAmt\n").append("  initProductPayAmt\n").append("  quantityClaimYn\n").append("  quantityClaimNo\n").append("  subscriptionHopeDelivery\n").append("  membershipsArrivalGuaranteeClaimSupportTarget\n").append("  __typename\n").append("}\n\n").append("fragment paginationField on Pagination {\n").append("  size\n").append("  totalElements\n").append("  page\n").append("  totalPages\n").append("  __typename\n").append("}");
        return query.toString();
    }

    private class NewOrder {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="sort_type")
            private String sortType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="orderStatus")
            private String orderStatus;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="dateRange_from")
            private String dateRange_from;
            @JsonProperty(value="dateRange_to")
            private String dateRange_to;
            @JsonProperty(value="detailedOrderStatus")
            private String detailedOrderStatus;

            private Variables() {
            }
        }
    }

    private class NewOrderClaim {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="claimStatus")
            private String claimStatus;
            @JsonProperty(value="dateRange_from")
            private String dateRange_from;
            @JsonProperty(value="dateRange_to")
            private String dateRange_to;
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="serviceType")
            private String serviceType;

            private Variables() {
            }
        }
    }
}

