/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.shop.data.naverstore.NaverStoreGenerateSignature;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

class NaverStoreOrderNewCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderNewCommand();
    JsonParser parser = new JsonParser();
    OkHttpClient client = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    ObjectMapper mapper = new ObjectMapper();
    private boolean isBasic = true;
    private boolean isParsing = true;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto dto = param.get(0);
        this.isParsing = dto.getVendorId().equals("N");
        boolean bl = this.isBasic = dto.getSpecificStatus() == null || dto.getSpecificStatus().equals("");
        if (!this.isParsing) {
            this.getNewOrderApi(dto, retList);
            return retList;
        }
        String start = YDMATimeUtil.getTime(dto.getStartDt());
        String end = YDMATimeUtil.getTime(dto.getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(dto.getStartDt());
        Date edate = formatter.parse(dto.getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            if (!YDMAProgressBar.get().isNullBar() && this.isBasic) {
                YDMAProgressBar.get().setValue("\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 - 1\ub144 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc218\uc815\ub41c \ub0a0\uc9dc\ub85c \uac80\uc0c9\ud569\ub2c8\ub2e4.", 0);
            }
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)(range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 90 == 0 ? (int)range / 90 : (int)range / 90 + 1;
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 89);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        int i = 0;
        while (i < num) {
            this.processOrders(dto, retList, start, end);
            cal1.add(5, 90);
            cal2.add(5, 90);
            start = String.valueOf(cal1.getTimeInMillis());
            end = String.valueOf(cal2.getTimeInMillis());
            ++i;
        }
        return retList;
    }

    private void processOrders(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        block29: {
            block28: {
                if (!this.isBasic) break block28;
                this.getNewOrder(dto, retList, start, end, "WAITING_DISPATCH", "ALL");
                break block29;
            }
            switch (dto.getSpecificStatus()) {
                case "\uc2e0\uaddc\uc8fc\ubb38": {
                    this.getNewOrder(dto, retList, start, end, "WAITING_DISPATCH", "NEW_ORDER");
                    break;
                }
                case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                    this.getNewOrder(dto, retList, start, end, "WAITING_DISPATCH", "PLACE_ORDER");
                    break;
                }
                case "\ubc30\uc1a1\uc911": {
                    this.getNewOrderDelivery(dto, retList, start, end, "DELIVERING", "403");
                    break;
                }
                case "\ubc30\uc1a1\uc644\ub8cc": {
                    this.getNewOrderDelivery(dto, retList, start, end, "DELIVERED", "410");
                    break;
                }
                case "\uad6c\ub9e4\ud655\uc815": {
                    this.getPurchaseDecisionOrder(dto, retList, start, end);
                    break;
                }
                case "\ucde8\uc18c": {
                    this.getCancelOrder(dto, retList, start, end);
                    break;
                }
                case "\ubc18\ud488": {
                    this.getReturnOrder(dto, retList, start, end);
                    break;
                }
                case "\uad50\ud658": {
                    this.getExchangeOrder(dto, retList, start, end);
                }
            }
        }
    }

    public void getNewOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end, String orderStatus, String detaliOrderStatus) throws Exception {
        try {
            Map<String, String> cookies = super.getCookies(dto);
            String merchantNo = super.getMerchantNo(cookies);
            String strParam = this.getNewOrderStringParam(merchantNo, start, end, orderStatus, detaliOrderStatus);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject object = this.parser.parse(body).getAsJsonObject();
            JsonObject data2 = object.get("data").getAsJsonObject();
            JsonObject deliveryList = data2.get("deliveryList").getAsJsonObject();
            JsonArray elements = deliveryList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                List<ShopOrderMstDto> param = this.setData(dto, elements, cookies);
                param.forEach(d -> d.setResult_code("1"));
                retList.addAll(param);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void getNewOrderDelivery(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end, String orderStatus, String status2) throws Exception {
        try {
            Map<String, String> cookies = super.getCookies(dto);
            String merchantNo = super.getMerchantNo(cookies);
            String strParam = this.getNewOrderStringParam(merchantNo, start, end, orderStatus, "ALL");
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject object = this.parser.parse(body).getAsJsonObject();
            JsonObject data2 = object.get("data").getAsJsonObject();
            JsonObject deliveryList = data2.get("deliveryList").getAsJsonObject();
            JsonArray elements = deliveryList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                List<ShopOrderMstDto> param = this.setDataDelivery(dto, elements, cookies, status2);
                param.forEach(d -> d.setResult_code("1"));
                retList.addAll(param);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String getNewOrderStringParam(String merchantNo, String start, String end, String orderStatus, String detaliOrderStatus) throws Exception {
        NewOrder newOrder = new NewOrder();
        newOrder.operationName = "smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery";
        newOrder.variables.merchantNo = merchantNo;
        newOrder.variables.serviceType = "MP";
        newOrder.variables.pagingPage = 1;
        newOrder.variables.pagingSize = 100;
        newOrder.variables.sortType = "RECENTLY_ORDER_YMDT";
        newOrder.variables.sortDirection = "DESC";
        newOrder.variables.rangeType = "PAY_COMPLETED";
        newOrder.variables.dateRange_from = start;
        newOrder.variables.dateRange_to = end;
        newOrder.variables.orderStatus = orderStatus;
        newOrder.variables.detailedOrderStatus = detaliOrderStatus;
        newOrder.query = this.getBasicGraphQLQuery();
        return this.mapper.writeValueAsString((Object)newOrder);
    }

    public List<ShopOrderMstDto> setData(ShopOrderMstDto ordDto, JsonArray order_arr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : order_arr) {
            JsonObject object = order.getAsJsonObject();
            String orderId = this.jsonElementNullStr(object.get("orderNo"));
            String productOrderId = this.jsonElementNullStr(object.get("productOrderNo"));
            if (this.isBasic && ShopOrderDao.get().isOrdered(orderId, productOrderId)) continue;
            ShopOrderMstDto dto = new ShopOrderMstDto();
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(orderId);
            dto.setOrder_status(this.getStatus(object.get("productOrderStatus").getAsString()));
            dto.setP_product_name(object.get("productName").getAsString());
            String orddt = YDMATimeUtil.getDate(object.get("orderDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setSale_cnt(object.get("orderQuantity").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_email("");
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setShopid(ordDto.getShopid());
            dto.setShop_userid(ordDto.getShop_userid());
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(productOrderId);
            dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
            dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
            dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
            String receiverAddr = this.jsonElementNullStr(object.get("receiverDisplayBaseAddress")).concat(" ").concat(this.jsonElementNullStr(object.get("receiverDisplayDetailAddress")));
            dto.setReceive_addr(receiverAddr);
            dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            String ordamt = object.get("productPayAmt").getAsString();
            dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
            dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(ordDto.getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setResult_code("1");
            String code = super.getCode(object.get("productNo").getAsString(), cookies);
            dto.setMall_product_id(code + "," + object.get("productNo").getAsString());
            list.add(dto);
        }
        return list;
    }

    private List<ShopOrderMstDto> setDataDelivery(ShopOrderMstDto ordDto, JsonArray order_arr, Map<String, String> cookies, String status2) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : order_arr) {
            JsonObject object = order.getAsJsonObject();
            ShopOrderMstDto dto = new ShopOrderMstDto();
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setOrder_status(status2);
            dto.setP_product_name(object.get("productName").getAsString());
            String orddt = YDMATimeUtil.getDate(object.get("orderDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setSale_cnt(object.get("orderQuantity").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_email("");
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setShopid(ordDto.getShopid());
            dto.setShop_userid(ordDto.getShop_userid());
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
            dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
            dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
            String receiverAddr = this.jsonElementNullStr(object.get("receiverDisplayBaseAddress")).concat(" ").concat(this.jsonElementNullStr(object.get("receiverDisplayDetailAddress")));
            dto.setReceive_addr(receiverAddr);
            dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            String ordamt = object.get("productPayAmt").getAsString();
            dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
            dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(ordDto.getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setResult_code("1");
            String code = super.getCode(object.get("productNo").getAsString(), cookies);
            dto.setMall_product_id(code + "," + object.get("productNo").getAsString());
            dto.setInvoice_no(this.jsonElementNullStr(object.get("deliveryInvoiceNo")));
            dto.setDelivery_id(this.jsonElementNullStr(object.get("deliveryCompanyCode")));
            list.add(dto);
        }
        return list;
    }

    public List<ShopOrderMstDto> getPurchaseDecisionOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        try {
            Map<String, String> cookies = super.getCookies(dto);
            String merchantNo = super.getMerchantNo(cookies);
            int page = 1;
            boolean isContinue = true;
            while (isContinue) {
                String json = this.getPurchaseDecisionOrderStringParam(merchantNo, start, end, page);
                String body = this.postSmartStoreGraphQL(cookies, json).body();
                JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
                JsonObject data2 = jsonobject.get("data").getAsJsonObject();
                JsonObject purchaseDecisionList = data2.get("purchaseDecisionList").getAsJsonObject();
                JsonObject pagination = purchaseDecisionList.get("pagination").getAsJsonObject();
                if (page < pagination.get("totalPages").getAsInt()) {
                    ++page;
                } else {
                    isContinue = false;
                }
                JsonArray elements = purchaseDecisionList.get("elements").getAsJsonArray();
                if (elements.size() <= 0) continue;
                List<ShopOrderMstDto> param1 = this.setDataByDelivery(dto, elements, cookies);
                param1.forEach(d -> d.setResult_code("1"));
                retList.addAll(param1);
            }
            return retList;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private String getPurchaseDecisionOrderStringParam(String merchantNo, String start, String end, int page) throws Exception {
        NewOrder deliveryComplted = new NewOrder();
        deliveryComplted.operationName = "SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision";
        deliveryComplted.variables.dateRange_from = start;
        deliveryComplted.variables.dateRange_to = end;
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = page;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.rangeType = "PAY_COMPLETED";
        deliveryComplted.variables.serviceType = "MP";
        deliveryComplted.variables.sortDirection = "DESC";
        deliveryComplted.variables.sortType = "PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT";
        deliveryComplted.query = super.getPurchaseDecisionGraphqlQuery();
        return this.mapper.writeValueAsString((Object)deliveryComplted);
    }

    private List<ShopOrderMstDto> setDataByDelivery(ShopOrderMstDto ordDto, JsonArray order_arr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : order_arr) {
            String ordamt;
            JsonObject object = order.getAsJsonObject();
            if (this.isBasic && ShopOrderDao.get().isOrdered(object.get("orderNo").getAsString())) continue;
            ShopOrderMstDto dto = new ShopOrderMstDto();
            if (object.get("orderStatus").getAsString().equals("PURCHASE_DECIDED")) {
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_id(object.get("orderNo").getAsString());
                String orderStatus = this.isBasic ? "410" : "901";
                dto.setOrder_status(orderStatus);
                dto.setP_product_name(object.get("productName").getAsString());
                String orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
                dto.setOrder_date(orddt);
                dto.setProduct_name(object.get("productName").getAsString());
                dto.setSale_cnt(object.get("orderQuantity").getAsString());
                dto.setUser_name(object.get("orderMemberName").getAsString());
                dto.setUser_email("");
                dto.setUser_id(object.get("orderMemberId").getAsString());
                dto.setReceive_name(object.get("receiverName").getAsString());
                dto.setShopid(ordDto.getShopid());
                dto.setShop_userid(ordDto.getShop_userid());
                dto.setMall_product_id(object.get("productNo").getAsString());
                dto.setReceive_zipcode("");
                dto.setReceive_addr("");
                dto.setUser_tel("");
                dto.setUser_cel("");
                dto.setReceive_tel("");
                dto.setReceive_cel("");
                dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
                dto.setDelv_msg("");
                dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
                ordamt = object.get("productPayAmt").getAsString();
                dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
                if (this.jsonElementNullStr(object.get("deliveryFeeAmt")).equals("")) {
                    dto.setPay_cost(ordamt);
                } else {
                    dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
                }
                dto.setTotal_cost(ordamt);
                dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
                dto.setCompno(ordDto.getCompno());
                dto.setReceive_email("");
                dto.setWon_cost("0");
                dto.setBox_ea("0");
                dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
                dto.setP_sku_id("");
                dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
                dto.setResult_code("1");
                dto.setAuthkey1(ordDto.getAuthkey1());
                dto.setInvoice_no(this.jsonElementNullStr(object.get("deliveryInvoiceNo")));
                dto.setDelivery_id("");
                dto.setDeliveryName(this.jsonElementNullStr(object.get("deliveryCompanyName")));
                dtolist.add(dto);
                continue;
            }
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setOrder_status(this.getStatus(object.get("orderStatus").getAsString()));
            dto.setP_product_name(object.get("productName").getAsString());
            String orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setSale_cnt(object.get("orderQuantity").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_email("");
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setShopid(ordDto.getShopid());
            dto.setShop_userid(ordDto.getShop_userid());
            String code = super.getCode(object.get("productNo").getAsString(), cookies);
            dto.setMall_product_id(code + "," + object.get("productNo").getAsString());
            dto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
            dto.setReceive_addr(this.jsonElementNullStr(object.get("receiverAddress")));
            dto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
            dto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
            dto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
            dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            if (object.has("productOrderMemo")) {
                dto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
            }
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            ordamt = object.get("productPayAmt").getAsString();
            if (object.has("settlementExpectAmt")) {
                dto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
            }
            if (this.jsonElementNullStr(object.get("deliveryFeeAmt")).equals("")) {
                dto.setPay_cost(ordamt);
            } else {
                dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
            }
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(ordDto.getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setResult_code("1");
            dto.setAuthkey1(ordDto.getAuthkey1());
            dto.setInvoice_no(this.jsonElementNullStr(object.get("invoiceNo")));
            dto.setDelivery_id(this.jsonElementNullStr(object.get("deliveryCompanyCode")));
            dtolist.add(dto);
        }
        return dtolist;
    }

    private void getCancelOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        Map<String, String> cookies = super.getCookies(dto);
        String merchantNo = super.getMerchantNo(cookies);
        int k = 0;
        while (k < 2) {
            String status2 = this.getStatusCancel(k);
            String strParam = this.getCancelOrderStringParam(merchantNo, status2, start, end);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
            JsonObject data2 = jsonobject.get("data").getAsJsonObject();
            JsonObject cancelList = data2.get("cancelListMp").getAsJsonObject();
            JsonArray elements = cancelList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                this.setDataByClaim(dto, elements, cookies, retList);
            }
            ++k;
        }
    }

    private void setDataByClaim(ShopOrderMstDto ordDto, JsonArray jsonArray, Map<String, String> cookies, List<ShopOrderMstDto> retList) throws Exception {
        for (JsonElement ele : jsonArray) {
            ShopOrderMstDto dto = new ShopOrderMstDto();
            JsonObject object = ele.getAsJsonObject();
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(object.get("orderNo").getAsString());
            dto.setOrder_status(this.getClaimStatus(object.get("claimStatus").getAsString()));
            dto.setP_product_name(object.get("productName").getAsString());
            String orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
            dto.setOrder_date(orddt);
            dto.setProduct_name(object.get("productName").getAsString());
            dto.setSale_cnt(object.get("orderQuantity").getAsString());
            dto.setUser_name(object.get("orderMemberName").getAsString());
            dto.setUser_email("");
            dto.setUser_id(object.get("orderMemberId").getAsString());
            dto.setReceive_name(object.get("receiverName").getAsString());
            dto.setShopid(ordDto.getShopid());
            dto.setShop_userid(ordDto.getShop_userid());
            dto.setMall_product_id(object.get("productNo").getAsString());
            dto.setReceive_zipcode("");
            dto.setReceive_addr("");
            dto.setUser_tel("");
            dto.setUser_cel("");
            dto.setReceive_tel("");
            dto.setReceive_cel("");
            dto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
            dto.setDelv_msg("");
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
            dto.setMall_won_cost("0");
            dto.setTotal_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setSale_cost(object.get("productUnitPrice").getAsString());
            dto.setCompno(ordDto.getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
            dto.setMall_exp_cd(object.get("productOrderNo").getAsString());
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
            dto.setResult_code("1");
            dto.setAuthkey1(ordDto.getAuthkey1());
            if (object.has("deliveryInvoiceNo")) {
                dto.setInvoice_no(this.jsonElementNullStr(object.get("deliveryInvoiceNo")));
            } else {
                dto.setInvoice_no("");
            }
            dto.setDelivery_id("");
            if (object.has("deliveryCompanyName")) {
                dto.setDeliveryName(this.jsonElementNullStr(object.get("deliveryCompanyName")));
            } else {
                dto.setDeliveryName("");
            }
            retList.add(dto);
        }
    }

    private String getClaimStatus(String status2) {
        String value = "";
        switch (status2) {
            case "CANCEL_REJECT": 
            case "CANCELING": 
            case "CANCEL_REQUEST": {
                value = "C01";
                break;
            }
            case "ADMIN_CANCEL_DONE": 
            case "CANCEL_DONE": {
                value = "C02";
                break;
            }
            case "RETURN_REJECT": 
            case "RETURN_REQUEST": {
                value = "R01";
                break;
            }
            case "RETURN_DONE": {
                value = "R02";
                break;
            }
            case "EXCHANGE_REQUEST": 
            case "EXCHANGE_REJECT": {
                value = "E01";
                break;
            }
            case "EXCHANGE_REDELIVERING": 
            case "EXCHANGE_DONE": {
                value = "E02";
            }
        }
        return value;
    }

    private String getCancelOrderStringParam(String merchantNo, String status2, String start, String end) throws Exception {
        NewOrderClaim cancelOrder = new NewOrderClaim();
        cancelOrder.operationName = "findClaimCancelsByDetailConditionsMp_ForClaimCancel";
        cancelOrder.variables.claimStatus = status2;
        cancelOrder.variables.dateRange_from = start;
        cancelOrder.variables.dateRange_to = end;
        cancelOrder.variables.merchantNo = merchantNo;
        cancelOrder.variables.serviceType = "MP";
        cancelOrder.variables.pagingPage = 1;
        cancelOrder.variables.pagingSize = 100;
        cancelOrder.variables.rangeType = "PAY_COMPLETED";
        cancelOrder.query = "query findClaimCancelsByDetailConditionsMp_ForClaimCancel($claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $merchantNo: String!, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  cancelListMp: findClaimCancelsByDetailConditionsMp_ForClaimCancel(\n    claimStatus: $claimStatus\n    dateRange_from: $dateRange_from\n    dateRange_to: $dateRange_to\n    detailSearch_keyword: $detailSearch_keyword\n    detailSearch_type: $detailSearch_type\n    merchantNo: $merchantNo\n    paging_page: $paging_page\n    paging_size: $paging_size\n    rangeType: $rangeType\n    serviceType: $serviceType\n    sort_direction: $sort_direction\n    sort_type: $sort_type\n  ) {\n    elements {\n      ...cancelElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment cancelElementField on CancelClaimSeller {\n  deliveryFeeAmt\n  deliveryFeeClass\n  biztalkAccountId\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  productUnitPrice\n  cancelDateTime\n  orderQuantity\n  productName\n  claimRequestOperatorType\n  clamRequestDateTime\n  orderMemberName\n  payDateTime\n  productOrderNo\n  productOptionContents\n  deliveryFeeRatingClass\n  orderMemberId\n  orderMemberNo\n  productOptionAmt\n  discountAmtChangedInfo\n  productNo\n  refundExpectDateTime\n  totalDiscountAmt\n  claimRequestAdmissionOperator\n  orderNo\n  productClass\n  receiverName\n  deliveryFeeChangedInfo\n  claimRequestReason\n  refundOperator\n  saleChannelType\n  receiverAddress\n  deliveryFeeDiscountAmt\n  receiverZipCode\n  sellerProductManagementCode\n  syncDateTime\n  productOrderStatus\n  sellerInternalCode2\n  claimRequestAdmissionDateTime\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  claimStatus\n  orderMemberTelNo\n  fulfillmentCompanyName\n  deliveryAttributeText\n  initTotalDiscountAmt\n  initProductPayAmt\n  quantityClaimYn\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}";
        return this.mapper.writeValueAsString((Object)cancelOrder);
    }

    private String getStatusCancel(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "CANCEL_REQUEST";
                break;
            }
            case 1: {
                value = "CANCEL_DONE";
            }
        }
        return value;
    }

    private void getReturnOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        Map<String, String> cookies = super.getCookies(dto);
        String merchantNo = super.getMerchantNo(cookies);
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatusReturn(k);
            String strParam = this.getReturnOrderStringParam(merchantNo, status2, start, end);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
            JsonObject data2 = jsonobject.get("data").getAsJsonObject();
            JsonObject returnList = data2.get("returnList").getAsJsonObject();
            JsonArray elements = returnList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                this.setDataByClaim(dto, elements, cookies, retList);
            }
            ++k;
        }
    }

    private String getReturnOrderStringParam(String merchantNo, String status2, String start, String end) throws Exception {
        NewOrderClaim returnOrder = new NewOrderClaim();
        returnOrder.operationName = "findClaimReturnsByDetailConditionsMp_ForClaimReturn";
        returnOrder.variables.claimStatus = status2;
        returnOrder.variables.dateRange_from = start;
        returnOrder.variables.dateRange_to = end;
        returnOrder.variables.merchantNo = merchantNo;
        returnOrder.variables.serviceType = "MP";
        returnOrder.variables.pagingPage = 1;
        returnOrder.variables.pagingSize = 100;
        returnOrder.variables.rangeType = "PAY_COMPLETED";
        returnOrder.query = "query findClaimReturnsByDetailConditionsMp_ForClaimReturn($claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $merchantNo: String!, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $serviceType: String!, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  returnList: findClaimReturnsByDetailConditionsMp_ForClaimReturn(\n    claimStatus: $claimStatus\n    dateRange_from: $dateRange_from\n    dateRange_to: $dateRange_to\n    detailSearch_keyword: $detailSearch_keyword\n    detailSearch_type: $detailSearch_type\n    merchantNo: $merchantNo\n    paging_page: $paging_page\n    paging_size: $paging_size\n    rangeType: $rangeType\n    serviceType: $serviceType\n    sort_direction: $sort_direction\n    sort_type: $sort_type\n  ) {\n    elements {\n      ...returnElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment returnElementField on ClaimReturnSeller {\n  returnCareTarget\n  deliveryFeeClass\n  holdbackStatus\n  deliveryInvoiceNo\n  claimExtraFeePayAmt\n  orderQuantity\n  productName\n  payDateTime\n  deliveryFeeRatingClass\n  orderMemberId\n  discountAmtChangedInfo\n  refundExpectDateTime\n  claimCollectStatusExposureText\n  totalDiscountAmt\n  orderNo\n  productClass\n  claimCollectDateTime\n  deliveryFeeChangedInfo\n  claimRequestDateTime\n  claimRequestReason\n  backDeliveryInvoiceNo\n  refundOperator\n  saleChannelType\n  deliveryCompanyName\n  sellerProductManagementCode\n  holdbackReleaseDateTime\n  claimStatus\n  holdbackConfigDateTime\n  orderMemberTelNo\n  orderMemberNo\n  deliveryFeeAmt\n  claimNo\n  backDeliveryMethodExposureText\n  deliveryMethod\n  biztalkAccountId\n  branchDeliveryStartDateTime\n  branchDeliveryEndDateTime\n  branchId\n  merchantChannelNo\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  claimCollectStatus\n  productUnitPrice\n  claimRequestOperatorType\n  orderMemberName\n  productOrderNo\n  productOptionContents\n  claimCollectAddress\n  claimDeliveryFeeAmt\n  productOptionAmt\n  productNo\n  returnReceiveAddress\n  backDeliveryCompanyName\n  receiverName\n  deliveryNo\n  refundDateTime\n  deliveryFeeDiscountAmt\n  claimRejectDetail\n  backDeliveryMethod\n  syncDateTime\n  productOrderStatus\n  backDeliveryNo\n  sellerInternalCode2\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  claimDeliveryFeePayMethod\n  claimDeliveryFeePayMethodText\n  claimExtraFeePayMethod\n  fulfillmentCompanyName\n  collectRemoteAreaCostChargeAmt\n  claimRequestReasonCollectFail\n  deliveryAttributeText\n  initTotalDiscountAmt\n  initProductPayAmt\n  quantityClaimYn\n  membershipsArrivalGuaranteeClaimSupportTarget\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}";
        return this.mapper.writeValueAsString((Object)returnOrder);
    }

    private String getStatusReturn(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "RETURN_REQUEST";
                break;
            }
            case 1: {
                value = "COLLECTING";
                break;
            }
            case 2: {
                value = "COLLECT_DONE";
                break;
            }
            case 3: {
                value = "RETURN_DONE";
            }
        }
        return value;
    }

    private void getExchangeOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        Map<String, String> cookies = super.getCookies(dto);
        String merchantNo = super.getMerchantNo(cookies);
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatusExchange(k);
            String strParam = this.getExchangeOrderStringParam(merchantNo, status2, start, end);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
            JsonObject data2 = jsonobject.get("data").getAsJsonObject();
            JsonObject exchangeList = data2.get("exchangeList").getAsJsonObject();
            JsonArray elements = exchangeList.get("elements").getAsJsonArray();
            if (elements.size() > 0) {
                this.setDataByClaim(dto, elements, cookies, retList);
            }
            ++k;
        }
    }

    private String getExchangeOrderStringParam(String merchantNo, String status2, String start, String end) throws Exception {
        NewOrderClaim exchangeOrder = new NewOrderClaim();
        exchangeOrder.operationName = "SmartStoreFindClaimExchangesByDetailConditions_ForClaimExchange";
        exchangeOrder.variables.claimStatus = status2;
        exchangeOrder.variables.dateRange_from = start;
        exchangeOrder.variables.dateRange_to = end;
        exchangeOrder.variables.merchantNo = merchantNo;
        exchangeOrder.variables.serviceType = "MP";
        exchangeOrder.variables.pagingPage = 1;
        exchangeOrder.variables.pagingSize = 100;
        exchangeOrder.variables.rangeType = "PAY_COMPLETED";
        exchangeOrder.query = "query SmartStoreFindClaimExchangesByDetailConditions_ForClaimExchange($claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $memberNo: String, $merchantNo: String!, $serviceType: String!, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $sort_direction: SortDirectionType, $sort_type: SortType) {\n  exchangeList: SmartStoreFindClaimExchangesByDetailConditions_ForClaimExchange(\n    claimStatus: $claimStatus\n    dateRange_from: $dateRange_from\n    dateRange_to: $dateRange_to\n    detailSearch_keyword: $detailSearch_keyword\n    detailSearch_type: $detailSearch_type\n    memberNo: $memberNo\n    serviceType: $serviceType\n    merchantNo: $merchantNo\n    paging_page: $paging_page\n    paging_size: $paging_size\n    rangeType: $rangeType\n    sort_direction: $sort_direction\n    sort_type: $sort_type\n  ) {\n    elements {\n      ...exchangeElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment exchangeElementField on ClaimExchangeSeller {\n  lastClaimNo\n  beforeClaimNo\n  reDeliveryAddress\n  returnCareTarget\n  branchId\n  merchantChannelNo\n  deliveryFeeClass\n  redeliveryOperationDateTime\n  holdbackStatus\n  deliveryInvoiceNo\n  claimExtraFeePayAmt\n  reDeliveryNo\n  orderQuantity\n  productName\n  claimType\n  payDateTime\n  deliveryFeeRatingClass\n  purchaseDecisionExtensionReasonDetailContent\n  orderMemberId\n  reDeliveryStatus\n  claimCollectStatusExposureText\n  totalDiscountAmt\n  claimRejectDetailContent\n  orderNo\n  productClass\n  claimCollectDateTime\n  reDeliveryInvoiceNo\n  purchaseDecisionExtensionReason\n  claimRequestReason\n  backDeliveryInvoiceNo\n  exchangeRequestDateTime\n  reDeliveryCompanyName\n  deliveryCompanyName\n  sellerProductManagementCode\n  holdbackReleaseDateTime\n  claimStatus\n  holdbackConfigDateTime\n  orderMemberTelNo\n  orderMemberNo\n  purchaseDecisionExtensionDateTime\n  deliveryFeeAmt\n  claimNo\n  backDeliveryMethodExposureText\n  deliveryMethod\n  biztalkAccountId\n  giftName\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  claimCollectStatus\n  productUnitPrice\n  claimRequestOperatorType\n  orderMemberName\n  productOrderNo\n  productOptionContents\n  claimCollectAddress\n  claimDeliveryFeeAmt\n  productOptionAmt\n  productNo\n  purchaseDecisionExpectDateTime\n  returnReceiveAddress\n  backDeliveryCompanyName\n  receiverName\n  deliveryNo\n  deliveryFeeDiscountAmt\n  reDeliveryMethod\n  syncDateTime\n  productOrderStatus\n  backDeliveryNo\n  sellerInternalCode2\n  sellerInternalCode1\n  deliveryBundleGroupSeq\n  productUrl\n  claimDeliveryFeePayMethod\n  claimDeliveryFeePayMethodText\n  claimExtraFeePayMethod\n  fulfillmentCompanyName\n  collectRemoteAreaCostChargeAmt\n  claimRequestReasonCollectFail\n  deliveryAttributeText\n  purchaseDecisionExtensionStatusType\n  initTotalDiscountAmt\n  initProductPayAmt\n  quantityClaimYn\n  membershipsArrivalGuaranteeClaimSupportTarget\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}";
        return this.mapper.writeValueAsString((Object)exchangeOrder);
    }

    private String getStatusExchange(int i) {
        String value = "";
        switch (i) {
            case 0: {
                value = "EXCHANGE_REQUEST";
                break;
            }
            case 1: {
                value = "EXCHANGE_COLLECTING";
                break;
            }
            case 2: {
                value = "EXCHANGE_COLLECT_DONE";
                break;
            }
            case 3: {
                value = "EXCHANGE_DONE";
            }
        }
        return value;
    }

    private List<ShopOrderMstDto> getNewOrderApi(ShopOrderMstDto dto, List<ShopOrderMstDto> retList) throws Exception {
        NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
        String startdt = dto.getStartDt().substring(0, 8);
        String enddt = dto.getEndDt().substring(0, 8);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date sdate = formatter.parse(startdt);
        Date edate = formatter.parse(enddt);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(sdate);
        String clientId = dto.getEDITAUTHKEY1();
        String clientSecret = dto.getEDITAPIKEY();
        Long timestamp = System.currentTimeMillis();
        String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
        String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
        int i = 0;
        while (i < (int)range) {
            this.getOrder(accessToken, sdate, dto, retList);
            cal1.add(5, 1);
            startdt = formatter.format(cal1.getTime());
            sdate = formatter.parse(startdt);
            ++i;
        }
        return retList;
    }

    private void getOrder(String accessToken, Date date, ShopOrderMstDto dto, List<ShopOrderMstDto> retList) {
        block25: {
            ArrayList<String> orderId = new ArrayList<String>();
            String datePatternNaverApi = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            SimpleDateFormat format = new SimpleDateFormat(datePatternNaverApi);
            String[] status2 = new String[]{"PAYED", "CLAIM_REJECTED"};
            String formatUrl = "https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=%sZ&lastChangedType=%s";
            try {
                Throwable throwable;
                int j = 0;
                while (j < 2) {
                    String url = String.format(formatUrl, format.format(date), status2[j]);
                    Request request2 = new Request.Builder().url(url).get().addHeader("Authorization", accessToken).build();
                    Thread.sleep(450L);
                    throwable = null;
                    Object var14_19 = null;
                    try (Response response = this.client.newCall(request2).execute();){
                        JsonObject object;
                        if (response.isSuccessful() && (object = (JsonObject)this.parser.parse(response.body().string())).has("data")) {
                            JsonArray datas = object.get("data").getAsJsonObject().get("lastChangeStatuses").getAsJsonArray();
                            for (JsonElement data2 : datas) {
                                orderId.add(data2.getAsJsonObject().get("productOrderId").getAsString());
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    ++j;
                }
                if (orderId.size() <= 0) break block25;
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
                Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(requestBody).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
                Throwable throwable3 = null;
                throwable = null;
                try (Response response = this.client.newCall(request2).execute();){
                    JsonArray jsonArray;
                    JsonObject object;
                    if (response.isSuccessful() && (object = this.parser.parse(response.body().string()).getAsJsonObject()).has("data") && (jsonArray = object.get("data").getAsJsonArray()).size() > 0) {
                        List<ShopOrderMstDto> param = this.setDataByApi(dto, jsonArray, accessToken);
                        param.forEach(d -> d.setResult_code("1"));
                        retList.addAll(param);
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print(e.getMessage());
            }
        }
    }

    public List<ShopOrderMstDto> setDataByApi(ShopOrderMstDto ordDto, JsonArray order_arr, String accessToken) throws Exception {
        ArrayList<ShopOrderMstDto> list = new ArrayList<ShopOrderMstDto>();
        for (JsonElement ele : order_arr) {
            Object ordererTel;
            JsonObject object = ele.getAsJsonObject();
            JsonObject productOrder = object.getAsJsonObject("productOrder");
            JsonObject order = object.getAsJsonObject("order");
            JsonObject shippingAddress = productOrder.getAsJsonObject("shippingAddress");
            String orderID = this.jsonElementNullStr(order.get("orderId"));
            String productOrderId = this.jsonElementNullStr(productOrder.get("productOrderId"));
            if (this.isBasic && ShopOrderDao.get().isOrdered(orderID, productOrderId)) continue;
            ShopOrderMstDto dto = new ShopOrderMstDto();
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setOrder_id(orderID);
            dto.setOrder_status(this.getStatus(productOrder.get("productOrderStatus").getAsString()));
            dto.setP_product_name(productOrder.get("productName").getAsString());
            String orddt = order.get("orderDate").getAsString().substring(0, 19).replace("T", " ");
            dto.setOrder_date(orddt);
            dto.setProduct_name(productOrder.get("productName").getAsString());
            dto.setSale_cnt(productOrder.get("quantity").getAsString());
            dto.setUser_name(order.get("ordererName").getAsString());
            dto.setUser_email("");
            dto.setReceive_name(shippingAddress.get("name").getAsString());
            dto.setShopid(ordDto.getShopid());
            dto.setShop_userid(ordDto.getShop_userid());
            dto.setUser_id(order.get("ordererId").getAsString());
            dto.setP_sku_value(this.jsonElementNullStr(productOrder.get("productOption")));
            dto.setSku_value(this.jsonElementNullStr(productOrder.get("productOption")));
            dto.setMall_exp_cd(productOrderId);
            if (order.get("ordererTel") == null) {
                ordererTel = "";
            } else {
                String str = order.get("ordererTel").getAsString();
                String first = str.substring(0, str.length() - 8);
                String middle = str.substring(str.length() - 8, str.length() - 4);
                String last = str.substring(str.length() - 4);
                ordererTel = first + "-" + middle + "-" + last;
            }
            dto.setUser_tel((String)ordererTel);
            dto.setUser_cel((String)ordererTel);
            dto.setReceive_tel(this.jsonElementNullStr(shippingAddress.get("tel2")));
            dto.setReceive_cel(this.jsonElementNullStr(shippingAddress.get("tel1")));
            dto.setReceive_zipcode(this.jsonElementNullStr(shippingAddress.get("zipCode")));
            String receiverAddr = this.jsonElementNullStr(shippingAddress.get("baseAddress")).concat(" ").concat(this.jsonElementNullStr(shippingAddress.get("detailedAddress")));
            dto.setReceive_addr(receiverAddr);
            dto.setDelv_cost(this.jsonElementNullStr(productOrder.get("deliveryFeeAmount")));
            dto.setDelv_msg(this.jsonElementNullStr(productOrder.get("shippingMemo")));
            dto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(productOrder.get("shippingFeeType"))));
            String ordamt = productOrder.get("totalPaymentAmount").getAsString();
            dto.setMall_won_cost(this.jsonElementNullStr(productOrder.get("expectedSettlementAmount")));
            dto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(productOrder.get("deliveryFeeAmount").getAsString())));
            dto.setTotal_cost(ordamt);
            dto.setSale_cost(Integer.toString(Integer.parseInt(productOrder.get("unitPrice").getAsString()) * Integer.parseInt(dto.getSale_cnt())));
            dto.setCompno(ordDto.getCompno());
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setP_sku_id("");
            dto.setCompayny_goods_cd(this.jsonElementNullStr(productOrder.get("sellerProductCode")));
            dto.setResult_code("1");
            dto.setMall_product_id(productOrder.get("originalProductId").getAsString() + "," + productOrder.get("productId").getAsString());
            list.add(dto);
        }
        return list;
    }

    @Override
    public String jsonElementNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    private String getStatus(String string) {
        String value = "";
        switch (string) {
            case "PLACE_ORDER": 
            case "NEW_ORDER": 
            case "PAYED": 
            case "PLACE_ORDER_RELEASE": {
                value = "100";
                break;
            }
            case "DELIVERING": {
                value = "403";
                break;
            }
            case "DELIVERED": {
                value = "410";
            }
        }
        return value;
    }

    private String getDelivery(String jsonElementNullStr) {
        String value = "";
        switch (jsonElementNullStr) {
            case "PREPAYED": 
            case "\uc120\uacb0\uc81c": {
                value = "\uc120\uacb0\uc81c";
                break;
            }
            case "\ubb34\ub8cc": 
            case "FREE": {
                value = "\ubb34\ub8cc";
            }
        }
        return value;
    }

    private String getBasicGraphQLQuery() {
        StringBuilder query = new StringBuilder();
        query.append("query smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery(").append("$dateRange_from: String, ").append("$dateRange_to: String, ").append("$delayDispatchGuideTreatStateType: DelayDispatchGuideTreatStateType, ").append("$deliveryDirectionClass: DeliveryDirectionClassType, ").append("$deliveryMethodType: DeliveryMethodType, ").append("$deliveryNo: String, ").append("$detailSearch_keyword: String, ").append("$detailSearch_type: DetailSearchType, ").append("$detailedOrderStatus: DetailedSearchOrderStatusType, ").append("$deviceClassType: DeviceClassType, ").append("$merchantNo: String!, ").append("$orderStatus: SearchOrderStatusType, ").append("$paging_page: Int, ").append("$paging_size: Int, ").append("$rangeType: RangeType, ").append("$serviceType: String!, ").append("$sort_direction: SortDirectionType, ").append("$sort_type: SortType").append(") {\n").append("  deliveryList: smartstoreFindDeliveriesByDetailConditions_ForSaleDelivery(\n").append("    dateRange_from: $dateRange_from\n").append("    dateRange_to: $dateRange_to\n").append("    delayDispatchGuideTreatStateType: $delayDispatchGuideTreatStateType\n").append("    deliveryDirectionClass: $deliveryDirectionClass\n").append("    deliveryMethodType: $deliveryMethodType\n").append("    deliveryNo: $deliveryNo\n").append("    detailSearch_keyword: $detailSearch_keyword\n").append("    detailSearch_type: $detailSearch_type\n").append("    detailedOrderStatus: $detailedOrderStatus\n").append("    deviceClassType: $deviceClassType\n").append("    merchantNo: $merchantNo\n").append("    orderStatus: $orderStatus\n").append("    paging_page: $paging_page\n").append("    paging_size: $paging_size\n").append("    rangeType: $rangeType\n").append("    serviceType: $serviceType\n").append("    sort_direction: $sort_direction\n").append("    sort_type: $sort_type\n").append("  ) {\n").append("    elements {\n").append("      ...deliveryElementField\n").append("      __typename\n").append("    }\n").append("    pagination {\n").append("      ...paginationField\n").append("      __typename\n").append("    }\n").append("    __typename\n").append("  }\n").append("}\n\n").append("fragment deliveryElementField on SaleDeliverySeller {\n").append("  returnCareTarget\n").append("  branchId\n").append("  merchantChannelNo\n").append("  deliveryFeeClass\n").append("  deliveryInvoiceNo\n").append("  orderQuantity\n").append("  productName\n").append("  payDateTime\n").append("  deliveryDateTime\n").append("  deliveryFeeRatingClass\n").append("  productOrderMemo\n").append("  orderMemberId\n").append("  remoteAreaCostChargeAmt\n").append("  payLocationType\n").append("  totalDiscountAmt\n").append("  orderNo\n").append("  payMeansClass\n").append("  productClass\n").append("  oneYearOrderAmt\n").append("  saleChannelType\n").append("  oneYearOrderCount\n").append("  deliveryCompanyName\n").append("  sellerProductManagementCode\n").append("  grade\n").append("  orderMemberTelNo\n").append("  deliveryFeeAmt\n").append("  claimNo\n").append("  deliveryMethod\n").append("  deliveryMethodPay\n").append("  biztalkAccountId\n").append("  giftName\n").append("  receiverTelNo2\n").append("  productPayAmt\n").append("  receiverTelNo1\n").append("  sixMonthOrderAmt\n").append("  orderStatus\n").append("  productUnitPrice\n").append("  waybillPrintDateTime\n").append("  threeMonthOrderCount\n").append("  orderMemberName\n").append("  productOrderNo\n").append("  deliveryCompanyCode\n").append("  productOptionContents\n").append("  dispatchDueDateTime\n").append("  knowledgeShoppingCommissionAmt\n").append("  productOptionAmt\n").append("  productNo\n").append("  individualCustomUniqueCode\n").append("  orderDateTime\n").append("  placingOrderDateTime\n").append("  inflowPath\n").append("  receiverName\n").append("  settlementExpectAmt\n").append("  deliveryNo\n").append("  threeMonthOrderAmt\n").append("  sellerDiscountAmt\n").append("  deliveryFeeDiscountAmt\n").append("  dispatchDateTime\n").append("  sixMonthOrderCount\n").append("  receiverZipCode\n").append("  payCommissionAmt\n").append("  takingGoodsPlaceAddress\n").append("  syncDateTime\n").append("  productOrderStatus\n").append("  sellerInternalCode2\n").append("  sellerOptionManagementCode\n").append("  sellerInternalCode1\n").append("  deliveryBundleGroupSeq\n").append("  productUrl\n").append("  subscriptionRound\n").append("  subscriptionPeriodCount\n").append("  fulfillmentCompanyName\n").append("  receiverIntegratedAddress\n").append("  receiverDisplayBaseAddress\n").append("  receiverDisplayDetailAddress\n").append("  deliveryAttributeText\n").append("  hopeDelivery\n").append("  initTotalDiscountAmt\n").append("  initProductPayAmt\n").append("  quantityClaimYn\n").append("  quantityClaimNo\n").append("  subscriptionHopeDelivery\n").append("  membershipsArrivalGuaranteeClaimSupportTarget\n").append("  __typename\n").append("}\n\n").append("fragment paginationField on Pagination {\n").append("  size\n").append("  totalElements\n").append("  page\n").append("  totalPages\n").append("  __typename\n").append("}");
        return query.toString();
    }

    private class NewOrder {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="sort_type")
            private String sortType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="orderStatus")
            private String orderStatus;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="dateRange_from")
            private String dateRange_from;
            @JsonProperty(value="dateRange_to")
            private String dateRange_to;
            @JsonProperty(value="detailedOrderStatus")
            private String detailedOrderStatus;

            private Variables() {
            }
        }
    }

    private class NewOrderClaim {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="claimStatus")
            private String claimStatus;
            @JsonProperty(value="dateRange_from")
            private String dateRange_from;
            @JsonProperty(value="dateRange_to")
            private String dateRange_to;
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="serviceType")
            private String serviceType;

            private Variables() {
            }
        }
    }
}

