/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TossShoppingLiteOrderCommand
extends IShopOrderTossShoppingCommand {
    private static IShopOrderCommand instance = new TossShoppingLiteOrderCommand();
    OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    JsonParser parser = new JsonParser();
    IShopCommonLogin is = new IShopCommonLogin(){};

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingLiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> retList = new ArrayList<ShopOrderMstNewDto>();
        String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdt);
        Date edate = formatter.parse(enddt);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        int num = (int)range % 30 == 0 ? (int)range / 30 : (int)range / 30 + 1;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            enddt = formatter.format(cal2.getTime());
        }
        int i = 0;
        while (i < num) {
            this.getNewOrder(dto, retList, startdt, enddt);
            cal1.add(5, 30);
            startdt = formatter.format(cal1.getTime());
            if (i == num - 2) {
                enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
            } else {
                cal2.add(5, 30);
                enddt = formatter.format(cal2.getTime());
            }
            ++i;
        }
        return retList;
    }

    private void getNewOrder(ShopOrderMstNewDto dto, List<ShopOrderMstNewDto> retList, String start, String end) throws Exception {
        HashMap<String, String> cookies = new HashMap();
        try {
            cookies = this.is.getTossCookies(dto.getShop_userid(), dto.getShopPw());
            String[] orderStatus = this.resolveOrderStatus(dto);
            if (orderStatus == null) {
                List<ShopOrderMstNewDto> retNew = this.getClaimOrder(dto, start, end, cookies, dto.getSpecificStatus());
                retList.addAll(retNew);
                return;
            }
            String strParam = "";
            JsonObject body = new JsonObject();
            JsonObject successObject = new JsonObject();
            JsonArray results = new JsonArray();
            String url = "https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/order/histories/paging";
            int i = 0;
            while (i < orderStatus.length) {
                boolean isContinue = true;
                int page = 1;
                while (isContinue) {
                    strParam = this.getNewOrderStringParam(dto.getApikey(), start, end, orderStatus[i], page++);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)strParam);
                    Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody).addHeader("Content-Type", "application/json");
                    for (Map.Entry entry : cookies.entrySet()) {
                        requestBuilder.addHeader("Cookie", (String)entry.getKey() + "=" + (String)entry.getValue());
                    }
                    Request request2 = requestBuilder.build();
                    Object object = null;
                    Object var19_25 = null;
                    try (Response response = this.client.newCall(request2).execute();){
                        if (!response.isSuccessful()) continue;
                        String responseBody = response.body().string();
                        body = this.parser.parse(responseBody).getAsJsonObject();
                        successObject = body.getAsJsonObject("success");
                        JsonObject paging = successObject.getAsJsonObject("paging");
                        isContinue = paging.get("hasNext").getAsBoolean();
                        results = successObject.getAsJsonArray("results");
                        if (results.size() <= 0) continue;
                        List<ShopOrderMstNewDto> param = this.setData(dto, results, cookies);
                        param.forEach(d -> d.setResult_code("1"));
                        retList.addAll(param);
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                ++i;
            }
            if (dto.getSpecificStatus().equals("\ud1b5\ud569")) {
                List<ShopOrderMstNewDto> retCancel = this.getClaimOrder(dto, start, end, cookies, "\ucde8\uc18c");
                retList.addAll(retCancel);
                List<ShopOrderMstNewDto> retReturn = this.getClaimOrder(dto, start, end, cookies, "\ubc18\ud488");
                retList.addAll(retReturn);
                List<ShopOrderMstNewDto> retExchange = this.getClaimOrder(dto, start, end, cookies, "\uad50\ud658");
                retList.addAll(retExchange);
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<ShopOrderMstNewDto> getClaimOrder(ShopOrderMstNewDto dto, String start, String end, Map<String, String> cookies, String status2) throws Exception {
        ArrayList<ShopOrderMstNewDto> retList = new ArrayList<ShopOrderMstNewDto>();
        String type = "";
        switch (status2) {
            case "\ucde8\uc18c": {
                type = "CANCEL";
                break;
            }
            case "\ubc18\ud488": {
                type = "RETURN";
                break;
            }
            case "\uad50\ud658": {
                type = "EXCHANGE";
            }
        }
        boolean isContinue = true;
        while (isContinue) {
            int page = 1;
            String strParam = this.getOrderClaimSyncStringParam(type, start, end, page++);
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)strParam);
            Request.Builder requestBuilder = new Request.Builder().url("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/orders/claims").post(requestBody).addHeader("Content-Type", "application/json").addHeader("X-Merchant-id", dto.getApikey());
            for (Map.Entry<String, String> entry : cookies.entrySet()) {
                requestBuilder.addHeader("Cookie", entry.getKey() + "=" + entry.getValue());
            }
            Throwable throwable = null;
            Iterator<Map.Entry<String, String>> iterator = null;
            try (Response response = this.client.newCall(requestBuilder.build()).execute();){
                if (!response.isSuccessful()) continue;
                String responseBody = response.body().string();
                JsonObject body = this.parser.parse(responseBody).getAsJsonObject();
                JsonObject successObject = body.getAsJsonObject("success");
                JsonObject paging = successObject.getAsJsonObject("paging");
                isContinue = paging.get("hasNext").getAsBoolean();
                JsonArray claims = successObject.getAsJsonArray("claims");
                if (claims.size() <= 0) continue;
                List<ShopOrderMstNewDto> param = this.setDataClaim(dto, claims, cookies, status2);
                param.forEach(d -> d.setResult_code("1"));
                retList.addAll(param);
            }
            catch (Throwable throwable2) {
                void var14_19;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var14_19;
            }
        }
        return retList;
    }

    private String getOrderClaimSyncStringParam(String type, String start, String end, int page) {
        JsonObject json = new JsonObject();
        json.addProperty("type", type);
        json.addProperty("page", (Number)page);
        json.addProperty("fromRequestDate", start);
        json.addProperty("toRequestDate", end);
        JsonArray statuses = new JsonArray();
        statuses.add("REQUESTED");
        statuses.add("COMPLETED");
        if (!type.equals("CANCEL")) {
            statuses.add("COLLECTING");
            statuses.add("COLLECTED");
            if (!type.equals("RETURN")) {
                statuses.add("DELIVERING");
            }
        }
        json.add("statuses", (JsonElement)statuses);
        json.addProperty("pageSize", (Number)50);
        return json.toString();
    }

    private String getNewOrderStringParam(String merchantId, String startDate, String endDate, String orderStatus, int page) {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("orderProductStatus", orderStatus);
        json.addProperty("masking", Boolean.valueOf(true));
        json.add("stockIds", (JsonElement)new JsonArray());
        json.addProperty("page", (Number)page);
        json.addProperty("pageSize", (Number)50);
        json.addProperty("sortDirection", "DESC");
        return json.toString();
    }

    private List<ShopOrderMstNewDto> setData(ShopOrderMstNewDto ordDto, JsonArray orderArr, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstNewDto> list = new ArrayList<ShopOrderMstNewDto>();
        Request.Builder requestBuilder = new Request.Builder().url("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/merchants/" + ordDto.getApikey() + "/my-settlement-configs?&checkIsMaintenanceTime=false").get().addHeader("Content-Type", "application/json");
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            requestBuilder.addHeader("Cookie", entry.getKey() + "=" + entry.getValue());
        }
        Request request2 = requestBuilder.build();
        double paymentFeeRate = 0.016;
        double salesFeeRate = 0.08;
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonObject object = this.parser.parse(response.body().string()).getAsJsonObject();
                if (object.get("resultType").getAsString().equals("SUCCESS")) {
                    JsonObject successObject = object.get("success").getAsJsonObject();
                    paymentFeeRate = successObject.get("tossMoneyFeeRate").getAsDouble() / 100.0;
                    salesFeeRate = successObject.get("feeRate").getAsDouble() / 100.0;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uacb0\uc81c \uc218\uc218\ub8cc\uc728 \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec\ubc23\uc0dd \uc5d0\ub7ec\uba54\uc138\uc9c0 [" + String.valueOf(e) + "]  \n \uae30\ubcf8\uac12\uc73c\ub85c \uac00\uc838\uc634");
        }
        for (JsonElement element : orderArr) {
            ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
            dto.setBasicInfo(ordDto);
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setResult_code("1");
            dto.setMall_exp_cd("");
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            JsonObject orderObject = element.getAsJsonObject();
            dto.setOrder_id(this.jsonElementNullStr(orderObject.get("orderId")));
            dto.setMall_order_id(this.jsonElementNullStr(orderObject.get("orderProductId")));
            dto.setOrder_status(this.getStatus(this.jsonElementNullStr(orderObject.get("orderProductStatus"))));
            dto.setOrder_date(this.jsonElementNullStr(orderObject.get("orderedAt")).replace("T", " "));
            dto.setUser_name(this.jsonElementNullStr(orderObject.get("ordererName")));
            String ordererPhone = TossShoppingLiteOrderCommand.formatPhoneNumber(this.jsonElementNullStr(orderObject.get("ordererPhone")));
            dto.setUser_tel(ordererPhone);
            dto.setUser_cel(ordererPhone);
            dto.setMall_product_id(this.jsonElementNullStr(orderObject.get("productId")));
            String productName = this.jsonElementNullStr(orderObject.get("productName"));
            dto.setP_product_name(productName);
            dto.setProduct_name(productName);
            String optionName = this.jsonElementNullStr(orderObject.get("optionName"));
            dto.setP_sku_value(optionName);
            dto.setSku_value(optionName);
            String compayny_goods_cd = "";
            if (orderObject.has("productManagementCode") && !orderObject.get("productManagementCode").isJsonNull()) {
                compayny_goods_cd = orderObject.get("productManagementCode").getAsString();
            }
            dto.setCompayny_goods_cd(compayny_goods_cd);
            dto.setReceive_name(orderObject.get("receiverName").getAsString());
            String address = this.jsonElementNullStr(orderObject.get("address")) + " " + this.jsonElementNullStr(orderObject.get("detailAddress"));
            dto.setReceive_addr(address);
            dto.setReceive_tel(TossShoppingLiteOrderCommand.formatPhoneNumber(this.jsonElementNullStr(orderObject.get("receiverPhone"))));
            dto.setReceive_cel(TossShoppingLiteOrderCommand.formatPhoneNumber(this.jsonElementNullStr(orderObject.get("receiverPhone"))));
            dto.setDelv_msg(this.jsonElementNullStr(orderObject.get("shippingNote")));
            dto.setReceive_zipcode(this.jsonElementNullStr(orderObject.get("zipCode")));
            dto.setDeliveryName(this.jsonElementNullStr(orderObject.get("deliveryCompanyCode")));
            dto.setInvoice_no(this.jsonElementNullStr(orderObject.get("shippingTrackingNumber")));
            dto.setCopy_idx(this.jsonElementNullStr(orderObject.get("deliveryFeeGroupId")));
            dto.setExpress_deadline(this.jsonElementNullStr(orderObject.get("shippingDeadlineAt")));
            int delvCost = 0;
            if (!orderObject.get("deliveryFee").isJsonNull()) {
                delvCost = orderObject.get("deliveryFee").getAsInt();
            }
            if (delvCost == 0) {
                dto.setDelivery_method_str2("\ubb34\ub8cc");
            } else {
                dto.setDelivery_method_str2("\uc120\uacb0\uc81c");
            }
            int optAddPrice = 0;
            int discountPrice = 0;
            int totalCost = orderObject.get("price").getAsInt();
            int saleCnt = orderObject.get("quantity").getAsInt();
            int saleCost = totalCost / saleCnt;
            int payCost = totalCost - discountPrice;
            int paymentFee = (int)Math.floor((double)totalCost * paymentFeeRate);
            int paymentFeeWithVat = (int)Math.floor((double)paymentFee * 1.1);
            int salesFee = (int)Math.floor((double)totalCost * salesFeeRate);
            int salesFeeWithVat = (int)Math.floor((double)salesFee * 1.1);
            int mallFee = paymentFeeWithVat + salesFeeWithVat;
            int supplyCost = totalCost - mallFee;
            int mallWonCost = supplyCost - discountPrice;
            dto.setTotal_cost(String.valueOf(totalCost));
            dto.setSale_cnt(this.fmtInt(saleCnt));
            dto.setSale_cost(this.fmtInt(saleCost));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setMall_won_cost(this.fmtInt(mallWonCost));
            dto.setOpt_add_cost(this.fmtInt(optAddPrice));
            dto.setDiscount_cost(this.fmtInt(discountPrice));
            dto.setRate(this.percentOf(mallFee, totalCost, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setDelv_cost(this.fmtInt(delvCost));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
            list.add(dto);
        }
        return list;
    }

    private List<ShopOrderMstNewDto> setDataClaim(ShopOrderMstNewDto ordDto, JsonArray claimorderArr, Map<String, String> cookies, String status2) {
        ArrayList<ShopOrderMstNewDto> list = new ArrayList<ShopOrderMstNewDto>();
        Request.Builder requestBuilder = new Request.Builder().url("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/merchants/" + ordDto.getApikey() + "/my-settlement-configs?&checkIsMaintenanceTime=false").get().addHeader("Content-Type", "application/json");
        for (Map.Entry<String, String> entry : cookies.entrySet()) {
            requestBuilder.addHeader("Cookie", entry.getKey() + "=" + entry.getValue());
        }
        Request request2 = requestBuilder.build();
        double paymentFeeRate = 0.016;
        double salesFeeRate = 0.08;
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (Response response = this.client.newCall(request2).execute();){
                JsonObject object = (JsonObject)this.parser.parse(response.body().string());
                if (object.get("resultType").getAsString().equals("SUCCESS")) {
                    JsonObject successObject = object.get("success").getAsJsonObject();
                    paymentFeeRate = successObject.get("tossMoneyFeeRate").getAsDouble() / 100.0;
                    salesFeeRate = successObject.get("feeRate").getAsDouble() / 100.0;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("\uacb0\uc81c \uc218\uc218\ub8cc\uc728 \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec\ubc23\uc0dd \uc5d0\ub7ec\uba54\uc138\uc9c0 [" + String.valueOf(e) + "]  \n \uae30\ubcf8\uac12\uc73c\ub85c \uac00\uc838\uc634");
        }
        for (JsonElement element : claimorderArr) {
            ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
            dto.setBasicInfo(ordDto);
            dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            dto.setResult_code("1");
            dto.setMall_exp_cd("");
            dto.setReceive_email("");
            dto.setWon_cost("0");
            dto.setBox_ea("0");
            dto.setCompayny_goods_cd("");
            dto.setDelv_cost("0");
            dto.setDelivery_method_str2("\ubb34\ub8cc");
            JsonObject claimorderObject = element.getAsJsonObject();
            JsonObject order = claimorderObject.get("order").getAsJsonObject();
            dto.setOrder_id(this.jsonElementNullStr(order.get("id")));
            dto.setMall_order_id(this.jsonElementNullStr(order.get("orderProductId")));
            dto.setOrder_status(this.getStatusClaim(claimorderObject.get("status").getAsString(), status2));
            dto.setOrder_date(this.jsonElementNullStr(order.get("createdDt")).replace("T", " "));
            dto.setUser_name(this.jsonElementNullStr(order.get("ordererName")));
            dto.setUser_tel(TossShoppingLiteOrderCommand.formatPhoneNumber(this.jsonElementNullStr(order.get("ordererPhoneNumber"))));
            dto.setUser_cel(TossShoppingLiteOrderCommand.formatPhoneNumber(this.jsonElementNullStr(order.get("ordererPhoneNumber"))));
            JsonObject product2 = claimorderObject.get("product").getAsJsonObject();
            dto.setMall_product_id(this.jsonElementNullStr(product2.get("id")));
            dto.setP_product_name(this.jsonElementNullStr(product2.get("name")));
            dto.setProduct_name(this.jsonElementNullStr(product2.get("name")));
            dto.setP_sku_value(this.jsonElementNullStr(product2.get("optionName")));
            dto.setSku_value(this.jsonElementNullStr(product2.get("optionName")));
            String address = order.get("address").getAsString() + " " + order.get("detailAddress").getAsString();
            dto.setReceive_addr(address);
            dto.setReceive_name(this.jsonElementNullStr(order.get("receiverName")));
            dto.setReceive_tel(TossShoppingLiteOrderCommand.formatPhoneNumber(order.get("receiverPhoneNumber").getAsString()));
            dto.setReceive_cel(TossShoppingLiteOrderCommand.formatPhoneNumber(order.get("receiverPhoneNumber").getAsString()));
            dto.setReceive_zipcode(order.get("zipCode").getAsString());
            dto.setClaim_reg_date(this.jsonElementNullStr(claimorderObject.get("requestedDate")).replace("T", " "));
            String claimReason = this.jsonElementNullStr(claimorderObject.get("requestReason")) + " " + this.jsonElementNullStr(claimorderObject.get("requestDetailReason"));
            dto.setClaim_reason(claimReason);
            int delvCost = 0;
            int optAddPrice = 0;
            int discountPrice = 0;
            int totalCost = order.get("price").getAsInt();
            int saleCnt = product2.get("quantity").getAsInt();
            int saleCost = totalCost / saleCnt;
            int payCost = totalCost - discountPrice;
            int paymentFee = (int)Math.floor((double)totalCost * paymentFeeRate);
            int paymentFeeWithVat = (int)Math.floor((double)paymentFee * 1.1);
            int salesFee = (int)Math.floor((double)totalCost * salesFeeRate);
            int salesFeeWithVat = (int)Math.floor((double)salesFee * 1.1);
            int mallFee = paymentFeeWithVat + salesFeeWithVat;
            int supplyCost = totalCost - mallFee;
            int mallWonCost = supplyCost - discountPrice;
            dto.setTotal_cost(String.valueOf(totalCost));
            dto.setSale_cnt(this.fmtInt(saleCnt));
            dto.setSale_cost(this.fmtInt(saleCost));
            dto.setMall_fee(this.fmtInt(mallFee));
            dto.setSupply_cost(this.fmtInt(supplyCost));
            dto.setPay_cost(this.fmtInt(payCost));
            dto.setMall_won_cost(this.fmtInt(mallWonCost));
            dto.setOpt_add_cost(this.fmtInt(optAddPrice));
            dto.setDiscount_cost(this.fmtInt(discountPrice));
            dto.setRate(this.percentOf(mallFee, totalCost, 2));
            dto.setReal_rate(this.percentOf(mallFee, payCost, 2));
            dto.setDelv_cost(this.fmtInt(delvCost));
            dto.setPay_cost_add_delv(this.fmtInt(payCost + delvCost));
            dto.setExpected_add_delv(this.fmtInt(mallWonCost + delvCost));
            list.add(dto);
        }
        return list;
    }

    public static String formatPhoneNumber(String phoneNumber) {
        if (phoneNumber == null || phoneNumber.isEmpty()) {
            return phoneNumber;
        }
        if (phoneNumber.startsWith("02")) {
            if (phoneNumber.length() == 10) {
                return phoneNumber.replaceAll("(02)(\\d{4})(\\d{4})", "$1-$2-$3");
            }
            if (phoneNumber.length() == 9) {
                return phoneNumber.replaceAll("(02)(\\d{3})(\\d{4})", "$1-$2-$3");
            }
        }
        if (phoneNumber.length() == 11) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{4})(\\d{4})", "$1-$2-$3");
        }
        if (phoneNumber.length() == 10) {
            return phoneNumber.replaceAll("(\\d{3})(\\d{3})(\\d{4})", "$1-$2-$3");
        }
        return phoneNumber;
    }

    private String[] resolveOrderStatus(ShopOrderMstNewDto dto) {
        switch (dto.getSpecificStatus()) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                return new String[]{"\uacb0\uc81c\uc644\ub8cc"};
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                return new String[]{"\uc0c1\ud488\uc900\ube44\uc911", "\ubc1c\uc1a1\uc9c0\uc5f0"};
            }
            case "\ubc30\uc1a1\uc911": {
                return new String[]{"\ubc30\uc1a1\uc911"};
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return new String[]{"\ubc30\uc1a1\uc644\ub8cc"};
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                return new String[]{"\uad6c\ub9e4\ud655\uc815"};
            }
            case "\uad50\ud658": 
            case "\ubc18\ud488": 
            case "\ucde8\uc18c": {
                return null;
            }
            case "\ud1b5\ud569": {
                return new String[]{"\uacb0\uc81c\uc644\ub8cc", "\uc0c1\ud488\uc900\ube44\uc911", "\ubc1c\uc1a1\uc9c0\uc5f0", "\ubc30\uc1a1\uc911", "\ubc30\uc1a1\uc644\ub8cc", "\uad6c\ub9e4\ud655\uc815"};
            }
        }
        return new String[0];
    }

    private String getStatus(String string) {
        String status2 = "";
        switch (string) {
            case "\uc0c1\ud488\uc900\ube44\uc911": 
            case "\uacb0\uc81c\uc644\ub8cc": 
            case "\ubc1c\uc1a1\uc9c0\uc5f0": {
                status2 = "100";
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                status2 = "403";
                break;
            }
            case "\uad6c\ub9e4\ud655\uc815": 
            case "\ubc30\uc1a1\uc644\ub8cc": {
                status2 = "410";
            }
        }
        return status2;
    }

    private String getStatusClaim(String status2, String type) {
        switch (type) {
            case "\ucde8\uc18c": {
                switch (status2) {
                    case "REQUESTED": {
                        return "C01";
                    }
                    case "COMPLETED": {
                        return "C02";
                    }
                }
            }
            case "\ubc18\ud488": {
                switch (status2) {
                    case "COLLECTING": 
                    case "REQUESTED": 
                    case "COLLECTED": {
                        return "R01";
                    }
                    case "COMPLETED": {
                        return "R02";
                    }
                }
            }
            case "\uad50\ud658": {
                switch (status2) {
                    case "COLLECTING": 
                    case "REQUESTED": 
                    case "COLLECTED": 
                    case "DELIVERING": {
                        return "E01";
                    }
                    case "COMPLETED": {
                        return "E02";
                    }
                }
            }
        }
        return "";
    }
}

