/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TossShoppingOrderCancelApprovalCommand
extends IShopOrderTossShoppingCommand {
    private static TossShoppingOrderCancelApprovalCommand instance = new TossShoppingOrderCancelApprovalCommand();
    ObjectMapper mapper = new ObjectMapper();
    OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();

    public static TossShoppingOrderCancelApprovalCommand getInstance() {
        return instance;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        Map<Object, Object> cookies = new HashMap();
        IShopCommonLogin is = new IShopCommonLogin(){};
        JsonObject body = new JsonObject();
        JsonParser paser = new JsonParser();
        try {
            for (ShopOrderMstDto dto : param) {
                cookies = is.getTossCookies(dto.getShop_userid(), dto.getShopPw());
                TossShoppingOrderCancelApprovalRequest req = new TossShoppingOrderCancelApprovalRequest();
                req.setMerchandId(Integer.parseInt(dto.getApikey()));
                req.setOrderProductIds(Arrays.asList(dto.getOrder_id()));
                req.setStatus("\uacb0\uc81c\ucde8\uc18c");
                req.setReason("\uae30\ud0c0");
                req.setDetailReason("");
                req.setDeliveryPenaltyCharger("USER");
                String json = this.mapper.writeValueAsString((Object)req);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)json);
                Request.Builder requestBuilder = new Request.Builder().url("https://api-public.toss.im/api-public/v3/shopping-order/order/status-update").put(requestBody).addHeader("Content-Type", "application/json");
                for (Map.Entry<Object, Object> entry : cookies.entrySet()) {
                    requestBuilder.addHeader("Cookie", (String)entry.getKey() + "=" + (String)entry.getValue());
                }
                Throwable throwable = null;
                Iterator<Map.Entry<Object, Object>> iterator = null;
                try (Response response = this.client.newCall(requestBuilder.build()).execute();){
                    if (response.isSuccessful()) {
                        body = paser.parse(response.body().string()).getAsJsonObject();
                        if (body.get("resultType").getAsString().equals("SUCCESS")) {
                            dto.setResult_code("1");
                            continue;
                        }
                        dto.setResult_code("-1");
                        continue;
                    }
                    dto.setResult_code("-1");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud1a0\uc2a4\uc1fc\ud551 \ucde8\uc18c\uc2b9\uc778 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4..");
        }
        return param;
    }

    class TossShoppingOrderCancelApprovalRequest {
        private int merchandId;
        private List<String> orderProductIds = new ArrayList<String>();
        private String status;
        private String reason;
        private String detailReason;
        private String deliveryPenaltyCharger;

        TossShoppingOrderCancelApprovalRequest() {
        }

        public int getMerchandId() {
            return this.merchandId;
        }

        public void setMerchandId(int merchandId) {
            this.merchandId = merchandId;
        }

        public List<String> getOrderProductIds() {
            return this.orderProductIds;
        }

        public void setOrderProductIds(List<String> orderProductIds) {
            this.orderProductIds = orderProductIds;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status2) {
            this.status = status2;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        public String getDetailReason() {
            return this.detailReason;
        }

        public void setDetailReason(String detailReason) {
            this.detailReason = detailReason;
        }

        public String getDeliveryPenaltyCharger() {
            return this.deliveryPenaltyCharger;
        }

        public void setDeliveryPenaltyCharger(String deliveryPenaltyCharger) {
            this.deliveryPenaltyCharger = deliveryPenaltyCharger;
        }
    }
}

