/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.wemakeprice;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.IShopProductCategory;
import com.kdjsystem.mlink.shop.common.ProductCategoryService;
import com.kdjsystem.mlink.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ShopProductWemarketCategory
extends ProductCategoryService
implements IShopProductCategory {
    public ShopProductWemarketCategory(IShopProductCategory productcategory) {
        super(productcategory);
    }

    @Override
    public String excute(ShopProductDto dto, Map<String, String> cookies, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String code = "";
        try {
            if (dto.getClass_nm1() != null && !dto.getClass_nm1().equals("")) {
                List<String> categs = this.getCategorySplit(dto.getClass_nm1());
                Categorys categorys = null;
                categorys = this.getCategorys(shoppingMallDetailDto.getApikey());
                if (categorys != null) {
                    for (ResultCategoryData data2 : categorys.data) {
                        int count = 0;
                        String fullname = this.setCategoryFullname(data2.getLcateName(), data2.getMcateName(), data2.getScateName(), data2.getDcateName());
                        if (fullname.equals("")) continue;
                        List<String> shopcategs = this.getCategorySplit(fullname.replaceAll(" ", ""));
                        for (String shopcateg : shopcategs) {
                            for (String categ : categs) {
                                if (shopcateg.length() < categ.length()) {
                                    if (!categ.contains(shopcateg)) continue;
                                    ++count;
                                    continue;
                                }
                                if (!shopcateg.contains(categ)) continue;
                                ++count;
                            }
                        }
                        data2.setCount(count);
                    }
                }
                List shopCate = categorys.data.stream().filter(d -> d.getCount() > 0).collect(Collectors.toList());
                ResultCategoryData maxitem = null;
                ShopCatInfDto cateDto = new ShopCatInfDto();
                List<String> name = Arrays.asList(dto.getClass_nm1().split(">"));
                List<String> detCode = this.getCategoryCode(dto);
                if (shopCate.size() > 0) {
                    maxitem = shopCate.stream().max(Comparator.comparing(ResultCategoryData::getCount)).get();
                    code = String.valueOf(maxitem.getDcateCode());
                    cateDto.setCompno(dto.getCompno());
                    cateDto.setShopcd(dto.getShopcd());
                    cateDto.setShopcatno(detCode.get(detCode.size() - 1));
                    cateDto.setShopcatnm(dto.getShopcd().concat("_").concat(name.get(name.size() - 1)));
                    cateDto.setShopcatsitenm(dto.getClass_nm1());
                    cateDto.setShopdetcatcd(String.valueOf(maxitem.getDcateCode()));
                    String categ = ShopCommonDao.get().getCategorySetting(dto.getShop_cid_info(), dto.getShopcd(), code);
                    dto.setShop_cid_info(categ);
                    ShopProductDao.get().Category(cateDto, dto, null, dto.getGoods_keyword());
                } else {
                    code = "4105238";
                    cateDto.setCompno(dto.getCompno());
                    cateDto.setShopcd(dto.getShopcd());
                    cateDto.setShopcatno(detCode.get(detCode.size() - 1));
                    cateDto.setShopcatnm(dto.getShopcd().concat("_").concat("\uc720\uc544/\uc5b4\ub9b0\uc774"));
                    cateDto.setShopcatsitenm(dto.getClass_nm1());
                    cateDto.setShopdetcatcd("4105238");
                }
            } else {
                code = "4105238";
            }
        }
        catch (Exception e) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage());
        }
        return code;
    }

    private Categorys getCategorys(String apikey) {
        Categorys categorys = null;
        try {
            String path = "wemarket/api/v1/getCategoryAPI";
            ObjectMapper mapper = new ObjectMapper();
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            Request request2 = new Request.Builder().url("http://api.kdjsystem.com:8082/".concat(path)).method("GET", null).addHeader("apiKey", apikey).build();
            Throwable throwable = null;
            Object var8_10 = null;
            try (Response response = client.newCall(request2).execute();){
                categorys = (Categorys)mapper.readValue(response.body().string().toString(), Categorys.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return categorys;
    }

    public static class Categorys {
        private String resultCode;
        private List<ResultCategoryData> data;
        private String error;

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<ResultCategoryData> getData() {
            return this.data;
        }

        public void setData(List<ResultCategoryData> data2) {
            this.data = data2;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ResultCategoryData {
        private String lcateName;
        private String mcateName;
        private String scateName;
        private String dcateName;
        private int dcateCode;
        private String fullcateName;
        private int count = 0;

        public String getLcateName() {
            return this.lcateName;
        }

        public void setLcateName(String lcateName) {
            this.lcateName = lcateName;
        }

        public String getMcateName() {
            return this.mcateName;
        }

        public void setMcateName(String mcateName) {
            this.mcateName = mcateName;
        }

        public String getScateName() {
            return this.scateName;
        }

        public void setScateName(String scateName) {
            this.scateName = scateName;
        }

        public String getDcateName() {
            return this.dcateName;
        }

        public void setDcateName(String dcateName) {
            this.dcateName = dcateName;
        }

        public int getDcateCode() {
            return this.dcateCode;
        }

        public void setDcateCode(int dcateCode) {
            this.dcateCode = dcateCode;
        }

        public String getFullcateName() {
            return this.fullcateName;
        }

        public void setFullcateName(String fullcateName) {
            this.fullcateName = fullcateName;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }
    }
}

