/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.wemakeprice;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.wemakeprice.IShopWemarketOrderCommand;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class WemarketOrderSearchCommand
extends IShopWemarketOrderCommand {
    private static IShopOrderCommand instance = new WemarketOrderSearchCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private WemarketOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            Object startDate = param.get(0).getStartDt().substring(0, 8);
            startDate = ((String)startDate).substring(0, 4) + "-" + ((String)startDate).substring(4, 6) + "-" + ((String)startDate).substring(6, 8);
            Object endDate = param.get(0).getEndDt().substring(0, 8);
            endDate = ((String)endDate).substring(0, 4) + "-" + ((String)endDate).substring(4, 6) + "-" + ((String)endDate).substring(6, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            Date sdate = formatter.parse((String)startDate);
            Date edate = formatter.parse((String)endDate);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(sdate);
            int i = 0;
            while (i < (int)range) {
                this.orderList(param, dtolist, (String)startDate);
                this.cancleList(param, dtolist, (String)startDate);
                this.cancleConfirmList(param, dtolist, (String)startDate);
                this.returnList(param, dtolist, (String)startDate);
                this.returnConfirmList(param, dtolist, (String)startDate);
                this.exchangeList(param, dtolist, (String)startDate);
                this.exchangeConfirmList(param, dtolist, (String)startDate);
                cal1.add(5, 1);
                startDate = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private void exchangeList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String date) throws Exception {
        try {
            String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"EXCHANGE\", \"claimStatus\": \"REQUEST\" }";
            Connection.Response rs = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", param.get(0).getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray jsonArray = (JsonArray)jsonObject.get("claim");
            String bundleNo = "";
            String orderNo = "";
            String prodNo = "";
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    jsonObject = (JsonObject)jsonArray.get(i);
                    bundleNo = jsonObject.get("bundleNo").getAsString();
                    JsonArray arr = (JsonArray)jsonObject.get("orderProduct");
                    int j = 0;
                    while (j < arr.size()) {
                        JsonObject product2 = arr.get(j).getAsJsonObject();
                        prodNo = product2.get("productNo").getAsString();
                        JsonArray option_arr = (JsonArray)product2.get("orderOption");
                        int k = 0;
                        while (k < option_arr.size()) {
                            product2 = option_arr.get(k).getAsJsonObject();
                            orderNo = product2.get("orderOptionNo").getAsString();
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getOrder_id().equals(orderNo) || !dto.getMall_product_id().equals(prodNo) || !dto.getCopy_idx().equals(bundleNo)) continue;
                                dto.setOrder_status("E01");
                                dto.setResult_code("1");
                                dtolist.add(dto);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \uad50\ud658 \uc694\uccad \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void exchangeConfirmList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String date) throws Exception {
        try {
            String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"EXCHANGE\", \"claimStatus\": \"APPROVE\" }";
            Connection.Response rs = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", param.get(0).getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray jsonArray = (JsonArray)jsonObject.get("claim");
            String bundleNo = "";
            String orderNo = "";
            String prodNo = "";
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    jsonObject = (JsonObject)jsonArray.get(i);
                    bundleNo = jsonObject.get("bundleNo").getAsString();
                    JsonArray arr = (JsonArray)jsonObject.get("orderProduct");
                    int j = 0;
                    while (j < arr.size()) {
                        JsonObject product2 = arr.get(j).getAsJsonObject();
                        prodNo = product2.get("productNo").getAsString();
                        JsonArray option_arr = (JsonArray)product2.get("orderOption");
                        int k = 0;
                        while (k < option_arr.size()) {
                            product2 = option_arr.get(k).getAsJsonObject();
                            orderNo = product2.get("orderOptionNo").getAsString();
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getOrder_id().equals(orderNo) || !dto.getMall_product_id().equals(prodNo) || !dto.getCopy_idx().equals(bundleNo)) continue;
                                dto.setOrder_status("E02");
                                dto.setResult_code("1");
                                ShopOrderMstDto temp = dto.clone("E02");
                                temp.setOrder_date(jsonObject.get("requestDate").getAsString());
                                dtolist.add(temp);
                                dtolist.add(dto);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \uad50\ud658 \ub9c8\uac10 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void returnList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String date) throws Exception {
        try {
            String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"RETURN\", \"claimStatus\": \"REQUEST\" }";
            Connection.Response rs = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", param.get(0).getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray jsonArray = (JsonArray)jsonObject.get("claim");
            String bundleNo = "";
            String orderNo = "";
            String prodNo = "";
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    jsonObject = (JsonObject)jsonArray.get(i);
                    bundleNo = jsonObject.get("bundleNo").getAsString();
                    JsonArray arr = (JsonArray)jsonObject.get("orderProduct");
                    int j = 0;
                    while (j < arr.size()) {
                        JsonObject product2 = arr.get(j).getAsJsonObject();
                        prodNo = product2.get("productNo").getAsString();
                        JsonArray option_arr = (JsonArray)product2.get("orderOption");
                        int k = 0;
                        while (k < option_arr.size()) {
                            product2 = option_arr.get(k).getAsJsonObject();
                            orderNo = product2.get("orderOptionNo").getAsString();
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getOrder_id().equals(orderNo) || !dto.getMall_product_id().equals(prodNo) || !dto.getCopy_idx().equals(bundleNo)) continue;
                                dto.setOrder_status("R01");
                                dto.setResult_code("1");
                                dtolist.add(dto);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \ubc18\ud488 \uc694\uccad \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void returnConfirmList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String date) throws Exception {
        try {
            String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"RETURN\", \"claimStatus\": \"APPROVE\" }";
            Connection.Response rs = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", param.get(0).getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray jsonArray = (JsonArray)jsonObject.get("claim");
            String bundleNo = "";
            String orderNo = "";
            String prodNo = "";
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    jsonObject = (JsonObject)jsonArray.get(i);
                    bundleNo = jsonObject.get("bundleNo").getAsString();
                    JsonArray arr = (JsonArray)jsonObject.get("orderProduct");
                    int j = 0;
                    while (j < arr.size()) {
                        JsonObject product2 = arr.get(j).getAsJsonObject();
                        prodNo = product2.get("productNo").getAsString();
                        JsonArray option_arr = (JsonArray)product2.get("orderOption");
                        int k = 0;
                        while (k < option_arr.size()) {
                            product2 = option_arr.get(k).getAsJsonObject();
                            orderNo = product2.get("orderOptionNo").getAsString();
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getOrder_id().equals(orderNo) || !dto.getMall_product_id().equals(prodNo) || !dto.getCopy_idx().equals(bundleNo)) continue;
                                dto.setOrder_status("R02");
                                dto.setResult_code("1");
                                ShopOrderMstDto temp = dto.clone("R02");
                                temp.setOrder_date(jsonObject.get("requestDate").getAsString());
                                dtolist.add(temp);
                                dtolist.add(dto);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \ubc18\ud488 \ub9c8\uac10 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<ShopOrderMstDto> cancleList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String date) throws Exception {
        try {
            String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"CANCEL\", \"claimStatus\": \"REQUEST\" }";
            Connection.Response rs = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", param.get(0).getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray jsonArray = (JsonArray)jsonObject.get("claim");
            String bundleNo = "";
            String orderNo = "";
            String prodNo = "";
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    jsonObject = (JsonObject)jsonArray.get(i);
                    bundleNo = jsonObject.get("bundleNo").getAsString();
                    JsonArray arr = (JsonArray)jsonObject.get("orderProduct");
                    int j = 0;
                    while (j < arr.size()) {
                        JsonObject product2 = arr.get(j).getAsJsonObject();
                        prodNo = product2.get("productNo").getAsString();
                        JsonArray option_arr = (JsonArray)product2.get("orderOption");
                        int k = 0;
                        while (k < option_arr.size()) {
                            product2 = option_arr.get(k).getAsJsonObject();
                            orderNo = product2.get("orderOptionNo").getAsString();
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getOrder_id().equals(orderNo) || !dto.getMall_product_id().equals(prodNo) || !dto.getCopy_idx().equals(bundleNo)) continue;
                                dto.setOrder_status("C01");
                                dto.setResult_code("1");
                                dtolist.add(dto);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \ucde8\uc18c \uc694\uccad \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private List<ShopOrderMstDto> cancleConfirmList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String date) throws Exception {
        try {
            String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"claimType\": \"CANCEL\", \"claimStatus\": \"APPROVE\" }";
            Connection.Response rs = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getClaimList").header("apiKey", param.get(0).getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = rs.body();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray jsonArray = (JsonArray)jsonObject.get("claim");
            String bundleNo = "";
            String orderNo = "";
            String prodNo = "";
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    jsonObject = (JsonObject)jsonArray.get(i);
                    bundleNo = jsonObject.get("bundleNo").getAsString();
                    JsonArray arr = (JsonArray)jsonObject.get("orderProduct");
                    int j = 0;
                    while (j < arr.size()) {
                        JsonObject product2 = arr.get(j).getAsJsonObject();
                        prodNo = product2.get("productNo").getAsString();
                        JsonArray option_arr = (JsonArray)product2.get("orderOption");
                        int k = 0;
                        while (k < option_arr.size()) {
                            product2 = option_arr.get(k).getAsJsonObject();
                            orderNo = product2.get("orderOptionNo").getAsString();
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getOrder_id().equals(orderNo) || !dto.getMall_product_id().equals(prodNo) || !dto.getCopy_idx().equals(bundleNo)) continue;
                                dto.setOrder_status("C02");
                                dto.setResult_code("1");
                                ShopOrderMstDto temp = dto.clone("C02");
                                temp.setOrder_date(jsonObject.get("requestDate").getAsString());
                                dtolist.add(temp);
                                dtolist.add(dto);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \ucde8\uc18c \ub9c8\uac10 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private List<ShopOrderMstDto> orderList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> dtolist, String date) throws Exception {
        try {
            String json = "{ \"fromDate\": \"" + date + " 00:00:00\", \"toDate\": \"" + date + " 23:59:59\", \"type\": \"COMPLETE\" }";
            Connection.Response response = Jsoup.connect((String)"http://api.kdjsystem.com:8082/wemarket/api/v2/getOrderList").header("apiKey", param.get(0).getApikey()).header("Accept", "application/json").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.POST).execute();
            String body = response.body();
            if (body.contains("\"resultCode\":null")) {
                return dtolist;
            }
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(body);
            jsonObject = (JsonObject)jsonObject.get("data");
            JsonArray jsonArray = (JsonArray)jsonObject.get("bundle");
            String bundleNo = "";
            String orderNo = "";
            String prodNo = "";
            if (jsonArray.size() != 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    jsonObject = (JsonObject)jsonArray.get(i);
                    bundleNo = jsonObject.get("bundleNo").getAsString();
                    JsonArray arr = (JsonArray)jsonObject.get("orderProduct");
                    int j = 0;
                    while (j < arr.size()) {
                        JsonObject product2 = arr.get(j).getAsJsonObject();
                        prodNo = product2.get("productNo").getAsString();
                        JsonArray option_arr = (JsonArray)product2.get("orderOption");
                        int k = 0;
                        while (k < option_arr.size()) {
                            product2 = option_arr.get(k).getAsJsonObject();
                            orderNo = product2.get("orderOptionNo").getAsString();
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getOrder_id().equals(orderNo) || !dto.getMall_product_id().equals(prodNo) || !dto.getCopy_idx().equals(bundleNo)) continue;
                                dto.setOrder_status("410");
                                dto.setResult_code("1");
                                dtolist.add(dto);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc704\uba54\ud504 \uc8fc\ubb38 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. ");
        }
        return dtolist;
    }
}

