/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.wemakeprice;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IShopProductCategory;
import com.kdjsystem.mlink.shop.common.ProductCategoryService;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopWeMarketAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.shop.dao.WorkmgrlogDao;
import com.kdjsystem.mlink.shop.data.wemakeprice.WemarketExitsProductCd;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WemarketProductRegService
implements IProduct {
    private static final String Host = "http://api.kdjsystem.com:8082/";
    List<String> imageDelete = new ArrayList<String>();
    private List<OptionList> optionList;

    private void DownLoadImage(ShopWeMarketAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception, InterruptedException {
        for (String img : strImages) {
            if (dtllist.getImageresizeyn().equals("Y")) {
                ShopCommon.downloadImgFile(img, Integer.parseInt(dtllist.getImageresize()), Integer.parseInt(dtllist.getImageresize()));
                Thread.sleep(1000L);
                continue;
            }
            ShopCommon.downloadImgFile(img, 460, 460);
            Thread.sleep(1000L);
        }
    }

    private void setCategoryNKeyword(ShopProductDto dto, Map<String, String> params) {
        params.put("dcateCd", "4104458");
        params.put("prodStatus", "");
        params.put("removeProdOptionNoStr", "");
        params.put("removeProdImgNoStr", "");
        params.put("removeProdFileNoStr", "");
        params.put("removeProdGnoticeNoStr", "");
        params.put("agreeNo", "");
        ArrayList<String> search = new ArrayList<String>();
        search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
        ArrayList<String> goodsearch = new ArrayList<String>();
        if (search.size() > 9) {
            int i = 0;
            while (i < 9) {
                goodsearch.add((String)search.get(i));
                ++i;
            }
        } else {
            goodsearch.addAll(search);
        }
        params.put("keywordWmp", goodsearch.stream().collect(Collectors.joining(",")));
        params.put("keywordEp", goodsearch.stream().collect(Collectors.joining(",")));
        params.put("searchSpecialYn", "");
        params.put("searchSpecialPrice", "");
        params.put("schCateType", "SELECT");
        params.put("cateSchNm", "");
    }

    private void setMalltypeNTax(ShopWeMarketAdditionDto dtllist, Map<String, String> params) {
        if (dtllist.getBizyn().equals("Y")) {
            params.put("mallType", "BIZ");
        } else {
            params.put("mallType", "NOR");
        }
        params.put("prodType", dtllist.getProducttype());
        params.put("dispYn", dtllist.getDisplayyn());
        params.put("taxYn", dtllist.getTaxyn());
        params.put("refPriceType", dtllist.getReferencepricetype());
    }

    private void setEtc(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            params.put("epYn", dtllist.getPricecomparisonsiteyn());
            params.put("reviewDisp", dtllist.getReviewdisp());
            params.put("adultLimitYn", dtllist.getAdultlimityn());
            params.put("localLiquorYn", "N");
            params.put("parallelImportYn", dtllist.getParallelimportyn());
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\ud734\ucc44\ub110, \uad6c\ub9e4\ud6c4\uae30, 19\uae08\uc81c\ud55c, \uc804\ud1b5\uc8fc, \ubcd1\ud589\uc218\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setLabels(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            List<String> labels = Arrays.asList(dtllist.getLabelnolist().split(","));
            params.put("labelList[0].labelGroup", "P");
            params.put("labelList[0].labelNo", "19");
            params.put("labelList[1].labelGroup", "P");
            params.put("labelList[1].labelNo", "20");
            params.put("labelList[2].labelGroup", "P");
            params.put("labelList[2].labelNo", "21");
            params.put("labelList[3].labelGroup", "P");
            params.put("labelList[3].labelNo", "22");
            if (labels.size() > 0) {
                for (String label : labels) {
                    if (label.equals("01")) {
                        params.put("labelList[0].useYn", "Y");
                        continue;
                    }
                    if (label.equals("02")) {
                        params.put("labelList[1].useYn", "Y");
                        continue;
                    }
                    if (label.equals("03")) {
                        params.put("labelList[2].useYn", "Y");
                        continue;
                    }
                    if (!label.equals("04")) continue;
                    params.put("labelList[3].useYn", "Y");
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc18d\uc131 \ub77c\ubca8 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setIsbnNCert(Map<String, String> params) throws Exception {
        try {
            params.put("isbn13", "");
            params.put("isbn10", "");
            params.put("certList[0].isCert", "D");
            params.put("certList[0].certGroup", "KD");
            params.put("certList[1].isCert", "D");
            params.put("certList[1].certGroup", "LF");
            params.put("certList[2].isCert", "D");
            params.put("certList[2].certGroup", "ER");
            params.put("certList[3].isCert", "D");
            params.put("certList[3].certGroup", "RP");
            params.put("certList[4].isCert", "D");
            params.put("certList[4].certGroup", "LC");
            params.put("cert.KD.isCert", "D");
            params.put("epMinPrice", "");
            params.put("epDt", "");
            params.put("epChannel", "");
            params.put("cobuyCount", "");
            params.put("cobuyPeriodYn", "Y");
            params.put("cobuyStartDt", YDMATimeUtil.getCurrentDateScheduler() + " 00:00");
            params.put("cobuyEndDt", "");
        }
        catch (Exception exception) {
            throw new Exception("ISBN, \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setSalePeriod(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            params.put("commissionType", "FR");
            params.put("commissionRate", "");
            params.put("commissionPrice", "");
            params.put("salePeriod", dtllist.getSaleperiodyn());
            params.put("saleStartDt", YDMATimeUtil.getCurrentDateScheduler() + " 00:00");
            params.put("saleEndDt", dtllist.getSaleendperiod() + " 23:00");
            params.put("stockCount", "999");
            params.put("saleStatus", "A");
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uae30\uac04 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setLimitCnt(ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            params.put("purchaseMinCount", dtllist.getPurchasemincount());
            params.put("purchaseLimitYn", dtllist.getPurchaselimityn());
            if (dtllist.getPurchaselimityn().equals("Y")) {
                params.put("purchaseLimitDuration", dtllist.getPurchaselimitduration());
                params.put("purchaseLimitDay", dtllist.getPurchaselimitday().equals("0") ? "" : dtllist.getPurchaselimitday());
                params.put("purchaseLimitCount", dtllist.getPurchaselimitcount());
            }
            params.put("basketLimitYn", dtllist.getBasketlimityn());
            params.put("validPeriod", "PERIOD");
            params.put("validStartDt", "");
            params.put("validEndDt", "");
            params.put("validDay", "");
            params.put("storeZipcode", "");
            params.put("storeAddr1", "");
            params.put("storeAddr2", "");
            params.put("storeRoadAddr1", "");
            params.put("storeRoadAddr2", "");
            params.put("storeLatitude", "");
            params.put("storeLongitude", "");
        }
        catch (Exception exception) {
            throw new Exception("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9, \uad6c\ub9e4\uc218\ub7c9\uc81c\ud55c, \uc7a5\ubc14\uad6c\ub2c8\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice setPrice(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            params.put("originPrice", resultMarketPrice.getConsumer_if_sale_price());
            params.put("salePrice", resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setOption(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, Map<String, String> params, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                if (shopOptionDtos.size() > 0) {
                    params.put("optSelUseYn", "Y");
                    List ShopOptions = shopOptionDtos.stream().filter(d -> !d.getCnt().equals("0")).collect(Collectors.toList());
                    List<String> name = Arrays.asList(((ShopOptionDto)ShopOptions.get(0)).getOptspecdes().split(":"));
                    ArrayList<String> opt1 = new ArrayList<String>();
                    ArrayList<String> opt2 = new ArrayList<String>();
                    for (ShopOptionDto option2 : ShopOptions) {
                        if (Arrays.asList(option2.getOptspecdes().split(":")).size() > 1) {
                            opt1.add(option2.getOptspecdes().split(":")[0]);
                            opt2.add(option2.getOptspecdes().split(":")[1]);
                            continue;
                        }
                        if (Arrays.asList(option2.getOptspecdes().split(":")).size() != 1) continue;
                        opt1.add(option2.getOptspecdes().split(":")[0]);
                    }
                    params.put("optionDepth", String.valueOf(name.size()));
                    params.put("opt1[1]", dto.getChar_1_nm());
                    params.put("opt2[1]", opt1.stream().distinct().collect(Collectors.joining(",")));
                    params.put("opt1[2]", dto.getChar_2_nm());
                    params.put("opt2[2]", opt2.size() > 0 ? opt2.stream().distinct().collect(Collectors.joining(",")) : "");
                    params.put("opt1[3]", "");
                    params.put("opt2[3]", "");
                    params.put("opt1[4]", "");
                    params.put("opt2[4]", "");
                    params.put("opt1[5]", "");
                    params.put("opt2[5]", "");
                    int i = 0;
                    while (i < ShopOptions.size()) {
                        params.put("optionList[" + i + "].priority", String.valueOf(i));
                        params.put("optionList[" + i + "].useYn", "Y");
                        List<String> opt = Arrays.asList(((ShopOptionDto)ShopOptions.get(i)).getOptspecdes().split(":"));
                        Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                        int deliveryFee = 0;
                        if (dtllist.getFreedelivery().equals("T")) {
                            if (dtllist.getExpprc() == 9999) {
                                if (!dto.getDelv_cost().equals("0")) {
                                    deliveryFee = Integer.parseInt(dto.getDelv_cost());
                                } else {
                                    ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                                    deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                                }
                            } else {
                                deliveryFee = dtllist.getExpprc();
                            }
                            salePrice = salePrice + (long)deliveryFee;
                        }
                        int amt = YDMAStringUtil.convertToInt(((ShopOptionDto)ShopOptions.get(i)).getAmt());
                        salePrice = salePrice + YDMAStringUtil.convertToLong(((ShopOptionDto)ShopOptions.get(i)).getAmt());
                        int limit_price = YDMAStringUtil.convertToInt(((ShopOptionDto)ShopOptions.get(i)).getLimit_price());
                        ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                        if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                            optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                        }
                        amt = Integer.parseInt(optionprice.getConsumer_if_sale_price()) - Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                        if (opt.size() > 1) {
                            params.put("optionList[" + i + "].opt1Val", opt.get(0));
                            params.put("optionList[" + i + "].opt2Val", opt.get(1));
                            params.put("optionList[" + i + "].optAddPrice", String.valueOf(amt));
                            params.put("optionList[" + i + "].stockCount", ((ShopOptionDto)ShopOptions.get(i)).getCnt());
                            params.put("optionList[" + i + "].sellerOptCd", "");
                            params.put("optionList[" + i + "].saleStatus", "A");
                            params.put("optionList[" + i + "].dispYn", "Y");
                        } else if (opt.size() == 1) {
                            params.put("optionList[" + i + "].opt1Val", opt.get(0));
                            params.put("optionList[" + i + "].optAddPrice", String.valueOf(amt));
                            params.put("optionList[" + i + "].stockCount", ((ShopOptionDto)ShopOptions.get(i)).getCnt());
                            params.put("optionList[" + i + "].sellerOptCd", "");
                            params.put("optionList[" + i + "].saleStatus", "A");
                            params.put("optionList[" + i + "].dispYn", "Y");
                        }
                        ++i;
                    }
                    params.put("sOptType", "S");
                    params.put("sDepth", String.valueOf(name.size()));
                    params.put("sOpt1Title", dto.getChar_1_nm());
                    params.put("sOpt2Title", dto.getChar_2_nm());
                    params.put("sOpt3Title", "");
                    params.put("sOpt4Title", "");
                    params.put("sOpt5Title", "");
                    params.put("optTxtUseYn", "N");
                } else {
                    params.put("optSelUseYn", "Y");
                    if (!dto.getChar_2_nm().isEmpty()) {
                        params.put("optionDepth", "2");
                        params.put("opt1[1]", dto.getChar_1_nm());
                        params.put("opt2[1]", "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694.");
                        params.put("opt1[2]", dto.getChar_2_nm());
                        params.put("opt2[2]", "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694.");
                        int i = 0;
                        while (i < 2) {
                            params.put("optionList[" + i + "].priority", String.valueOf(i));
                            params.put("optionList[" + i + "].useYn", "Y");
                            params.put("optionList[" + i + "].opt1Val", "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694.");
                            params.put("optionList[" + i + "].opt2Val", "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694.");
                            params.put("optionList[" + i + "].optAddPrice", "0");
                            params.put("optionList[" + i + "].stockCount", "999");
                            params.put("optionList[" + i + "].sellerOptCd", "");
                            params.put("optionList[" + i + "].saleStatus", "A");
                            params.put("optionList[" + i + "].dispYn", "Y");
                            ++i;
                        }
                    } else {
                        params.put("optionDepth", "1");
                        params.put("opt1[1]", dto.getChar_1_nm());
                        params.put("opt2[1]", "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694.");
                        params.put("optionList[1].priority", "0");
                        params.put("optionList[1].useYn", "Y");
                        params.put("optionList[1].opt1Val", "\ubc30\uc1a1\uba54\ubaa8\uc5d0 \uae30\uc785\ud558\uc138\uc694.");
                        params.put("optionList[1].optAddPrice", "0");
                        params.put("optionList[1].stockCount", "999");
                        params.put("optionList[1].sellerOptCd", "");
                        params.put("optionList[1].saleStatus", "A");
                        params.put("optionList[1].dispYn", "Y");
                    }
                    params.put("sOptType", "S");
                    params.put("sDepth", dto.getChar_2_nm().isEmpty() ? "1" : "2");
                    params.put("sOpt1Title", dto.getChar_1_nm());
                    params.put("sOpt2Title", dto.getChar_2_nm());
                    params.put("sOpt3Title", "");
                    params.put("sOpt4Title", "");
                    params.put("sOpt5Title", "");
                    params.put("optTxtUseYn", "N");
                }
            } else {
                params.put("optSelUseYn", "N");
                params.put("optTxtUseYn", "N");
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setProductName(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, Map<String, String> params) throws Exception {
        try {
            String value = IProduct.formatProductNameByCode(dtllist.getProdoutput(), dto);
            if (!dtllist.getProdnmfirst().equals("")) {
                value = dtllist.getProdnmfirst().concat(value);
            }
            if (!dtllist.getProdnmlast().equals("")) {
                value = value.concat(dtllist.getProdnmlast());
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 130) : value;
            params.put("prodNm", sellerProductName);
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private boolean getProductprodnochk(String productNo, ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto) throws IOException {
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(Host.concat(String.format("wemarket/api/v1/getProductAPI?productNo=%s", productNo))).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getApikey()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
        String data2 = "";
        Throwable throwable = null;
        Object var8_9 = null;
        try (Response response = client.newCall(request2).execute();){
            data2 = response.body().string();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
        jsonObject.get("resultCode").getAsInt();
        JsonObject jsonObject1 = (JsonObject)jsonObject.get("data");
        JsonObject basic = (JsonObject)jsonObject1.get("basic");
        String status2 = basic.get("productStatusName").getAsString();
        return status2.equals("\ud310\ub9e4\uc911");
    }

    private void Basic(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        try {
            weProductReg.basic = new Basic();
            String value = IProduct.formatProductNameByCode(dtllist.getProdoutput(), dto);
            if (!dtllist.getProdnmfirst().equals("")) {
                value = dtllist.getProdnmfirst().concat(value);
            }
            if (!dtllist.getProdnmlast().equals("")) {
                value = value.concat(dtllist.getProdnmlast());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 70);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? (value.length() > 70 ? value.substring(0, 70) : value) : value;
            weProductReg.basic.productName = sellerProductName;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.basic.productType = dtllist.getProducttype();
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc720\ud615 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void BasicShipping(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            weProductReg.basic.shipPolicyNo = dtllist.getShippolicyno();
            weProductReg.basic.shipInfo = new ShipInfo();
            Data ship = this.getShipAPI(dtllist, shoppingMallDetailDto);
            weProductReg.basic.shipInfo.claimShipFee = ship.getBundleKind().equals("BND") ? null : ship.getClaimShipFee();
            weProductReg.basic.shipInfo.releaseZipCode = ship.getBundleKind().equals("BND") ? null : ship.getReleaseZipCode();
            weProductReg.basic.shipInfo.releaseRoadAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseRoadAddress1();
            weProductReg.basic.shipInfo.releaseRoadAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseRoadAddress2();
            weProductReg.basic.shipInfo.releaseAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseAddress1();
            weProductReg.basic.shipInfo.releaseAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReleaseAddress2();
            weProductReg.basic.shipInfo.returnZipCode = ship.getBundleKind().equals("BND") ? null : ship.getReturnZipCode();
            weProductReg.basic.shipInfo.returnRoadAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReturnRoadAddress1();
            weProductReg.basic.shipInfo.returnRoadAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReturnRoadAddress2();
            weProductReg.basic.shipInfo.returnAddress1 = ship.getBundleKind().equals("BND") ? null : ship.getReturnAddress1();
            weProductReg.basic.shipInfo.returnAddress2 = ship.getBundleKind().equals("BND") ? null : ship.getReturnAddress2();
            weProductReg.basic.shipInfo.releaseDay = ship.getBundleKind().equals("BND") ? null : ship.getReleaseDay();
            weProductReg.basic.shipInfo.releaseTime = ship.getBundleKind().equals("BND") ? null : ship.getReleaseTime();
            weProductReg.basic.shipInfo.holidayExceptYn = ship.getBundleKind().equals("BND") ? null : ship.getHolidayExceptYn();
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ucc45\ubc88\ud638 \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private Data getShipAPI(ShopWeMarketAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto) throws IOException, JsonParseException, JsonMappingException {
        Shippingpolicy shipPolicy;
        String path = "wemarket/api/v1/getShipAPI";
        ObjectMapper mapper = new ObjectMapper();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(Host.concat(path)).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getApikey()).build();
        Throwable throwable = null;
        Object var9_9 = null;
        try (Response response = client.newCall(request2).execute();){
            shipPolicy = (Shippingpolicy)mapper.readValue(response.body().string().toString(), Shippingpolicy.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Data ship = shipPolicy.data.stream().filter(d -> d.getShipPolicyNo() == Integer.parseInt(dtllist.getShippolicyno())).findAny().get();
        return ship;
    }

    private void BasicEtc(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        Object brand;
        String response;
        String path;
        ObjectMapper mapper;
        try {
            weProductReg.basic.adultLimitYn = dtllist.getAdultlimityn();
        }
        catch (Exception exception) {
            throw new Exception("19\uae08\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.basic.displayYn = dtllist.getDisplayyn();
        }
        catch (Exception exception) {
            throw new Exception("\ub178\ucd9c\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.basic.bizYn = dtllist.getBizyn();
        }
        catch (Exception exception) {
            throw new Exception("\uc0ac\uc5c5\uc790\uc804\uc6a9\uc0c1\ud488 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        weProductReg.basic.styleYn = "N";
        try {
            if (dtllist.getBrandyn().equals("Y")) {
                weProductReg.basic.brandNo = dtllist.getBrandno().equals("") ? "" : dtllist.getBrandno();
            } else {
                mapper = new ObjectMapper();
                String brandnm = dto.getBrand_nm();
                path = "wemarket/api/v1/getBrandAPI?brandName=" + brandnm;
                response = this.getBrandNMakerAPI(dto, dtllist, shoppingMallDetailDto, path);
                if (!response.equals("")) {
                    BrandData brandNm;
                    brand = (Brand)mapper.readValue(response, Brand.class);
                    weProductReg.basic.brandNo = ((Brand)brand).data != null ? ((brandNm = (BrandData)((Brand)brand).data.stream().filter(d -> d.getBrandName().equals(dto.getBrand_nm())).findAny().orElse(null)) == null ? "" : brandNm.getBrandNo()) : "";
                } else {
                    weProductReg.basic.brandNo = "";
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ube0c\ub79c\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getMakeryn().equals("Y")) {
                weProductReg.basic.makerNo = dtllist.getMakerno().equals("") ? "" : dtllist.getMakerno();
            } else {
                mapper = new ObjectMapper();
                String makernm = dto.getMaker();
                path = "wemarket/api/v1/getMakerAPI?makerName=" + makernm;
                response = this.getBrandNMakerAPI(dto, dtllist, shoppingMallDetailDto, path);
                if (!response.equals("")) {
                    MakerData makerNM;
                    brand = (Maker)mapper.readValue(response, Maker.class);
                    weProductReg.basic.makerNo = ((Maker)brand).data != null ? ((makerNM = (MakerData)((Maker)brand).data.stream().filter(d -> d.getMakerName().equals(dto.getMaker())).findAny().orElse(null)) == null ? "" : makerNM.getMakerNo()) : "";
                } else {
                    weProductReg.basic.makerNo = "";
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\uc870\uc0ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String getBrandNMakerAPI(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, String path) throws IOException, JsonParseException, JsonMappingException {
        String value = "";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(Host.concat(path)).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getApikey()).build();
        Throwable throwable = null;
        Object var9_10 = null;
        try (Response response = client.newCall(request2).execute();){
            value = response.code() == 200 ? response.body().string() : "";
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return value;
    }

    private void SalePeriod(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        weProductReg.sale = new Sale();
        try {
            weProductReg.sale.salePeriod = dtllist.getSaleperiodyn();
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uae30\uac04 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.saleStartDate = YDMATimeUtil.getCurrentDateScheduler() + " 00:00";
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uc2dc\uc791\uc77c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.saleEndDate = dtllist.getSaleendperiod() + " 23:00";
            dto.setSaleenddt(dtllist.getSaleendperiod());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uc885\ub8cc\uc77c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice SalePrice(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            weProductReg.sale.originPrice = resultMarketPrice.getConsumer_if_sale_price();
            weProductReg.sale.salePrice = resultMarketPrice.getConsumer_if_sale_price();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void SaleEtc(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg) throws Exception {
        weProductReg.sale.stockCount = "998";
        try {
            weProductReg.sale.taxYn = dtllist.getTaxyn();
        }
        catch (Exception exception) {
            throw new Exception("\uacfc\uc138\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.purchaseMinCount = dtllist.getPurchasemincount();
        }
        catch (Exception exception) {
            throw new Exception("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.purchaseLimitYn = dtllist.getPurchaselimityn();
        }
        catch (Exception exception) {
            throw new Exception("1\uc778\ub2f9 \uad6c\ub9e4\uc81c\ud55c \uc0ac\uc6a9\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getPurchaselimityn().equals("Y")) {
                weProductReg.sale.purchaseLimitDuration = dtllist.getPurchaselimitduration();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c \ud0c0\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getPurchaselimityn().equals("Y")) {
                weProductReg.sale.purchaseLimitDay = dtllist.getPurchaselimitday().equals("0") ? null : dtllist.getPurchaselimitday();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c \uc77c\uc790 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (dtllist.getPurchaselimityn().equals("Y")) {
                weProductReg.sale.purchaseLimitCount = dtllist.getPurchaselimitcount();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c \uac1c\uc218 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.basketLimitYn = dtllist.getBasketlimityn();
        }
        catch (Exception exception) {
            throw new Exception("\uc7a5\ubc14\uad6c\ub2c8\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.sale.referencePriceType = dtllist.getReferencepricetype();
        }
        catch (Exception exception) {
            throw new Exception("\uae30\uc900\uac00\uaca9 \uadfc\uac70\uc815\ubcf4\ud0c0\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void DetailImgNRemark(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, WeMarketProductReg weProductReg, List<String> strImages) throws Exception {
        try {
            String basicImg;
            weProductReg.detail = new Detail();
            weProductReg.detail.addImgUrlList = new ArrayList<String>();
            weProductReg.detail.basicImgUrl = basicImg = strImages.get(0);
            if (strImages.size() > 1) {
                int i = 1;
                while (i < strImages.size()) {
                    if (i <= 2) {
                        String additionalImg = strImages.get(i);
                        weProductReg.detail.addImgUrlList.add(additionalImg);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new Exception("\ub300\ud45c \ubc0f \ucd94\uac00\uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage().toString());
        }
        try {
            String listImg;
            weProductReg.detail.listImgUrl = listImg = strImages.get(0);
        }
        catch (Exception e) {
            throw new Exception("\ub9ac\uc2a4\ud305\uc774\ubbf8\uc9c0 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + e.getMessage().toString());
        }
        Object addDetailPlus = "";
        try {
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = dtllist.getDetailKeywordL() + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            weProductReg.detail.descType = "HTML";
            weProductReg.detail.descHtml = ((String)addDetailPlus).replace("\n", "").replace("\"", "'") + IProduct.removeBrokenImgTag(dto.getGoods_remarks()).replace("\n", "").replace("\"", "'");
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\uc138\uc124\uba85 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Option(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ResultMarketPrice resultMarketPrice) throws Exception {
        List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
        String addOptionLeftNm = "";
        String addOptionRightNm = "";
        try {
            weProductReg.option = new Option();
            if (shopOptionDtos.size() > 0) {
                if (dtllist.getAddoptionlb().equals("Y")) {
                    addOptionLeftNm = dtllist.getAddOptionL();
                }
                if (dtllist.getAddoptionrb().equals("Y")) {
                    addOptionRightNm = dtllist.getAddOptionR();
                }
                weProductReg.option.selectOptionUseYn = "Y";
                List options = shopOptionDtos.stream().filter(d -> !d.getCnt().equals("0")).collect(Collectors.toList());
                if (options.size() > 0) {
                    String[] optionTypes = ((ShopOptionDto)options.get(0)).getName().split(":");
                    weProductReg.option.selectOptionDepth = String.valueOf(optionTypes.length);
                    if (optionTypes.length == 3) {
                        weProductReg.option.selectOptionTitle1 = optionTypes[0];
                        weProductReg.option.selectOptionTitle2 = optionTypes[1];
                        weProductReg.option.selectOptionTitle3 = optionTypes[2];
                    } else if (optionTypes.length == 2) {
                        weProductReg.option.selectOptionTitle1 = optionTypes[0];
                        weProductReg.option.selectOptionTitle2 = optionTypes[1];
                    } else {
                        weProductReg.option.selectOptionTitle1 = optionTypes[0];
                    }
                    weProductReg.option.selectOptionValueList = new ArrayList<SelectOptionValueList>();
                    int i = 0;
                    while (i < options.size()) {
                        SelectOptionValueList selectOptionValueList = new SelectOptionValueList();
                        List<String> opt = Arrays.asList(((ShopOptionDto)options.get(i)).getOptspecdes().split(":"));
                        Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                        int deliveryFee = 0;
                        if (dtllist.getFreedelivery().equals("T")) {
                            if (dtllist.getExpprc() == 9999) {
                                if (!dto.getDelv_cost().equals("0")) {
                                    deliveryFee = Integer.parseInt(dto.getDelv_cost());
                                } else {
                                    ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                                    deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                                }
                            } else {
                                deliveryFee = dtllist.getExpprc();
                            }
                            salePrice = salePrice + (long)deliveryFee;
                        }
                        int amt = YDMAStringUtil.convertToInt(((ShopOptionDto)options.get(i)).getAmt());
                        salePrice = salePrice + YDMAStringUtil.convertToLong(((ShopOptionDto)options.get(i)).getAmt());
                        int limit_price = YDMAStringUtil.convertToInt(((ShopOptionDto)options.get(i)).getLimit_price());
                        ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                        if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                            optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
                        }
                        amt = Integer.parseInt(optionprice.getConsumer_if_sale_price()) - Integer.parseInt(resultMarketPrice.getConsumer_if_sale_price());
                        if (opt.size() > 2) {
                            selectOptionValueList.optionValue1 = addOptionLeftNm + opt.get(0) + addOptionRightNm;
                            selectOptionValueList.optionValue2 = addOptionLeftNm + opt.get(1) + addOptionRightNm;
                            selectOptionValueList.optionValue3 = addOptionLeftNm + opt.get(2) + addOptionRightNm;
                            selectOptionValueList.optAddPrice = String.valueOf(amt);
                            selectOptionValueList.stockCount = ((ShopOptionDto)options.get(i)).getCnt();
                            selectOptionValueList.displayYn = "Y";
                        } else if (opt.size() > 1) {
                            selectOptionValueList.optionValue1 = addOptionLeftNm + opt.get(0) + addOptionRightNm;
                            selectOptionValueList.optionValue2 = addOptionLeftNm + opt.get(1) + addOptionRightNm;
                            selectOptionValueList.optAddPrice = String.valueOf(amt);
                            selectOptionValueList.stockCount = ((ShopOptionDto)options.get(i)).getCnt();
                            selectOptionValueList.displayYn = "Y";
                        } else {
                            selectOptionValueList.optionValue1 = addOptionLeftNm + opt.get(0) + addOptionRightNm;
                            selectOptionValueList.optAddPrice = String.valueOf(amt);
                            selectOptionValueList.stockCount = ((ShopOptionDto)options.get(i)).getCnt();
                            selectOptionValueList.displayYn = "Y";
                        }
                        weProductReg.option.selectOptionValueList.add(selectOptionValueList);
                        ++i;
                    }
                    weProductReg.option.textOptionUseYn = "N";
                } else {
                    weProductReg.option.selectOptionUseYn = "N";
                    weProductReg.option.textOptionUseYn = "N";
                }
            } else {
                weProductReg.option.selectOptionUseYn = "N";
                weProductReg.option.textOptionUseYn = "N";
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ub4f1\ub85d\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Notice(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            int gnoticeNo = Integer.parseInt(dto.getProp1_cd());
            if (gnoticeNo > 26 || gnoticeNo < 31) {
                gnoticeNo = 38;
            } else if (gnoticeNo > 33 || gnoticeNo < 41) {
                gnoticeNo = 38;
            }
            NoticeData data2 = this.getNoticeAPI(gnoticeNo, shoppingMallDetailDto);
            String attrcd = gnoticeNo < 10 ? "00".concat(String.valueOf(gnoticeNo)) : "0".concat(String.valueOf(gnoticeNo));
            dto.setProp1_cd(attrcd);
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            NoticeListMain group = new NoticeListMain();
            group.groupNoticeNo = data2.groupNoticeNo;
            int i = 0;
            while (i < data2.noticeList.size()) {
                int num = i;
                NoticeListValue value = new NoticeListValue();
                ShopProdAttrnmDto shopProdAttrnmDto = dto.getShopProdAttrnmDtos().stream().filter(d -> d.getAttrnm().contains(noticeData.noticeList.get((int)n).noticeName)).findAny().orElse(null);
                value.description = shopProdAttrnmDto == null ? "\uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0" : (shopProdAttrnmDto.getProp_val().equals("") ? "\uc0c1\ud488\uc0c1\uc138 \uc124\uba85 \ucc38\uace0" : shopProdAttrnmDto.getProp_val());
                value.noticeNo = data2.noticeList.get(i).getNoticeNo();
                group.noticeList.add(value);
                ++i;
            }
            weProductReg.noticeList.add(group);
        }
        catch (Exception exception) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private NoticeData getNoticeAPI(int gnoticeNo, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String path = "wemarket/api/v1/getNoticeAPI";
        ObjectMapper mapper = new ObjectMapper();
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(Host.concat(path)).method("GET", null).addHeader("apiKey", shoppingMallDetailDto.getApikey()).build();
        Throwable throwable = null;
        Object var8_9 = null;
        try (Response response = client.newCall(request2).execute();){
            if (response.code() == 200) {
                NoticeTypeGET shipPolicy = (NoticeTypeGET)mapper.readValue(response.body().string().toString(), NoticeTypeGET.class);
                NoticeData ship = shipPolicy.data.stream().filter(d -> d.getGroupNoticeNo().equals(String.valueOf(gnoticeNo))).findAny().get();
                return ship;
            }
            throw new Exception("\uace0\uc2dc\uc815\ubcf4\ub97c \ud68d\ub4dd\ud558\uc9c0 \ubabb\ud588\uc2b5\ub2c8\ub2e4..");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void Etc(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        weProductReg.etc = new Etc();
        try {
            weProductReg.etc.parallelImportYn = dtllist.getParallelimportyn();
        }
        catch (Exception exception) {
            throw new Exception("\ubcd1\ud589\uc218\uc785 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcKidIsCertification = "D";
                weProductReg.etc.kcKidCertificationList = new ArrayList<KcKidCertificationList>();
                KcKidCertificationList kcKidCertificationList = new KcKidCertificationList();
                kcKidCertificationList.certificationType = "KD_SAFETY_CT";
                weProductReg.etc.kcKidCertificationList.add(kcKidCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc5b4\ub9b0\uc774\uc81c\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcLifeIsCertification = "D";
                weProductReg.etc.kcLifeCertificationList = new ArrayList<KcLifeCertificationList>();
                KcLifeCertificationList kcLifeCertificationList = new KcLifeCertificationList();
                kcLifeCertificationList.certificationType = "LF_SAFETY_CT";
                weProductReg.etc.kcLifeCertificationList.add(kcLifeCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0dd\ud65c\uc6a9\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcElectricIsCertification = "D";
                weProductReg.etc.kcElectricCertificationList = new ArrayList<KcElectricCertificationList>();
                KcElectricCertificationList kcElectricCertificationList = new KcElectricCertificationList();
                kcElectricCertificationList.certificationType = "ER_SAFETY_CT";
                weProductReg.etc.kcElectricCertificationList.add(kcElectricCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc804\uae30\uc6a9\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcReportIsCertification = "D";
                weProductReg.etc.kcReportCertificationList = new ArrayList<KcReportCertificationList>();
                KcReportCertificationList kcReportCertificationList = new KcReportCertificationList();
                kcReportCertificationList.certificationType = "RP_STB";
                weProductReg.etc.kcReportCertificationList.add(kcReportCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\ubc29\uc1a1\ud1b5\uc2e0\uae30\uc790\uc7ac \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            if (!dto.getCert_type().equals("0")) {
                weProductReg.etc.kcLifeChemistryIsCertification = "D";
                weProductReg.etc.kcLifeChemistryCertificationList = new ArrayList<KcLifeChemistryCertificationList>();
                KcLifeChemistryCertificationList kcLifeChemistryCertificationList = new KcLifeChemistryCertificationList();
                kcLifeChemistryCertificationList.certificationType = "LC_SELF_CHECK";
                weProductReg.etc.kcLifeChemistryCertificationList.add(kcLifeChemistryCertificationList);
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0dd\ud65c\ud654\ud559\uc81c\ud488 \uc778\uc99d\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.etc.sellerProdCode = dto.getCompayny_goods_cd();
        }
        catch (Exception exception) {
            throw new Exception("\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.etc.priceComparisonSiteYn = dtllist.getPricecomparisonsiteyn();
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\ud734\ucc44\ub110 \ub4f1\ub85d\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            ArrayList<String> search = new ArrayList<String>();
            search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            ArrayList<String> goodsearch = new ArrayList<String>();
            if (search.size() > 9) {
                int i = 0;
                while (i < 9) {
                    goodsearch.add((String)search.get(i));
                    ++i;
                }
            } else {
                goodsearch.addAll(search);
            }
            weProductReg.etc.keywordPriceComparisonSite = goodsearch.stream().collect(Collectors.joining(","));
            weProductReg.etc.keywordWemakeprice = goodsearch.stream().collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            throw new Exception("\ud0a4\uc6cc\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        weProductReg.etc.isbn13 = "";
        weProductReg.etc.isbn10 = "";
        try {
            weProductReg.etc.displayOnlyDealYn = dtllist.getDisplayonlydealyn();
        }
        catch (Exception exception) {
            throw new Exception("\ub51c\uc5d0\uc11c\ub9cc \ub178\ucd9c\uc5ec\ubd80 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            weProductReg.etc.reviewDisp = dtllist.getReviewdisp();
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\ud6c4\uae30 \ub178\ucd9c\uc81c\ud55c \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        try {
            List<String> labels = Arrays.asList(dtllist.getLabelnolist().split(","));
            if (labels.size() > 0) {
                weProductReg.etc.labelNoList = new ArrayList<String>();
                for (String label : labels) {
                    if (label.equals("01")) {
                        weProductReg.etc.labelNoList.add("19");
                        continue;
                    }
                    if (label.equals("02")) {
                        weProductReg.etc.labelNoList.add("20");
                        continue;
                    }
                    if (label.equals("03")) {
                        weProductReg.etc.labelNoList.add("21");
                        continue;
                    }
                    if (!label.equals("04")) continue;
                    weProductReg.etc.labelNoList.add("22");
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc18d\uc131 \ub77c\ubca8 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String setProductReg(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception {
        String json = "";
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        WeMarketProductReg weProductReg = new WeMarketProductReg();
        weProductReg.productNo = "";
        this.Basic(dto, dtllist, weProductReg);
        this.Category(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.BasicShipping(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.BasicEtc(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.SalePeriod(dto, dtllist, weProductReg);
        ResultMarketPrice resultMarketPrice = this.SalePrice(dto, dtllist, weProductReg);
        this.SaleEtc(dto, dtllist, weProductReg);
        this.DetailImgNRemark(dto, dtllist, shoppingMallDetailDto, weProductReg, strImages);
        this.Option(dto, dtllist, weProductReg, resultMarketPrice);
        this.Notice(dto, dtllist, weProductReg, shoppingMallDetailDto);
        this.Etc(dto, dtllist, weProductReg, shoppingMallDetailDto);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)weProductReg);
        return json;
    }

    private void Category(ShopProductDto dto, ShopWeMarketAdditionDto dtllist, WeMarketProductReg weProductReg, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            if (dtllist.getIsCategory().equals("1")) {
                weProductReg.basic.dcateCode = dtllist.getShopcatno();
            } else if (dto.getShopCid() == null || dto.getShopCid().equals("")) {
                String cateNum;
                ProductCategoryService service = new ProductCategoryService(IShopProductCategory.getSearchBean(dto.getShopcd()));
                weProductReg.basic.dcateCode = cateNum = service.excute(dto, null, shoppingMallDetailDto);
            } else {
                weProductReg.basic.dcateCode = dto.getShopCid();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    @Override
    public ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShopWeMarketAdditionDto dtllist = null;
        ShoppingMallDetailDto shoppingMallDetailDto = sendProdList.getShoppingMallDetailDto();
        List<ShopProductDto> prodList = sendProdList.getShopProductDto();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        workMngDto.setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        String uuid = sendProdList.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        dtllist = (ShopWeMarketAdditionDto)sendProdList.getProductAdditionDto();
        double mod = 0.0;
        double rate = 0.0;
        try {
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            mod = sendProdList.isManual() ? (double)conf.getProccnt() / (double)prodList.size() : 100.0 / (double)prodList.size();
            int progress = workMngDto.getProgress_rate();
            List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ShopProductDto dto : prodList) {
                this.imageDelete = new ArrayList<String>();
                if ((int)(rate += mod) > 0) {
                    progress += (int)rate;
                    rate = 0.0;
                }
                workMngDto.setProgress_rate(progress);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                String prodNo = WemarketExitsProductCd.get().getisExistsProdNo(dto.getCompayny_goods_cd(), shoppingMallDetailDto.getApikey());
                if (!prodNo.equals("")) {
                    workMngDto.setWork_status("-1");
                    workMngDetailDto.setStatus("-1");
                    workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                    dto.setResult_code("-1");
                    dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                ArrayList<String> strImages = new ArrayList();
                ImageTransformParams params = new ImageTransformParams();
                params.setShopProductDto(dto);
                params.setChangesize(dtllist.getChangesize());
                params.setChangeSizeX(dtllist.getChangeSizeX());
                params.setChangeSizeY(dtllist.getChangeSizeY());
                params.setChangeSizeW(dtllist.getChangeSizeW());
                params.setChangeSizeH(dtllist.getChangeSizeH());
                params.setAngle(dtllist.getAngle());
                params.setScalePercent(dtllist.getScalePercent());
                params.setImgThreeOnFour(dtllist.getImgThreeOnFour());
                params.setRemoveImgTextYN("");
                params.setMirrorImgYN(dtllist.getMirrorImgYN());
                params.setImageresize("");
                params.setImageresize1("");
                UnifiedUploadManager manager = new UnifiedUploadManager();
                strImages = manager.processAndUploadImages(params);
                this.imageDelete = strImages;
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        String matched = IProduct.findFirstForbiddenKeyword(dto, shoppingMallDetailDto.getForbiddenKeywords());
                        if (matched != null) {
                            throw new IllegalArgumentException(String.format("\uae08\uc9c0 \ud0a4\uc6cc\ub4dc '%s'\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc0c1\ud488\uba85=\"%s\", \uac80\uc0c9 \ud0a4\uc6cc\ub4dc=\"%s\"", matched, dto.getGoods_nm(), dto.getGoods_search()));
                        }
                        String json = this.setProductReg(dto, dtllist, shoppingMallDetailDto, strImages);
                        this.productRegSend(json, dto, shoppingMallDetailDto);
                        this.deleteFTPServer(this.imageDelete);
                        if (dto.getResult_code().equals("1")) {
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            workMngDetailDto.setMessage(shoppingMallDetailDto.getShopnm() + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            dto.setShopprodno(dto.getShopprodno());
                            dto.setResult_text(shoppingMallDetailDto.getShopnm() + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                            WorkMngDao.get().saveProdLog(dto, json);
                        } else {
                            String errorMessage = this.setErrorMessage(dto.getResult_text());
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(errorMessage.equals("") ? dto.getResult_text() : errorMessage);
                            dto.setResult_code("-1");
                            dto.setResult_text(errorMessage.equals("") ? dto.getResult_text() : errorMessage);
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        String errorMessage = "";
                        if (!dto.getResult_text().equals("")) {
                            errorMessage = this.setErrorMessage(dto.getResult_text());
                        }
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(errorMessage.equals("") ? e.getMessage() : errorMessage);
                        dto.setResult_code("-1");
                        dto.setResult_text(errorMessage.equals("") ? e.getMessage() : errorMessage);
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    if (!conf.getSaveproductlogyn().equals("Y")) continue;
                    ArrayList<String> sendList = new ArrayList<String>();
                    sendList.add(uuid);
                    sendList.add(dto.getShopcd());
                    sendList.add(shoppingMallDetailDto.getShopnm());
                    sendList.add(dto.getShopseq());
                    sendList.add(shoppingMallDetailDto.getShoppingid());
                    sendList.add(shoppingMallDetailDto.getNicknm1());
                    sendList.add(workMngDetailDto.getSeq());
                    sendList.add(dto.getCompayny_goods_cd());
                    sendList.add(workMngDetailDto.getStatus());
                    sendList.add(workMngDetailDto.getMessage());
                    sendList.add(dtllist.getSeq());
                    sendList.add(dtllist.getTitle());
                    sendList.add(dtllist.getImgOneOnOne());
                    sendList.add(String.valueOf(dtllist.getSellerDc()));
                    sendList.add(String.valueOf(dtllist.getMargin()));
                    sendList.add(String.valueOf(dtllist.getCommission()));
                    sendList.add(dtllist.getChangeSizeX());
                    sendList.add(dtllist.getChangeSizeY());
                    sendList.add(dtllist.getChangeSizeW());
                    sendList.add(dtllist.getChangeSizeH());
                    sendList.add(String.valueOf(dtllist.getAngle()));
                    sendList.add(String.valueOf(dtllist.getScalePercent()));
                    sendList.add(dtllist.getMirrorImgYN());
                    sendList.add(dto.getGoods_keyword());
                    sendList.add(dto.getClass_cd3());
                    sendList.add(dto.getClass_nm1());
                    sendList.add(YDMATimeUtil.getCurrentTimeByYDFormat());
                    sendList.add(dto.getGoods_cost());
                    sendList.add(dto.getDelv_cost());
                    sendList.add(dto.getGoods_search());
                    sendList.add("0");
                    WorkmgrlogDao.get().insertWorkLog(sendList);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            workMngDto.setWork_enddate(YDMATimeUtil.getCurrentTimeByYDFormat());
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    private synchronized void productRegSend(String json, ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        YDMAStringUtil.Print(json);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url(Host.concat("wemarket/api/v1/setProductAPI")).method("POST", body).addHeader("apiKey", shoppingMallDetailDto.getApikey()).addHeader("application", "json;charset=UTF-8").addHeader("Accept", "application/json").addHeader("Content-Type", "application/json").build();
        String data2 = "";
        Throwable throwable = null;
        Object var10_11 = null;
        try (Response response = client.newCall(request2).execute();){
            data2 = response.body().string();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
        int code = jsonObject.get("resultCode").getAsInt();
        if (code == 200) {
            JsonObject value = (JsonObject)jsonObject.get("data");
            dto.setResult_code("1");
            dto.setShopprodno(value.get("productNo").getAsString());
        } else {
            dto.setResult_code("-1");
            dto.setResult_text(jsonObject.get("error").getAsString());
        }
        YDMAStringUtil.Print();
    }

    private String setErrorMessage(String error) {
        Object errorMessage = "";
        errorMessage = error.contains("\uc0c1\ud488\uba85\uc5d0 \uc0ac\uc6a9 \uc81c\ud55c\ub41c \ub2e8\uc5b4") || error.contains("\uc0c1\ud488\uba85\uc5d0 \uc785\ub825\uc774 \ubd88\uac00\ub2a5\ud55c \ubb38\uc790") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488\uba85 \ud574\ub2f9 \ubb38\uc790 \uc785\ub825\ubd88\uac00] " + error : (error.contains("KC \uc778\uc99d\uc815\ubcf4 \ud544\uc218 \uce74\ud14c\uace0\ub9ac") || error.contains("\uce74\ud14c\uace0\ub9ac\ub97c \ubaa8\ub450 \uc120\ud0dd") || error.contains("\uad8c\ud55c\uc774 \ud544\uc694\ud55c \uce74\ud14c\uace0\ub9ac") || error.contains("\uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \ucf54\ub4dc\uac00 \uc5c6\uc2b5") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488 \uce74\ud14c\uace0\ub9ac \uac12 \ubd88\uc77c\uce58 \ubc0f \uc5c6\uc74c] " + error : (error.contains("\uae08\uc9c0\ub41c \ud0a4\uc6cc\ub4dc") || error.contains("\ub4f1\ub85d \ubd88\uac00 \ud0a4\uc6cc\ub4dc") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\ud574\ub2f9 \ud0a4\uc6cc\ub4dc \uc785\ub825\ubd88\uac00] " + error : "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : " + error));
        return errorMessage;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    private static class Basic {
        private String productName;
        private String productType;
        private String dcateCode;
        private String shipPolicyNo;
        private ShipInfo shipInfo;
        private String adultLimitYn;
        private String displayYn;
        private String bizYn;
        private String styleYn;
        private String brandNo;
        private String makerNo;

        private Basic() {
        }

        public String getProductName() {
            return this.productName;
        }

        public void setProductName(String productName) {
            this.productName = productName;
        }

        public String getProductType() {
            return this.productType;
        }

        public void setProductType(String productType) {
            this.productType = productType;
        }

        public String getDcateCode() {
            return this.dcateCode;
        }

        public void setDcateCode(String dcateCode) {
            this.dcateCode = dcateCode;
        }

        public String getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(String shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public ShipInfo getShipInfo() {
            return this.shipInfo;
        }

        public void setShipInfo(ShipInfo shipInfo) {
            this.shipInfo = shipInfo;
        }

        public String getAdultLimitYn() {
            return this.adultLimitYn;
        }

        public void setAdultLimitYn(String adultLimitYn) {
            this.adultLimitYn = adultLimitYn;
        }

        public String getDisplayYn() {
            return this.displayYn;
        }

        public void setDisplayYn(String displayYn) {
            this.displayYn = displayYn;
        }

        public String getBizYn() {
            return this.bizYn;
        }

        public void setBizYn(String bizYn) {
            this.bizYn = bizYn;
        }

        public String getStyleYn() {
            return this.styleYn;
        }

        public void setStyleYn(String styleYn) {
            this.styleYn = styleYn;
        }

        public String getBrandNo() {
            return this.brandNo;
        }

        public void setBrandNo(String brandNo) {
            this.brandNo = brandNo;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }
    }

    private static class BranchList {
        private String branchId;
        private String originPrice;
        private String salePrice;
        private String useYn;

        private BranchList() {
        }

        public String getBranchId() {
            return this.branchId;
        }

        public void setBranchId(String branchId) {
            this.branchId = branchId;
        }

        public String getOriginPrice() {
            return this.originPrice;
        }

        public void setOriginPrice(String originPrice) {
            this.originPrice = originPrice;
        }

        public String getSalePrice() {
            return this.salePrice;
        }

        public void setSalePrice(String salePrice) {
            this.salePrice = salePrice;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }
    }

    private static class Brand {
        private String resultCode;
        private List<BrandData> data;
        private String error;

        private Brand() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<BrandData> getData() {
            return this.data;
        }

        public void setData(List<BrandData> data2) {
            this.data = data2;
        }
    }

    private static class BrandData {
        private String brandNo;
        private String brandName;
        private String brandNameEnglish;
        private String makerNo;
        private String makerName;

        private BrandData() {
        }

        public String getBrandNo() {
            return this.brandNo;
        }

        public void setBrandNo(String brandNo) {
            this.brandNo = brandNo;
        }

        public String getBrandName() {
            return this.brandName;
        }

        public void setBrandName(String brandName) {
            this.brandName = brandName;
        }

        public String getBrandNameEnglish() {
            return this.brandNameEnglish;
        }

        public void setBrandNameEnglish(String brandNameEnglish) {
            this.brandNameEnglish = brandNameEnglish;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getMakerName() {
            return this.makerName;
        }

        public void setMakerName(String makerName) {
            this.makerName = makerName;
        }
    }

    private static class BrandSearch {
        private String brandDesc;
        private String brandNm;
        private String brandNmEng;
        private String brandNo;
        private String chgDt;
        private String chgNm;
        private String imgUrl;
        private String makerNm;
        private String makerNo;
        private String regDt;
        private String regNm;
        private String useYn;

        private BrandSearch() {
        }

        public String getBrandDesc() {
            return this.brandDesc;
        }

        public void setBrandDesc(String brandDesc) {
            this.brandDesc = brandDesc;
        }

        public String getBrandNm() {
            return this.brandNm;
        }

        public void setBrandNm(String brandNm) {
            this.brandNm = brandNm;
        }

        public String getBrandNmEng() {
            return this.brandNmEng;
        }

        public void setBrandNmEng(String brandNmEng) {
            this.brandNmEng = brandNmEng;
        }

        public String getBrandNo() {
            return this.brandNo;
        }

        public void setBrandNo(String brandNo) {
            this.brandNo = brandNo;
        }

        public String getChgDt() {
            return this.chgDt;
        }

        public void setChgDt(String chgDt) {
            this.chgDt = chgDt;
        }

        public String getChgNm() {
            return this.chgNm;
        }

        public void setChgNm(String chgNm) {
            this.chgNm = chgNm;
        }

        public String getImgUrl() {
            return this.imgUrl;
        }

        public void setImgUrl(String imgUrl) {
            this.imgUrl = imgUrl;
        }

        public String getMakerNm() {
            return this.makerNm;
        }

        public void setMakerNm(String makerNm) {
            this.makerNm = makerNm;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getRegDt() {
            return this.regDt;
        }

        public void setRegDt(String regDt) {
            this.regDt = regDt;
        }

        public String getRegNm() {
            return this.regNm;
        }

        public void setRegNm(String regNm) {
            this.regNm = regNm;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }
    }

    private static class Data {
        private String partnerGroupId;
        private int shipPolicyNo;
        private String shipPolicyName;
        private String shipMng;
        private String shipMethod;
        private String parcelCompanyCode;
        private String bundleKind;
        private String shipType;
        private String shipFee;
        private String shipFeeDisplayYn;
        private String freeCondition;
        private String differenceYn;
        private String differenceCount;
        private String prepaymentYn;
        private String claimShipFee;
        private String shipArea;
        private String jejuShipFee;
        private String islandMountainShipFee;
        private String releaseDay;
        private String releaseTime;
        private String holidayExceptYn;
        private String releaseZipCode;
        private String releaseRoadAddress1;
        private String releaseRoadAddress2;
        private String releaseAddress1;
        private String releaseAddress2;
        private String returnZipCode;
        private String returnRoadAddress1;
        private String returnRoadAddress2;
        private String returnAddress1;
        private String returnAddress2;
        private String safetyNoDisplayYn;

        private Data() {
        }

        public String getPartnerGroupId() {
            return this.partnerGroupId;
        }

        public void setPartnerGroupId(String partnerGroupId) {
            this.partnerGroupId = partnerGroupId;
        }

        public int getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(int shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public String getShipPolicyName() {
            return this.shipPolicyName;
        }

        public void setShipPolicyName(String shipPolicyName) {
            this.shipPolicyName = shipPolicyName;
        }

        public String getShipMng() {
            return this.shipMng;
        }

        public void setShipMng(String shipMng) {
            this.shipMng = shipMng;
        }

        public String getShipMethod() {
            return this.shipMethod;
        }

        public void setShipMethod(String shipMethod) {
            this.shipMethod = shipMethod;
        }

        public String getParcelCompanyCode() {
            return this.parcelCompanyCode;
        }

        public void setParcelCompanyCode(String parcelCompanyCode) {
            this.parcelCompanyCode = parcelCompanyCode;
        }

        public String getBundleKind() {
            return this.bundleKind;
        }

        public void setBundleKind(String bundleKind) {
            this.bundleKind = bundleKind;
        }

        public String getShipType() {
            return this.shipType;
        }

        public void setShipType(String shipType) {
            this.shipType = shipType;
        }

        public String getShipFee() {
            return this.shipFee;
        }

        public void setShipFee(String shipFee) {
            this.shipFee = shipFee;
        }

        public String getShipFeeDisplayYn() {
            return this.shipFeeDisplayYn;
        }

        public void setShipFeeDisplayYn(String shipFeeDisplayYn) {
            this.shipFeeDisplayYn = shipFeeDisplayYn;
        }

        public String getFreeCondition() {
            return this.freeCondition;
        }

        public void setFreeCondition(String freeCondition) {
            this.freeCondition = freeCondition;
        }

        public String getDifferenceYn() {
            return this.differenceYn;
        }

        public void setDifferenceYn(String differenceYn) {
            this.differenceYn = differenceYn;
        }

        public String getDifferenceCount() {
            return this.differenceCount;
        }

        public void setDifferenceCount(String differenceCount) {
            this.differenceCount = differenceCount;
        }

        public String getPrepaymentYn() {
            return this.prepaymentYn;
        }

        public void setPrepaymentYn(String prepaymentYn) {
            this.prepaymentYn = prepaymentYn;
        }

        public String getClaimShipFee() {
            return this.claimShipFee;
        }

        public void setClaimShipFee(String claimShipFee) {
            this.claimShipFee = claimShipFee;
        }

        public String getShipArea() {
            return this.shipArea;
        }

        public void setShipArea(String shipArea) {
            this.shipArea = shipArea;
        }

        public String getJejuShipFee() {
            return this.jejuShipFee;
        }

        public void setJejuShipFee(String jejuShipFee) {
            this.jejuShipFee = jejuShipFee;
        }

        public String getIslandMountainShipFee() {
            return this.islandMountainShipFee;
        }

        public void setIslandMountainShipFee(String islandMountainShipFee) {
            this.islandMountainShipFee = islandMountainShipFee;
        }

        public String getReleaseDay() {
            return this.releaseDay;
        }

        public void setReleaseDay(String releaseDay) {
            this.releaseDay = releaseDay;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }

        public void setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
        }

        public String getHolidayExceptYn() {
            return this.holidayExceptYn;
        }

        public void setHolidayExceptYn(String holidayExceptYn) {
            this.holidayExceptYn = holidayExceptYn;
        }

        public String getReleaseZipCode() {
            return this.releaseZipCode;
        }

        public void setReleaseZipCode(String releaseZipCode) {
            this.releaseZipCode = releaseZipCode;
        }

        public String getReleaseRoadAddress1() {
            return this.releaseRoadAddress1;
        }

        public void setReleaseRoadAddress1(String releaseRoadAddress1) {
            this.releaseRoadAddress1 = releaseRoadAddress1;
        }

        public String getReleaseRoadAddress2() {
            return this.releaseRoadAddress2;
        }

        public void setReleaseRoadAddress2(String releaseRoadAddress2) {
            this.releaseRoadAddress2 = releaseRoadAddress2;
        }

        public String getReleaseAddress1() {
            return this.releaseAddress1;
        }

        public void setReleaseAddress1(String releaseAddress1) {
            this.releaseAddress1 = releaseAddress1;
        }

        public String getReleaseAddress2() {
            return this.releaseAddress2;
        }

        public void setReleaseAddress2(String releaseAddress2) {
            this.releaseAddress2 = releaseAddress2;
        }

        public String getReturnZipCode() {
            return this.returnZipCode;
        }

        public void setReturnZipCode(String returnZipCode) {
            this.returnZipCode = returnZipCode;
        }

        public String getReturnRoadAddress1() {
            return this.returnRoadAddress1;
        }

        public void setReturnRoadAddress1(String returnRoadAddress1) {
            this.returnRoadAddress1 = returnRoadAddress1;
        }

        public String getReturnRoadAddress2() {
            return this.returnRoadAddress2;
        }

        public void setReturnRoadAddress2(String returnRoadAddress2) {
            this.returnRoadAddress2 = returnRoadAddress2;
        }

        public String getReturnAddress1() {
            return this.returnAddress1;
        }

        public void setReturnAddress1(String returnAddress1) {
            this.returnAddress1 = returnAddress1;
        }

        public String getReturnAddress2() {
            return this.returnAddress2;
        }

        public void setReturnAddress2(String returnAddress2) {
            this.returnAddress2 = returnAddress2;
        }

        public String getSafetyNoDisplayYn() {
            return this.safetyNoDisplayYn;
        }

        public void setSafetyNoDisplayYn(String safetyNoDisplayYn) {
            this.safetyNoDisplayYn = safetyNoDisplayYn;
        }
    }

    private static class Detail {
        private String basicImgUrl;
        private List<String> addImgUrlList;
        private String listImgUrl;
        private String descType;
        private List<String> descImgUrlList;
        private String descHtml;

        private Detail() {
        }

        public String getBasicImgUrl() {
            return this.basicImgUrl;
        }

        public void setBasicImgUrl(String basicImgUrl) {
            this.basicImgUrl = basicImgUrl;
        }

        public List<String> getAddImgUrlList() {
            return this.addImgUrlList;
        }

        public void setAddImgUrlList(List<String> addImgUrlList) {
            this.addImgUrlList = addImgUrlList;
        }

        public String getListImgUrl() {
            return this.listImgUrl;
        }

        public void setListImgUrl(String listImgUrl) {
            this.listImgUrl = listImgUrl;
        }

        public String getDescType() {
            return this.descType;
        }

        public void setDescType(String descType) {
            this.descType = descType;
        }

        public List<String> getDescImgUrlList() {
            return this.descImgUrlList;
        }

        public void setDescImgUrlList(List<String> descImgUrlList) {
            this.descImgUrlList = descImgUrlList;
        }

        public String getDescHtml() {
            return this.descHtml;
        }

        public void setDescHtml(String descHtml) {
            this.descHtml = descHtml;
        }
    }

    private static class Etc {
        private String parallelImportYn;
        private String parallelImportUrl;
        private String kcKidIsCertification;
        private List<KcKidCertificationList> kcKidCertificationList;
        private String kcLifeIsCertification;
        private List<KcLifeCertificationList> kcLifeCertificationList;
        private String kcElectricIsCertification;
        private List<KcElectricCertificationList> kcElectricCertificationList;
        private String kcReportIsCertification;
        private List<KcReportCertificationList> kcReportCertificationList;
        private String kcLifeChemistryIsCertification;
        private List<KcLifeChemistryCertificationList> kcLifeChemistryCertificationList;
        private String sellerProdCode;
        private String priceComparisonSiteYn;
        private String keywordPriceComparisonSite;
        private String keywordWemakeprice;
        private String isbn13;
        private String isbn10;
        private String displayOnlyDealYn;
        private String reviewDisp;
        private List<String> labelNoList;

        private Etc() {
        }
    }

    private static class KcElectricCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcElectricCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcKidCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcKidCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcLifeCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcLifeCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcLifeChemistryCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcLifeChemistryCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class KcReportCertificationList {
        private String certificationType;
        private String certificationNo;

        private KcReportCertificationList() {
        }

        public String getCertificationType() {
            return this.certificationType;
        }

        public void setCertificationType(String certificationType) {
            this.certificationType = certificationType;
        }

        public String getCertificationNo() {
            return this.certificationNo;
        }

        public void setCertificationNo(String certificationNo) {
            this.certificationNo = certificationNo;
        }
    }

    private static class Maker {
        private String resultCode;
        private List<MakerData> data;
        private String error;

        private Maker() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<MakerData> getData() {
            return this.data;
        }

        public void setData(List<MakerData> data2) {
            this.data = data2;
        }
    }

    private static class MakerData {
        private String makerNo;
        private String makerName;
        private String makerNameEnglish;

        private MakerData() {
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getMakerName() {
            return this.makerName;
        }

        public void setMakerName(String makerName) {
            this.makerName = makerName;
        }

        public String getMakerNameEnglish() {
            return this.makerNameEnglish;
        }

        public void setMakerNameEnglish(String makerNameEnglish) {
            this.makerNameEnglish = makerNameEnglish;
        }
    }

    private static class MakerSearch {
        private String chgDt;
        private String chgNm;
        private String makerNm;
        private String makerNmEng;
        private String makerNo;
        private String regDt;
        private String regNm;
        private String siteUrl;
        private String useYn;

        private MakerSearch() {
        }

        public String getChgDt() {
            return this.chgDt;
        }

        public void setChgDt(String chgDt) {
            this.chgDt = chgDt;
        }

        public String getChgNm() {
            return this.chgNm;
        }

        public void setChgNm(String chgNm) {
            this.chgNm = chgNm;
        }

        public String getMakerNm() {
            return this.makerNm;
        }

        public void setMakerNm(String makerNm) {
            this.makerNm = makerNm;
        }

        public String getMakerNmEng() {
            return this.makerNmEng;
        }

        public void setMakerNmEng(String makerNmEng) {
            this.makerNmEng = makerNmEng;
        }

        public String getMakerNo() {
            return this.makerNo;
        }

        public void setMakerNo(String makerNo) {
            this.makerNo = makerNo;
        }

        public String getRegDt() {
            return this.regDt;
        }

        public void setRegDt(String regDt) {
            this.regDt = regDt;
        }

        public String getRegNm() {
            return this.regNm;
        }

        public void setRegNm(String regNm) {
            this.regNm = regNm;
        }

        public String getSiteUrl() {
            return this.siteUrl;
        }

        public void setSiteUrl(String siteUrl) {
            this.siteUrl = siteUrl;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }
    }

    private static class NoticeData {
        private String groupNoticeNo;
        private String groupNoticeNoName;
        private List<NoticeLists> noticeList;

        private NoticeData() {
        }

        public String getGroupNoticeNo() {
            return this.groupNoticeNo;
        }

        public void setGroupNoticeNo(String groupNoticeNo) {
            this.groupNoticeNo = groupNoticeNo;
        }

        public String getGroupNoticeNoName() {
            return this.groupNoticeNoName;
        }

        public void setGroupNoticeNoName(String groupNoticeNoName) {
            this.groupNoticeNoName = groupNoticeNoName;
        }

        public List<NoticeLists> getNoticeList() {
            return this.noticeList;
        }

        public void setNoticeList(List<NoticeLists> noticeList) {
            this.noticeList = noticeList;
        }
    }

    private static class NoticeListMain {
        private String groupNoticeNo;
        private List<NoticeListValue> noticeList = new ArrayList<NoticeListValue>();

        private NoticeListMain() {
        }

        public String getGroupNoticeNo() {
            return this.groupNoticeNo;
        }

        public void setGroupNoticeNo(String groupNoticeNo) {
            this.groupNoticeNo = groupNoticeNo;
        }

        public List<NoticeListValue> getNoticeList() {
            return this.noticeList;
        }

        public void setNoticeList(List<NoticeListValue> noticeList) {
            this.noticeList = noticeList;
        }
    }

    private static class NoticeListValue {
        private String noticeNo;
        private String description;

        private NoticeListValue() {
        }

        public String getNoticeNo() {
            return this.noticeNo;
        }

        public void setNoticeNo(String noticeNo) {
            this.noticeNo = noticeNo;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    private static class NoticeLists {
        private String noticeNo;
        private String noticeName;
        private String defaltValue;

        private NoticeLists() {
        }

        public String getNoticeNo() {
            return this.noticeNo;
        }

        public void setNoticeNo(String noticeNo) {
            this.noticeNo = noticeNo;
        }

        public String getNoticeName() {
            return this.noticeName;
        }

        public void setNoticeName(String noticeName) {
            this.noticeName = noticeName;
        }

        public String getDefaltValue() {
            return this.defaltValue;
        }

        public void setDefaltValue(String defaltValue) {
            this.defaltValue = defaltValue;
        }
    }

    private static class NoticeType {
        private int gnoticeNo;
        private int noticeNo;
        private String noticeNm;
        private int priority;
        private String commentType;
        private String commentTypeName;
        private String placeholder;
        private String useYn;
        private String prodDesc;

        private NoticeType() {
        }

        public int getGnoticeNo() {
            return this.gnoticeNo;
        }

        public void setGnoticeNo(int gnoticeNo) {
            this.gnoticeNo = gnoticeNo;
        }

        public int getNoticeNo() {
            return this.noticeNo;
        }

        public void setNoticeNo(int noticeNo) {
            this.noticeNo = noticeNo;
        }

        public String getNoticeNm() {
            return this.noticeNm;
        }

        public void setNoticeNm(String noticeNm) {
            this.noticeNm = noticeNm;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public String getCommentType() {
            return this.commentType;
        }

        public void setCommentType(String commentType) {
            this.commentType = commentType;
        }

        public String getCommentTypeName() {
            return this.commentTypeName;
        }

        public void setCommentTypeName(String commentTypeName) {
            this.commentTypeName = commentTypeName;
        }

        public String getPlaceholder() {
            return this.placeholder;
        }

        public void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }

        public String getProdDesc() {
            return this.prodDesc;
        }

        public void setProdDesc(String prodDesc) {
            this.prodDesc = prodDesc;
        }
    }

    private static class NoticeTypeGET {
        private String resultCode;
        private List<NoticeData> data;
        private String error;

        private NoticeTypeGET() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<NoticeData> getData() {
            return this.data;
        }

        public void setData(List<NoticeData> data2) {
            this.data = data2;
        }
    }

    private static class Option {
        private String selectOptionUseYn;
        private String selectOptionDepth;
        private String selectOptionTitle1;
        private String selectOptionTitle2;
        private String selectOptionTitle3;
        private String selectOptionTitle4;
        private String selectOptionTitle5;
        private List<SelectOptionValueList> selectOptionValueList;
        private String textOptionUseYn;
        private String textOptionDepth;
        private String textOptionTitle1;
        private String textOptionTitle2;

        private Option() {
        }

        public String getSelectOptionUseYn() {
            return this.selectOptionUseYn;
        }

        public void setSelectOptionUseYn(String selectOptionUseYn) {
            this.selectOptionUseYn = selectOptionUseYn;
        }

        public String getSelectOptionDepth() {
            return this.selectOptionDepth;
        }

        public void setSelectOptionDepth(String selectOptionDepth) {
            this.selectOptionDepth = selectOptionDepth;
        }

        public String getSelectOptionTitle1() {
            return this.selectOptionTitle1;
        }

        public void setSelectOptionTitle1(String selectOptionTitle1) {
            this.selectOptionTitle1 = selectOptionTitle1;
        }

        public String getSelectOptionTitle2() {
            return this.selectOptionTitle2;
        }

        public void setSelectOptionTitle2(String selectOptionTitle2) {
            this.selectOptionTitle2 = selectOptionTitle2;
        }

        public String getSelectOptionTitle3() {
            return this.selectOptionTitle3;
        }

        public void setSelectOptionTitle3(String selectOptionTitle3) {
            this.selectOptionTitle3 = selectOptionTitle3;
        }

        public String getSelectOptionTitle4() {
            return this.selectOptionTitle4;
        }

        public void setSelectOptionTitle4(String selectOptionTitle4) {
            this.selectOptionTitle4 = selectOptionTitle4;
        }

        public String getSelectOptionTitle5() {
            return this.selectOptionTitle5;
        }

        public void setSelectOptionTitle5(String selectOptionTitle5) {
            this.selectOptionTitle5 = selectOptionTitle5;
        }

        public List<SelectOptionValueList> getSelectOptionValueList() {
            return this.selectOptionValueList;
        }

        public void setSelectOptionValueList(List<SelectOptionValueList> selectOptionValueList) {
            this.selectOptionValueList = selectOptionValueList;
        }

        public String getTextOptionUseYn() {
            return this.textOptionUseYn;
        }

        public void setTextOptionUseYn(String textOptionUseYn) {
            this.textOptionUseYn = textOptionUseYn;
        }

        public String getTextOptionDepth() {
            return this.textOptionDepth;
        }

        public void setTextOptionDepth(String textOptionDepth) {
            this.textOptionDepth = textOptionDepth;
        }

        public String getTextOptionTitle1() {
            return this.textOptionTitle1;
        }

        public void setTextOptionTitle1(String textOptionTitle1) {
            this.textOptionTitle1 = textOptionTitle1;
        }

        public String getTextOptionTitle2() {
            return this.textOptionTitle2;
        }

        public void setTextOptionTitle2(String textOptionTitle2) {
            this.textOptionTitle2 = textOptionTitle2;
        }
    }

    private class OptionList {
        private OptionList() {
        }
    }

    private static class Sale {
        private String salePeriod;
        private String saleStartDate;
        private String saleEndDate;
        private String originPrice;
        private String salePrice;
        private String stockCount;
        private String taxYn;
        private String purchaseMinCount;
        private String purchaseLimitYn;
        private String purchaseLimitDuration;
        private String purchaseLimitDay;
        private String purchaseLimitCount;
        private String basketLimitYn;
        private String referencePriceType;

        private Sale() {
        }

        public String getSalePeriod() {
            return this.salePeriod;
        }

        public void setSalePeriod(String salePeriod) {
            this.salePeriod = salePeriod;
        }

        public String getSaleStartDate() {
            return this.saleStartDate;
        }

        public void setSaleStartDate(String saleStartDate) {
            this.saleStartDate = saleStartDate;
        }

        public String getSaleEndDate() {
            return this.saleEndDate;
        }

        public void setSaleEndDate(String saleEndDate) {
            this.saleEndDate = saleEndDate;
        }

        public String getOriginPrice() {
            return this.originPrice;
        }

        public void setOriginPrice(String originPrice) {
            this.originPrice = originPrice;
        }

        public String getSalePrice() {
            return this.salePrice;
        }

        public void setSalePrice(String salePrice) {
            this.salePrice = salePrice;
        }

        public String getStockCount() {
            return this.stockCount;
        }

        public void setStockCount(String stockCount) {
            this.stockCount = stockCount;
        }

        public String getTaxYn() {
            return this.taxYn;
        }

        public void setTaxYn(String taxYn) {
            this.taxYn = taxYn;
        }

        public String getPurchaseMinCount() {
            return this.purchaseMinCount;
        }

        public void setPurchaseMinCount(String purchaseMinCount) {
            this.purchaseMinCount = purchaseMinCount;
        }

        public String getPurchaseLimitYn() {
            return this.purchaseLimitYn;
        }

        public void setPurchaseLimitYn(String purchaseLimitYn) {
            this.purchaseLimitYn = purchaseLimitYn;
        }

        public String getPurchaseLimitDuration() {
            return this.purchaseLimitDuration;
        }

        public void setPurchaseLimitDuration(String purchaseLimitDuration) {
            this.purchaseLimitDuration = purchaseLimitDuration;
        }

        public String getPurchaseLimitDay() {
            return this.purchaseLimitDay;
        }

        public void setPurchaseLimitDay(String purchaseLimitDay) {
            this.purchaseLimitDay = purchaseLimitDay;
        }

        public String getPurchaseLimitCount() {
            return this.purchaseLimitCount;
        }

        public void setPurchaseLimitCount(String purchaseLimitCount) {
            this.purchaseLimitCount = purchaseLimitCount;
        }

        public String getBasketLimitYn() {
            return this.basketLimitYn;
        }

        public void setBasketLimitYn(String basketLimitYn) {
            this.basketLimitYn = basketLimitYn;
        }

        public String getReferencePriceType() {
            return this.referencePriceType;
        }

        public void setReferencePriceType(String referencePriceType) {
            this.referencePriceType = referencePriceType;
        }
    }

    private static class SelectOptionValueList {
        private String optionValue1;
        private String optionValue2;
        private String optionValue3;
        private String optionValue4;
        private String optionValue5;
        private String optAddPrice;
        private String stockCount;
        private String displayYn;
        private String sellerOptionCode;

        private SelectOptionValueList() {
        }

        public String getOptionValue1() {
            return this.optionValue1;
        }

        public void setOptionValue1(String optionValue1) {
            this.optionValue1 = optionValue1;
        }

        public String getOptionValue2() {
            return this.optionValue2;
        }

        public void setOptionValue2(String optionValue2) {
            this.optionValue2 = optionValue2;
        }

        public String getOptionValue3() {
            return this.optionValue3;
        }

        public void setOptionValue3(String optionValue3) {
            this.optionValue3 = optionValue3;
        }

        public String getOptionValue4() {
            return this.optionValue4;
        }

        public void setOptionValue4(String optionValue4) {
            this.optionValue4 = optionValue4;
        }

        public String getOptionValue5() {
            return this.optionValue5;
        }

        public void setOptionValue5(String optionValue5) {
            this.optionValue5 = optionValue5;
        }

        public String getOptAddPrice() {
            return this.optAddPrice;
        }

        public void setOptAddPrice(String optAddPrice) {
            this.optAddPrice = optAddPrice;
        }

        public String getStockCount() {
            return this.stockCount;
        }

        public void setStockCount(String stockCount) {
            this.stockCount = stockCount;
        }

        public String getDisplayYn() {
            return this.displayYn;
        }

        public void setDisplayYn(String displayYn) {
            this.displayYn = displayYn;
        }

        public String getSellerOptionCode() {
            return this.sellerOptionCode;
        }

        public void setSellerOptionCode(String sellerOptionCode) {
            this.sellerOptionCode = sellerOptionCode;
        }
    }

    private static class ShipInfo {
        private String claimShipFee;
        private String releaseZipCode;
        private String releaseRoadAddress1;
        private String releaseRoadAddress2;
        private String releaseAddress1;
        private String releaseAddress2;
        private String returnZipCode;
        private String returnRoadAddress1;
        private String returnRoadAddress2;
        private String returnAddress1;
        private String returnAddress2;
        private String releaseDay;
        private String releaseTime;
        private String holidayExceptYn;

        private ShipInfo() {
        }

        public String getClaimShipFee() {
            return this.claimShipFee;
        }

        public void setClaimShipFee(String claimShipFee) {
            this.claimShipFee = claimShipFee;
        }

        public String getReleaseZipCode() {
            return this.releaseZipCode;
        }

        public void setReleaseZipCode(String releaseZipCode) {
            this.releaseZipCode = releaseZipCode;
        }

        public String getReleaseRoadAddress1() {
            return this.releaseRoadAddress1;
        }

        public void setReleaseRoadAddress1(String releaseRoadAddress1) {
            this.releaseRoadAddress1 = releaseRoadAddress1;
        }

        public String getReleaseRoadAddress2() {
            return this.releaseRoadAddress2;
        }

        public void setReleaseRoadAddress2(String releaseRoadAddress2) {
            this.releaseRoadAddress2 = releaseRoadAddress2;
        }

        public String getReleaseAddress1() {
            return this.releaseAddress1;
        }

        public void setReleaseAddress1(String releaseAddress1) {
            this.releaseAddress1 = releaseAddress1;
        }

        public String getReleaseAddress2() {
            return this.releaseAddress2;
        }

        public void setReleaseAddress2(String releaseAddress2) {
            this.releaseAddress2 = releaseAddress2;
        }

        public String getReturnZipCode() {
            return this.returnZipCode;
        }

        public void setReturnZipCode(String returnZipCode) {
            this.returnZipCode = returnZipCode;
        }

        public String getReturnRoadAddress1() {
            return this.returnRoadAddress1;
        }

        public void setReturnRoadAddress1(String returnRoadAddress1) {
            this.returnRoadAddress1 = returnRoadAddress1;
        }

        public String getReturnRoadAddress2() {
            return this.returnRoadAddress2;
        }

        public void setReturnRoadAddress2(String returnRoadAddress2) {
            this.returnRoadAddress2 = returnRoadAddress2;
        }

        public String getReturnAddress1() {
            return this.returnAddress1;
        }

        public void setReturnAddress1(String returnAddress1) {
            this.returnAddress1 = returnAddress1;
        }

        public String getReturnAddress2() {
            return this.returnAddress2;
        }

        public void setReturnAddress2(String returnAddress2) {
            this.returnAddress2 = returnAddress2;
        }

        public String getReleaseDay() {
            return this.releaseDay;
        }

        public void setReleaseDay(String releaseDay) {
            this.releaseDay = releaseDay;
        }

        public String getReleaseTime() {
            return this.releaseTime;
        }

        public void setReleaseTime(String releaseTime) {
            this.releaseTime = releaseTime;
        }

        public String getHolidayExceptYn() {
            return this.holidayExceptYn;
        }

        public void setHolidayExceptYn(String holidayExceptYn) {
            this.holidayExceptYn = holidayExceptYn;
        }
    }

    private static class ShipPolicy {
        private int shipPolicyNo;
        private String shipPolicyNm;
        private String defaultYn;
        private String shipMng;
        private String shipMngNm;
        private String warehouseInside;
        private String warehouseOutside;
        private String shipMethod;
        private String shipMethodNm;
        private String releaseDay;
        private String holidayExceptYn;
        private String holidayExceptYnNm;
        private String bundleKind;
        private String bundleKindNm;
        private String shipType;
        private String shipTypeNm;
        private String shipFee;
        private String shipFeeDispYn;
        private String shipFeeDispYnNm;
        private String freeCondition;
        private String diffYn;
        private String prepaymentYn;
        private String claimShipFee;
        private String shipArea;
        private String shipAreaNm;
        private String releaseZipcode;
        private String releaseAddr1;
        private String releaseAddr2;
        private String releaseRoadAddr1;
        private String releaseRoadAddr2;
        private String returnZipcode;
        private String returnAddr1;
        private String returnAddr2;
        private String returnRoadAddr1;
        private String returnRoadAddr2;
        private String useYn;
        private String safetyNoDispYn;
        private String safetyNoDispYnNm;

        private ShipPolicy() {
        }

        public int getShipPolicyNo() {
            return this.shipPolicyNo;
        }

        public void setShipPolicyNo(int shipPolicyNo) {
            this.shipPolicyNo = shipPolicyNo;
        }

        public String getShipPolicyNm() {
            return this.shipPolicyNm;
        }

        public void setShipPolicyNm(String shipPolicyNm) {
            this.shipPolicyNm = shipPolicyNm;
        }

        public String getDefaultYn() {
            return this.defaultYn;
        }

        public void setDefaultYn(String defaultYn) {
            this.defaultYn = defaultYn;
        }

        public String getShipMng() {
            return this.shipMng;
        }

        public void setShipMng(String shipMng) {
            this.shipMng = shipMng;
        }

        public String getShipMngNm() {
            return this.shipMngNm;
        }

        public void setShipMngNm(String shipMngNm) {
            this.shipMngNm = shipMngNm;
        }

        public String getWarehouseInside() {
            return this.warehouseInside;
        }

        public void setWarehouseInside(String warehouseInside) {
            this.warehouseInside = warehouseInside;
        }

        public String getWarehouseOutside() {
            return this.warehouseOutside;
        }

        public void setWarehouseOutside(String warehouseOutside) {
            this.warehouseOutside = warehouseOutside;
        }

        public String getShipMethod() {
            return this.shipMethod;
        }

        public void setShipMethod(String shipMethod) {
            this.shipMethod = shipMethod;
        }

        public String getShipMethodNm() {
            return this.shipMethodNm;
        }

        public void setShipMethodNm(String shipMethodNm) {
            this.shipMethodNm = shipMethodNm;
        }

        public String getReleaseDay() {
            return this.releaseDay;
        }

        public void setReleaseDay(String releaseDay) {
            this.releaseDay = releaseDay;
        }

        public String getHolidayExceptYn() {
            return this.holidayExceptYn;
        }

        public void setHolidayExceptYn(String holidayExceptYn) {
            this.holidayExceptYn = holidayExceptYn;
        }

        public String getHolidayExceptYnNm() {
            return this.holidayExceptYnNm;
        }

        public void setHolidayExceptYnNm(String holidayExceptYnNm) {
            this.holidayExceptYnNm = holidayExceptYnNm;
        }

        public String getBundleKind() {
            return this.bundleKind;
        }

        public void setBundleKind(String bundleKind) {
            this.bundleKind = bundleKind;
        }

        public String getBundleKindNm() {
            return this.bundleKindNm;
        }

        public void setBundleKindNm(String bundleKindNm) {
            this.bundleKindNm = bundleKindNm;
        }

        public String getShipType() {
            return this.shipType;
        }

        public void setShipType(String shipType) {
            this.shipType = shipType;
        }

        public String getShipTypeNm() {
            return this.shipTypeNm;
        }

        public void setShipTypeNm(String shipTypeNm) {
            this.shipTypeNm = shipTypeNm;
        }

        public String getShipFee() {
            return this.shipFee;
        }

        public void setShipFee(String shipFee) {
            this.shipFee = shipFee;
        }

        public String getShipFeeDispYn() {
            return this.shipFeeDispYn;
        }

        public void setShipFeeDispYn(String shipFeeDispYn) {
            this.shipFeeDispYn = shipFeeDispYn;
        }

        public String getShipFeeDispYnNm() {
            return this.shipFeeDispYnNm;
        }

        public void setShipFeeDispYnNm(String shipFeeDispYnNm) {
            this.shipFeeDispYnNm = shipFeeDispYnNm;
        }

        public String getFreeCondition() {
            return this.freeCondition;
        }

        public void setFreeCondition(String freeCondition) {
            this.freeCondition = freeCondition;
        }

        public String getDiffYn() {
            return this.diffYn;
        }

        public void setDiffYn(String diffYn) {
            this.diffYn = diffYn;
        }

        public String getPrepaymentYn() {
            return this.prepaymentYn;
        }

        public void setPrepaymentYn(String prepaymentYn) {
            this.prepaymentYn = prepaymentYn;
        }

        public String getClaimShipFee() {
            return this.claimShipFee;
        }

        public void setClaimShipFee(String claimShipFee) {
            this.claimShipFee = claimShipFee;
        }

        public String getShipArea() {
            return this.shipArea;
        }

        public void setShipArea(String shipArea) {
            this.shipArea = shipArea;
        }

        public String getShipAreaNm() {
            return this.shipAreaNm;
        }

        public void setShipAreaNm(String shipAreaNm) {
            this.shipAreaNm = shipAreaNm;
        }

        public String getReleaseZipcode() {
            return this.releaseZipcode;
        }

        public void setReleaseZipcode(String releaseZipcode) {
            this.releaseZipcode = releaseZipcode;
        }

        public String getReleaseAddr1() {
            return this.releaseAddr1;
        }

        public void setReleaseAddr1(String releaseAddr1) {
            this.releaseAddr1 = releaseAddr1;
        }

        public String getReleaseAddr2() {
            return this.releaseAddr2;
        }

        public void setReleaseAddr2(String releaseAddr2) {
            this.releaseAddr2 = releaseAddr2;
        }

        public String getReleaseRoadAddr1() {
            return this.releaseRoadAddr1;
        }

        public void setReleaseRoadAddr1(String releaseRoadAddr1) {
            this.releaseRoadAddr1 = releaseRoadAddr1;
        }

        public String getReleaseRoadAddr2() {
            return this.releaseRoadAddr2;
        }

        public void setReleaseRoadAddr2(String releaseRoadAddr2) {
            this.releaseRoadAddr2 = releaseRoadAddr2;
        }

        public String getReturnZipcode() {
            return this.returnZipcode;
        }

        public void setReturnZipcode(String returnZipcode) {
            this.returnZipcode = returnZipcode;
        }

        public String getReturnAddr1() {
            return this.returnAddr1;
        }

        public void setReturnAddr1(String returnAddr1) {
            this.returnAddr1 = returnAddr1;
        }

        public String getReturnAddr2() {
            return this.returnAddr2;
        }

        public void setReturnAddr2(String returnAddr2) {
            this.returnAddr2 = returnAddr2;
        }

        public String getReturnRoadAddr1() {
            return this.returnRoadAddr1;
        }

        public void setReturnRoadAddr1(String returnRoadAddr1) {
            this.returnRoadAddr1 = returnRoadAddr1;
        }

        public String getReturnRoadAddr2() {
            return this.returnRoadAddr2;
        }

        public void setReturnRoadAddr2(String returnRoadAddr2) {
            this.returnRoadAddr2 = returnRoadAddr2;
        }

        public String getUseYn() {
            return this.useYn;
        }

        public void setUseYn(String useYn) {
            this.useYn = useYn;
        }

        public String getSafetyNoDispYn() {
            return this.safetyNoDispYn;
        }

        public void setSafetyNoDispYn(String safetyNoDispYn) {
            this.safetyNoDispYn = safetyNoDispYn;
        }

        public String getSafetyNoDispYnNm() {
            return this.safetyNoDispYnNm;
        }

        public void setSafetyNoDispYnNm(String safetyNoDispYnNm) {
            this.safetyNoDispYnNm = safetyNoDispYnNm;
        }
    }

    private static class Shippingpolicy {
        private String resultCode;
        private List<Data> data;
        private String error;

        private Shippingpolicy() {
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getResultCode() {
            return this.resultCode;
        }

        public void setResultCode(String resultCode) {
            this.resultCode = resultCode;
        }

        public List<Data> getData() {
            return this.data;
        }

        public void setData(List<Data> data2) {
            this.data = data2;
        }
    }

    private static class Upload_file {
        @JsonProperty(value="absolute_path")
        private String absolute_path;
        @JsonProperty(value="directory")
        private String directory;
        @JsonProperty(value="extension")
        private String extension;
        @JsonProperty(value="file_name")
        private String file_name;
        @JsonProperty(value="file_size")
        private String file_size;
        @JsonProperty(value="full_name")
        private String full_name;
        @JsonProperty(value="height")
        private String height;
        @JsonProperty(value="mime_type")
        private String mime_type;
        @JsonProperty(value="url")
        private String url;
        @JsonProperty(value="width")
        private String width;

        private Upload_file() {
        }
    }

    private static class WeMarketProductReg {
        private String productNo;
        private Basic basic;
        private Sale sale;
        private Detail detail;
        private Option option;
        private List<NoticeListMain> noticeList = new ArrayList<NoticeListMain>();
        private Etc etc;
        private BranchList branchList;

        private WeMarketProductReg() {
        }

        public List<NoticeListMain> getNoticeList() {
            return this.noticeList;
        }

        public void setNoticeList(List<NoticeListMain> noticeList) {
            this.noticeList = noticeList;
        }

        public String getProductNo() {
            return this.productNo;
        }

        public void setProductNo(String productNo) {
            this.productNo = productNo;
        }

        public Basic getBasic() {
            return this.basic;
        }

        public void setBasic(Basic basic) {
            this.basic = basic;
        }

        public Sale getSale() {
            return this.sale;
        }

        public void setSale(Sale sale) {
            this.sale = sale;
        }

        public Detail getDetail() {
            return this.detail;
        }

        public void setDetail(Detail detail) {
            this.detail = detail;
        }

        public Option getOption() {
            return this.option;
        }

        public void setOption(Option option2) {
            this.option = option2;
        }

        public Etc getEtc() {
            return this.etc;
        }

        public void setEtc(Etc etc) {
            this.etc = etc;
        }

        public BranchList getBranchList() {
            return this.branchList;
        }

        public void setBranchList(BranchList branchList) {
            this.branchList = branchList;
        }
    }

    private static class fileArr {
        @JsonProperty(value="original_file")
        private String original_file;
        @JsonProperty(value="upload_file")
        private Upload_file upload_file;

        private fileArr() {
        }
    }
}

