/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.jcef;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.cef.callback.CefCookieVisitor;
import org.cef.misc.BoolRef;
import org.cef.network.CefCookie;
import org.cef.network.CefCookieManager;

public class CookieManagerDialog
extends JDialog {
    private static int testCookieId = 1;
    private final CefCookieManager manager;
    private final CookieTableModel tblModel = new CookieTableModel();

    public CookieManagerDialog(Frame owner, String title, CefCookieManager cookieManager) {
        super(owner, title, false);
        this.setLayout(new BorderLayout());
        this.setSize(800, 600);
        this.manager = cookieManager;
        JTable cookieTable = new JTable(this.tblModel);
        cookieTable.setFillsViewportHeight(true);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JButton delButton = new JButton("Delete cookies");
        delButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CookieManagerDialog.this.tblModel.removeCookies();
            }
        });
        controlPanel.add(delButton);
        JButton testCreateCookie = new JButton("Add test cookie");
        testCreateCookie.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name;
                CefCookie cookie;
                Date now = new Date();
                Date expires = new Date(now.getTime() + 86400000L);
                if (CookieManagerDialog.this.manager.setCookie("http://my.test.cookie", cookie = new CefCookie(name = "testNo" + testCookieId++, "testCookie", ".test.cookie", "/", false, true, now, now, true, expires))) {
                    CookieManagerDialog.this.tblModel.visit(cookie, 1, 1, new BoolRef());
                }
            }
        });
        controlPanel.add(testCreateCookie);
        JButton doneButton = new JButton("Done");
        doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CookieManagerDialog.this.setVisible(false);
            }
        });
        controlPanel.add(doneButton);
        this.add(new JScrollPane(cookieTable));
        this.add((Component)controlPanel, "South");
        if (this.manager == null) {
            throw new NullPointerException("Cookie manager is null");
        }
        this.manager.visitAllCookies((CefCookieVisitor)this.tblModel);
    }

    private class CookieTableModel
    extends AbstractTableModel
    implements CefCookieVisitor {
        private final String[] columnNames;
        private Vector<Object[]> rowData = new Vector();

        public CookieTableModel() {
            this.columnNames = new String[]{"Name", "Value", "Domain", "Path", "Secure", "HTTP only", "Created", "Last Access", "Expires"};
        }

        public boolean visit(CefCookie cookie, int count, int total, BoolRef delete) {
            Object[] entry = new Object[]{cookie.name, cookie.value, cookie.domain, cookie.path, new Boolean(cookie.secure), new Boolean(cookie.httponly), cookie.creation, cookie.lastAccess, cookie.expires};
            int row = this.rowData.size();
            this.rowData.addElement(entry);
            this.fireTableRowsInserted(row, row);
            return true;
        }

        public void removeCookies() {
            int cnt = this.rowData.size();
            if (cnt > 0) {
                this.rowData.clear();
                CookieManagerDialog.this.manager.deleteCookies("", "");
                this.fireTableRowsDeleted(0, cnt - 1);
            }
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (this.rowData.size() > 0) {
                return this.rowData.get(0)[columnIndex].getClass();
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.rowData.get(rowIndex)[columnIndex];
        }
    }
}

