/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.QuestListDto;
import com.kdjsystem.mlink.tot.ui.MainView;
import com.kdjsystem.mlink.tot.ui.OrderListUpload11stManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public abstract class IShopOrderJob
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data2 = context.getJobDetail().getJobDataMap();
        ScheduleInfoDto scheduler = (ScheduleInfoDto)data2.get((Object)"Order");
        List list = (List)data2.get((Object)"SHOP");
        String execKey = (String)data2.get((Object)"EXEC_KEY");
        List<String> macAddressList = IShopCommonLogin.getLocalMacAddressListNotVirtual();
        if (!macAddressList.contains(execKey)) {
            return;
        }
        if (scheduler.getJobcd() == 2) {
            YDMAStringUtil.Print("\uc8fc\ubb38 EXECUTE \uc2dc\uc791");
            this.getOrderData(context, scheduler, list);
            this.getDomeOrderData(context, scheduler);
            this.setOrderExpress(context, scheduler, list);
            this.syncDomeOrderData(context, scheduler);
            this.triggerAutoSearchIfViewOpened();
        } else if (scheduler.getJobcd() == 1) {
            List<QuestListDto> qnalist = this.conVersion(list);
            YDMAStringUtil.Print("\ubb38\uc758 EXECUTE \uc2dc\uc791");
            this.getQuestion(context, scheduler, qnalist);
            this.getEmergency(context, scheduler, qnalist);
            this.getProductName(context, scheduler, qnalist);
            this.sendReply(context, scheduler, qnalist);
        }
    }

    private void triggerAutoSearchIfViewOpened() {
        Display.getDefault().syncExec(() -> {
            block7: {
                try {
                    IViewPart viewPart = null;
                    IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        try {
                            viewPart = window.getActivePage().showView(MainView.ID);
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                    if (!(viewPart instanceof MainView)) break block7;
                    MainView view = (MainView)viewPart;
                    CTabFolder mainTabFolder = view.getMainTabFolder();
                    CTabItem[] cTabItemArray = mainTabFolder.getItems();
                    int n3 = cTabItemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CTabItem item = cTabItemArray[n4];
                        Control ctrl = item.getControl();
                        if (ctrl != null && ctrl instanceof OrderListUpload11stManager) {
                            ((OrderListUpload11stManager)ctrl).bindData();
                            break;
                        }
                        ++n4;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected abstract int getOrderData(JobExecutionContext var1, ScheduleInfoDto var2, List<ShopOrderMstDto> var3);

    protected abstract int setConfirm(JobExecutionContext var1, ScheduleInfoDto var2, List<ShopOrderMstDto> var3);

    protected abstract int getNewOrder(JobExecutionContext var1, ScheduleInfoDto var2, List<ShopOrderMstDto> var3);

    protected abstract int getOrderSync(JobExecutionContext var1, ScheduleInfoDto var2, List<ShopOrderMstDto> var3);

    protected abstract int setOrderExpress(JobExecutionContext var1, ScheduleInfoDto var2, List<ShopOrderMstDto> var3);

    protected abstract int getQuestion(JobExecutionContext var1, ScheduleInfoDto var2, List<QuestListDto> var3);

    protected abstract int getEmergency(JobExecutionContext var1, ScheduleInfoDto var2, List<QuestListDto> var3);

    protected abstract int getProductName(JobExecutionContext var1, ScheduleInfoDto var2, List<QuestListDto> var3);

    protected abstract int sendReply(JobExecutionContext var1, ScheduleInfoDto var2, List<QuestListDto> var3);

    protected abstract int sendEmailNKakao(JobExecutionContext var1, ScheduleInfoDto var2, List<ShopOrderMstDto> var3);

    private List<QuestListDto> conVersion(List<ShopOrderMstDto> list) {
        ArrayList<QuestListDto> qnalist = new ArrayList<QuestListDto>();
        for (ShopOrderMstDto dto : list) {
            QuestListDto adddto = new QuestListDto();
            adddto.setApikey(dto.getApikey());
            adddto.setAuthkey1(dto.getAuthkey1());
            adddto.setAuthkey2(dto.getAuthKey2());
            adddto.setShopid(dto.getShop_userid());
            adddto.setShopnm(dto.getShopid());
            adddto.setShopPw(dto.getShopPw());
            adddto.setStartDt(dto.getStartDt());
            adddto.setEndDt(dto.getEndDt());
            qnalist.add(adddto);
        }
        return qnalist;
    }

    protected abstract int getDomeOrderData(JobExecutionContext var1, ScheduleInfoDto var2);

    protected abstract int syncDomeOrderData(JobExecutionContext var1, ScheduleInfoDto var2);
}

