/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.NaverCateApiInfoDto;
import com.kdjsystem.mlink.shop.dao.ProdReceiveSetDto;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.domesin.DomesinShopDao;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.ShoppingMallDao;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobProductReceive
implements Job {
    private static OkHttpClient client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    JsonParser parser = new JsonParser();
    JsonObject jsonObject = new JsonObject();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data2 = context.getJobDetail().getJobDataMap();
        List list = (List)data2.get((Object)"DOMESHOP");
        String execKey = (String)data2.get((Object)"EXEC_KEY");
        List<String> macAddressList = IShopCommonLogin.getLocalMacAddressListNotVirtual();
        if (!macAddressList.contains(execKey)) {
            return;
        }
        YDMAStringUtil.Print("\uc218\uc2e0/\uc800\uc7a5 \uc2a4\ucf00\uc974\ub7ec \uc2dc\uc791");
        this.receiveStart(list);
        YDMAStringUtil.Print("\uc218\uc2e0/\uc800\uc7a5 \uc2a4\ucf00\uc974\ub7ec \uc885\ub8cc");
    }

    private void receiveStart(List<ProdReceiveSetDto> list) {
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\uc0c1\ud488\uc218\uc2e0\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", list.size(), 100, true);
        int count = 0;
        ArrayList<NaverCateApiInfoDto> cateInfos = new ArrayList();
        try {
            cateInfos = ShopCommonDao.get().getNaverCateApiInfos();
        }
        catch (Exception e1) {
            YDMAStringUtil.Print("\ub124\uc774\ubc84 \uac80\uc0c9 api \uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + String.valueOf(e1) + "]");
            e1.printStackTrace();
        }
        for (ProdReceiveSetDto dto : list) {
            try {
                if (!dto.getExclude_date().equals("\uc624\ub298") && !dto.getExclude_date().equals("\uc5b4\uc81c") && !dto.getExclude_date().equals("7\uc77c")) continue;
                int limitPage = dto.getProdqty() / 1000;
                String domeName = ShopCommon.getDomeMallName(dto.getShopcd());
                if (count != 0) {
                    console.setValueBack("", count);
                    console.setValueBack("----------------------------------------------", count);
                    console.setValueBack("", count);
                }
                console.setValueBack(domeName + " \uc0c1\ud488 \uac00\uc838\uc624\uae30\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", count);
                HashMap<String, ProductResultDto> resultProdList = new HashMap<String, ProductResultDto>();
                ObjectMapper objectMapper = new ObjectMapper();
                Map parameters = (Map)objectMapper.readValue(dto.getParam(), Map.class);
                this.parametersSetting(parameters, dto);
                String response = this.getApiProduct(1, parameters);
                ProductResultDto productDome = MLinkCommon.get().getProductMapping(response, dto.getShopcd());
                int totalpage = YDMAStringUtil.convertToInt(productDome.total_page);
                int totalCount = YDMAStringUtil.convertToInt(productDome.total_count);
                console.setValueBack(String.format(domeName + " \ucd1d \ud398\uc774\uc9c0 : %s\ud398\uc774\uc9c0, \ucd1d \ub370\uc774\ud130 \uc218 : %s\uac74 \uc785\ub2c8\ub2e4. \n", totalpage, totalCount), count);
                boolean useNameChange = dto.getReg_target().split(",")[0].equals("Y");
                boolean[] boollist = new boolean[]{useNameChange, dto.getReg_target().split(",")[1].equals("Y"), dto.getReg_target().split(",")[2].equals("Y"), dto.getReg_target().split(",")[3].equals("Y"), dto.getReg_target().split(",")[4].equals("Y")};
                this.jsonObject = this.parser.parse(dto.getParam2()).getAsJsonObject();
                HashMap<String, String> replaceNameMap = new HashMap<String, String>();
                Pattern pattern = null;
                if (useNameChange) {
                    String[] beforeArr = this.jsonObject.get("before_word").getAsString().split(",");
                    String[] afterArr = this.jsonObject.get("after_word").getAsString().split(",", -1);
                    int minLength = Math.min(beforeArr.length, afterArr.length);
                    int num = 0;
                    while (num < minLength) {
                        replaceNameMap.put(beforeArr[num], afterArr[num]);
                        ++num;
                    }
                    String regex = replaceNameMap.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
                    pattern = Pattern.compile(regex);
                }
                this.process(Arrays.asList(productDome), 1, boollist, this.jsonObject, pattern, replaceNameMap, console, count, domeName, cateInfos);
                resultProdList.put("1", productDome);
                if (totalpage == 1 || totalpage == 0) {
                    console.setValueBack(domeName + " " + totalpage + "\ud398\uc774\uc9c0 \uac00\uc838\uc624\uae30\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4. \n", count);
                } else {
                    console.setValueBack(domeName + " 1\ud398\uc774\uc9c0 \uac00\uc838\uc624\uae30 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4. \n", count);
                    int k = 2;
                    while (k <= totalpage) {
                        if (k > limitPage) break;
                        response = this.getApiProduct(k, parameters);
                        productDome = MLinkCommon.get().getProductMapping(response, dto.getShopcd());
                        this.process(Arrays.asList(productDome), k, boollist, this.jsonObject, pattern, replaceNameMap, console, count, domeName, cateInfos);
                        console.setValueBack(domeName + " " + k + "\ud398\uc774\uc9c0 \uac00\uc838\uc624\uae30\ub97c \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4. \n", count);
                        resultProdList.put(String.valueOf(k), productDome);
                        ++k;
                    }
                }
                console.setValueBack(domeName + "\uc0c1\ud488 \uac00\uc838\uc624\uae30\ub97c \uc885\ub8cc\ud569\ub2c8\ub2e4.", count);
                if (totalCount == 0) {
                    console.setValueBack(domeName + " \uc800\uc7a5\ud560 \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", count);
                } else {
                    String saveType;
                    ArrayList<ProductItemDto> contents = new ArrayList<ProductItemDto>();
                    for (ProductResultDto resultDto : resultProdList.values()) {
                        contents.addAll(resultDto.items);
                    }
                    String string = saveType = this.jsonObject.has("save_type") ? this.jsonObject.get("save_type").getAsString() : null;
                    if ("ALL".equals(saveType)) {
                        this.saveExcel(this.jsonObject, domeName, contents, console, count);
                        this.saveDefault(domeName, contents, console, count);
                    } else if ("EXCEL".equals(saveType)) {
                        this.saveExcel(this.jsonObject, domeName, contents, console, count);
                    } else if ("MLINK".equals(saveType)) {
                        this.saveDefault(domeName, contents, console, count);
                    }
                }
                ++count;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int i = 0;
        while (i < 5) {
            console.setValueBack("\uc218\uc2e0 \uc791\uc5c5\uc774 \ub9c8\ubb34\ub9ac \ub418\uc5b4 " + String.valueOf(5 - i) + "\ucd08 \ub4a4\uc5d0 \ucc3d\uc774 \ub2eb\ud799\ub2c8\ub2e4.", count);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        console.end();
    }

    private void saveExcel(JsonObject jsonObject, String domeName, List<ProductItemDto> contents, YDMAProgressBar console, int count) throws Exception {
        console.setValueBack(domeName + " \uc5d1\uc140 \uc800\uc7a5\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", count);
        String savePath = jsonObject.get("save_path").getAsString();
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss"));
        String filePath = savePath + "\\" + domeName + "_" + timestamp + ".xlsx";
        this.printExpPickupList(filePath, contents);
        console.setValueBack(domeName + " \uc5d1\uc140 \uc800\uc7a5\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4.", count);
    }

    private void saveDefault(String domeName, List<ProductItemDto> contents, YDMAProgressBar console, int count) {
        console.setValueBack(domeName + " \uc800\uc7a5\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", count);
        this.save(contents, console);
        console.setValueBack(domeName + " \uc800\uc7a5\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4.", count);
    }

    /*
     * Exception decompiling
     */
    private void parametersSetting(Map<String, String> parameters, ProdReceiveSetDto dto) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[11] lbl77 : CaseStatement: default:\u000a, @NONE, blocks:[11] lbl77 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getApiProduct(int page, Map<String, String> parameters) throws Exception {
        String path = "/api/v1/b2bmall/find";
        ShopPreferencesDto dto1 = ShopCommonDao.get().getSystemConf();
        parameters.put("V_PAGE", String.valueOf(page));
        String postForm = MLinkCommon.get().convertToJson(parameters);
        String result = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            URIBuilder uriBuilder = new URIBuilder(URI.create(dto1.getUrl_prodrecv())).setPath(path);
            StringEntity params = new StringEntity(postForm, "UTF-8");
            client = HttpClients.createDefault();
            HttpPost requestPatch = new HttpPost(uriBuilder.build().toString());
            requestPatch.addHeader("content-type", "application/json");
            requestPatch.setEntity((HttpEntity)params);
            response = client.execute((HttpUriRequest)requestPatch);
            int status2 = response.getStatusLine().getStatusCode();
            if (status2 == 200) {
                InputStream is = response.getEntity().getContent();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                JsonObject resObject = (JsonObject)this.parser.parse((Reader)br);
                result = resObject.toString();
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
            if (client != null) {
                client.close();
            }
        }
        return result;
    }

    private void process(List<ProductResultDto> chunks, int page, boolean[] boolList, JsonObject jsonObject, Pattern pattern, Map<String, String> replaceNameMap, YDMAProgressBar console, int count, String domeName, List<NaverCateApiInfoDto> cateInfos) {
        for (ProductResultDto result : chunks) {
            console.setValueBack(String.format(domeName + " %s\ud398\uc774\uc9c0 \uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \uc911 ...", page), count);
            int lineCnt = 1000 * (page - 1) + 1;
            if (!(boolList[0] | boolList[1] | boolList[2] | boolList[3] | boolList[4])) continue;
            for (ProductItemDto item : result.items) {
                String code = "(" + String.valueOf(lineCnt) + ") ";
                if (boolList[1] && cateInfos.size() > 0) {
                    try {
                        code = code + JobProductReceive.saveTopCategoryInfoFromNaverByProductName(item, cateInfos);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    code = code + " [" + item.getIcode() + "] " + item.getIname();
                }
                console.setValueBack(code, count);
                if (boolList[0]) {
                    Matcher matcher = pattern.matcher(item.getIname());
                    StringBuffer afterName = new StringBuffer();
                    while (matcher.find()) {
                        if (replaceNameMap.get(matcher.group()) == null) continue;
                        matcher.appendReplacement(afterName, replaceNameMap.get(matcher.group()));
                    }
                    matcher.appendTail(afterName);
                    if (!item.getIname().equals(afterName.toString())) {
                        console.setValueBack("\uc0c1\ud488\uba85 \ubcc0\ud658 \ub2e8\uc5b4\uc5d0 \ub9e4\uce58\ub418\uc5b4 [" + item.getIname() + "] \u2192 [" + afterName.toString() + "]\ub85c \ubcc0\ud658\ud558\uc600\uc2b5\ub2c8\ub2e4.", count);
                        item.setIname(afterName.toString());
                    }
                }
                if (boolList[3]) {
                    String delivery_fee = jsonObject.get("delivery_fee").getAsString();
                    String r_delivery_fee = jsonObject.get("r_delivery_fee").getAsString();
                    if (!delivery_fee.equals("9999")) {
                        item.setDelivery_amount(delivery_fee);
                    }
                    if (!r_delivery_fee.equals("9999")) {
                        item.setR_delivery_amount(r_delivery_fee);
                    }
                }
                if (boolList[4]) {
                    String maker = jsonObject.get("maker").getAsString();
                    String brand = jsonObject.get("brand").getAsString();
                    if (!maker.equals("")) {
                        item.setMaker(maker);
                    }
                    if (!brand.equals("")) {
                        item.setBrand(brand);
                    }
                }
                ++lineCnt;
            }
        }
    }

    public static String saveTopCategoryInfoFromNaverByProductName(ProductItemDto dto, List<NaverCateApiInfoDto> cateInfos) throws Exception {
        String name = dto.getIname();
        String status2 = "N";
        Object text = "";
        String encodedName = null;
        try {
            encodedName = URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("\uac80\uc0c9\uc5b4 \uc778\ucf54\ub529 \uc2e4\ud328", e);
        }
        String url = "https://openapi.naver.com/v1/search/shop.json?query=" + encodedName + "&display=1&start=1&sort=sim";
        String body = "";
        boolean success = false;
        while (!success && !cateInfos.isEmpty()) {
            Request request2 = new Request.Builder().url(url).get().addHeader("X-Naver-Client-Id", cateInfos.get(0).getClientID()).addHeader("X-Naver-Client-Secret", cateInfos.get(0).getClientSecret()).build();
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try (Response response = client.newCall(request2).execute();){
                    body = response.body().string();
                    if (!response.isSuccessful()) {
                        if (body.contains("\ucd08\uacfc")) {
                            cateInfos.remove(0);
                            continue;
                        }
                        throw new Exception("\uc694\uccad \uc2e4\ud328: " + body);
                    }
                    success = true;
                    JsonParser parser = new JsonParser();
                    JsonObject object = parser.parse(body).getAsJsonObject();
                    if (object.get("total").getAsInt() == 0) {
                        YDMAStringUtil.Print("1.Not found:" + dto.getIcode() + name);
                        break;
                    }
                    JsonArray items = object.get("items").getAsJsonArray();
                    JsonObject item = items.get(0).getAsJsonObject();
                    String category1 = item.get("category1").getAsString();
                    String category2 = item.get("category2").getAsString();
                    String category3 = item.get("category3").getAsString();
                    String category4 = item.get("category4").getAsString();
                    StringJoiner cateJoiner = new StringJoiner(">");
                    if (!category1.isEmpty()) {
                        cateJoiner.add(category1);
                    }
                    if (!category2.isEmpty()) {
                        cateJoiner.add(category2);
                    }
                    if (!category3.isEmpty()) {
                        cateJoiner.add(category3);
                    }
                    if (!category4.isEmpty()) {
                        cateJoiner.add(category4);
                    }
                    String catFullName = cateJoiner.toString();
                    List<List<String>> result = ShoppingMallDao.get().ShopSearchToCategoryKeyword("shop0055", catFullName);
                    if (result.size() <= 0) break;
                    String catInfo = ShopCommonDao.get().getEsCodeNaver(result.get(0).get(0));
                    String[] splitJson = catInfo.split("[|]");
                    if (splitJson.length > 1) {
                        dto.setEs(splitJson[0]);
                        dto.setCid(splitJson[0]);
                        dto.setClass_cd3(splitJson[0]);
                        dto.setCateg_nm(catFullName);
                        status2 = "Y";
                        continue;
                    }
                    YDMAStringUtil.Print("2.Not found:" + dto.getIcode() + name + result.get(0).get(0) + ", name :" + catFullName);
                    break;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                text = "[" + dto.getIcode() + "] " + name;
                return text;
            }
        }
        text = "[" + dto.getIcode() + "] ";
        if (status2.equals("Y")) {
            text = (String)text + dto.getCateg_nm() + " [ ";
        }
        text = (String)text + name;
        return text;
    }

    private void save(List<ProductItemDto> contents, YDMAProgressBar console) {
        int[] resultCount = new int[1];
        Display display = new Display();
        Shell shell = new Shell(display);
        String midi = "";
        String jobDetail = "SCHEDULER";
        try {
            try {
                if (DomesinShopDao.get().saveOrdInfo(midi, contents, resultCount, shell, jobDetail)) {
                    int failedCount = contents.size() - resultCount[0];
                    console.setValueBack(contents.size() + "\uac1c\uc758 \uc0c1\ud488 \uc911 " + resultCount[0] + "\uac1c\uc758 \ud574\ub2f9 \uc0c1\ud488\uc744 \ub4f1\ub85d\ud588\uc2b5\ub2c8\ub2e4. \uc2e4\ud328\uac74\uc218 [ " + failedCount + " ]\uac74", 2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!shell.isDisposed()) {
                    shell.dispose();
                }
                if (!display.isDisposed()) {
                    display.dispose();
                }
            }
        }
        finally {
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            if (!display.isDisposed()) {
                display.dispose();
            }
        }
    }

    private int printExpPickupList(String fileSavePath, List<ProductItemDto> params) throws Exception {
        String newfile = fileSavePath;
        String[] prod11stmst = new String[]{"search", "vender_code", "icode", "iname", "keyword", "img", "content", "select_option", "price", "islimit", "limit_price", "delivery_type", "delivery_amount", "r_delivery_amount", "delivery_qty", "isreturn", "itype", "tax", "icountry", "cate_depth", "cid", "categ_nm", "es", "gosi_code", "gosi1", "gosi2", "gosi3", "gosi4", "gosi5", "gosi6", "gosi7", "gosi8", "gosi9", "gosi10", "gosi11", "gosi12", "gosi13", "gosi14", "gosi15", "gosi16", "gosi17", "gosi18", "gosi19", "gosi20", "gosi21", "gosi22", "status", "maker", "brand", "reg_datetime", "up_datetime", "adult", "cert_type", "cert", "cert_no", "notice", "price_consumer", "text_option", "is_overseas", "reg_datetime", "es_coupang", "es_auction", "esm_auction", "es_gmarket", "esm_gmarket", "es_11st", "es_interpark", "es_storefarm", "es_wemarket", "es_kakao", "es_tmon", " es_ssg", "es_lotteon", "es_melchi", "es_tossShopping", "es_alwayz"};
        String[] prod11stmst_name = new String[]{"\ub3c4\ub9e4\ubab0\ucf54\ub4dc", "\uacf5\uae09\uc0ac\ucf54\ub4dc", "\uc0c1\ud488\ucf54\ub4dc", "\uc0c1\ud488\uba85", "\ud0a4\uc6cc\ub4dc", "\uc0c1\ud488\uc774\ubbf8\uc9c0", "\uc0c1\ud488\uc0c1\uc138\uc124\uba85", "\uc635\uc158", "\uc6d0\uac00", "\uac00\uaca9\uc815\ucc45\n0:\uc790\uc728\ud310\ub9e4,1:\ud310\ub9e4\uac00 \uc900\uc218\uc0c1\ud488", "\uac00\uaca9\uc900\uc218\uac00", "\ubc30\uc1a1\uc815\ucc45\t\n0:\uae30\ubcf8\ubc30\uc1a1,1:\ubb34\ub8cc\ubc30\uc1a1,2:\ucc29\ubd88\ubc30\uc1a1,\uc218\ub7c9\ubcc4 \ubc30\uc1a1", "\ubc30\uc1a1\ube44", "\ubc18\ud488\ubc30\uc1a1\ube44", "\ubb36\uc74c\ubc30\uc1a1\uc218\ub7c9", "\ubc18\ud488\uc815\ucc45\n0:\ubc18\ud488\ubd88\uac00,1:\ubc18\ud488\uac00\ub2a5", "\uc0c1\ud488\uad6c\ubd84\n0:\uc0c8\uc0c1\ud488,1:\uc911\uace0\uc0c1\ud488", "\uacfc\uc138/\uba74\uc138\n0:\uacfc\uc138,1:\uba74\uc138", "\uc6d0\uc0b0\uc9c0", "", "\ub3c4\ub9e4 \uce74\ud14c\uace0\ub9ac\ucf54\ub4dc", "\ub3c4\ub9e4 \uce74\ud14c\uace0\ub9ac \uba85\uce6d", "\uc774\uc140\ub7ec\uc2a4\uce74\ud14c\uace0\ub9ac\ucf54\ub4dc", "\uc0c1\ud488\uace0\uc2dc\ucf54\ub4dc", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa91", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa92", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa93", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa94", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa95", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa96", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa97", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa98", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa99", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa910", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa911", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa912", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa913", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa914", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa915", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa916", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa917", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa918", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa919", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa920", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa921", "\uc0c1\ud488\uace0\uc2dc\ud56d\ubaa922", "\ud310\ub9e4\uc0c1\ud0dc", "\uc81c\uc870\uc0ac", "\ube0c\ub79c\ub4dc", "\ub4f1\ub85d\uc77c", "\uc218\uc815\uc77c", "\uc131\uc778\uc0c1\ud488\uc5ec\ubd80\n0:\uc804\uccb4\uc774\uc6a9\uac00,1:\uc131\uc778\uc804\uc6a9\uc0c1\ud488", "\uc778\uc99d\uad6c\ubd84\n0:\uc778\uc99d\ub300\uc0c1\uc544\ub2d8,1:\uc778\uc99d\ub300\uc0c1,2:\uc0c1\uc138\uc124\uba85\uc5d0 \ud45c\uae30", "\uc778\uc99d\uc120\ud0dd", "\uc778\uc99d\ubc88\ud638", "\uc0c1\ud488\uac1c\ubcc4\uacf5\uc9c0", "\uc77c\ubc18\uc18c\ube44\uc790 \uac00\uaca9", "\uc0c1\ud488\uc785\ub825\uc635\uc158", "\ud574\uc678\uc9c1\ubc30\uc1a1\uc5ec\ubd80\n0:\uad6d\ub0b4\ubc30\uc1a1\uc0c1\ud488,1:\ud574\uc678\uc9c1\ubc30\uc1a1\uc0c1\ud488", "\ub4f1\ub85d\uc77c\uc790", "\uce74\ud14c\uace0\ub9ac-\ucfe0\ud321", "\uce74\ud14c\uace0\ub9ac-\uc625\uc1581", "\uce74\ud14c\uace0\ub9ac-\uc625\uc1582", "\uce74\ud14c\uace0\ub9ac-\uc9c0\ub9c8\ucf131", "\uce74\ud14c\uace0\ub9ac-\uc9c0\ub9c8\ucf132", "\uce74\ud14c\uace0\ub9ac-11\ubc88\uac00", "\uce74\ud14c\uace0\ub9ac-\uc778\ud130\ud30c\ud06c", "\uce74\ud14c\uace0\ub9ac-\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4", "\uce74\ud14c\uace0\ub9ac-\uc704\uba54\ud504", "\uce74\ud14c\uace0\ub9ac-\uce74\uce74\uc624", "\uce74\ud14c\uace0\ub9ac-\ud2f0\ubaac", "\uce74\ud14c\uace0\ub9ac-SSG", "\uce74\ud14c\uace0\ub9ac-\ub86f\ub370\uc628", "\uce74\ud14c\uace0\ub9ac-\uba78\uce58\uc1fc\ud551", "\uce74\ud14c\uace0\ub9ac-\ud1a0\uc2a4\uc1fc\ud551", "\uce74\ud14c\uace0\ub9ac-\uc62c\uc6e8\uc774\uc988"};
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFColor color_pass = new XSSFColor();
        color_pass.setIndexed((int)IndexedColors.GREY_40_PERCENT.getIndex());
        XSSFCellStyle cs_center = workbook.createCellStyle();
        cs_center.setAlignment(HorizontalAlignment.CENTER);
        cs_center.setFillForegroundColor(color_pass);
        cs_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cs_center.setWrapText(true);
        XSSFSheet prodmanager = workbook.createSheet("\uc0c1\ud488\uad00\ub9ac");
        if (prodmanager == null) {
            return -1;
        }
        XSSFCellStyle cs_wrap = workbook.createCellStyle();
        cs_wrap.setWrapText(true);
        Row row_head2 = prodmanager.createRow(1);
        row_head2.setHeightInPoints(100.0f);
        row_head2.setRowStyle((CellStyle)cs_center);
        int i = 0;
        while (i < prod11stmst_name.length) {
            Cell cell = row_head2.createCell(i);
            cell.setCellValue(prod11stmst_name[i]);
            if (i == 3 || i == 4 || i == 5 || i == 6 || i == 7) {
                prodmanager.setColumnWidth(i, 8000);
            } else {
                prodmanager.setColumnWidth(i, 3000);
            }
            ++i;
        }
        int rowIdx = 2;
        for (ProductItemDto dto : params) {
            Row row = prodmanager.createRow(rowIdx);
            Cell cell = null;
            ObjectMapper oMapper = new ObjectMapper();
            Map map = (Map)oMapper.convertValue((Object)dto, Map.class);
            int idx = 0;
            String value = "";
            String[] stringArray = prod11stmst;
            int n = prod11stmst.length;
            int n2 = 0;
            while (n2 < n) {
                String colName = stringArray[n2];
                cell = row.createCell(idx++);
                value = map.get(colName) == null ? (colName.equals("es_tossShopping") || colName.equals("es_alwayz") ? " " : "") : map.get(colName).toString();
                cell.setCellValue(value);
                ++n2;
            }
            ++rowIdx;
        }
        FileOutputStream fileOut = new FileOutputStream(newfile);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
        return 0;
    }
}

