/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.common.IShopQuestion;
import com.kdjsystem.mlink.shop.common.ProductQuestionService;
import com.kdjsystem.mlink.shop.common.SchedulerService;
import com.kdjsystem.mlink.shop.common.ShopOrderContext;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDao;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopQuestionDao;
import com.kdjsystem.mlink.shop.job.IShopOrderJob;
import com.kdjsystem.mlink.shop.mlink.MLinkDomeOrderCollectConnection;
import com.kdjsystem.mlink.shop.mlink.MLinkDomeOrderProductSettingConnection;
import com.kdjsystem.mlink.shop.mlink.MLinkOrderConnection;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.AlimTalkChargeDao;
import com.kdjsystem.mlink.tot.data.dao.CompInfoDao;
import com.kdjsystem.mlink.tot.data.dao.QuestListDto;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openqa.selenium.chrome.ChromeDriver;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShopOrderJob
extends IShopOrderJob {
    static final Logger log = LoggerFactory.getLogger(ShopOrderJob.class);
    ChromeExtention chrome = ChromeExtention.getInstace();
    ChromeDriver driver = null;
    private String dateFrom;

    @Override
    protected int getOrderData(JobExecutionContext context, ScheduleInfoDto scheduler, List<ShopOrderMstDto> list) {
        boolean orderconf;
        boolean ordernew;
        Calendar cal = Calendar.getInstance();
        int dayOfWeek = cal.get(7);
        boolean sync = switch (dayOfWeek) {
            case 1 -> {
                ordernew = scheduler.getJobexe24().equals("Y");
                orderconf = scheduler.getJobexe14().equals("Y");
                yield scheduler.getJobexe34().equals("Y");
            }
            case 6 -> {
                ordernew = scheduler.getJobexe22().equals("Y");
                orderconf = scheduler.getJobexe12().equals("Y");
                yield scheduler.getJobexe32().equals("Y");
            }
            case 7 -> {
                ordernew = scheduler.getJobexe23().equals("Y");
                orderconf = scheduler.getJobexe13().equals("Y");
                yield scheduler.getJobexe33().equals("Y");
            }
            default -> {
                ordernew = scheduler.getJobexe21().equals("Y");
                orderconf = scheduler.getJobexe11().equals("Y");
                yield scheduler.getJobexe31().equals("Y");
            }
        };
        if (!(ordernew || orderconf || sync)) {
            return 0;
        }
        int maxcount = list.size();
        int count = 0;
        int tot_newordcnt = 0;
        int tot_sycordcnt = 0;
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\uc2a4\ucf00\uc974\ub7ec(\uc8fc\ubb38)", maxcount, 100, true);
        console.setValueBack("[INFO] \uc8fc\ubb38 \uc218\uc9d1 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 0);
        for (ShopOrderMstDto dto : list) {
            if (!dto.getEndDt().substring(0, 8).equals(YDMATimeUtil.getCurrentTime().substring(0, 8))) {
                LocalDate currentEndDate = LocalDate.parse(YDMATimeUtil.getCurrentTime().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd"));
                LocalDate pastEndDate = LocalDate.parse(dto.getEndDt().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd"));
                long daysBetween = ChronoUnit.DAYS.between(pastEndDate, currentEndDate);
                LocalDate pastStartDate = LocalDate.parse(dto.getStartDt().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd"));
                LocalDate currentStateDate = pastStartDate.plus(daysBetween, ChronoUnit.DAYS);
                dto.setStartDt(currentStateDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")) + "000000");
                dto.setEndDt(YDMATimeUtil.getCurrentTime().substring(0, 8) + "235959");
            }
            String shopinfo = String.format("[%s - %s(%s)]", dto.getShopnm(), dto.getShop_userid(), dto.getNickname());
            try {
                int newordcnt = 0;
                int sycordcnt = 0;
                List<ShopOrderMstDto> resultList = new ArrayList<ShopOrderMstDto>();
                if (ordernew) {
                    this.setValueBack(shopinfo + " \uc8fc\ubb38 \uc218\uc9d1\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", count, console);
                    resultList = MLinkOrderConnection.get().getOrderNew(dto);
                    newordcnt = resultList.size();
                    if (newordcnt > 0) {
                        ShopOrderDao.get().SaveOrderCreate(resultList, false);
                        this.logOrderDetails(resultList, count, "ORD_COLLECT", "\uc8fc\ubb38\uc744 \uc218\uc9d1\ud558\uc600\uc2b5\ub2c8\ub2e4.", "\uc131\uacf5", console);
                        if (orderconf) {
                            resultList = MLinkOrderConnection.get().getOrderConf(dto, resultList);
                            this.logOrderDetails(resultList, count, "ORD_CONFIRM", "\uc8fc\ubb38\uc744 \ud655\uc778\ud558\uc600\uc2b5\ub2c8\ub2e4.", "\uc131\uacf5", console);
                        }
                    }
                }
                if (sync && (resultList = MLinkOrderConnection.get().getOrderSync2(dto, resultList)).size() > 0) {
                    this.logOrderDetails(resultList, count, "ORD_SYNC", "\ub3d9\uae30\ud654\ub97c \uc644\ub8cc\ud558\uc600\uc2b5\ub2c8\ub2e4.", "\uc131\uacf5", console);
                }
                this.setValueBack(String.format(" \u2192 [\uacb0\uacfc] \uc2e0\uaddc\uc8fc\ubb38 %s\uac74, \ub3d9\uae30\ud654 %s\uac74", newordcnt, resultList.size()), ++count, console);
                this.setValueBack(shopinfo + " \uc8fc\ubb38 \uc218\uc9d1\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4.", count, console);
                this.setValueBack("---------------------------------------------------------------------------------------", count, console);
                tot_newordcnt += newordcnt;
                tot_sycordcnt += sycordcnt;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                console.setValueBack(shopinfo + String.format("\uc5d0\ub7ec\ubc1c\uc0dd : %s", ex.getMessage()), count);
                console.end();
            }
        }
        YDMAStringUtil.Print("\uc8fc\ubb38 EXECUTE \uc885\ub8cc");
        this.setValueBack(String.format("[\uc804\uccb4\uacb0\uacfc] \uc2e0\uaddc\uc8fc\ubb38 %s\uac74, \ub3d9\uae30\ud654 %s\uac74\uc785\ub2c8\ub2e4.", tot_newordcnt, tot_sycordcnt), count, console);
        this.setValueBack("5\ucd08 \ub4a4\uc5d0 \ucc3d\uc774 \ub2eb\ud799\ub2c8\ub2e4.", count, console);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        console.end();
        return 0;
    }

    private void logOrderDetails(List<ShopOrderMstDto> resultList, int count, String jobType, String header, String status2, YDMAProgressBar console) {
        if (resultList == null || resultList.isEmpty()) {
            return;
        }
        this.setValueBack(String.format(" \u2192 %s", header), count, console);
        for (ShopOrderMstDto item : resultList) {
            String option2 = item.getP_sku_value();
            String optionText = option2 == null || option2.isEmpty() ? "" : " | " + option2 + " ";
            String comment = String.format("     %s%s | %s\uac1c | %s\uc6d0", item.getP_product_name(), optionText, item.getSale_cnt(), item.getTotal_cost());
            String logMsg = String.format("%s%s | %s\uac1c | %s\uc6d0", item.getP_product_name(), optionText, item.getSale_cnt(), item.getTotal_cost());
            this.setValueBackAndJobLog(comment, count, item, jobType, status2, logMsg, console);
        }
    }

    @Override
    protected int setConfirm(JobExecutionContext context, ScheduleInfoDto value, List<ShopOrderMstDto> list) {
        try {
            String jobexe14;
            List<Object> datasource = new ArrayList();
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            this.dateFrom = new SimpleDateFormat("yyyyMMdd").format(date_from);
            String jobexe11 = value.getJobexe11() == null ? "" : value.getJobexe11();
            String jobexe12 = value.getJobexe12() == null ? "" : value.getJobexe12();
            String jobexe13 = value.getJobexe13() == null ? "" : value.getJobexe13();
            String string = jobexe14 = value.getJobexe14() == null ? "" : value.getJobexe14();
            if (jobexe11.equals("Y") || jobexe12.equals("Y") || jobexe13.equals("Y") || jobexe14.equals("Y")) {
                datasource = ShopOrderDao.get().getShopOrderList(this.dateFrom.concat("0000"), YDMATimeUtil.getCurrentDateHanjin().concat("2359"), "", "\ubd80\ubd84\uc77c\uce58", "", "REG_DATE");
                Map<String, List<ShopOrderMstDto>> mapList = datasource.stream().collect(Collectors.toList()).stream().collect(Collectors.groupingBy(ShopOrderMstDto::getShopid));
                if (value.getOutofexe() != null) {
                    String[] getdate;
                    String[] stringArray = getdate = value.getOutofexe().split(",");
                    int n = getdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String date = stringArray[n2];
                        if (!date.equals(YDMATimeUtil.getCurrentDateScheduler())) {
                            for (ShopOrderMstDto dto : list) {
                                String format = new SimpleDateFormat("yyyyMMdd").format(date_from);
                                dto.setStartDt(format.concat("0000"));
                                dto.setEndDt(YDMATimeUtil.getCurrentDateHanjin());
                                List<Object> resultList = new ArrayList();
                                resultList = mapList.get(dto.getShopid());
                                YDMAProgressBar.get().setValue(String.format(" -> \ud655\uc778(%s)\ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", dto.getShopid()), 0);
                                if (resultList == null || resultList.size() <= 0) continue;
                                MLinkOrderConnection.get().getOrderConf(dto, resultList);
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected int getNewOrder(JobExecutionContext context, ScheduleInfoDto value, List<ShopOrderMstDto> list) {
        Calendar calender_dateTime_from = Calendar.getInstance();
        calender_dateTime_from.add(5, -6);
        Date date_from = calender_dateTime_from.getTime();
        try {
            for (ShopOrderMstDto dto : list) {
                String shopinfo = String.format("%s", dto.getShop_userid());
                List<Object> resultList = new ArrayList();
                String format = new SimpleDateFormat("yyyyMMdd").format(date_from);
                dto.setStartDt(format.concat("0000"));
                if (dto.getShopid().equals("shop0075")) {
                    dto.setVendorId(dto.getApikey());
                }
                YDMAProgressBar.get().setValue(shopinfo + " ID \uc8fc\ubb38 \uc815\ubcf4 \uc218\uc9d1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
                resultList = MLinkOrderConnection.get().getOrderNew(dto);
                if (resultList.size() <= 0) continue;
                ShopOrderDao.get().SaveOrderCreate(resultList, false);
                int i = 0;
                while (i < resultList.size()) {
                    YDMAProgressBar.get().setValue(String.format(" -> \uc8fc\ubb38(%s)\uc744 \uc800\uc7a5\ud558\uc600\uc2b5\ub2c8\ub2e4. %s,%s(%s) %s \uc6d0", ((ShopOrderMstDto)resultList.get(i)).getMall_product_id(), ((ShopOrderMstDto)resultList.get(i)).getP_product_name(), ((ShopOrderMstDto)resultList.get(i)).getP_sku_value(), ((ShopOrderMstDto)resultList.get(i)).getSale_cnt(), ((ShopOrderMstDto)resultList.get(i)).getTotal_cost()), 0);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected int getOrderSync(JobExecutionContext context, ScheduleInfoDto value, List<ShopOrderMstDto> list) {
        try {
            String jobexe34;
            List<Object> datasource = new ArrayList();
            Calendar calender_dateTime_from = Calendar.getInstance();
            calender_dateTime_from.add(5, -6);
            Date date_from = calender_dateTime_from.getTime();
            String format = new SimpleDateFormat("yyyyMMdd").format(date_from);
            String jobexe31 = value.getJobexe31() == null ? "" : value.getJobexe31();
            String jobexe32 = value.getJobexe32() == null ? "" : value.getJobexe32();
            String jobexe33 = value.getJobexe33() == null ? "" : value.getJobexe33();
            String string = jobexe34 = value.getJobexe34() == null ? "" : value.getJobexe34();
            if (jobexe31.equals("Y") || jobexe32.equals("Y") || jobexe33.equals("Y") || jobexe34.equals("Y")) {
                datasource = ShopOrderDao.get().getShopOrderList(format.concat("0000"), YDMATimeUtil.getCurrentDateHanjin().concat("2359"), "", "\ubd80\ubd84\uc77c\uce58", "", "REG_DATE");
                Map<String, List<ShopOrderMstDto>> mapList = datasource.stream().collect(Collectors.toList()).stream().collect(Collectors.groupingBy(ShopOrderMstDto::getShopid));
                if (value.getOutofexe() != null) {
                    String[] getdate;
                    String[] stringArray = getdate = value.getOutofexe().split(",");
                    int n = getdate.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String date = stringArray[n2];
                        if (!date.equals(YDMATimeUtil.getCurrentDateScheduler())) {
                            for (ShopOrderMstDto dto : list) {
                                if (dto.getShopid().equals("shop0003") | dto.getShopid().equals("shop0055")) {
                                    dto.setStartDt(format.concat("0000"));
                                    dto.setEndDt(YDMATimeUtil.getCurrentDateHanjin().concat("2359"));
                                } else {
                                    dto.setStartDt(format);
                                    dto.setEndDt(YDMATimeUtil.getCurrentDateHanjin());
                                }
                                List<ShopOrderMstDto> resultList = mapList.get(dto.getShopid());
                                YDMAProgressBar.get().setValue(String.format(" -> \ub3d9\uae30\ud654(%s)\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", dto.getShopid()), 0);
                                MLinkOrderConnection.get().getOrderSync(dto, resultList);
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected int setOrderExpress(JobExecutionContext context, ScheduleInfoDto scheduler, List<ShopOrderMstDto> list) {
        int maxcount;
        List<ShopOrderMstDto> datasource;
        YDMAProgressBar console;
        block21: {
            block20: {
                console = new YDMAProgressBar();
                Calendar cal = Calendar.getInstance();
                int dayOfWeek = cal.get(7);
                if (switch (dayOfWeek) {
                    case 1 -> scheduler.getJobexe44().equals("Y");
                    case 6 -> scheduler.getJobexe42().equals("Y");
                    case 7 -> scheduler.getJobexe43().equals("Y");
                    default -> scheduler.getJobexe41().equals("Y");
                }) break block20;
                return 0;
            }
            LocalDateTime now = LocalDateTime.now();
            LocalDateTime oneWeekAgo = now.minusWeeks(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
            LocalDateTime endOfDay = now.withHour(23).withMinute(59).withSecond(0).withNano(0);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            String startDate = oneWeekAgo.format(formatter);
            String endDate = endOfDay.format(formatter);
            datasource = ShopOrderDao.get().getShopOrderListByScheduler(startDate, endDate, "'402'");
            if (scheduler.getSitechk().equals("Y")) {
                List items = list.stream().map(ShopOrderMstDto::getShopid).distinct().collect(Collectors.toList());
                datasource = datasource.stream().filter(dto -> items.contains(dto.getShopid())).collect(Collectors.toList());
            }
            if ((maxcount = datasource.size()) != 0) break block21;
            return 0;
        }
        try {
            Map<String, Map<String, List<ShopOrderMstDto>>> mapList = datasource.stream().collect(Collectors.groupingBy(ShopOrderMstDto::getShopid, Collectors.groupingBy(ShopOrderMstDto::getShop_userid)));
            console.startToBack("\uc2a4\ucf00\uc974\ub7ec(\uc8fc\ubb38)", maxcount, 100, true);
            console.setValueBack("[INFO] \uc1a1\uc7a5 \uc804\uc1a1 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 0);
            int count = 0;
            int tot_okCnt = 0;
            for (String shopid : mapList.keySet()) {
                Map<String, List<ShopOrderMstDto>> map = mapList.get(shopid);
                int newordcnt = 0;
                int okCnt = 0;
                int fail = 0;
                for (String shopUserID : map.keySet()) {
                    List<ShopOrderMstDto> listdto = map.get(shopUserID);
                    listdto = listdto.stream().filter(d -> !d.getCopyYN().equals("Y")).collect(Collectors.toList());
                    String shopinfo = String.format("[%s - %s(%s)]", listdto.get(0).getShopid(), listdto.get(0).getShop_userid(), listdto.get(0).getNickname());
                    console.setValueBack(shopinfo + " \uc1a1\uc7a5 \uc804\uc1a1\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", count);
                    listdto = ShopOrderContext.get().setContext(IShopOrderCommand.getContext(shopid, "403")).excute(listdto);
                    listdto = listdto.stream().filter(d -> d.getResult_code() != null && d.getResult_code().equals("1")).collect(Collectors.toList());
                    if (listdto.size() > 0) {
                        ShopOrderDao.get().SaveOrUpdate(listdto);
                        int i = 0;
                        while (i < listdto.size()) {
                            String headerText = " \u2192 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n     ";
                            String comment = String.format("%s | %s | %s\uac1c | %s\uc6d0", listdto.get(i).getReceive_name(), listdto.get(i).getP_product_name(), listdto.get(i).getSale_cnt(), listdto.get(i).getSale_cost());
                            this.setValueBackAndJobLog(headerText + comment, ++count, listdto.get(i), "ORD_DELV_SEND", "\uc131\uacf5", comment, console);
                            if (listdto.get(i).getResult_code().equals("1")) {
                                ++okCnt;
                            }
                            ++i;
                        }
                    } else {
                        console.setValueBack(String.format(" [\uacb0\uacfc] %s \ubc1c\uc1a1\ucc98\ub9ac\uc2e4\ud328. \uc1fc\ud551\ubab0 \uc0c1\ud0dc\uac12\uc744 \ud655\uc778 \ubd80\ud0c1\ub4dc\ub9bd\ub2c8\ub2e4. ", shopinfo), ++count);
                    }
                    newordcnt += listdto.size();
                }
                console.setValueBack(String.format(" [\uacb0\uacfc] %s %s\uac74 \uc911 \uc815\uc0c1  %s\uac74\uc744 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", shopid, newordcnt, okCnt), count += fail);
                tot_okCnt += okCnt;
            }
            console.setValueBack("---------------------------------------------------------------------------------------", count);
            console.setValueBack(String.format("[\uc804\uccb4\uacb0\uacfc] %s\uac74 \uc911 \uc815\uc0c1 %s\uac74\uc744 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4.", maxcount, tot_okCnt), count);
            console.setValueBack("\ubc1c\uc1a1 \uc791\uc5c5\uc774 \ub9c8\ubb34\ub9ac \ub418\uc5b4 5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 0);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            console.end();
        }
        catch (Exception e) {
            console.setValueBack(e.getMessage(), 0);
            console.setValueBack("\ubc1c\uc1a1 \uc791\uc5c5\uc774 \ub9c8\ubb34\ub9ac \ub418\uc5b4 5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 0);
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            console.end();
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected int sendEmailNKakao(JobExecutionContext context, ScheduleInfoDto value, List<ShopOrderMstDto> list) {
        YDMAStringUtil.Print("\uba54\uc77c\uc2dc\uc791");
        CompInfoDao dao = new CompInfoDao();
        try {
            String smschk;
            String kakao;
            AlimTalkChargeDao aldao = new AlimTalkChargeDao();
            List<Object> result = new ArrayList();
            List<String> complist = dao.getServerCompany();
            List<String> charge = aldao.getAlimTalkChargeList(complist.get(25));
            List<String> allist = aldao.getAlimTalkChargeList(complist.get(25));
            String email = value.getEmailchk() == null ? "" : value.getEmailchk();
            String string = kakao = value.getSmschk() == null ? "" : value.getSmschk();
            if (email.equals("Y")) {
                String emailaddr = value.getEmailaddr();
                SchedulerService.get().sendEmail(complist, emailaddr);
            }
            if (!kakao.equals("Y")) return 0;
            String smsno = value.getSmsno();
            String startdt = "";
            String enddt = "";
            Date end = null;
            Date start = null;
            Date now = null;
            String string2 = smschk = value.getDontchk() == null ? "" : value.getDontchk();
            if (smschk.equals("Y")) {
                startdt = value.getDontstr();
                enddt = value.getDontend();
                SimpleDateFormat format = new SimpleDateFormat("HH:mm");
                start = format.parse(startdt);
                end = format.parse(enddt);
                String now1 = YDMATimeUtil.getCurrentTimeOnlyKaKao();
                now = format.parse(now1);
                if (start.getTime() < now.getTime() && end.getTime() > now.getTime()) {
                    return 0;
                }
                result = SchedulerService.get().sendKakao(smsno, startdt, enddt, smschk, complist);
                aldao.updateMoneyKakaoInfo(YDMASessonUtil.getUserInfo().getUserId(), Integer.parseInt(charge.get(3)) + Integer.parseInt(allist.get(5)), Integer.parseInt(charge.get(4)) - Integer.parseInt(allist.get(5)), (String)result.get(6), "KAKAO", (String)result.get(5));
            } else {
                result = SchedulerService.get().sendKakao(smsno, startdt, enddt, smschk, complist);
                aldao.updateMoneyKakaoInfo(YDMASessonUtil.getUserInfo().getUserId(), Integer.parseInt(charge.get(3)) + Integer.parseInt(allist.get(5)), Integer.parseInt(charge.get(4)) - Integer.parseInt(allist.get(5)), (String)result.get(6), "KAKAO", (String)result.get(5));
            }
            YDMAStringUtil.Print();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public String splitMark(String text) {
        String[] split = text.split("-| ");
        Object complite = "";
        int j = 0;
        while (j < split.length) {
            complite = (String)complite + split[j];
            complite = ((String)complite).trim();
            ++j;
        }
        return complite;
    }

    @Override
    protected int getQuestion(JobExecutionContext context, ScheduleInfoDto value, List<QuestListDto> list) {
        try {
            String jobexe24;
            YDMAStringUtil.Print("\ubb38\uc758\uc218\uc9d1");
            YDMAStringUtil.Print("SHOP : " + list.get(0).getShopnm());
            YDMAStringUtil.Print("ID : " + list.get(0).getShopid());
            YDMAStringUtil.Print("PASS : " + list.get(0).getShopPw());
            String jobexe21 = value.getJobexe11() == null ? "" : value.getJobexe11();
            String jobexe22 = value.getJobexe12() == null ? "" : value.getJobexe12();
            String jobexe23 = value.getJobexe13() == null ? "" : value.getJobexe13();
            String string = jobexe24 = value.getJobexe14() == null ? "" : value.getJobexe14();
            if (jobexe21.equals("Y") | jobexe22.equals("Y") | jobexe23.equals("Y") | jobexe24.equals("Y") && value.getOutofexe() != null) {
                String[] getdate;
                String[] stringArray = getdate = value.getOutofexe().split(",");
                int n = getdate.length;
                int n2 = 0;
                while (n2 < n) {
                    String date = stringArray[n2];
                    if (!date.equals(YDMATimeUtil.getCurrentDateScheduler())) {
                        YDMAStringUtil.Print("\ub3cc\uc544\uac00\uace0 \uc788\ub294\uc9c0" + YDMATimeUtil.getCurrentTimeByNewFormat());
                        for (QuestListDto dto : list) {
                            ArrayList<QuestListDto> searchlist = new ArrayList<QuestListDto>();
                            List<QuestListDto> args = Arrays.asList(dto);
                            ProductQuestionService service = new ProductQuestionService(IShopQuestion.getSearchBean(dto.getShopnm()));
                            searchlist.addAll(service.excute(args));
                            if (searchlist.size() <= 0) continue;
                            ShopQuestionDao.get().SaveOrUpdate(searchlist);
                        }
                        YDMAStringUtil.Print("\ubb38\uc758\uc218\uc9d1 \ub05d ");
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected int getEmergency(JobExecutionContext context, ScheduleInfoDto value, List<QuestListDto> list) {
        try {
            String jobexe24;
            String jobexe21 = value.getJobexe21() == null ? "" : value.getJobexe21();
            String jobexe22 = value.getJobexe22() == null ? "" : value.getJobexe22();
            String jobexe23 = value.getJobexe23() == null ? "" : value.getJobexe23();
            String string = jobexe24 = value.getJobexe24() == null ? "" : value.getJobexe24();
            if (jobexe21.equals("Y") | jobexe22.equals("Y") | jobexe23.equals("Y") | jobexe24.equals("Y") && value.getOutofexe() != null) {
                String[] getdate;
                String[] stringArray = getdate = value.getOutofexe().split(",");
                int n = getdate.length;
                int n2 = 0;
                while (n2 < n) {
                    String date = stringArray[n2];
                    if (!date.equals(YDMATimeUtil.getCurrentDateScheduler())) {
                        YDMAStringUtil.Print("\ub3cc\uc544\uac00\uace0 \uc788\ub294\uc9c0" + YDMATimeUtil.getCurrentTimeByNewFormat());
                        for (QuestListDto dto : list) {
                            ArrayList<QuestListDto> searchlist = new ArrayList<QuestListDto>();
                            List<QuestListDto> args = Arrays.asList(dto);
                            ProductQuestionService service = new ProductQuestionService(IShopQuestion.getSearchBean(dto.getShopnm()));
                            searchlist.addAll(service.excute(args));
                            if (searchlist.size() <= 0) continue;
                            ShopQuestionDao.get().SaveOrUpdate(searchlist);
                        }
                        YDMAStringUtil.Print("\ubb38\uc758\uc218\uc9d1 \ub05d ");
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected int getProductName(JobExecutionContext context, ScheduleInfoDto value, List<QuestListDto> list) {
        try {
            String jobexe24;
            String jobexe21 = value.getJobexe31() == null ? "" : value.getJobexe31();
            String jobexe22 = value.getJobexe32() == null ? "" : value.getJobexe32();
            String jobexe23 = value.getJobexe33() == null ? "" : value.getJobexe33();
            String string = jobexe24 = value.getJobexe34() == null ? "" : value.getJobexe34();
            if (jobexe21.equals("Y") | jobexe22.equals("Y") | jobexe23.equals("Y") | jobexe24.equals("Y") && value.getOutofexe() != null) {
                String[] getdate;
                String[] stringArray = getdate = value.getOutofexe().split(",");
                int n = getdate.length;
                int n2 = 0;
                while (n2 < n) {
                    String date = stringArray[n2];
                    if (!date.equals(YDMATimeUtil.getCurrentDateScheduler())) {
                        YDMAStringUtil.Print("\ub3cc\uc544\uac00\uace0 \uc788\ub294\uc9c0" + YDMATimeUtil.getCurrentTimeByNewFormat());
                        for (QuestListDto dto : list) {
                            ArrayList<QuestListDto> searchlist = new ArrayList<QuestListDto>();
                            List<QuestListDto> args = Arrays.asList(dto);
                            ProductQuestionService service = new ProductQuestionService(IShopQuestion.getSearchBean(dto.getShopnm()));
                            searchlist.addAll(service.excute(args));
                            if (searchlist.size() <= 0) continue;
                            ShopQuestionDao.get().SaveOrUpdate(searchlist);
                        }
                        YDMAStringUtil.Print("\ubb38\uc758\uc218\uc9d1 \ub05d ");
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    protected int sendReply(JobExecutionContext context, ScheduleInfoDto value, List<QuestListDto> list) {
        block9: {
            try {
                String jobexe34;
                ArrayList<QuestListDto> quest = new ArrayList<QuestListDto>();
                List<Object> datasource = new ArrayList();
                String startdt = list.get(0).getStartDt() + "000000";
                String enddt = list.get(0).getEndDt() + "999999";
                datasource = ShopQuestionDao.get().QuestionAnswer(startdt, enddt, "REGDM");
                ArrayList<QuestListDto> resultList = new ArrayList<QuestListDto>();
                YDMAStringUtil.Print("\uc8fc\ubb38\ud655\uc778\uc2dc\uc791");
                String jobexe31 = value.getJobexe41() == null ? "" : value.getJobexe41();
                String jobexe32 = value.getJobexe42() == null ? "" : value.getJobexe42();
                String jobexe33 = value.getJobexe43() == null ? "" : value.getJobexe43();
                String string = jobexe34 = value.getJobexe44() == null ? "" : value.getJobexe44();
                if (jobexe31.equals("Y") | jobexe32.equals("Y") | jobexe33.equals("Y") | jobexe34.equals("Y")) {
                    if (value.getOutofexe() != null) {
                        String[] getdate;
                        String[] stringArray = getdate = value.getOutofexe().split(",");
                        int n = getdate.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String date = stringArray[n2];
                            if (!date.equals(YDMATimeUtil.getCurrentDateScheduler())) {
                                YDMAStringUtil.Print("\uc8fc\ubb38\ud655\uc778\ub3c8\ub2e41");
                                if (datasource.size() > 0) {
                                    for (QuestListDto questListDto : datasource) {
                                        resultList.add(questListDto);
                                        resultList = resultList.stream().filter(p -> p.getQnastat().equals("101")).collect(Collectors.toList());
                                        ProductQuestionService service = new ProductQuestionService(IShopQuestion.getEnrollmentBean(questListDto.getShopnm()));
                                        quest.addAll(service.excute(resultList));
                                        if (resultList != null && resultList.size() > 0) {
                                            ShopQuestionDao.get().SenddtUpdate(quest);
                                        }
                                        YDMAStringUtil.Print("\ub2f5\ubcc0\ud655\uc778 \ub05d ");
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    break block9;
                }
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    protected int getDomeOrderData(JobExecutionContext context, ScheduleInfoDto scheduler) {
        List<ShopOrderMstDto> list;
        boolean domeOrder;
        Calendar cal = Calendar.getInstance();
        int dayOfWeek = cal.get(7);
        boolean domeCollection = switch (dayOfWeek) {
            case 1 -> {
                domeOrder = scheduler.getJobexe54().equals("Y");
                yield scheduler.getJobexe64().equals("Y");
            }
            case 6 -> {
                domeOrder = scheduler.getJobexe52().equals("Y");
                yield scheduler.getJobexe62().equals("Y");
            }
            case 7 -> {
                domeOrder = scheduler.getJobexe53().equals("Y");
                yield scheduler.getJobexe63().equals("Y");
            }
            default -> {
                domeOrder = scheduler.getJobexe51().equals("Y");
                yield scheduler.getJobexe61().equals("Y");
            }
        };
        if (!domeOrder && !domeCollection) {
            return 0;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime oneWeekAgo = now.minusWeeks(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime endOfDay = now.withHour(23).withMinute(59).withSecond(0).withNano(0);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        String startDate = oneWeekAgo.format(formatter);
        String endDate = endOfDay.format(formatter);
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\uc2a4\ucf00\uc974\ub7ec(\uc8fc\ubb38)", 100, 100, true);
        ArrayList<String> items = new ArrayList<String>();
        if (scheduler.getSitechk().equals("Y")) {
            try {
                List<List<String>> content = ScheduleInfoDao.get().getScheduleSiteByJobcd(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), 4);
                for (List<String> a : content) {
                    items.add(a.get(2));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        if (domeOrder) {
            console.setValueBack("[INFO] \uc2e0\uaddc \uc8fc\ubb38 \uc0c1\ud488 \ub370\uc774\ud130\ub4e4\uc758 \ub3c4\ub9e4 \uc8fc\ubb38\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 0);
            try {
                list = ShopOrderDao.get().getShopOrderListByScheduler(startDate, endDate, "'100'");
                list = list.stream().filter(dto -> dto.getGoods_keyword() != null).collect(Collectors.toList());
                if (scheduler.getSitechk().equals("Y")) {
                    list = list.stream().filter(dto -> items.contains(dto.getGoods_keyword())).collect(Collectors.toList());
                }
                if (!list.isEmpty()) {
                    MLinkDomeOrderProductSettingConnection.get().SendDomeOrderAllByScheduller(list, oneWeekAgo.toString(), now.toString(), console);
                } else {
                    console.setValueBack("\ub3c4\ub9e4\uc8fc\ubb38 \ucc98\ub9ac\ud560 \uc2e0\uaddc\uc8fc\ubb38\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", 90);
                }
            }
            catch (Exception e) {
                console.setValueBack("\uc2e0\uaddc \uc8fc\ubb38 \uc0c1\ud488 \ub370\uc774\ud130\ub4e4\uc758 \ub3c4\ub9e4 \uc8fc\ubb38 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [" + String.valueOf(e) + "]", 100);
            }
            console.setValueBack("\uc2e0\uaddc \uc8fc\ubb38 \uc0c1\ud488 \ub370\uc774\ud130\ub4e4\uc758 \ub3c4\ub9e4 \uc8fc\ubb38\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4.", 100);
        }
        if (domeOrder && domeCollection) {
            console.setValueBack("", 0);
            console.setValueBack("--------------------------------------------------------------------------------------", 0);
            console.setValueBack("--------------------------------------------------------------------------------------", 0);
            console.setValueBack("", 0);
        }
        if (domeCollection) {
            console.setValueBack("[INFO] \ub3c4\ub9e4 \uc2e0\uaddc, \ub3c4\ub9e4 \uc900\ube44 \ub370\uc774\ud130\ub4e4\uc758 \ub3c4\ub9e4 \uc218\uc9d1\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 0);
            try {
                list = ShopOrderDao.get().getShopOrderListByScheduler(startDate, endDate, "'500','501'");
                if (scheduler.getSitechk().equals("Y")) {
                    list = list.stream().filter(dto -> dto.getGoods_keyword() != null && items.contains(dto.getGoods_keyword())).collect(Collectors.toList());
                }
                if (!list.isEmpty()) {
                    MLinkDomeOrderCollectConnection.get().CollectDomeOrderAll(null, null, list, null, null, oneWeekAgo.toString(), now.toString(), true, console);
                } else {
                    console.setValueBack("\ub3c4\ub9e4\uc218\uc9d1 \ucc98\ub9ac \ub300\uc0c1\uc778 [\ub3c4\ub9e4\uc2e0\uaddc], [\ub3c4\ub9e4\uc900\ube44] \uc0c1\ud0dc\uc758 \uc8fc\ubb38\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", 90);
                }
            }
            catch (Exception e) {
                console.setValueBack("\ub3c4\ub9e4 \uc2e0\uaddc, \ub3c4\ub9e4 \uc900\ube44 \ub370\uc774\ud130\ub4e4\uc758 \ub3c4\ub9e4 \uc218\uc9d1 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [" + String.valueOf(e) + "]", 100);
            }
            console.setValueBack("\ub3c4\ub9e4 \uc2e0\uaddc, \ub3c4\ub9e4 \uc900\ube44 \ub370\uc774\ud130\ub4e4\uc758 \ub3c4\ub9e4 \uc218\uc9d1\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4.", 100);
            console.setValueBack("", 0);
        }
        console.setValueBack("\ub3c4\ub9e4 \uc8fc\ubb38 \ubc0f \uc218\uc9d1 \uc791\uc5c5\uc774 \ub9c8\ubb34\ub9ac \ub418\uc5b4 5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 0);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        console.end();
        return 0;
    }

    @Override
    protected int syncDomeOrderData(JobExecutionContext context, ScheduleInfoDto scheduler) {
        Calendar cal = Calendar.getInstance();
        int dayOfWeek = cal.get(7);
        if (!(switch (dayOfWeek) {
            case 1 -> scheduler.getJobexe74().equals("Y");
            case 6 -> scheduler.getJobexe72().equals("Y");
            case 7 -> scheduler.getJobexe73().equals("Y");
            default -> scheduler.getJobexe71().equals("Y");
        })) {
            return 0;
        }
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime oneWeekAgo = now.minusWeeks(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
        LocalDateTime endOfDay = now.withHour(23).withMinute(59).withSecond(0).withNano(0);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        String startDate = oneWeekAgo.format(formatter);
        String endDate = endOfDay.format(formatter);
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\uc2a4\ucf00\uc974\ub7ec(\uc8fc\ubb38)", 100, 100, true);
        ArrayList<String> items = new ArrayList<String>();
        if (scheduler.getSitechk().equals("Y")) {
            try {
                List<List<String>> content = ScheduleInfoDao.get().getScheduleSiteByJobcd(Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()), 4);
                for (List<String> a : content) {
                    items.add(a.get(2));
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        console.setValueBack("[INFO] \ub3c4\ub9e4 \ub3d9\uae30\ud654 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 0);
        try {
            List<ShopOrderMstDto> list = ShopOrderDao.get().getShopOrderListByScheduler(startDate, endDate, "'500'");
            if (scheduler.getSitechk().equals("Y")) {
                list = list.stream().filter(dto -> dto.getGoods_keyword() != null && items.contains(dto.getGoods_keyword())).collect(Collectors.toList());
            }
            MLinkDomeOrderCollectConnection.get().CollectDomeOrderAllSync(null, null, list, null, null, oneWeekAgo.toString(), now.toString(), true, console);
        }
        catch (Exception e) {
            console.setValueBack("\ub3c4\ub9e4\uc2e0\uaddc \uc0c1\ud0dc\uc778 \uc8fc\ubb38 \uac74\uc5d0 \ub300\ud55c \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. (\uc5d0\ub7ec \uba54\uc138\uc9c0 : " + String.valueOf(e) + ")", 100);
        }
        console.setValueBack("\ub3c4\ub9e4 \ub3d9\uae30\ud654\ub97c \uc885\ub8cc\ud569\ub2c8\ub2e4.", 100);
        console.setValueBack("\ub3c4\ub9e4 \ub3d9\uae30\ud654 \uc791\uc5c5\uc774 \ub9c8\ubb34\ub9ac \ub418\uc5b4 5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 0);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        console.end();
        return 0;
    }

    private void setValueBack(String message, int value, YDMAProgressBar console) {
        console.setValueBack(message, value);
    }

    private void setValueBackAndJobLog(String title, int value, ShopOrderMstDto shopOrderMstDto, String jobType, String jobResult, String logMsg, YDMAProgressBar console) {
        console.setValueBackAndJobLogForOrder(title, value, shopOrderMstDto, jobType, "SCHEDULER", jobResult, logMsg);
    }
}

