/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.shop.liteOrder.DisplayColumnSettingDto;
import com.kdjsystem.mlink.shop.liteOrder.LiteOrderManagerDao;
import com.kdjsystem.mlink.shop.mlink.MLinkHelpArticleManager;
import com.kdjsystem.mlink.tot.common.YDMAHttpUtil;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ColumnOrderDialog
extends CommandDialog {
    private Table leftTable;
    private Table rightTable;
    private Button addBtn;
    private Button removeBtn;
    private Button upBtn;
    private Button downBtn;
    private Button topBtn;
    private Button bottomBtn;
    private String _classNm;
    private boolean isUserSetting = false;
    private List<DisplayColumnSettingDto> leftList = new ArrayList<DisplayColumnSettingDto>();
    private List<DisplayColumnSettingDto> rightList = new ArrayList<DisplayColumnSettingDto>();
    private Font FONT = SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0);
    private Font FONT_B = SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1);

    public ColumnOrderDialog(Shell parentShell, String classNm) {
        super(parentShell);
        this._classNm = classNm;
        this.init();
    }

    private void init() {
        try {
            this.isUserSetting = LiteOrderManagerDao.get().isUserSetting(this._classNm);
            if (!this.isUserSetting) {
                this.leftList = LiteOrderManagerDao.get().getDefaultSetting(this._classNm, "N");
                this.rightList = LiteOrderManagerDao.get().getDefaultSetting(this._classNm, "Y");
            } else {
                this.leftList = LiteOrderManagerDao.get().getUserSetting(this._classNm, "N");
                this.rightList = LiteOrderManagerDao.get().getUserSetting(this._classNm, "Y");
            }
        }
        catch (Exception exception) {}
    }

    private Composite createBanner(Composite parent, String text) {
        Composite wrap = new Composite(parent, 0);
        wrap.setBackground(new Color((Device)parent.getDisplay(), 255, 249, 219));
        GridData gd = new GridData(4, 128, true, false);
        gd.verticalIndent = 4;
        wrap.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 12;
        gl.marginHeight = 8;
        gl.horizontalSpacing = 8;
        wrap.setLayout((Layout)gl);
        Label icon = new Label(wrap, 0);
        icon.setBackground(wrap.getBackground());
        icon.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        Label msg = new Label(wrap, 64);
        msg.setBackground(wrap.getBackground());
        msg.setFont(this.FONT);
        msg.setText(text);
        msg.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        return wrap;
    }

    private Composite createCard(Composite parent, String title, int columns) {
        Composite outer = new Composite(parent, 0);
        outer.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout g0 = new GridLayout(1, false);
        g0.marginWidth = 0;
        g0.marginHeight = 0;
        outer.setLayout((Layout)g0);
        Composite card = new Composite(outer, 2048);
        card.setBackground(parent.getDisplay().getSystemColor(1));
        card.setBackgroundMode(2);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 4;
        gd.verticalIndent = 4;
        card.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout(columns, false);
        gl.marginWidth = 14;
        gl.marginHeight = 12;
        gl.horizontalSpacing = 12;
        gl.verticalSpacing = 8;
        card.setLayout((Layout)gl);
        Label caption = new Label(card, 0);
        caption.setText(title);
        caption.setFont(this.FONT_B);
        GridData capGD = new GridData(4, 0x1000000, true, false);
        capGD.horizontalSpan = columns;
        caption.setLayoutData((Object)capGD);
        Label sep = new Label(card, 258);
        GridData sepGD = new GridData(4, 0x1000000, true, false);
        sepGD.horizontalSpan = columns;
        sep.setLayoutData((Object)sepGD);
        return card;
    }

    private static Table createTableWithColumns(Composite parent) {
        Composite tableWrap = new Composite(parent, 0);
        tableWrap.setLayoutData((Object)new GridData(4, 4, true, true));
        TableColumnLayout tcl = new TableColumnLayout();
        tableWrap.setLayout((Layout)tcl);
        Table table = new Table(tableWrap, 68100);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn c1 = new TableColumn(table, 16384);
        c1.setText("\uceec\ub7fc\uba85");
        tcl.setColumnData((Widget)c1, (ColumnLayoutData)new ColumnWeightData(70, 120, true));
        TableColumn c2 = new TableColumn(table, 131072);
        c2.setText("\ub108\ube44");
        tcl.setColumnData((Widget)c2, (ColumnLayoutData)new ColumnWeightData(30, 60, true));
        return table;
    }

    private Button createIconButton(Composite parent, String text, Image img, int width) {
        Button b = new Button(parent, 8);
        b.setText(text);
        b.setImage(img);
        GridData gd = new GridData(width, -1);
        b.setLayoutData((Object)gd);
        return b;
    }

    private Button createIconButton(Composite parent, String text, int width) {
        Button b = new Button(parent, 8);
        b.setText(text);
        GridData gd = new GridData(width, -1);
        b.setLayoutData((Object)gd);
        return b;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(3, false));
        container.setBackground(parent.getDisplay().getSystemColor(22));
        Composite banner = this.createBanner(container, "\ud45c\uc2dc\ud560 \uceec\ub7fc\uc744 \uc120\ud0dd\ud558\uace0 \uc21c\uc11c\ub97c \uc815\ud558\uc138\uc694. \ub4dc\ub798\uadf8/\ubc84\ud2bc \uc774\ub3d9, \ub108\ube44\ub294 \ub354\ube14\ud074\ub9ad\uc73c\ub85c \uc124\uc815 \uac00\ub2a5 \ud569\ub2c8\ub2e4.");
        GridData gdBanner = new GridData(4, 128, true, false);
        gdBanner.horizontalSpan = 3;
        banner.setLayoutData((Object)gdBanner);
        Composite leftCard = this.createCard(container, "\uc228\uae40 \uceec\ub7fc", 1);
        GridData gdLeft = new GridData(4, 4, false, true);
        gdLeft.widthHint = 250;
        leftCard.setLayoutData((Object)gdLeft);
        this.leftTable = ColumnOrderDialog.createTableWithColumns(leftCard);
        Composite centerCard = this.createCard(container, "\uc774\ub3d9", 1);
        GridData gdCenter = new GridData(1, 4, false, true);
        gdCenter.widthHint = 140;
        centerCard.setLayoutData((Object)gdCenter);
        Image addImg = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD");
        Image remImg = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
        this.addBtn = this.createIconButton(centerCard, "\ucd94\uac00", addImg, 110);
        this.removeBtn = this.createIconButton(centerCard, "\uc81c\uac70", remImg, 110);
        Label spacer = new Label(centerCard, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite rightCard = this.createCard(container, "\ud45c\uc2dc \uceec\ub7fc", 2);
        GridData gdRight = new GridData(4, 4, false, true);
        gdRight.widthHint = 400;
        rightCard.setLayoutData((Object)gdRight);
        this.rightTable = ColumnOrderDialog.createTableWithColumns(rightCard);
        Composite arrowComp = new Composite(rightCard, 0);
        arrowComp.setLayout((Layout)new GridLayout(1, false));
        arrowComp.setLayoutData((Object)new GridData(1, 128, false, false));
        this.topBtn = this.createIconButton(arrowComp, "\u25b3 \ub9e8 \uc704", 110);
        this.upBtn = this.createIconButton(arrowComp, "\u25b2 \uc704\ub85c", 110);
        this.downBtn = this.createIconButton(arrowComp, "\u25bc \uc544\ub798", 110);
        this.bottomBtn = this.createIconButton(arrowComp, "\u25bd \ub9e8 \uc544\ub798", 110);
        this.addTableItemLeft(this.leftTable);
        this.addTableItemLight(this.rightTable);
        this.bindEvents();
        return container;
    }

    private void bindEvents() {
        this.addBtn.addListener(13, e -> {
            int idx = this.leftTable.getSelectionIndex();
            if (idx >= 0) {
                TableItem sel = this.leftTable.getItem(idx);
                this.addTableItem(this.rightTable, sel.getText(0), sel.getText(1));
                this.leftTable.remove(idx);
                this.isUserSetting = true;
            }
        });
        this.removeBtn.addListener(13, e -> {
            int idx = this.rightTable.getSelectionIndex();
            if (idx >= 0) {
                TableItem sel = this.rightTable.getItem(idx);
                this.addTableItem(this.leftTable, sel.getText(0), sel.getText(1));
                this.rightTable.remove(idx);
                this.isUserSetting = true;
            }
        });
        this.upBtn.addListener(13, e -> this.moveItem(this.rightTable, -1));
        this.downBtn.addListener(13, e -> this.moveItem(this.rightTable, 1));
        this.topBtn.addListener(13, e -> this.moveToEdge(this.rightTable, true));
        this.bottomBtn.addListener(13, e -> this.moveToEdge(this.rightTable, false));
        TableEditor editor = new TableEditor(this.rightTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.rightTable.addListener(8, e -> {
            Point pt = new Point(e.x, e.y);
            TableItem item = this.rightTable.getItem(pt);
            if (item == null) {
                return;
            }
            int columnIndex = -1;
            int i = 0;
            while (i < this.rightTable.getColumnCount()) {
                if (item.getBounds(i).contains(pt)) {
                    columnIndex = i;
                    break;
                }
                ++i;
            }
            if (columnIndex == 1) {
                Text text = new Text((Composite)this.rightTable, 0);
                text.setText(item.getText(columnIndex));
                text.selectAll();
                text.setFocus();
                editor.setEditor((Control)text, item, columnIndex);
                text.addListener(25, ev -> {
                    if (!ev.text.matches("[0-9]*")) {
                        ev.doit = false;
                    }
                });
                text.addListener(16, ev -> {
                    item.setText(1, text.getText());
                    text.dispose();
                });
                text.addListener(31, ev -> {
                    if (ev.detail == 4) {
                        item.setText(1, text.getText());
                        text.dispose();
                        ev.doit = false;
                    } else if (ev.detail == 2) {
                        text.dispose();
                        ev.doit = false;
                    }
                });
                this.isUserSetting = true;
            }
        });
    }

    private void addTableItemLeft(Table table) {
        for (DisplayColumnSettingDto dto : this.leftList) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, dto.getItem_nm());
            if (this.isUserSetting) {
                item.setText(1, String.valueOf(dto.getUser_width()));
                continue;
            }
            item.setText(1, String.valueOf(dto.getDefault_width()));
        }
    }

    private void addTableItemLight(Table table) {
        for (DisplayColumnSettingDto dto : this.rightList) {
            TableItem item = new TableItem(table, 0);
            item.setText(0, dto.getItem_nm());
            if (this.isUserSetting) {
                item.setText(1, String.valueOf(dto.getUser_width()));
                continue;
            }
            item.setText(1, String.valueOf(dto.getDefault_width()));
        }
    }

    private void addTableItem(Table table, String colName, String width) {
        TableItem item = new TableItem(table, 0);
        item.setText(0, colName);
        if (table.getColumnCount() > 1) {
            item.setText(1, width);
        }
    }

    private void moveItem(Table table, int direction) {
        int idx = table.getSelectionIndex();
        if (idx < 0) {
            return;
        }
        int newIdx = idx + direction;
        if (newIdx < 0 || newIdx >= table.getItemCount()) {
            return;
        }
        this.swapItem(table, idx, newIdx);
        table.setSelection(newIdx);
        this.isUserSetting = true;
    }

    private void moveToEdge(Table table, boolean top) {
        int newIdx;
        int idx = table.getSelectionIndex();
        if (idx < 0) {
            return;
        }
        int n = newIdx = top ? 0 : table.getItemCount() - 1;
        if (idx == newIdx) {
            return;
        }
        String[] values = new String[table.getColumnCount()];
        TableItem item = table.getItem(idx);
        int i = 0;
        while (i < values.length) {
            values[i] = item.getText(i);
            ++i;
        }
        table.remove(idx);
        TableItem newItem = new TableItem(table, 0, newIdx);
        newItem.setText(values);
        table.setSelection(newIdx);
        this.isUserSetting = true;
    }

    private void swapItem(Table table, int idx1, int idx2) {
        String[] values1 = new String[table.getColumnCount()];
        String[] values2 = new String[table.getColumnCount()];
        TableItem item1 = table.getItem(idx1);
        TableItem item2 = table.getItem(idx2);
        int i = 0;
        while (i < table.getColumnCount()) {
            values1[i] = item1.getText(i);
            values2[i] = item2.getText(i);
            ++i;
        }
        item1.setText(values2);
        item2.setText(values1);
    }

    public String[][] getRightItems() {
        TableItem[] items = this.rightTable.getItems();
        String[][] result = new String[items.length][2];
        int i = 0;
        while (i < items.length) {
            result[i][0] = items[i].getText(0);
            result[i][1] = items[i].getText(1);
            ++i;
        }
        return result;
    }

    protected void okPressed() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"\ud45c\uc2dc \uc124\uc815 \uc800\uc7a5", (String)"\uc9c0\uae08 \uc124\uc815\uc744 \uc800\uc7a5\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?")) {
            if (this.isUserSetting) {
                DisplayColumnSettingDto dto;
                ArrayList<DisplayColumnSettingDto> updateList = new ArrayList<DisplayColumnSettingDto>();
                TableItem[] lItems = this.leftTable.getItems();
                TableItem[] rItems = this.rightTable.getItems();
                int i = 0;
                while (i < lItems.length) {
                    dto = new DisplayColumnSettingDto();
                    dto.setUser_seq(i + 1);
                    dto.setUser_use_yn("N");
                    dto.setItem_nm(lItems[i].getText(0));
                    dto.setUser_width(Integer.parseInt(lItems[i].getText(1)));
                    updateList.add(dto);
                    ++i;
                }
                i = 0;
                while (i < rItems.length) {
                    dto = new DisplayColumnSettingDto();
                    dto.setUser_seq(i + 1);
                    dto.setUser_use_yn("Y");
                    dto.setItem_nm(rItems[i].getText(0));
                    dto.setUser_width(Integer.parseInt(rItems[i].getText(1)));
                    updateList.add(dto);
                    ++i;
                }
                try {
                    LiteOrderManagerDao.get().setDisplayColumnUpdate(updateList, this._classNm);
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"\ud45c\uc2dc \ud56d\ubaa9 \uc124\uc815 \uc800\uc7a5", (String)"\uc815\uc0c1\uc801\uc73c\ub85c \uc800\uc7a5\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\ub9ac\uc2a4\ud2b8\uc5d0\ub294 \uc8fc\ubb38 Lite \ud0ed\uc744 \ub2eb\uace0 \ub2e4\uc2dc \uc5f4\uba74 \uc801\uc6a9\ub429\ub2c8\ub2e4. ");
                    super.okPressed();
                }
                catch (Exception e) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"\ud45c\uc2dc \ud56d\ubaa9 \uc124\uc815 \uc800\uc7a5", (String)("\uc800\uc7a5\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc7a0\uc2dc\ud6c4\uc5d0 \uc2dc\ub3c4 \ud574\uc8fc\uc138\uc694 \r\n \uc5d0\ub7ec\uba54\uc138\uc9c0 : " + e.getMessage()));
                }
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"\ud45c\uc2dc \ud56d\ubaa9 \uc124\uc815 \uc800\uc7a5", (String)"\ubc14\ub010 \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
        }
    }

    private void reset() {
        if (MessageDialog.openConfirm((Shell)this.getShell(), (String)"\ud45c\uc2dc \uc124\uc815 \ucd08\uae30\ud654", (String)"\ud45c\uc2dc \uc124\uc815\uc744 \uae30\ubcf8\uc73c\ub85c \ucd08\uae30\ud654\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c?")) {
            this.isUserSetting = false;
            this.leftTable.removeAll();
            this.rightTable.removeAll();
            try {
                this.leftList = LiteOrderManagerDao.get().getDefaultSetting(this._classNm, "N");
                this.rightList = LiteOrderManagerDao.get().getDefaultSetting(this._classNm, "Y");
                this.addTableItemLeft(this.leftTable);
                this.addTableItemLight(this.rightTable);
                int result = LiteOrderManagerDao.get().resetDisplayColumnSetting(this._classNm);
                if (result > 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"\ud45c\uc2dc \ud56d\ubaa9 \uc124\uc815 \ucd08\uae30\ud654", (String)"\uc815\uc0c1\uc801\uc73c\ub85c \ucd08\uae30\ud654\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n\ub9ac\uc2a4\ud2b8\uc5d0\ub294 \uc8fc\ubb38 Lite \ud0ed\uc744 \ub2eb\uace0 \ub2e4\uc2dc \uc5f4\uba74 \uc801\uc6a9\ub429\ub2c8\ub2e4. ");
                    super.okPressed();
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"\ud45c\uc2dc \uc124\uc815 \ucd08\uae30\ud654 \uc5d0\ub7ec", (String)("\ucd08\uae30\ud654 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc7a0\uc2dc\ud6c4\uc5d0 \uc2dc\ub3c4 \ud574\uc8fc\uc138\uc694 \r\n \uc5d0\ub7ec\uba54\uc138\uc9c0 : " + e.getMessage()));
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn_help = this.createButton(parent, 17, "\ub3c4\uc6c0\ub9d0", false);
        btn_help.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/help_20.png"));
        btn_help.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String url = MLinkHelpArticleManager.getUrl("LiteOrderManager", "Common");
                if (url != null) {
                    YDMAHttpUtil.browser(url);
                }
            }
        });
        Button button_reset = this.createButton(parent, 7, "\ucd08\uae30\ud654", false);
        button_reset.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc804\uccb4\uc0c8\ub85c\uace0\uce68.png"));
        button_reset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnOrderDialog.this.reset();
            }
        });
        Button btn_ok = this.createButton(parent, 0, "\uc800\uc7a5", false);
        btn_ok.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucc98\ub9ac\uc644\ub8cc.png"));
        Button btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("\ud45c\uc2dc \ud56d\ubaa9 \uc124\uc815");
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(800, 650);
    }
}

