/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.tot.common.YDMAPluginUtils;
import com.kdjsystem.mlink.tot.data.excel.MyDataManagerFactory;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;

public class LiteOrderBulkInvoiceDialog
extends CommandDialog {
    private Text text;
    private Button btnsearch;
    private List<List<String>> resultList = new ArrayList<List<String>>();
    private String title = "";
    private String buttonName = "";

    public List<List<String>> getResultList() {
        return this.resultList;
    }

    public LiteOrderBulkInvoiceDialog(Shell parentShell, boolean isModify) {
        super(parentShell);
        this.title = !isModify ? "\uc1a1\uc7a5\uc77c\uad04\ub4f1\ub85d" : "\uc1a1\uc7a5\uc77c\uad04\uc218\uc815";
        this.buttonName = !isModify ? "\uc77c\uad04 \ub4f1\ub85d" : "\uc77c\uad04 \uc218\uc815";
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 15;
        layout.marginHeight = 15;
        layout.verticalSpacing = 12;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setBackground(parent.getDisplay().getSystemColor(1));
        Composite infoBox = new Composite(container, 2048);
        infoBox.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout infoLayout = new GridLayout(1, false);
        infoLayout.marginWidth = 10;
        infoLayout.marginHeight = 8;
        infoBox.setLayout((Layout)infoLayout);
        infoBox.setBackground(parent.getDisplay().getSystemColor(29));
        Label guideLabel1 = new Label(infoBox, 64);
        guideLabel1.setText("\uc5d1\uc140 \ud30c\uc77c\uc758 1\uc5f4\uc5d0\ub294 \uc1fc\ud551\ubab0 \uc8fc\ubb38\ubc88\ud638, 2\uc5f4\uc5d0\ub294 \ubc30\uc1a1\uc0ac\uba85, 3\uc5f4\uc5d0\ub294 \uc1a1\uc7a5\ubc88\ud638\ub97c \uc785\ub825\ud574 \uc8fc\uc138\uc694.");
        guideLabel1.setBackground(infoBox.getBackground());
        Label guideLabel2 = new Label(infoBox, 64);
        guideLabel2.setText("\uccab \ubc88\uc9f8 \uc2dc\ud2b8\uc758 2\ubc88\uc9f8 \ud589\ubd80\ud130 \ub370\uc774\ud130\ub97c \uc77d\uc5b4 \uc0ac\uc6a9\ud569\ub2c8\ub2e4. 3\uc5f4 \uc774\ud6c4\uc758 \uac12\uc740 \uc77d\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4");
        guideLabel2.setBackground(infoBox.getBackground());
        Label guideLabel4 = new Label(infoBox, 64);
        guideLabel4.setText("\ud544\uc694 \ud558\uc2e0\uacbd\uc6b0 \uc591\uc2dd \ub2e4\uc6b4\uc744 \ud558\uc5ec \uc785\ub825 \ud6c4\uc5d0 \uc5c5\ub85c\ub4dc \ud558\uc2dc\uba74 \ub429\ub2c8\ub2e4.");
        guideLabel4.setBackground(infoBox.getBackground());
        Composite fileRow = new Composite(container, 0);
        fileRow.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fileRow.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout fileLayout = new GridLayout(3, false);
        fileLayout.marginWidth = 0;
        fileLayout.marginHeight = 5;
        fileLayout.horizontalSpacing = 8;
        fileRow.setLayout((Layout)fileLayout);
        Label lblNewLabel = new Label(fileRow, 0);
        lblNewLabel.setText("\ud30c\uc77c \uacbd\ub85c:");
        lblNewLabel.setBackground(fileRow.getBackground());
        this.text = new Text(fileRow, 2056);
        GridData gdText = new GridData(4, 0x1000000, true, false);
        gdText.widthHint = 300;
        this.text.setLayoutData((Object)gdText);
        this.btnsearch = new Button(fileRow, 8);
        this.btnsearch.setText("\ucc3e\uae30");
        this.btnsearch.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uac80\uc0c9.png"));
        GridData gdBtn = new GridData(131072, 0x1000000, false, false);
        gdBtn.widthHint = 70;
        gdBtn.heightHint = 24;
        this.btnsearch.setLayoutData((Object)gdBtn);
        this.btnsearch.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LiteOrderBulkInvoiceDialog.this.btn_search_selectionEvent();
            }
        });
        return container;
    }

    private void btn_search_selectionEvent() {
        FileDialog fileSelectionDialog = MyDataManagerFactory.createExcelFileSelectionDialog();
        fileSelectionDialog.setFilterExtensions(new String[]{"*.xls", "*.xlsx"});
        String filePath = fileSelectionDialog.open();
        this.text.setText(filePath);
    }

    protected void okPressed() {
        if (this.text.getText().equals("")) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"\ud30c\uc77c \uacbd\ub85c \uc785\ub825", (String)"\ucc3e\uae30\ub85c \ud30c\uc77c \uacbd\ub85c\ub97c \uac80\uc0c9\ud574\uc8fc\uc138\uc694.");
            this.btnsearch.setFocus();
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(new File(this.text.getText()));
            Object workbook = this.text.getText().endsWith(".xlsx") ? new XSSFWorkbook((InputStream)fis) : new HSSFWorkbook((InputStream)fis);
            Sheet sheet = workbook.getSheetAt(0);
            for (Row row : sheet) {
                if (row.getRowNum() == 0) continue;
                ArrayList<String> rowData = new ArrayList<String>();
                for (Cell cell : row) {
                    if (cell.getColumnIndex() > 2) break;
                    rowData.add(this.getCellValue(cell));
                }
                this.resultList.add(rowData);
            }
            super.okPressed();
        }
        catch (Exception exception) {
            return;
        }
    }

    private String getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case 1: {
                if (cell.getStringCellValue().equals("Unknown")) {
                    return "";
                }
                return cell.getStringCellValue();
            }
            case 0: {
                double d = cell.getNumericCellValue();
                int n = (int)d;
                return String.valueOf(n);
            }
            case 4: {
                return String.valueOf(cell.getBooleanCellValue());
            }
        }
        return "";
    }

    private void printList(String fileSavePath) throws Exception {
        block22: {
            HSSFWorkbook workbook;
            String newfile = fileSavePath;
            String[] name = new String[]{"\uc544\ub798\uc5d0 \uc8fc\ubb38\ubc88\ud638\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694", "\uc544\ub798\uc5d0 \ud0dd\ubc30\uc0ac\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694", "\uc544\ub798\uc5d0 \uc1a1\uc7a5\ubc88\ud638\ub97c \uc785\ub825\ud574\uc8fc\uc138\uc694"};
            if (newfile.endsWith(".xls")) {
                Cell cell22;
                workbook = new HSSFWorkbook();
                CellStyle csCenter = workbook.createCellStyle();
                csCenter.setFillForegroundColor(IndexedColors.GREY_40_PERCENT.getIndex());
                csCenter.setWrapText(true);
                Sheet sheet = workbook.createSheet("\uc1a1\uc7a5 \uc5c5\ub85c\ub4dc \uc591\uc2dd");
                Row rowHead = sheet.createRow(0);
                rowHead.setHeightInPoints(40.0f);
                int i22 = 0;
                while (i22 < name.length) {
                    cell22 = rowHead.createCell(i22);
                    cell22.setCellValue(name[i22]);
                    cell22.setCellStyle(csCenter);
                    sheet.setColumnWidth(i22, 8000);
                    ++i22;
                }
                Throwable i22 = null;
                cell22 = null;
                try (FileOutputStream out = new FileOutputStream(newfile);){
                    workbook.write((OutputStream)out);
                    break block22;
                }
                catch (Throwable cell22) {
                    if (i22 == null) {
                        i22 = cell22;
                    } else if (i22 != cell22) {
                        i22.addSuppressed(cell22);
                    }
                    throw i22;
                }
            }
            workbook = new XSSFWorkbook();
            XSSFColor color_pass = new XSSFColor();
            color_pass.setIndexed((int)IndexedColors.GREY_40_PERCENT.getIndex());
            XSSFCellStyle cs_center = workbook.createCellStyle();
            cs_center.setAlignment(HorizontalAlignment.CENTER);
            cs_center.setFillForegroundColor(color_pass);
            cs_center.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs_center.setWrapText(true);
            XSSFSheet prodmanager = workbook.createSheet("\uc1a1\uc7a5 \uc5c5\ub85c\ub4dc \uc591\uc2dd");
            Row row_head = prodmanager.createRow(0);
            row_head.setHeightInPoints(40.0f);
            row_head.setRowStyle((CellStyle)cs_center);
            int i = 0;
            while (i < name.length) {
                Cell cell = row_head.createCell(i);
                cell.setCellValue(name[i]);
                prodmanager.setColumnWidth(i, 8000);
                ++i;
            }
            Throwable throwable = null;
            Object var10_22 = null;
            try (FileOutputStream out = new FileOutputStream(newfile);){
                workbook.write((OutputStream)out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        boolean retVal = MessageDialog.openQuestion((Shell)this.getShell(), (String)"\uc591\uc2dd \ub2e4\uc6b4", (String)"\uc5c5\ub85c\ub4dc \uc591\uc2dd\uc744 \uc5d1\uc140\ub85c \uc800\uc7a5\ud558\uc600\uc2b5\ub2c8\ub2e4. \ud30c\uc77c\uc744 \uc5ec\uc2dc\uaca0\uc2b5\ub2c8\uae4c?");
        if (retVal) {
            Desktop.getDesktop().edit(new File(fileSavePath));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btn_excelSave = this.createButton(parent, 7, "\uc591\uc2dd \ub2e4\uc6b4", false);
        btn_excelSave.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc5d1\uc140\uc800\uc7a5.png"));
        btn_excelSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileSelectionDialog = new FileDialog(YDMAPluginUtils.getShell(), 8192);
                String[] filters = new String[]{"*.xls", "*.xlsx"};
                fileSelectionDialog.setFilterExtensions(filters);
                String fileSavePath = fileSelectionDialog.open();
                if (fileSavePath == null) {
                    return;
                }
                try {
                    LiteOrderBulkInvoiceDialog.this.printList(fileSavePath);
                }
                catch (Exception ex) {
                    MessageDialog.openError((Shell)LiteOrderBulkInvoiceDialog.this.getShell(), (String)"\uc5d1\uc140 \uc591\uc2dd \ub2e4\uc6b4", (String)ex.getMessage());
                }
            }
        });
        Button btn_ok = this.createButton(parent, 0, this.buttonName, false);
        btn_ok.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucc98\ub9ac\uc644\ub8cc.png"));
        Button btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.title);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(580, 245);
    }
}

