/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopOrderContext;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.liteOrder.LiteCancelOrderManager;
import com.kdjsystem.mlink.shop.liteOrder.LiteConfirmedOrderManager;
import com.kdjsystem.mlink.shop.liteOrder.LiteNewOrderManager;
import com.kdjsystem.mlink.shop.liteOrder.LiteShippingOrderManager;
import com.kdjsystem.mlink.tot.common.YDMAGridColumn;
import com.kdjsystem.mlink.tot.common.YDMAGridColumnList;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import com.kdjsystem.mlink.tot.ui.MyCellRenderer;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class LiteOrderResultDialog
extends CommandDialog {
    String TITLE = "\uc8fc\ubb38 \ucc98\ub9ac \uacb0\uacfc";
    LiteNewOrderManager opener;
    LiteCancelOrderManager cancelOpener;
    LiteConfirmedOrderManager confirmedOpener;
    LiteShippingOrderManager shippingOpener;
    String dateFrom;
    String dateTo;
    String dateFrom2;
    String dateTo2;
    Button btn_noauto;
    YDMAGridColumnList col_list = new YDMAGridColumnList();
    GridTableViewer gridTableViewer;
    protected String copyValue;
    final Shell shell = this.getShell();
    private Grid grid;
    boolean canViewUsage = false;
    Map<String, LiteOrderResultDto> resultMap = new HashMap<String, LiteOrderResultDto>();
    List<LiteOrderResultDto> resultList = new ArrayList<LiteOrderResultDto>();
    List<ShopOrderMstDto> _list = new ArrayList<ShopOrderMstDto>();
    Map<String, Map<String, List<ShopOrderMstDto>>> mapList = null;
    String type = "";
    Button btn_ok = null;

    public LiteOrderResultDialog(Shell parentShell, LiteNewOrderManager opener, List<ShopOrderMstDto> list) {
        super(parentShell);
        this.opener = opener;
        this._list = list;
        this.converMapList(list);
        this.convertShopOrderToResultList(list);
        this.type = "201";
        this.TITLE = "\uc8fc\ubb38 \ud655\uc778 \uacb0\uacfc";
    }

    public LiteOrderResultDialog(Shell parentShell, LiteConfirmedOrderManager opener, List<ShopOrderMstDto> list) {
        super(parentShell);
        this.confirmedOpener = opener;
        this._list = list;
        this.converMapList(list);
        this.convertShopOrderToResultList(list);
        this.type = "403";
        this.TITLE = "\ubc1c\uc1a1 \ucc98\ub9ac \uacb0\uacfc";
    }

    public LiteOrderResultDialog(Shell parentShell, LiteShippingOrderManager opener, List<ShopOrderMstDto> list) {
        super(parentShell);
        this.shippingOpener = opener;
        this._list = list;
        this.converMapList(list);
        this.convertShopOrderToResultList(list);
        this.type = "303";
        this.TITLE = "\uc1a1\uc7a5 \uc218\uc815 \uacb0\uacfc";
    }

    public LiteOrderResultDialog(Shell parentShell, LiteCancelOrderManager opener, List<ShopOrderMstDto> list) {
        super(parentShell);
        this.cancelOpener = opener;
        this._list = list;
        this.converMapList(list);
        this.convertShopOrderToResultList(list);
        this.type = "C02";
        this.TITLE = "\ucde8\uc18c \uc2b9\uc778 \uacb0\uacfc";
    }

    private void converMapList(List<ShopOrderMstDto> list) {
        this.mapList = list.stream().collect(Collectors.groupingBy(ShopOrderMstDto::getShopid, () -> new LinkedHashMap(), Collectors.groupingBy(ShopOrderMstDto::getShopseq, () -> new LinkedHashMap(), Collectors.toList())));
    }

    private void convertShopOrderToResultList(List<ShopOrderMstDto> list) {
        int i = 1;
        for (ShopOrderMstDto order : list) {
            LiteOrderResultDto dto = new LiteOrderResultDto();
            dto.no = i++;
            dto.shopid = order.getShopid();
            dto.shop_userid = order.getShop_userid();
            dto.order_id = order.getOrder_id();
            dto.result = "";
            dto.resultMessage = "";
            dto.p_product_name = order.getP_product_name();
            dto.mall_product_id = order.getMall_product_id();
            this.resultList.add(dto);
            this.resultMap.put(order.getOrder_id(), dto);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setGridColumns();
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout(null);
        SashForm sashForm = new SashForm(container, 0);
        sashForm.setBounds(10, 10, 970, 387);
        this.gridTableViewer = new GridTableViewer((Composite)sashForm, 2818);
        this.grid = this.gridTableViewer.getGrid();
        this.grid.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.grid.setLinesVisible(true);
        this.grid.setLineColor(SWTResourceManager.getColor(18));
        this.grid.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setRGB(68, 80, 94);
        myHeaderRender.setFGC(1);
        for (YDMAGridColumn col : this.col_list.getColumns()) {
            GridColumn tableViewerColumn_x = new GridColumn(this.grid, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setWidth(col.getWidth());
            tableViewerColumn_x.setText(col.getText());
            tableViewerColumn_x.setAlignment(16384);
            MyCellRenderer myCellRenderer = new MyCellRenderer();
            if (col.getSeq() == 0 || col.getSeq() == 4) {
                myCellRenderer.setColumnAlign(0x1000000);
            } else {
                myCellRenderer.setColumnAlign(16384);
            }
            tableViewerColumn_x.setCellRenderer((GridCellRenderer)myCellRenderer);
        }
        sashForm.setWeights(new int[]{1});
        this.gridTableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        this.gridTableViewer.setLabelProvider((IBaseLabelProvider)new MyLableProvider());
        this.gridTableViewer.setInput(this.resultList);
        return container;
    }

    @Override
    protected void initializeBounds() {
        super.initializeBounds();
        Display.getDefault().asyncExec(() -> this.startBackgroundWork());
    }

    private void startBackgroundWork() {
        new Thread(() -> {
            for (String shopid : this.mapList.keySet()) {
                Map<String, List<ShopOrderMstDto>> map = this.mapList.get(shopid);
                for (String key2 : map.keySet()) {
                    List<ShopOrderMstDto> listdto = map.get(key2);
                    try {
                        listdto = ShopOrderContext.get().setContext(IShopOrderCommand.getContext(shopid, this.type)).excute(listdto);
                        for (ShopOrderMstDto sodto : listdto) {
                            String result = sodto.getResult_code().equals("1") ? "\uc131\uacf5" : "\uc2e4\ud328";
                            Display.getDefault().asyncExec(() -> this.updateResult(sodto.getOrder_id(), result, sodto.getResult_text()));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            Display.getDefault().asyncExec(() -> this.btn_ok.setEnabled(true));
        }).start();
    }

    public void updateResult(String orderId, String result, String message) {
        LiteOrderResultDto dto = this.resultMap.get(orderId);
        Display.getDefault().asyncExec(() -> {
            liteOrderResultDto.result = result;
            liteOrderResultDto.resultMessage = message;
            this.gridTableViewer.update((Object)dto, null);
        });
    }

    public void finalBtnOkEnable() {
        Display.getDefault().asyncExec(() -> this.btn_ok.setEnabled(true));
    }

    private void setGridColumns() {
        this.col_list.add(0, "No", "No.", 35);
        this.col_list.add(1, "SHOPID", "\uc1fc\ud551\ubab0", 100);
        this.col_list.add(2, "SHOP_USERID", "\uc1fc\ud551\ubab0ID", 100);
        this.col_list.add(3, "ORDER_ID", "\uc8fc\ubb38\ubc88\ud638", 140);
        this.col_list.add(4, "P_PRODUCT_NAME", "\uc0c1\ud488\uba85", 150);
        this.col_list.add(5, "MALL_PRODUCT_ID", "\uc0c1\ud488\ubc88\ud638", 100);
        this.col_list.add(6, "RESULT", "\uacb0\uacfc", 50);
        this.col_list.add(7, "RESULTMESSAGE", "\uacb0\uacfc\uba54\uc138\uc9c0", 500);
    }

    protected void okPressed() {
        switch (this.type) {
            case "201": {
                this.opener.bindData();
                break;
            }
            case "403": {
                this.confirmedOpener.bindData();
                break;
            }
            case "303": {
                this.shippingOpener.bindData();
                break;
            }
            case "C02": {
                this.cancelOpener.bindData();
            }
        }
        super.okPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btn_ok = this.createButton(parent, 0, "\ud655\uc778", false);
        this.btn_ok.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucc98\ub9ac\uc644\ub8cc.png"));
        this.btn_ok.setEnabled(false);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(1000, 500);
    }

    class LiteOrderResultDto {
        private int no;
        private String shopid;
        private String shop_userid;
        private String order_id;
        private String result;
        private String resultMessage;
        private String mall_product_id;
        private String p_product_name;

        LiteOrderResultDto() {
        }
    }

    class MyContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class MyLableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLableProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            LiteOrderResultDto dto = (LiteOrderResultDto)element;
            String value = "";
            switch (columnIndex) {
                case 0: {
                    value = String.valueOf(dto.no);
                    break;
                }
                case 1: {
                    value = ShopCommon.getShoppingMallName(dto.shopid);
                    break;
                }
                case 2: {
                    value = dto.shop_userid;
                    break;
                }
                case 3: {
                    value = dto.order_id;
                    break;
                }
                case 4: {
                    value = dto.p_product_name;
                    break;
                }
                case 5: {
                    value = dto.mall_product_id;
                    break;
                }
                case 6: {
                    value = dto.result;
                    break;
                }
                case 7: {
                    value = dto.resultMessage;
                    break;
                }
            }
            return value;
        }

        public Color getForeground(Object element, int columnIndex) {
            Color color = null;
            LiteOrderResultDto dto = (LiteOrderResultDto)element;
            if (columnIndex == 6 || columnIndex == 7) {
                color = dto.result.equals("\uc131\uacf5") ? Display.getCurrent().getSystemColor(9) : Display.getCurrent().getSystemColor(3);
            }
            return color;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

