/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.liteOrder;

import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.tot.common.YDMAGridColumn;
import com.kdjsystem.mlink.tot.common.YDMAGridColumnList;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class LiteOrderStatisticsDialog
extends CommandDialog {
    List<ShopOrderMstNewDto> _list;
    String symbolic = "com.kdjsystem.mlink.tot";
    private CTabFolder tabFolder;
    private CTabItem tabItem;
    private Text txtOrderCnt;
    private Text txtItems;
    private Text txtTotalQty;
    private Text txtTotal;
    private Text txtMarketFee;
    private Text txtRate;
    private Text txtSupply;
    private Text txtDiscount;
    private Text txtRealTotal;
    private Text txtRealRate;
    private Text txtExpected;
    private Text txtDelvCost;
    private Text txtRealPlusDelv;
    private Text txtExpectPlusDelv;
    private Text txtInfo;
    private CTabItem tabItem_1;
    private CTabItem tabItem_2;
    private CTabItem tabItem_3;
    private CTabItem tabItem_4;
    private CTabItem tabItem_5;
    YDMAGridColumnList col_list = new YDMAGridColumnList();
    List<OrderStatisticsDto> orderStatisticsByDay = new ArrayList<OrderStatisticsDto>();
    List<OrderStatisticsDto> orderStatisticsByMonth = new ArrayList<OrderStatisticsDto>();
    List<OrderStatisticsDto> orderStatisticsByShop = new ArrayList<OrderStatisticsDto>();
    List<OrderStatisticsDto> orderStatisticsByShopAndNickname = new ArrayList<OrderStatisticsDto>();
    List<OrderStatisticsDto> orderStatisticsByProduct = new ArrayList<OrderStatisticsDto>();
    private Button btn_cancel;

    public LiteOrderStatisticsDialog(Shell parentShell, List<ShopOrderMstNewDto> list) {
        super(parentShell);
        this._list = list;
        this.setCommonGridColumns();
    }

    private void setCommonGridColumns() {
        int i = 1;
        this.col_list.add(i++, "orderCnt", "\uc8fc\ubb38\uac74\uc218", 100);
        this.col_list.add(i++, "items", "\uace0\uc720\uc0c1\ud488\uc218", 80);
        this.col_list.add(i++, "total", "\ucd1d\uc8fc\ubb38\uae08\uc561", 100);
        this.col_list.add(i++, "marketFee", "\ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561", 120);
        this.col_list.add(i++, "rate", "\uc218\uc218\ub8cc\uc728", 80);
        this.col_list.add(i++, "supply", "\uacf5\uae09\uae08\uc561", 80);
        this.col_list.add(i++, "discount", "\ud560\uc778\uae08\uc561", 80);
        this.col_list.add(i++, "realTotal", "\uacb0\uc81c\uae08\uc561", 100);
        this.col_list.add(i++, "expected", "\uc815\uc0b0\uc608\uc815\uae08\uc561", 100);
        this.col_list.add(i++, "delvCost", "\ubc30\uc1a1\ube44", 80);
        this.col_list.add(i++, "realTotalPlusDelv", "\uacb0\uc81c\uae08\uc561(\ubc30\uc1a1\ube44 \ud3ec\ud568)", 130);
        this.col_list.add(i++, "expectPlusDelv", "\uc815\uc0b0\uc608\uc815\uae08\uc561(\ubc30\uc1a1\ube44 \ud3ec\ud568)", 130);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.tabFolder = new CTabFolder(container, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tabItem = new CTabItem(this.tabFolder, 0);
        this.tabItem.setText("\uc815\uc0b0\ub0b4\uc5ed");
        this.tabItem.setImage(ResourceManager.getPluginImage(this.symbolic, "icons/N\uac00\uaca9\ub300\ubcc4\ud1b5\uacc4.png"));
        this.tabItem_1 = new CTabItem(this.tabFolder, 0);
        this.tabItem_1.setText("\uc77c\ubcc4 \ud1b5\uacc4");
        this.tabItem_1.setImage(ResourceManager.getPluginImage(this.symbolic, "icons/N\uc77c\ubcc4\ud1b5\uacc4.png"));
        this.tabItem_2 = new CTabItem(this.tabFolder, 0);
        this.tabItem_2.setText("\uc6d4\ubcc4 \ud1b5\uacc4");
        this.tabItem_2.setImage(ResourceManager.getPluginImage(this.symbolic, "icons/N\uc6d4\ubcc4\ud1b5\uacc4.png"));
        this.tabItem_3 = new CTabItem(this.tabFolder, 0);
        this.tabItem_3.setText("\ud310\ub9e4\ucc98\ubcc4 \ud1b5\uacc4");
        this.tabItem_3.setImage(ResourceManager.getPluginImage(this.symbolic, "icons/N\ud310\ub9e4\ucc98\ubcc4\ud1b5\uacc4.png"));
        this.tabItem_4 = new CTabItem(this.tabFolder, 0);
        this.tabItem_4.setText("\ud310\ub9e4\ucc98\uacc4\uc815\ubcc4 \ud1b5\uacc4");
        this.tabItem_4.setImage(ResourceManager.getPluginImage(this.symbolic, "icons/N\uace0\uac1d\ubcc4\ud1b5\uacc4.png"));
        this.tabItem_5 = new CTabItem(this.tabFolder, 0);
        this.tabItem_5.setText("\uc0c1\ud488\ubcc4 \ud1b5\uacc4");
        this.tabItem_5.setImage(ResourceManager.getPluginImage(this.symbolic, "icons/N\uc0c1\ud488\ubcc4\ud1b5\uacc4.png"));
        this.createFirstTabItemComposite();
        this.dataBinding();
        this.createOrderGroupings();
        this.createTabItemCompoiste(1);
        this.createTabItemCompoiste(2);
        this.createTabItemCompoiste(3);
        this.createTabItemCompoiste(4);
        this.createTabItemCompoiste(5);
        return container;
    }

    private void createFirstTabItemComposite() {
        Composite compsite = new Composite((Composite)this.tabFolder, 0);
        this.tabItem.setControl((Control)compsite);
        compsite.setLayout((Layout)new GridLayout(1, false));
        compsite.setBackground(this.tabFolder.getBackground());
        Group counters = new Group(compsite, 0);
        counters.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        counters.setText("\uc8fc\ubb38 \uc694\uc57d");
        counters.setLayoutData((Object)new GridData(4, 128, true, false));
        counters.setLayout((Layout)new GridLayout(14, false));
        new Label((Composite)counters, 0).setText("\uc8fc\ubb38\uac74\uc218");
        this.txtOrderCnt = this.createNum((Composite)counters, 70);
        new Label((Composite)counters, 0).setText("\uac74");
        this.spacer((Composite)counters, 18);
        new Label((Composite)counters, 0).setText("\uace0\uc720\uc0c1\ud488\uc218");
        this.txtItems = this.createNum((Composite)counters, 70);
        new Label((Composite)counters, 0).setText("\uac1c");
        this.spacer((Composite)counters, 18);
        new Label((Composite)counters, 0).setText("\ucd1d\uc8fc\ubb38\uc218\ub7c9");
        this.txtTotalQty = this.createNum((Composite)counters, 70);
        new Label((Composite)counters, 0).setText("\uac1c");
        Label stretch = new Label((Composite)counters, 0);
        GridData gdStretch = new GridData(4, 0x1000000, true, false);
        gdStretch.horizontalSpan = 2;
        stretch.setLayoutData((Object)gdStretch);
        Button chartBtn = new Button((Composite)counters, 8);
        chartBtn.setText("\uadf8\ub798\ud504\ubcf4\uae30");
        GridData gdBtn = new GridData(131072, 0x1000000, false, false);
        gdBtn.widthHint = 140;
        gdBtn.heightHint = 36;
        gdBtn.horizontalSpan = 1;
        chartBtn.setLayoutData((Object)gdBtn);
        chartBtn.setEnabled(false);
        chartBtn.setVisible(false);
        Group group = new Group(compsite, 0);
        group.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        group.setText("\ud569\uacc4 \uacc4\uc0b0 \ub0b4\uc5ed");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(7, false));
        this.span((Composite)group, 7);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\ucd1d\uc8fc\ubb38\uae08\uc561");
        this.txtTotal = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \ub2e8\uac00 \u00d7 \uc218\ub7c9 ) + \uc635\uc158\ucd94\uac00\uae08\uc561", 3);
        this.span((Composite)group, 1);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561");
        this.txtMarketFee = this.createNum((Composite)group, 120);
        this.span((Composite)group, 4);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\uc218\uc218\ub8cc\uc728");
        this.txtRate = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561 / \ucd1d\uc8fc\ubb38\uae08\uc561 ) * 100", 3);
        this.span((Composite)group, 1);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\uacf5\uae09\uae08\uc561");
        this.txtSupply = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \ucd1d\uc8fc\ubb38\uae08\uc561 - \ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561 )", 3);
        this.span((Composite)group, 1);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\ud560\uc778\uae08\uc561");
        this.txtDiscount = this.createNum((Composite)group, 120);
        this.span((Composite)group, 4);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\uacb0\uc81c\uae08\uc561");
        this.txtRealTotal = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \ucd1d\uc8fc\ubb38\uae08\uc561 - \ud560\uc778\uae08\uc561 )", 3);
        this.span((Composite)group, 1);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\uc2e4\uc218\uc218\ub8cc\uc728");
        this.txtRealRate = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561 / \uc2e4\uc8fc\ubb38\uae08\uc561 ) * 100", 3);
        this.span((Composite)group, 1);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\uc815\uc0b0\uc608\uc815\uae08\uc561");
        this.txtExpected = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \uacf5\uae09\uae08\uc561 - \ud560\uc778\uae08\uc561 )", 3);
        this.span((Composite)group, 1);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\ubc30\uc1a1\ube44");
        this.txtDelvCost = this.createNum((Composite)group, 120);
        this.span((Composite)group, 4);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\uacb0\uc81c\uae08\uc561(\ubc30\uc1a1\ube44\ud3ec\ud568)");
        this.txtRealPlusDelv = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \uacb0\uc81c\uae08\uc561 + \ubc30\uc1a1\ube44 )", 3);
        this.span((Composite)group, 1);
        this.spacer((Composite)group, 20);
        this.createLabel((Composite)group, "\uc815\uc0b0\uc608\uc815\uae08\uc561(\ubc30\uc1a1\ube44\ud3ec\ud568)");
        this.txtExpectPlusDelv = this.createNum((Composite)group, 120);
        this.createHint((Composite)group, "= ( \uc815\uc0b0\uc608\uc815\uae08\uc561 + \ubc30\uc1a1\ube44 )", 3);
        this.span((Composite)group, 7);
        Group info = new Group(compsite, 0);
        info.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 1));
        info.setText("\uc815\ubcf4 \ub0b4\uc5ed");
        info.setLayoutData((Object)new GridData(4, 4, true, true));
        info.setLayout((Layout)new GridLayout(1, false));
        this.txtInfo = new Text((Composite)info, 2818);
        GridData gdInfo = new GridData(4, 4, true, true);
        gdInfo.heightHint = 150;
        this.txtInfo.setLayoutData((Object)gdInfo);
    }

    private void dataBinding() {
        if (this._list == null || this._list.size() == 0) {
            this.txtOrderCnt.setText("0");
            this.txtItems.setText("0");
            this.txtTotal.setText("0");
            this.txtMarketFee.setText("0");
            this.txtRate.setText("0");
            this.txtSupply.setText("0");
            this.txtDiscount.setText("0");
            this.txtRealTotal.setText("0");
            this.txtExpected.setText("0");
            this.txtDelvCost.setText("0");
            this.txtRealPlusDelv.setText("0");
            this.txtExpectPlusDelv.setText("0");
            return;
        }
        OrderSummary summary = this.calculateTotals(this._list);
        this.txtOrderCnt.setText(this.fmtInt(this._list.size()));
        this.txtItems.setText(this.fmtInt(summary.uniqueProdCount));
        this.txtTotalQty.setText(this.fmtInt(summary.qty));
        this.txtTotal.setText(this.fmtInt(summary.totalCost));
        this.txtMarketFee.setText(this.fmtInt(summary.marketFee));
        this.txtSupply.setText(this.fmtInt(summary.supply));
        this.txtDiscount.setText(this.fmtInt(summary.discount));
        this.txtRealTotal.setText(this.fmtInt(summary.realTotal));
        this.txtRate.setText(this.percentOf(summary.marketFee, summary.totalCost, 2));
        this.txtRealRate.setText(this.percentOf(summary.marketFee, summary.realTotal, 2));
        this.txtExpected.setText(this.fmtInt(summary.expect));
        this.txtDelvCost.setText(this.fmtInt(summary.delvCost));
        this.txtRealPlusDelv.setText(this.fmtInt(summary.realPlusD));
        this.txtExpectPlusDelv.setText(this.fmtInt(summary.expectPlusD));
        this.txtInfo.setText(this.getMemo(summary));
    }

    private void createOrderGroupings() {
        if (this._list == null || this._list.size() == 0) {
            return;
        }
        Map byDay = this._list.stream().collect(Collectors.groupingBy(dto -> dto.getOrder_date().substring(0, 10), TreeMap::new, Collectors.toList()));
        this.completeOrderStatisticsList(byDay, this.orderStatisticsByDay, 0);
        Map byMonth = this._list.stream().collect(Collectors.groupingBy(dto -> dto.getOrder_date().substring(0, 7), TreeMap::new, Collectors.toList()));
        this.completeOrderStatisticsList(byMonth, this.orderStatisticsByMonth, 0);
        Map<String, List<ShopOrderMstNewDto>> byShop = this._list.stream().collect(Collectors.groupingBy(ShopOrderMstNewDto::getShopid));
        this.completeOrderStatisticsList(byShop, this.orderStatisticsByShop, 1);
        Map<String, List<ShopOrderMstNewDto>> byShopAndSeq = this._list.stream().collect(Collectors.groupingBy(dto -> dto.getShopid() + "-" + dto.getShopseq()));
        this.completeOrderStatisticsList(byShopAndSeq, this.orderStatisticsByShopAndNickname, 2);
        Map<String, List<ShopOrderMstNewDto>> byProduct = this._list.stream().collect(Collectors.groupingBy(ShopOrderMstNewDto::getP_product_name));
        this.completeOrderStatisticsList(byProduct, this.orderStatisticsByProduct, 0);
    }

    private void completeOrderStatisticsList(Map<String, List<ShopOrderMstNewDto>> map, List<OrderStatisticsDto> statisticsList, int stat) {
        Object gubun = "";
        for (String key : map.keySet()) {
            List<ShopOrderMstNewDto> list = map.get(key);
            OrderSummary summary = this.calculateTotals(list);
            OrderStatisticsDto dto = new OrderStatisticsDto();
            gubun = key;
            if (stat == 1) {
                gubun = ShopCommon.getShoppingMallName(key);
            } else if (stat == 2) {
                gubun = ShopCommon.getShoppingMallName(list.get(0).getShopid()) + "-" + list.get(0).getNickname() + "(" + list.get(0).getShop_userid() + ")";
            }
            dto.gubun = gubun;
            dto.orderCnt = this.fmtInt(list.size());
            dto.items = this.fmtInt(summary.uniqueProdCount);
            dto.total = this.fmtInt(summary.totalCost);
            dto.marketFee = this.fmtInt(summary.marketFee);
            dto.rate = this.percentOf(summary.marketFee, summary.totalCost, 2);
            dto.supply = this.fmtInt(summary.supply);
            dto.discount = this.fmtInt(summary.discount);
            dto.realTotal = this.fmtInt(summary.realTotal);
            dto.expected = this.fmtInt(summary.expect);
            dto.delvCost = this.fmtInt(summary.delvCost);
            dto.realTotalPlusDelv = this.fmtInt(summary.realPlusD);
            dto.expectPlusDelv = this.fmtInt(summary.expectPlusD);
            dto.companygoodscd = list.get(0).getCompayny_goods_cd();
            statisticsList.add(dto);
        }
    }

    private void createTabItemCompoiste(int seq) {
        String firstText = "";
        int firstSize = 0;
        CTabItem tabItem = null;
        switch (seq) {
            case 1: {
                firstText = "\uc77c\ubcc4\ub0a0\uc9dc";
                firstSize = 120;
                tabItem = this.tabItem_1;
                break;
            }
            case 2: {
                firstText = "\uc6d4\ubcc4\ub0a0\uc9dc";
                firstSize = 100;
                tabItem = this.tabItem_2;
                break;
            }
            case 3: {
                firstText = "\uc1fc\ud551\ubab0";
                firstSize = 120;
                tabItem = this.tabItem_3;
                break;
            }
            case 4: {
                firstText = "\uc1fc\ud551\ubab0-\ub2c9\ub124\uc784(\uc544\uc774\ub514)";
                firstSize = 300;
                tabItem = this.tabItem_4;
                break;
            }
            case 5: {
                firstText = "\uc0c1\ud488\uba85";
                firstSize = 400;
                tabItem = this.tabItem_5;
            }
        }
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        tabItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(this.tabFolder.getBackground());
        Composite wrapper = new Composite(composite, 0);
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        wrapper.setLayout((Layout)new GridLayout(1, false));
        GridTableViewer gridTableViewer = new GridTableViewer(wrapper, 2818);
        Grid grid = gridTableViewer.getGrid();
        GridData gdGrid = new GridData(4, 4, true, true);
        gdGrid.widthHint = 800;
        gdGrid.heightHint = 400;
        gdGrid.minimumWidth = 400;
        grid.setLayoutData((Object)gdGrid);
        grid.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        grid.setLinesVisible(true);
        grid.setLineColor(SWTResourceManager.getColor(18));
        grid.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setRGB(68, 80, 94);
        myHeaderRender.setFGC(1);
        GridColumn tableViewerColumn = new GridColumn(grid, 0x1000000);
        tableViewerColumn.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
        tableViewerColumn.setWidth(firstSize);
        tableViewerColumn.setText(firstText);
        tableViewerColumn.setAlignment(0x1000000);
        for (YDMAGridColumn col : this.col_list.getColumns()) {
            GridColumn tableViewerColumn_x = new GridColumn(grid, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setWidth(col.getWidth());
            tableViewerColumn_x.setText(col.getText());
            tableViewerColumn_x.setAlignment(0x1000000);
        }
        if (seq == 5) {
            GridColumn tableViewerColumn2 = new GridColumn(grid, 0x1000000);
            tableViewerColumn2.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn2.setWidth(100);
            tableViewerColumn2.setText("\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc");
            tableViewerColumn2.setAlignment(16384);
        }
        gridTableViewer.setContentProvider((IContentProvider)new MyContentProvider());
        gridTableViewer.setLabelProvider((IBaseLabelProvider)new MyLableProvider());
        switch (seq) {
            case 1: {
                gridTableViewer.setInput(this.orderStatisticsByDay);
                break;
            }
            case 2: {
                gridTableViewer.setInput(this.orderStatisticsByMonth);
                break;
            }
            case 3: {
                gridTableViewer.setInput(this.orderStatisticsByShop);
                break;
            }
            case 4: {
                gridTableViewer.setInput(this.orderStatisticsByShopAndNickname);
                break;
            }
            case 5: {
                gridTableViewer.setInput(this.orderStatisticsByProduct);
            }
        }
    }

    private void spacer(Composite parent, int px) {
        Label s = new Label(parent, 0);
        GridData gd = new GridData();
        gd.widthHint = px;
        s.setLayoutData((Object)gd);
    }

    private Label createLabel(Composite p, String text) {
        Label l = new Label(p, 0);
        l.setText(" " + text);
        l.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        l.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 9, 1));
        return l;
    }

    private Text createNum(Composite p, int width) {
        Text t = new Text(p, 133120);
        GridData gd = new GridData();
        gd.widthHint = width;
        t.setLayoutData((Object)gd);
        return t;
    }

    private void span(Composite p, int size) {
        int i = 0;
        while (i < size) {
            new Label(p, 0);
            ++i;
        }
    }

    private void createHint(Composite p, String hint, int span) {
        Label h = new Label(p, 0);
        h.setText("  " + hint);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.horizontalSpan = span;
        h.setLayoutData((Object)gd);
    }

    private OrderSummary calculateTotals(List<ShopOrderMstNewDto> list) {
        OrderSummary summary = new OrderSummary();
        int totalCost = 0;
        int expect = 0;
        int qty = 0;
        int delvCost = 0;
        int marketFee = 0;
        int supply = 0;
        int payCost = 0;
        int discount = 0;
        int expectPlusD = 0;
        int realPlusD = 0;
        HashSet<String> uniqueProdSet = new HashSet<String>();
        for (ShopOrderMstNewDto dto : list) {
            try {
                totalCost += this.parseIntSafe(dto.getTotal_cost());
            }
            catch (Exception exception) {
                totalCost += 0;
            }
            expect += this.parseIntSafe(dto.getMall_won_cost());
            qty += this.parseIntSafe(dto.getSale_cnt());
            delvCost += this.parseIntSafe(dto.getDelv_cost());
            marketFee += this.parseIntSafe(dto.getMall_fee());
            supply += this.parseIntSafe(dto.getSupply_cost());
            payCost += this.parseIntSafe(dto.getPay_cost());
            discount += this.parseIntSafe(dto.getDiscount_cost());
            expectPlusD += this.parseIntSafe(dto.getExpected_add_delv());
            realPlusD += this.parseIntSafe(dto.getPay_cost_add_delv());
            uniqueProdSet.add(dto.getProduct_name());
        }
        summary.totalCost = totalCost;
        summary.expect = expect;
        summary.qty = qty;
        summary.delvCost = delvCost;
        summary.marketFee = marketFee;
        summary.supply = supply;
        summary.realTotal = payCost;
        summary.discount = discount;
        summary.realPlusD = realPlusD;
        summary.expectPlusD = expectPlusD;
        summary.uniqueProdCount = uniqueProdSet.size();
        return summary;
    }

    private int parseIntSafe(String s) {
        String t;
        block3: {
            try {
                t = this.onlyDigits(s);
                if (!t.isEmpty() && !t.equals("-")) break block3;
                return 0;
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return Integer.parseInt(t);
    }

    private String onlyDigits(String s) {
        if (s == null) {
            return "";
        }
        return s.replaceAll("[^0-9]", "");
    }

    private String fmtInt(int v) {
        return String.format("%,d", v);
    }

    private String percentOf(int part, int base, int scale) {
        if (base == 0) {
            return "0%";
        }
        double p = (double)part * 100.0 / (double)base;
        return String.format(Locale.KOREA, "%." + scale + "f%%", p);
    }

    private String getMemo(OrderSummary summary) {
        String formatMemo = "\uc8fc\ubb38\uac74\uc218: %s\uac74%n\uace0\uc720\uc0c1\ud488\uc218: %s\uac1c%n\ucd1d\uc8fc\ubb38\uc218\ub7c9: %s\uac1c%n%n\ucd1d\uc8fc\ubb38\uae08\uc561: %s\uc6d0%n\ub9c8\ucf13\uc218\uc218\ub8cc\uae08\uc561: %s\uc6d0%n\uc218\uc218\ub8cc\uc728: %s%n\uacf5\uae09\uae08\uc561: %s\uc6d0%n\ud560\uc778\uae08\uc561: %s\uc6d0%n\uc2e4\uc8fc\ubb38\uae08\uc561: %s\uc6d0%n\uc2e4\uc218\uc218\ub8cc\uc728: %s%n\uc815\uc0b0\uc608\uc815\uae08\uc561: %s\uc6d0%n\ubc30\uc1a1\ube44: %s\uc6d0%n\uc2e4\uc8fc\ubb38\uae08\uc561(\ubc30\uc1a1\ube44\ud3ec\ud568): %s\uc6d0%n\uc815\uc0b0\uc608\uc815\uae08\uc561(\ubc30\uc1a1\ube44\ud3ec\ud568): %s\uc6d0%n";
        return String.format(formatMemo, this.fmtInt(this._list.size()), this.fmtInt(summary.uniqueProdCount), this.fmtInt(summary.qty), this.fmtInt(summary.totalCost), this.fmtInt(summary.marketFee), this.percentOf(summary.marketFee, summary.totalCost, 2), this.fmtInt(summary.supply), "0", this.fmtInt(summary.realTotal), this.percentOf(summary.marketFee, summary.realTotal, 2), this.fmtInt(summary.expect), this.fmtInt(summary.delvCost), this.fmtInt(summary.realPlusD), this.fmtInt(summary.expectPlusD));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btn_cancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        this.btn_cancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("\ud1b5\uacc4");
        super.configureShell(newShell);
    }

    class MyContentProvider
    extends ArrayContentProvider
    implements IStructuredContentProvider {
        MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    class MyLableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        MyLableProvider() {
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            OrderStatisticsDto dto = (OrderStatisticsDto)element;
            String value = "";
            switch (columnIndex) {
                case 0: {
                    value = dto.gubun;
                    break;
                }
                case 1: {
                    value = dto.orderCnt;
                    break;
                }
                case 2: {
                    value = dto.items;
                    break;
                }
                case 3: {
                    value = dto.total;
                    break;
                }
                case 4: {
                    value = dto.marketFee;
                    break;
                }
                case 5: {
                    value = dto.rate;
                    break;
                }
                case 6: {
                    value = dto.supply;
                    break;
                }
                case 7: {
                    value = dto.discount;
                    break;
                }
                case 8: {
                    value = dto.realTotal;
                    break;
                }
                case 9: {
                    value = dto.expected;
                    break;
                }
                case 10: {
                    value = dto.delvCost;
                    break;
                }
                case 11: {
                    value = dto.realTotalPlusDelv;
                    break;
                }
                case 12: {
                    value = dto.expectPlusDelv;
                    break;
                }
                case 13: {
                    value = dto.companygoodscd;
                }
            }
            return value;
        }
    }

    class OrderStatisticsDto {
        private String gubun;
        private String orderCnt;
        private String items;
        private String total;
        private String marketFee;
        private String rate;
        private String supply;
        private String discount;
        private String realTotal;
        private String expected;
        private String delvCost;
        private String realTotalPlusDelv;
        private String expectPlusDelv;
        private String companygoodscd;

        OrderStatisticsDto() {
        }
    }

    class OrderSummary {
        int totalCost;
        int expect;
        int qty;
        int delvCost;
        int discount;
        int marketFee;
        int supply;
        int realTotal;
        int realPlusD;
        int expectPlusD;
        int uniqueProdCount;

        OrderSummary() {
        }
    }
}

