/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.CloudinaryApiInfoDto;
import com.kdjsystem.mlink.shop.mlink.MLinkLoginResponseDto;
import com.kdjsystem.mlink.shop.mlink.MLinkSessonUtil;
import com.kdjsystem.mlink.tot.Activator;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.UserDto;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MLinkAPI {
    private static MLinkAPI instance = new MLinkAPI();
    static final String LOGIN_HOST = "http://api.kdjsystem.com:8080";
    final OkHttpClient client = new OkHttpClient();

    public static MLinkAPI get() {
        return instance;
    }

    public UserDto Login(String compno, String id, String pw) throws Exception {
        UserDto dto;
        block18: {
            dto = new UserDto();
            int instcount = Activator.getCurrentCountFromSocketServer();
            StringBuffer payload = new StringBuffer();
            payload.append("{ \n");
            payload.append("\t\"compno\":" + compno + ", \n");
            payload.append("\t\"userid\":\"" + id + "\", \n");
            payload.append("\t\"password\":\"" + pw + "\", \n");
            payload.append("\t\"instcount\":" + instcount + " \n");
            payload.append("}\n");
            try {
                block19: {
                    MediaType mediaType = MediaType.parse((String)"");
                    RequestBody body = RequestBody.create((MediaType)mediaType, (String)payload.toString());
                    Request request2 = new Request.Builder().url(LOGIN_HOST.concat("/api/v2/login2")).addHeader("Content-Type", "application/json").post(body).build();
                    String data2 = this.client.newCall(request2).execute().body().string().toString();
                    if (data2 == null || data2.length() <= 0) break block19;
                    try {
                        ObjectMapper mapper = new ObjectMapper();
                        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                        MLinkLoginResponseDto userInfo = (MLinkLoginResponseDto)mapper.readValue(data2, MLinkLoginResponseDto.class);
                        if (userInfo.resultCode.equals("0")) {
                            dto.setCompno(compno);
                            dto.setUserId(id);
                            dto.setUsernam(userInfo.usernam);
                            dto.setUserpwd(pw);
                            dto.setEmail(userInfo.email);
                            dto.setProgcd(userInfo.progcd);
                            dto.setUseyn("Y");
                            dto.setLtype(userInfo.ltype);
                            dto.setEnduse(userInfo.enduse);
                            dto.setStartuse(userInfo.startuse);
                            dto.setPricetype(userInfo.pricetype);
                            dto.setY_enduse(userInfo.y_enduse);
                            dto.setY_priceType(userInfo.y_priceType);
                            MLinkSessonUtil.get().setUserInfo(userInfo);
                            YDMAStringUtil.Print(MLinkSessonUtil.get().getToken());
                            break block18;
                        }
                        switch (userInfo.resultCode) {
                            case "-99": {
                                MLinkSessonUtil.get().ResultLoginText = "\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uacc4\uc815\uc785\ub2c8\ub2e4.";
                                dto = null;
                                break;
                            }
                            case "-1": {
                                MLinkSessonUtil.get().ResultLoginText = "\uc544\uc774\ub514 \ub610\ub294 \ube44\ubc00\ubc88\ud638\uac00 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                                dto = null;
                                break;
                            }
                            case "-2": {
                                MLinkSessonUtil.get().ResultLoginText = "\uc0ac\uc6a9 \uac00\ub2a5\ud55c PC \uac1c\uc218\ub97c \ucd08\uacfc\ud588\uc2b5\ub2c8\ub2e4.\n10\ubd84 \ud6c4 \ub2e4\uc2dc \ub85c\uadf8\uc778\ud574 \uc8fc\uc138\uc694.";
                                dto = null;
                                break;
                            }
                            default: {
                                MLinkSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \ucc98\ub9ac \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \uc5d0\ub7ec\ubc88\ud638: [" + userInfo.resultCode + "]";
                                dto = null;
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        MLinkSessonUtil.get().ResultLoginText = e.getMessage();
                    }
                    break block18;
                }
                MLinkSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \uc751\ub2f5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
            }
            catch (Exception e) {
                MLinkSessonUtil.get().ResultLoginText = e.getMessage();
            }
        }
        return dto;
    }

    public void DosinCountCheck(String compno, String id, String pw, String date) {
        try {
            String ipadd = IShopCommonLogin.getLocalMacAddress().replace("-", "");
            pw = this.encodeValue(pw);
            String path = "http://api.kdjsystem.com:8080/api/v1/dosincount?compno=" + compno + "&id=" + id + "&pw=" + pw + "&date=" + date.concat("-").concat(ipadd);
            Request request2 = new Request.Builder().url(path).method("GET", null).build();
            this.client.newCall(request2).execute();
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
    }

    private String encodeValue(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
    }

    public void setUserCountPermitAPI(String stat) {
        try {
            String ipadd = IShopCommonLogin.getLocalMacAddress().replace("-", "");
            String compno = YDMASessonUtil.getCompnoInfo().getCompno();
            String id = YDMASessonUtil.getUserInfo().getUserId();
            String path = String.format("%s/api/v1/setusercount?compno=%s&id=%s&stat=%s&macaddr=%s", LOGIN_HOST, compno, id, stat, ipadd);
            Request request2 = new Request.Builder().url(path).method("GET", null).build();
            this.client.newCall(request2).execute();
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
    }

    public void findEnduseAndPriceType() {
        try {
            int compno = Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno());
            String id = YDMASessonUtil.getUserInfo().getUserId();
            String path = String.format("%s/api/v1/findEnduseAndPriceType?compno=%s&id=%s", LOGIN_HOST, compno, id);
            Request request2 = new Request.Builder().url(path).method("GET", null).build();
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    if (!response.isSuccessful() || response.body() == null) {
                        MLinkSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \uc751\ub2f5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                        return;
                    }
                    String data2 = response.body().string();
                    if (data2 == null || data2.length() <= 0) {
                        MLinkSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \ube48 \uc751\ub2f5\uc744 \ubc1b\uc558\uc2b5\ub2c8\ub2e4.";
                        return;
                    }
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    MLinkLoginResponseDto userInfo = (MLinkLoginResponseDto)mapper.readValue(data2, MLinkLoginResponseDto.class);
                    if (userInfo != null) {
                        YDMASessonUtil.getUserInfo().setEnduse(userInfo.enduse);
                        YDMASessonUtil.getUserInfo().setPricetype(userInfo.pricetype);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                MLinkSessonUtil.get().ResultLoginText = "API \ud638\ucd9c \uc2e4\ud328: " + e.getMessage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            YDMAStringUtil.Print("\uc138\uc158 \uc815\ubcf4 \ud30c\uc2f1 \uc624\ub958: " + e.getMessage());
        }
    }

    public CloudinaryApiInfoDto findEasyCloudStatus(CloudinaryApiInfoDto dto) {
        CloudinaryApiInfoDto EasyCloudInfo = new CloudinaryApiInfoDto();
        try {
            String path = String.format("%s/api/v1/findEasyCloudStatus?seq=%s&cloudname=%s", LOGIN_HOST, dto.getSeq(), dto.getCloudname());
            Request request2 = new Request.Builder().url(path).method("GET", null).build();
            try {
                Throwable throwable = null;
                Object var6_9 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    if (!response.isSuccessful() || response.body() == null) {
                        MLinkSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \uc751\ub2f5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                        return EasyCloudInfo;
                    }
                    String data2 = response.body().string();
                    if (data2 == null || data2.length() <= 0) {
                        MLinkSessonUtil.get().ResultLoginText = "\ub85c\uadf8\uc778 \uc11c\ubc84\ub85c\ubd80\ud130 \ube48 \uc751\ub2f5\uc744 \ubc1b\uc558\uc2b5\ub2c8\ub2e4.";
                        return EasyCloudInfo;
                    }
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                    EasyCloudInfo = (CloudinaryApiInfoDto)mapper.readValue(data2, CloudinaryApiInfoDto.class);
                    if (EasyCloudInfo != null) {
                        return EasyCloudInfo;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                MLinkSessonUtil.get().ResultLoginText = "API \ud638\ucd9c \uc2e4\ud328: " + e.getMessage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            YDMAStringUtil.Print("\uc138\uc158 \uc815\ubcf4 \ud30c\uc2f1 \uc624\ub958: " + e.getMessage());
        }
        return EasyCloudInfo;
    }
}

