/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.mlink;

import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.OrderStatus;
import com.kdjsystem.mlink.shop.common.ShopLoadingBar;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.domaemart.DomaemartCommon;
import com.kdjsystem.mlink.shop.domeatoz.DomeAtozOrderCommon;
import com.kdjsystem.mlink.shop.domechanggo.DomechanggoCommon;
import com.kdjsystem.mlink.shop.domeggook.DomeggookCommon;
import com.kdjsystem.mlink.shop.domesin.DomesinCommon;
import com.kdjsystem.mlink.shop.domesin.DomesinLogin;
import com.kdjsystem.mlink.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.shop.feelwoo.FeelwooCommon;
import com.kdjsystem.mlink.shop.funnshopping.FunNOrderCommon;
import com.kdjsystem.mlink.shop.hubseller.HubsellerCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.onchannel.OnChannelCommon;
import com.kdjsystem.mlink.shop.onnme.OnnmeCommon;
import com.kdjsystem.mlink.shop.ownerclan.OwnerClanCommon;
import com.kdjsystem.mlink.shop.roomnoffice.RoomNOfficeCommon;
import com.kdjsystem.mlink.shop.sellerfriend.SellerfriendCommon;
import com.kdjsystem.mlink.shop.sellmall.SellmallCommon;
import com.kdjsystem.mlink.shop.threemro.ThreeMroCommon;
import com.kdjsystem.mlink.shop.tobizon.TobizonOrderCommon;
import com.kdjsystem.mlink.shop.zentrade.ZentradeCommon;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.ui.OrderListUpload11stManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.chrome.ChromeDriver;

public class MLinkDomeOrderCollectConnection {
    static MLinkDomeOrderCollectConnection instance = new MLinkDomeOrderCollectConnection();
    String title = "\uc8fc\ubb38\uc5f0\ub3d9";
    private Shell _shell;
    private DateTime _dateTime_from;
    private DateTime _dateTime_to;
    OrderListUpload11stManager _opener;

    public static MLinkDomeOrderCollectConnection get() {
        return instance;
    }

    public void CollectDomeOrder(OrderListUpload11stManager opener, String shopcd, String shopseq, Shell shell, GridItem[] gridItems, DateTime dateTime_from, DateTime dateTime_to) {
        this._shell = shell;
        this._dateTime_from = dateTime_from;
        this._dateTime_to = dateTime_to;
        this._opener = opener;
        if (YDMASessonUtil.getLoginType() == 2) {
            if (shopcd.equals("shop0000")) {
                this.getMLinkOrddtl();
            } else {
                this.CollectDomeOrderEach(shopcd, shopseq, gridItems);
            }
        } else {
            this.getMLinkOrddtl();
        }
    }

    private void CollectDomeOrderEach(String shopcd, String shopseq, GridItem[] gridItems) {
        if (gridItems == null || gridItems.length == 0) {
            MessageDialog.openInformation((Shell)this._shell, (String)this.title, (String)"\uc120\ud0dd\ub41c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ud655\uc778\ud6c4\uc5d0 \uc9c4\ud589\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
            return;
        }
        try {
            this.commandOrderValidate(gridItems, "501", this._dateTime_from, this._dateTime_to);
            List<ShopOrderMstDto> list = Arrays.stream(gridItems).map(d -> (ShopOrderMstDto)d.getData()).collect(Collectors.toList());
            YDMAProgressBar.get().start(this.getMessage(shopcd, true), list.size(), 100, true);
            YDMAProgressBar.get().setValue(this.getMessage(shopcd, false), 0);
            list = this.getDomeOrderList(list, shopcd, shopseq, null, false);
            list = list.stream().filter(d -> d.getResult_code() != null && d.getResult_code().equals("1")).collect(Collectors.toList());
            if (list.size() > 0) {
                ShopOrderDao.get().SaveOrUpdate(list);
            }
            this._opener.bindData();
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)this._shell, (String)this.title, (String)e.getMessage());
        }
    }

    private List<ShopOrderMstDto> getDomeOrderList(List<ShopOrderMstDto> list, String shopcd, String shopseq, YDMAProgressBar console, boolean isAll) {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        try {
            ChromeDriver driver = null;
            HashMap map = new HashMap();
            if (isAll) {
                for (ShopOrderMstDto dto : list) {
                    String orderCode = dto.getDosinOrder_code();
                    if (orderCode.contains("-")) {
                        int key = Integer.parseInt(orderCode.split("-")[1]);
                        map.putIfAbsent(key, new ArrayList());
                        ((List)map.get(key)).add(dto);
                        continue;
                    }
                    map.putIfAbsent(1, new ArrayList());
                    ((List)map.get(1)).add(dto);
                }
            } else {
                int key = Integer.parseInt(shopseq);
                map.putIfAbsent(key, new ArrayList());
                ((List)map.get(key)).addAll(list);
            }
            switch (shopcd) {
                case "shop0283": {
                    if (YDMASessonUtil.getLoginType() == 2 && DomesinSessonUtil.get().getLargeCategory() == null) {
                        DomesinLogin.get().Login();
                    }
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(DomesinCommon.get().OrderListComplateCallBack((List)map.get(key), console, dto, isAll));
                    }
                    break;
                }
                case "shop0284": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        driver = IShopCommonLogin.loginDomesin2(dto.getShoppingid(), dto.getPassword(), true);
                        retList.addAll(DomesinCommon.get().OrderListComplateCallBack2((List)map.get(key), ChromeScript.get().getCookies(driver), console, isAll));
                    }
                    break;
                }
                case "shop0286": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(FunNOrderCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9991": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(DomeAtozOrderCommon.get().atozOrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop0316": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(TobizonOrderCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9994": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(ThreeMroCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop5001": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(HubsellerCommon.get().HubsellerOrderSearch((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop0319": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(DomeggookCommon.get().DomeggokOrderSearch((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop7777": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(SellmallCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9995": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(ZentradeCommon.get().ZentradeOrderSearch((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop0203": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(DomechanggoCommon.get().DomechanggoOrderSearch((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9996": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(OnChannelCommon.get().OnchannelOrderSearch((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9990": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(FeelwooCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9989": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(SellerfriendCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9987": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(OnnmeCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9986": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(RoomNOfficeCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop9985": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        retList.addAll(DomaemartCommon.get().OrderListComplateCallBack((List)map.get(key), dto, console, isAll));
                    }
                    break;
                }
                case "shop0120": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        if ("Y".equals(dto.getVendorId())) {
                            driver = IShopCommonLogin.loginOwnerClan(dto.getShoppingid(), dto.getPassword(), dto.getShopcd(), true);
                            retList.addAll(OwnerClanCommon.get().ownerClanCollectOrder((List)map.get(key), dto, ChromeScript.get().getCookies(driver), console, isAll));
                            continue;
                        }
                        retList.addAll(OwnerClanCommon.get().ownerClanCollectOrder((List)map.get(key), dto, null, console, isAll));
                    }
                }
            }
        }
        catch (Exception e) {
            if (this._shell == null) {
                this.setValue(console, "", 0);
            }
            MessageDialog.openInformation((Shell)this._shell, (String)this.title, (String)e.getMessage());
        }
        return retList;
    }

    private List<ShopOrderMstDto> syncDomeOrders(List<ShopOrderMstDto> list, String shopcd, String shopseq, YDMAProgressBar console) {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        try {
            HashMap map = new HashMap();
            for (ShopOrderMstDto dto : list) {
                String orderCode = dto.getDosinOrder_code();
                if (orderCode.contains("-")) {
                    int key = Integer.parseInt(orderCode.split("-")[1]);
                    map.putIfAbsent(key, new ArrayList());
                    ((List)map.get(key)).add(dto);
                    continue;
                }
                map.putIfAbsent(1, new ArrayList());
                ((List)map.get(1)).add(dto);
            }
            switch (shopcd) {
                case "shop0120": {
                    for (Integer key : map.keySet()) {
                        ShoppingMallDetailDto dto = ShopCommonDao.get().getShopDtlIdWithDome(shopcd, String.valueOf(key));
                        if (dto.getVendorId().equals("Y")) {
                            this.setValue(console, "\uc624\ub108\ud074\ub79c \uc8fc\ubb38 \ub3d9\uae30\ud654\ub294 API \ubc29\uc2dd\ub9cc \uc0ac\uc6a9 \uac00\ub2a5\ud569\ub2c8\ub2e4.", 0);
                            continue;
                        }
                        retList.addAll(OwnerClanCommon.get().syncOwnerClanOrders((List)map.get(key), dto, console));
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            if (this._shell == null) {
                this.setValue(console, "", 0);
            }
            MessageDialog.openInformation((Shell)this._shell, (String)this.title, (String)e.getMessage());
        }
        return retList;
    }

    public void CollectDomeOrderAll(OrderListUpload11stManager opener, Shell shell, List<ShopOrderMstDto> order_list, DateTime dateTime_from, DateTime dateTime_to, String start, String end, boolean isScheduler, YDMAProgressBar console) {
        if (order_list == null) {
            this.FinishMent(isScheduler, console);
            return;
        }
        if ((order_list = order_list.stream().filter(p -> p.getOrder_status().equals("500") || p.getOrder_status().equals("501")).filter(p -> p.getGoods_keyword() != null).collect(Collectors.toList())).size() == 0) {
            this.FinishMent(isScheduler, console);
            return;
        }
        if (!isScheduler) {
            YDMAProgressBar.get().start(this.getMessage("", true), order_list.size(), 100, true);
        }
        this.setValue(console, "\ub3c4\ub9e4\ubab0\ubcc4 \uc77c\uad04\uc8fc\ubb38 \uc218\uc9d1 \uc2dc\uc791", 0);
        int totalCount = order_list.size();
        int newCount = (int)order_list.stream().filter(p -> p.getOrder_status().equals("500")).count();
        int preparedCount = totalCount - newCount;
        this.setValue(console, "\ub3c4\ub9e4\uc2e0\uaddc " + newCount + "\uac74, \ub3c4\ub9e4\uc900\ube44 " + preparedCount + "\uac74, \ucd1d " + order_list.size() + "\uac74\uc758 \ub3c4\ub9e4 \uc8fc\ubb38 \uc815\ubcf4 \uac00\uc838\uc624\uae30\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4", 0);
        if (isScheduler) {
            order_list.forEach(d -> {
                d.setStartDt(start);
                d.setEndDt(end);
            });
        } else {
            this._shell = shell;
            this._opener = opener;
            order_list.forEach(d -> {
                d.setStartDt(YDMATimeUtil.getRoRddtDate(dateTime_from));
                d.setEndDt(YDMATimeUtil.getRoRddtDate(dateTime_to));
            });
        }
        List malls = order_list.stream().map(p -> {
            String companyGoodsCd = p.getCompayny_goods_cd();
            return this.getMallCodeFromGoodsCd(companyGoodsCd, p.getGoods_keyword());
        }).distinct().collect(Collectors.toList());
        Map<String, List<ShopOrderMstDto>> order_mapList = order_list.stream().collect(Collectors.groupingBy(p -> {
            String companyGoodsCd = p.getCompayny_goods_cd();
            return this.getMallCodeFromGoodsCd(companyGoodsCd, p.getGoods_keyword());
        }));
        int succesCount = 0;
        for (String mall : malls) {
            try {
                ShoppingMallDetailDto shopdto = ShopCommonDao.get().getShopDtlOneIdWithDome(mall);
                succesCount += this.CollectDomeOrderAllEach(shopdto.getShopcd(), shopdto.getShopseq(), order_mapList.get(mall), isScheduler, console);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int failedCount = totalCount - succesCount;
        this.setValue(console, "--------------------------------------------------------------------------------------", 0);
        this.setValue(console, String.format("[\uc804\uccb4 \uacb0\uacfc] \ub3d9\uae30\ud654 \uc131\uacf5\uac74\uc218 %s\uac74, \uc2e4\ud328\uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4.", succesCount, failedCount), totalCount);
        if (!isScheduler) {
            this._opener.bindData();
        }
    }

    private void FinishMent(boolean isScheduler, YDMAProgressBar console) {
        if (!isScheduler) {
            YDMAProgressBar.get().start(this.getMessage("", true), 100, 100, true);
        }
        this.setValue(console, "\ub3c4\ub9e4\ubab0\ubcc4 \uc77c\uad04\uc8fc\ubb38 \uc218\uc9d1 \uc2dc\uc791", 0);
        this.setValue(console, "\ub3c4\ub9e4\uc2e0\uaddc 0\uac74, \ub3c4\ub9e4\uc900\ube44 0\uac74, \ucd1d 0\uac74\uc758 \ub3c4\ub9e4 \uc8fc\ubb38 \uc815\ubcf4 \uac00\uc838\uc624\uae30\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
        this.setValue(console, "--------------------------------------------------------------------------------------", 0);
        this.setValue(console, "[\uc804\uccb4 \uacb0\uacfc] \ub3d9\uae30\ud654 \uc131\uacf5\uac74\uc218 0\uac74, \uc2e4\ud328\uac74\uc218 0\uac74 \uc785\ub2c8\ub2e4.", 100);
    }

    private int CollectDomeOrderAllEach(String shopcd, String shopseq, List<ShopOrderMstDto> list, boolean isScheduler, YDMAProgressBar console) {
        int successCount = 0;
        try {
            this.setValue(console, "--------------------------------------------------------------------------------------", 0);
            if (!shopcd.equals("shop0120")) {
                this.setValue(console, this.getMessage(shopcd, false), 0);
            }
            list = this.getDomeOrderList(list, shopcd, shopseq, console, true);
            if ((list = list.stream().filter(d -> d.getResult_code() != null && d.getResult_code().equals("1")).collect(Collectors.toList())).size() > 0) {
                ShopOrderDao.get().SaveOrUpdate(list);
            }
            successCount = list.size();
        }
        catch (Exception e) {
            if (isScheduler) {
                this.setValue(console, e.getMessage(), 0);
            }
            MessageDialog.openInformation((Shell)this._shell, (String)this.title, (String)e.getMessage());
        }
        return successCount;
    }

    private int CollectDomeOrderAllSyncEach(ShoppingMallDetailDto shopdto, List<ShopOrderMstDto> list, boolean isScheduler, YDMAProgressBar console) {
        int successCount = 0;
        String shopcd = shopdto.getShopcd();
        String shopseq = shopdto.getShopseq();
        try {
            if (!shopcd.equals("shop0120")) {
                this.setValue(console, this.getMessage(shopcd, false), 0);
            }
            if ((list = this.syncDomeOrders(list, shopcd, shopseq, console)).size() > 0) {
                ShopOrderDao.get().SaveDuplicateOrders(list, shopdto, false);
                for (ShopOrderMstDto dto : list) {
                    String headerText = " \u2192 \uc911\ubcf5 \uc8fc\ubb38\uc73c\ub85c \uc758\uc2ec\ub418\ub294 \ub370\uc774\ud130\ub97c \uc218\uc9d1\ud588\uc2b5\ub2c8\ub2e4.\n     ";
                    String comment = String.format("%s | %s | %s", dto.getCompayny_goods_cd(), dto.getReceive_name(), dto.getDs_order_status());
                    this.setValueAndJobLog(console, headerText + comment, 0, dto, "ORD_DOME_SYNC", "\uc131\uacf5", comment);
                }
            }
            successCount = list.size();
        }
        catch (Exception e) {
            if (isScheduler) {
                this.setValue(console, e.getMessage(), 0);
            }
            MessageDialog.openInformation((Shell)this._shell, (String)this.title, (String)e.getMessage());
        }
        return successCount;
    }

    public void CollectDomeOrderAllSync(OrderListUpload11stManager opener, Shell shell, List<ShopOrderMstDto> order_list, DateTime dateTime_from, DateTime dateTime_to, String start, String end, boolean isScheduler, YDMAProgressBar console) {
        if (order_list == null) {
            this.setValue(console, "\ub3d9\uae30\ud654\ud560 \uc8fc\ubb38\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", 0);
            return;
        }
        Set dupOrderIds = order_list.stream().filter(p -> p.getDs_order_status().equals("\uc911\ubcf5 \uc8fc\ubb38 \uc758\uc2ec")).map(ShopOrderMstDto::getOrder_id).collect(Collectors.toSet());
        List<ShopOrderMstDto> finalOrderList = order_list.stream().filter(p -> p.getOrder_status().equals("500")).filter(p -> !p.getDs_order_status().equals("\uc911\ubcf5 \uc8fc\ubb38 \uc758\uc2ec")).filter(p -> !dupOrderIds.contains(p.getOrder_id())).collect(Collectors.toList());
        if (finalOrderList.size() == 0) {
            this.setValue(console, "\ub3d9\uae30\ud654\ud560 \uc8fc\ubb38\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", 0);
            return;
        }
        if (!isScheduler) {
            YDMAProgressBar.get().start(this.getMessage("", true), finalOrderList.size(), 100, true);
        }
        int totalCount = finalOrderList.size();
        int newCount = (int)finalOrderList.stream().filter(p -> p.getOrder_status().equals("500")).count();
        this.setValue(console, newCount + "\uac74\uc5d0 \ub300\ud55c \ub3c4\ub9e4 \ub3d9\uae30\ud654\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
        if (isScheduler) {
            finalOrderList.forEach(d -> {
                d.setStartDt(start);
                d.setEndDt(end);
            });
        } else {
            this._shell = shell;
            this._opener = opener;
            finalOrderList.forEach(d -> {
                d.setStartDt(YDMATimeUtil.getRoRddtDate(dateTime_from));
                d.setEndDt(YDMATimeUtil.getRoRddtDate(dateTime_to));
            });
        }
        List malls = finalOrderList.stream().map(p -> {
            String companyGoodsCd = p.getCompayny_goods_cd();
            return this.getMallCodeFromGoodsCd(companyGoodsCd, p.getGoods_keyword());
        }).distinct().collect(Collectors.toList());
        Map<String, List<ShopOrderMstDto>> order_mapList = finalOrderList.stream().collect(Collectors.groupingBy(p -> {
            String companyGoodsCd = p.getCompayny_goods_cd();
            return this.getMallCodeFromGoodsCd(companyGoodsCd, p.getGoods_keyword());
        }));
        int succesCount = 0;
        for (String mall : malls) {
            try {
                ShoppingMallDetailDto shopdto = ShopCommonDao.get().getShopDtlOneIdWithDome(mall);
                succesCount += this.CollectDomeOrderAllSyncEach(shopdto, order_mapList.get(mall), isScheduler, console);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.setValue(console, "--------------------------------------------------------------------------------------", 0);
        this.setValue(console, String.format("[\uc804\uccb4 \uacb0\uacfc] \uc911\ubcf5 \uc8fc\ubb38\uc73c\ub85c \uc758\uc2ec\ub418\ub294 \uc8fc\ubb38\uc774 %s\uac74 \uc788\uc2b5\ub2c8\ub2e4.", succesCount), totalCount);
        if (!isScheduler) {
            this._opener.bindData();
        }
    }

    private int CollectDomeOrderAllSync(String shopcd, String shopseq, List<ShopOrderMstDto> list, boolean isScheduler, YDMAProgressBar console) {
        int successCount = 0;
        try {
            this.setValue(console, "--------------------------------------------------------------------------------------", 0);
            if (!shopcd.equals("shop0120")) {
                this.setValue(console, this.getMessage(shopcd, false), 0);
            }
            list = this.getDomeOrderList(list, shopcd, shopseq, console, true);
            if ((list = list.stream().filter(d -> d.getResult_code() != null && d.getResult_code().equals("1")).collect(Collectors.toList())).size() > 0) {
                ShopOrderDao.get().SaveOrUpdate(list);
            }
            successCount = list.size();
        }
        catch (Exception e) {
            if (isScheduler) {
                this.setValue(console, e.getMessage(), 0);
            }
            MessageDialog.openInformation((Shell)this._shell, (String)this.title, (String)e.getMessage());
        }
        return successCount;
    }

    private void getMLinkOrddtl() {
        List<Object> totalList = new ArrayList();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ShopLoadingBar loading = new ShopLoadingBar(this._shell);){
                List<ShopOrderMstDto> pickexps = ShopOrderDao.get().getPickExpTable(YDMATimeUtil.getOrddtDate(this._dateTime_from), YDMATimeUtil.getOrddtDate(this._dateTime_to));
                for (ShopOrderMstDto shopOrderMstDto : pickexps) {
                    shopOrderMstDto.setExpnm(shopOrderMstDto.getExpnm().substring(0, shopOrderMstDto.getExpnm().indexOf("_")));
                    totalList.add(shopOrderMstDto);
                    List<ShopOrderMstDto> moveLsts = ShopOrderDao.get().getMoveSeqList(shopOrderMstDto.getOrddt(), shopOrderMstDto.getOrdseq(), shopOrderMstDto.getSeq());
                    if (moveLsts.size() <= 0) continue;
                    for (ShopOrderMstDto moveLst : moveLsts) {
                        moveLst.setOrddt(shopOrderMstDto.getOrddt());
                        moveLst.setOrdseq(shopOrderMstDto.getOrdseq());
                        moveLst.setSeq(shopOrderMstDto.getSeq());
                        moveLst.setMoveseq(shopOrderMstDto.getMoveseq());
                        moveLst.setExpnm(shopOrderMstDto.getExpnm());
                        moveLst.setInvno(shopOrderMstDto.getInvno());
                        totalList.add(moveLst);
                    }
                }
                for (ShopOrderMstDto shopOrderMstDto : totalList) {
                    ShopOrderMstDto dto = ShopOrderDao.get().getOrderMstTable(shopOrderMstDto.getSabordno(), shopOrderMstDto.getExpnm());
                    shopOrderMstDto.setDelivery_id(dto.getDelivery_id());
                    shopOrderMstDto.setOrder_status(dto.getOrder_status());
                }
                if ((totalList = totalList.stream().filter(d -> d.getOrder_status().equals("201") || d.getOrder_status().equals("301") || d.getOrder_status().equals("401")).collect(Collectors.toList())).size() > 0) {
                    ShopOrderDao.get().setDeliveryCode(totalList);
                    this._opener.bindData();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getMessage(String shopcd, boolean isStartMessage) {
        Object message;
        HashMap<String, String> shopMessages = new HashMap<String, String>();
        shopMessages.put("shop0283", "[\ub3c4\ub9e4\uc758\uc2e0] ");
        shopMessages.put("shop0284", "[\ub3c4\ub9e4\uc758\uc2e02] ");
        shopMessages.put("shop0286", "[\ud380\uc564\uc1fc\ud551] ");
        shopMessages.put("shop0120", "[\uc624\ub108\ud074\ub79c] ");
        shopMessages.put("shop9991", "[\ub3c4\ub9e4\uc544\ud1a0\uc988] ");
        shopMessages.put("shop0316", "[\ud22c\ube44\uc988\uc628] ");
        shopMessages.put("shop9994", "[\uc4f0\ub9ac\uc5e0\uc54c\uc624] ");
        shopMessages.put("shop5001", "[\ud5c8\ube0c\uc140\ub7ec] ");
        shopMessages.put("shop0319", "[\ub3c4\ub9e4\ub9e4] ");
        shopMessages.put("shop7777", "[\uc140\ubab0] ");
        shopMessages.put("shop9995", "[\uc820\ud2b8\ub808\uc774\ub4dc] ");
        shopMessages.put("shop0203", "[\ub3c4\ub9e4\ucc3d\uace0] ");
        shopMessages.put("shop9996", "[\uc628\ucc44\ub110] ");
        shopMessages.put("shop9990", "[\ud544\uc6b0\ucee4\uba38\uc2a4] ");
        shopMessages.put("shop9989", "[\uc140\ub7ec\ud504\ub80c\ub4dc] ");
        shopMessages.put("shop9987", "[\uc628\ubbf8] ");
        shopMessages.put("shop9986", "[\ub8f8\uc564\uc624\ud53c\uc2a4] ");
        shopMessages.put("shop9985", "[\ub3c4\ub9e4\ub9c8\ud2b8] ");
        Object object = message = isStartMessage ? "\uc8fc\ubb38\uc0c1\ud0dc \ubc0f \uc1a1\uc7a5\uc815\ubcf4 \uac00\uc838\uc624\uae30" : "";
        if (shopMessages.containsKey(shopcd)) {
            message = (String)shopMessages.get(shopcd) + (String)message;
        }
        return message;
    }

    private void commandOrderValidate(GridItem[] griditems, String code, DateTime dateTime_from, DateTime dateTime_to) throws Exception {
        List<ShopOrderMstDto> items = Arrays.stream(griditems).map(d -> (ShopOrderMstDto)d.getData()).collect(Collectors.toList());
        if (items.size() == 0) {
            throw new Exception("\uadf8\ub9ac\ub4dc\ub97c \uc120\ud0dd\ud574  \uc8fc\uc138\uc694 ");
        }
        int i = 0;
        while (i < items.size()) {
            String retValitate = OrderStatus.validate(((ShopOrderMstDto)items.get(i)).getOrder_status(), code);
            if (!retValitate.equals("0")) {
                throw new Exception("\uc120\ud0dd\ud55c \uadf8\ub9ac\ub4dc \uac12" + retValitate);
            }
            ++i;
        }
        items.forEach(d -> {
            d.setStartDt(YDMATimeUtil.getRoRddtDate(dateTime_from));
            d.setEndDt(YDMATimeUtil.getRoRddtDate(dateTime_to));
        });
    }

    private String getMallCodeFromGoodsCd(String companyGoodsCd, String goodsKeyword) {
        String prefix;
        if (companyGoodsCd == null) {
            return goodsKeyword;
        }
        int prefixLength = companyGoodsCd.toUpperCase().startsWith("DMT") || companyGoodsCd.toUpperCase().startsWith("FWC") ? 3 : 2;
        switch (prefix = companyGoodsCd.substring(0, prefixLength).toUpperCase()) {
            case "AZ": {
                return "shop9991";
            }
            case "FWC": {
                return "shop9990";
            }
            case "SF": {
                return "shop9989";
            }
            case "OM": {
                return "shop9987";
            }
            case "RM": {
                return "shop9986";
            }
            case "DMT": {
                return "shop9985";
            }
        }
        return goodsKeyword;
    }

    public ShopDeliveryDto findDelvName(ShopOrderMstDto dto, String delv, List<ShopDeliveryDto> datasource) {
        String shopId = dto.getShopid();
        String cleanedDelv = delv.replaceAll("\\s+", "");
        ShopDeliveryDto delvname = !(!"shop0003".equals(shopId) && !"shop00031".equals(shopId) || !"\ud3b8\uc758\uc810\ud0dd\ubc30".equals(delv) && !"CU\ud3b8\uc758\uc810\ud0dd\ubc30".equals(delv)) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").equals(cleanedDelv)).findAny().orElse(null) : ("shop0075".equals(shopId) && "CJ\ub300\ud55c\ud1b5\uc6b4".equals(delv) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").contains(cleanedDelv)).findAny().orElse(null) : ("shop9984".equals(shopId) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDivNM().replaceAll("\\s+", "").contains(cleanedDelv)).findAny().orElse(null) : ("\uc77c\uc591\ub85c\uc9c0\uc2a4".equals(delv) ? (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").contains("\uc77c\uc591\ud0dd\ubc30")).findAny().orElse(null) : (ShopDeliveryDto)datasource.stream().filter(d -> d.getDs_code().replaceAll("\\s+", "").contains(cleanedDelv)).findAny().orElse(null))));
        return delvname;
    }

    public void showDomeMessage(ShopOrderMstDto dto, int page, String message, boolean isDelivery, YDMAProgressBar console) {
        String headerText = " \u2192 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n     ";
        String comment = "";
        comment = isDelivery ? (message.equals("") ? String.format("%s | %s | %s | %s ", dto.getProduct_name().equals("") ? dto.getP_product_name() : dto.getProduct_name(), dto.getReceive_name(), dto.getDs_order_status(), dto.getInvoice_no()) : String.format("%s | %s | %s | %s | \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getProduct_name().equals("") ? dto.getP_product_name() : dto.getProduct_name(), dto.getReceive_name(), dto.getDs_order_status(), dto.getInvoice_no(), message)) : (message.equals("") ? String.format("%s | %s | %s ", dto.getProduct_name().equals("") ? dto.getP_product_name() : dto.getProduct_name(), dto.getReceive_name(), dto.getDs_order_status()) : String.format("%s | %s | %s | \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getProduct_name().equals("") ? dto.getP_product_name() : dto.getProduct_name(), dto.getReceive_name(), dto.getDs_order_status(), message));
        this.setValueAndJobLog(console, headerText + comment, page, dto, "ORD_DOME_COLLECT", "\uc131\uacf5", comment);
    }

    private void setValue(YDMAProgressBar console, String message, int page) {
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, page);
    }

    private void setValueAndJobLog(YDMAProgressBar console, String message, int page, ShopOrderMstDto shopOrderMstDto, String jobType, String jobResult, String logMsg) {
        MLinkCommon.get().setValueYDMAprogrssBarisSchedulerAndJobLog(console, message, page, shopOrderMstDto, jobType, jobResult, logMsg);
    }
}

