/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot;

import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class SwtAutoOkForNoUpdates {
    private static final boolean ENABLED = true;
    private static final Pattern[] MSG = new Pattern[]{Pattern.compile("No\\s+updates\\s+were\\s+found.*available\\s+software\\s+sites", 34), Pattern.compile("\uc5c5\ub370\uc774\ud2b8.*\uc5c6\uc2b5\ub2c8\ub2e4", 32)};

    private SwtAutoOkForNoUpdates() {
    }

    public static void install() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display d = PlatformUI.getWorkbench().getDisplay();
        d.addFilter(22, e -> {
            if (!(e.widget instanceof Shell)) {
                return;
            }
            Shell shell = (Shell)e.widget;
            d.timerExec(120, () -> SwtAutoOkForNoUpdates.tryAutoOk(shell));
        });
    }

    private static void tryAutoOk(Shell shell) {
        if (shell == null || shell.isDisposed()) {
            return;
        }
        if (Boolean.TRUE.equals(shell.getData("autoOkHandled"))) {
            return;
        }
        String payload = (shell.getText() == null ? "" : shell.getText()) + "\n" + SwtAutoOkForNoUpdates.collectText((Composite)shell);
        if (!SwtAutoOkForNoUpdates.matches(payload)) {
            return;
        }
        shell.setData("autoOkHandled", (Object)Boolean.TRUE);
        Button ok = shell.getDefaultButton();
        if (ok == null || ok.isDisposed()) {
            ok = SwtAutoOkForNoUpdates.findOk((Composite)shell);
        }
        Button toClick = ok;
        shell.getDisplay().timerExec(80, () -> {
            if (toClick != null && !toClick.isDisposed()) {
                Event ev = new Event();
                ev.widget = toClick;
                toClick.notifyListeners(13, ev);
            } else if (!shell.isDisposed()) {
                shell.close();
            }
        });
    }

    private static boolean matches(String t) {
        if (t == null) {
            return false;
        }
        String s = t.replace("&", "");
        Pattern[] patternArray = MSG;
        int n = MSG.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            if (p.matcher(s).find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String collectText(Composite root) {
        StringBuilder sb = new StringBuilder(256);
        SwtAutoOkForNoUpdates.collect(root, sb);
        return sb.toString();
    }

    private static void collect(Composite parent, StringBuilder out) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t;
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                SwtAutoOkForNoUpdates.collect((Composite)c, out);
            } else if (c instanceof Label) {
                t = ((Label)c).getText();
                if (t != null && !t.isEmpty()) {
                    out.append(t).append('\n');
                }
            } else if (c instanceof Link && (t = ((Link)c).getText()) != null && !t.isEmpty()) {
                out.append(t).append('\n');
            }
            ++n2;
        }
    }

    private static Button findOk(Composite root) {
        return SwtAutoOkForNoUpdates.findButton((Control)root, "OK", "\ud655\uc778");
    }

    private static Button findButton(Control c, String ... labels) {
        Button b;
        if (c instanceof Button && ((b = (Button)c).getStyle() & 8) != 0) {
            String txt = b.getText() == null ? "" : b.getText().replace("&", "");
            String[] stringArray = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String want = stringArray[n2];
                if (txt.equalsIgnoreCase(want)) {
                    return b;
                }
                ++n2;
            }
        }
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                Control child = controlArray[n3];
                Button r = SwtAutoOkForNoUpdates.findButton(child, labels);
                if (r != null) {
                    return r;
                }
                ++n3;
            }
        }
        return null;
    }
}

