/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.aes256util.AES256Util;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class DBCPInit {
    private static final Log LOGGER = LogFactory.getLog(DBCPInit.class);
    private static final String POOL_NAME = "ydincdb";
    private static DBCPInit instance;
    private static final AtomicInteger connectionCount;

    static {
        connectionCount = new AtomicInteger(0);
    }

    public static synchronized DBCPInit getInstance() throws Exception {
        if (instance == null) {
            instance = new DBCPInit();
            LOGGER.info((Object)"DBManager initialized");
        }
        return instance;
    }

    private DBCPInit() throws Exception {
        this.initConnectionPool();
    }

    private void initConnectionPool() throws Exception {
        LOGGER.info((Object)"===== Apache DBCP2 Init Start =====");
        String jdbcDriver = YDMAProperties.getInstance().getAppProperty("jdbc.driver");
        String jdbcurl = YDMAProperties.getInstance().getAppProperty("jdbc.url");
        String user = YDMAProperties.getInstance().getAppProperty("jdbc.username");
        String pwd = YDMAProperties.getInstance().getAppProperty("jdbc.password");
        try {
            AES256Util.getInstance((String)AES256Util.KEY_WORD);
            user = AES256Util.decrypt((String)user);
            AES256Util.getInstance((String)AES256Util.KEY_WORD);
            pwd = AES256Util.decrypt((String)pwd);
        }
        catch (Exception e) {
            LOGGER.error((Object)"DB \uacc4\uc815 \ubcf5\ud638\ud654 \uc2e4\ud328", (Throwable)e);
            throw e;
        }
        Class.forName(jdbcDriver);
        if (YDMASessonUtil.getConnectip() != null && !"localhost:43306".equals(YDMASessonUtil.getConnectip().getProgcd())) {
            jdbcurl = jdbcurl.replace("localhost:43306", YDMASessonUtil.getConnectip().getProgcd());
        }
        DriverManagerConnectionFactory connFactory = new DriverManagerConnectionFactory(jdbcurl, user, pwd);
        PoolableConnectionFactory poolableConnFactory = new PoolableConnectionFactory((ConnectionFactory)connFactory, null);
        poolableConnFactory.setValidationQuery("SELECT 1");
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setTimeBetweenEvictionRunsMillis(300000L);
        poolConfig.setTestWhileIdle(true);
        poolConfig.setTestOnBorrow(false);
        poolConfig.setMinIdle(3);
        poolConfig.setMaxIdle(5);
        poolConfig.setMaxTotal(5);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)poolableConnFactory, poolConfig);
        poolableConnFactory.setPool((ObjectPool)connectionPool);
        Class.forName("org.apache.commons.dbcp2.PoolingDriver");
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(POOL_NAME, (ObjectPool)connectionPool);
        LOGGER.info((Object)"===== Apache DBCP2 Init End =====");
    }

    public Connection getConnection() throws SQLException {
        Connection con = DriverManager.getConnection("jdbc:apache:commons:dbcp:ydincdb");
        connectionCount.incrementAndGet();
        return con;
    }

    public void freeConnection(Connection con, List<PreparedStatement> pstmtList, List<ResultSet> rsList) {
        try {
            for (ResultSet rs : rsList) {
                this.freeResultSet(rs);
            }
            for (PreparedStatement pstmt : pstmtList) {
                this.freeStatement(pstmt);
            }
            this.freeConnection(con);
        }
        catch (Exception e) {
            LOGGER.warn((Object)"freeConnection(Connection, List<PreparedStatement>, List<ResultSet>) failed", (Throwable)e);
        }
    }

    public void freeConnection(Connection con, List<PreparedStatement> list, ResultSet rs) {
        this.freeResultSet(rs);
        if (list != null) {
            list.forEach(this::freeStatement);
        }
        this.freeConnection(con);
    }

    public void freeConnection(Connection con) {
        if (con != null) {
            try {
                try {
                    if (!con.isClosed()) {
                        con.close();
                    }
                }
                catch (SQLException e) {
                    LOGGER.warn((Object)"Connection close failed", (Throwable)e);
                    connectionCount.decrementAndGet();
                }
            }
            finally {
                connectionCount.decrementAndGet();
            }
        }
    }

    public void freeStatement(PreparedStatement pstmt) {
        try {
            if (pstmt != null && !pstmt.isClosed()) {
                pstmt.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn((Object)"PreparedStatement close failed", (Throwable)e);
        }
    }

    public void freeConnection(Connection con, PreparedStatement pstmt, ResultSet rs) {
        try {
            this.freeResultSet(rs);
            this.freeStatement(pstmt);
            this.freeConnection(con);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void freeResultSet(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException e) {
            LOGGER.warn((Object)"ResultSet close failed", (Throwable)e);
        }
    }
}

