/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.IndexJob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class IndexDistributionDao {
    private static IndexDistributionDao INSTANCE = new IndexDistributionDao();

    public static IndexDistributionDao get() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<IndexJob> getPendingJobs() throws Exception {
        ArrayList<IndexJob> jobs = new ArrayList<IndexJob>();
        String sql = "SELECT id, sql_text FROM index_distribution WHERE executed_flag = 0 AND execute_after <= NOW()";
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            Connection connection = DBCPInit.getInstance().getConnection();
            try {
                block19: {
                    PreparedStatement pstmt = connection.prepareStatement(sql);
                    try {
                        try (ResultSet rs = pstmt.executeQuery();){
                            while (rs.next()) {
                                IndexJob job = new IndexJob();
                                job.setId(rs.getLong("id"));
                                job.setSqlText(rs.getString("sql_text"));
                                jobs.add(job);
                            }
                        }
                        if (pstmt == null) break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (pstmt == null) throw throwable;
                        pstmt.close();
                        throw throwable;
                    }
                    pstmt.close();
                }
                if (connection == null) return jobs;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            connection.close();
            return jobs;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            }
            if (throwable == throwable4) throw throwable;
            throwable.addSuppressed(throwable4);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void markExecuted(long id, boolean success, String message) throws Exception {
        String sql = "UPDATE index_distribution SET executed_flag=?, result_msg=?, executed_at=NOW() WHERE id=?";
        Throwable throwable = null;
        Object var7_7 = null;
        try {
            Connection connection = DBCPInit.getInstance().getConnection();
            try {
                try (PreparedStatement pstmt = connection.prepareStatement(sql);){
                    pstmt.setInt(1, success ? 1 : 2);
                    pstmt.setString(2, message);
                    pstmt.setLong(3, id);
                    pstmt.executeUpdate();
                }
                if (connection == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            connection.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void updateDBIndexes() {
        try {
            List<IndexJob> jobs = IndexDistributionDao.get().getPendingJobs();
            for (IndexJob job : jobs) {
                try {
                    Throwable throwable = null;
                    Object var5_8 = null;
                    try {
                        Connection connection = DBCPInit.getInstance().getConnection();
                        try {
                            try (Statement stmt = connection.createStatement();){
                                String sql = job.getSqlText().trim();
                                if (sql.toUpperCase().startsWith("CREATE INDEX") || sql.toUpperCase().startsWith("ALTER TABLE")) {
                                    stmt.execute(sql);
                                    IndexDistributionDao.get().markExecuted(job.getId(), true, "OK");
                                } else {
                                    IndexDistributionDao.get().markExecuted(job.getId(), false, "Invalid SQL: " + sql);
                                }
                            }
                            if (connection == null) continue;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (connection != null) {
                                connection.close();
                            }
                            throw throwable;
                        }
                        connection.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    IndexDistributionDao.get().markExecuted(job.getId(), false, e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

