/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.splashHandlers;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.splash.AbstractSplashHandler;

public class BrowserSplashHandler
extends AbstractSplashHandler {
    private static final String F_BROWSER_URL = "http://www.google.com";
    private Browser fBrowser = null;
    private Button fButton = null;
    private boolean fClose = false;

    public void init(Shell splash) {
        super.init(splash);
        this.configureUISplash();
        this.createUI();
        this.createUIListeners();
        splash.layout(true);
        this.doEventLoop();
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        while (!this.fClose) {
            if (splash.getDisplay().readAndDispatch()) continue;
            splash.getDisplay().sleep();
        }
    }

    private void createUIListeners() {
        this.createUIListenersBrowser();
        this.createUIListenersButton();
    }

    private void createUIListenersButton() {
        this.fButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BrowserSplashHandler.this.fClose = true;
            }
        });
    }

    private void createUIListenersBrowser() {
        this.fBrowser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                BrowserSplashHandler.this.fBrowser.setVisible(true);
                BrowserSplashHandler.this.fButton.setVisible(true);
            }
        });
    }

    private void createUI() {
        this.createUIBrowser();
        this.createUIButton();
    }

    private void createUIButton() {
        Shell splash = this.getSplash();
        this.fButton = new Button((Composite)splash, 8);
        this.fButton.setText("Close");
        this.fButton.setVisible(false);
        this.configureUIButtonBounds();
        GridData data2 = new GridData(0x1000000, 4, false, false);
        data2.widthHint = 80;
        this.fButton.setLayoutData((Object)data2);
    }

    private void configureUIButtonBounds() {
        Shell splash = this.getSplash();
        int button_x_coord = splash.getSize().x / 2 - this.fButton.computeSize((int)-1, (int)-1).x / 2;
        int button_y_coord = splash.getSize().y - this.fButton.computeSize((int)-1, (int)-1).y;
        int button_x_width = splash.getSize().x;
        int button_y_width = this.fButton.computeSize((int)-1, (int)-1).y;
        this.fButton.setBounds(button_x_coord, button_y_coord, button_x_width, button_y_width);
    }

    private void createUIBrowser() {
        this.fBrowser = new Browser((Composite)this.getSplash(), 0);
        this.fBrowser.setUrl(F_BROWSER_URL);
        this.fBrowser.setVisible(false);
        GridData data2 = new GridData(4, 4, true, true);
        this.fBrowser.setLayoutData((Object)data2);
    }

    private void configureUISplash() {
        GridLayout layout = new GridLayout(1, true);
        this.getSplash().setLayout((Layout)layout);
    }
}

