/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.splashHandlers;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.splash.AbstractSplashHandler;

public class InteractiveSplashHandler
extends AbstractSplashHandler {
    private static final int F_LABEL_HORIZONTAL_INDENT = 175;
    private static final int F_BUTTON_WIDTH_HINT = 80;
    private static final int F_TEXT_WIDTH_HINT = 175;
    private static final int F_COLUMN_COUNT = 3;
    private Composite fCompositeLogin = null;
    private Text fTextUsername = null;
    private Text fTextPassword = null;
    private Button fButtonOK = null;
    private Button fButtonCancel = null;
    private boolean fAuthenticated = false;

    public void init(Shell splash) {
        super.init(splash);
        this.configureUISplash();
        this.createUI();
        this.createUIListeners();
        splash.layout(true);
        this.doEventLoop();
    }

    private void doEventLoop() {
        Shell splash = this.getSplash();
        while (!this.fAuthenticated) {
            if (splash.getDisplay().readAndDispatch()) continue;
            splash.getDisplay().sleep();
        }
    }

    private void createUIListeners() {
        this.createUIListenersButtonOK();
        this.createUIListenersButtonCancel();
    }

    private void createUIListenersButtonCancel() {
        this.fButtonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonCancelWidgetSelected();
            }
        });
    }

    private void handleButtonCancelWidgetSelected() {
        this.getSplash().getDisplay().close();
        System.exit(0);
    }

    private void createUIListenersButtonOK() {
        this.fButtonOK.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InteractiveSplashHandler.this.handleButtonOKWidgetSelected();
            }
        });
    }

    private void handleButtonOKWidgetSelected() {
        String username = this.fTextUsername.getText();
        String password = this.fTextPassword.getText();
        if (username.length() > 0 && password.length() > 0) {
            this.fAuthenticated = true;
        } else {
            MessageDialog.openError((Shell)this.getSplash(), (String)"Authentication Failed", (String)"A username and password must be specified to login.");
        }
    }

    private void createUI() {
        this.createUICompositeLogin();
        this.createUICompositeBlank();
        this.createUILabelUserName();
        this.createUITextUserName();
        this.createUILabelPassword();
        this.createUITextPassword();
        this.createUILabelBlank();
        this.createUIButtonOK();
        this.createUIButtonCancel();
    }

    private void createUIButtonCancel() {
        this.fButtonCancel = new Button(this.fCompositeLogin, 8);
        this.fButtonCancel.setText("Cancel");
        GridData data2 = new GridData(0, 0, false, false);
        data2.widthHint = 80;
        data2.verticalIndent = 10;
        this.fButtonCancel.setLayoutData((Object)data2);
    }

    private void createUIButtonOK() {
        this.fButtonOK = new Button(this.fCompositeLogin, 8);
        this.fButtonOK.setText("OK");
        GridData data2 = new GridData(0, 0, false, false);
        data2.widthHint = 80;
        data2.verticalIndent = 10;
        this.fButtonOK.setLayoutData((Object)data2);
    }

    private void createUILabelBlank() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setVisible(false);
    }

    private void createUITextPassword() {
        int style = 0x400800;
        this.fTextPassword = new Text(this.fCompositeLogin, style);
        GridData data2 = new GridData(0, 0, false, false);
        data2.widthHint = 175;
        data2.horizontalSpan = 2;
        this.fTextPassword.setLayoutData((Object)data2);
    }

    private void createUILabelPassword() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setText("&Password:");
        GridData data2 = new GridData();
        data2.horizontalIndent = 175;
        label.setLayoutData((Object)data2);
    }

    private void createUITextUserName() {
        this.fTextUsername = new Text(this.fCompositeLogin, 2048);
        GridData data2 = new GridData(0, 0, false, false);
        data2.widthHint = 175;
        data2.horizontalSpan = 2;
        this.fTextUsername.setLayoutData((Object)data2);
    }

    private void createUILabelUserName() {
        Label label = new Label(this.fCompositeLogin, 0);
        label.setText("&User Name:");
        GridData data2 = new GridData();
        data2.horizontalIndent = 175;
        label.setLayoutData((Object)data2);
    }

    private void createUICompositeBlank() {
        Composite spanner = new Composite(this.fCompositeLogin, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalSpan = 3;
        spanner.setLayoutData((Object)data2);
    }

    private void createUICompositeLogin() {
        this.fCompositeLogin = new Composite((Composite)this.getSplash(), 2048);
        GridLayout layout = new GridLayout(3, false);
        this.fCompositeLogin.setLayout((Layout)layout);
    }

    private void configureUISplash() {
        FillLayout layout = new FillLayout();
        this.getSplash().setLayout((Layout)layout);
        this.getSplash().setBackgroundMode(1);
    }
}

