/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.ShopLoadingBar;
import com.kdjsystem.mlink.shop.common.ShopWorkService;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.domesin.DomesinAPI;
import com.kdjsystem.mlink.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.shop.mlink.MLinkAPI;
import com.kdjsystem.mlink.shop.mlink.MLinkSessonUtil;
import com.kdjsystem.mlink.tot.Activator;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.BrandsDao;
import com.kdjsystem.mlink.tot.data.dao.CompInfoDao;
import com.kdjsystem.mlink.tot.data.dao.UserDao;
import com.kdjsystem.mlink.tot.data.dao.UserDto;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class Login
extends CommandDialog {
    public static String ID = "com.kdjsystem.mlink.tot.command.Login.ID";
    private static final String LAST_COMPNO = "last-compno";
    private static final String LAST_USER = "last-user";
    private static final String PASSWORD = "password";
    private static final String SAVED_ID = "saved-id";
    private static final String SAVED = "saved-connections";
    private boolean authenticated = false;
    private String errorMessage = "";
    String TITLE = "\ub85c\uadf8\uc778";
    private Text txt_compno;
    private Text txt_pw;
    private Text txt_id;
    static String host;
    private Button ck_autoLogin;
    private Label lb_message;
    private Label lb_brandName;
    private Label lb_logo;
    private Label lb_compno;
    private Label lb_userid;
    int setupType = 2;

    public Login(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(2080);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lb_brandName = new Label(composite, 0);
        this.lb_brandName.setText("");
        this.lb_brandName.setBounds(4, 3, 168, 20);
        this.lb_compno = new Label(composite, 0);
        this.lb_compno.setText("4");
        this.lb_compno.setBounds(188, 38, 21, 20);
        this.txt_compno = new Text(composite, 2048);
        this.lb_userid = new Label(composite, 0);
        this.lb_userid.setBounds(177, 71, 58, 20);
        this.lb_userid.setText(this.errorMessage);
        this.txt_id = new Text(composite, 2048);
        this.txt_id.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    Login.this.txt_pw.setFocus();
                }
            }
        });
        this.txt_id.setBounds(241, 67, 201, 26);
        this.txt_id.setFocus();
        Label lblNewLabel_1 = new Label(composite, 0);
        lblNewLabel_1.setBounds(177, 106, 59, 20);
        lblNewLabel_1.setText("Password : ");
        this.txt_pw = new Text(composite, 0x400800);
        this.txt_pw.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Login.this.txt_pw.getShell().setImeInputMode(20);
            }
        });
        this.txt_pw.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                    Login.this.okPressed();
                }
            }
        });
        this.txt_pw.setBounds(241, 102, 201, 26);
        this.ck_autoLogin = new Button(composite, 32);
        this.ck_autoLogin.setBounds(177, 175, 119, 16);
        this.ck_autoLogin.setText("\uc790\ub3d9 \ub85c\uadf8\uc778");
        this.lb_message = new Label(composite, 0);
        this.lb_message.setForeground(SWTResourceManager.getColor(3));
        this.lb_message.setBounds(177, 134, 288, 29);
        this.lb_message.setText("");
        this.lb_logo = new Label(composite, 0);
        this.lb_logo.setAlignment(131072);
        this.lb_logo.setBounds(24, 38, 139, 133);
        this.init();
        this.readAutoLogin();
        return container;
    }

    private void init() {
        this.lb_brandName.setText("\ucf00\uc774\ub514\uc81c\uc774\uc2dc\uc2a4\ud15c");
        this.lb_logo.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/MLink-removebg.png"));
        this.lb_compno.setText("\ud68c\uc0ac ID : ");
        this.lb_compno.setBounds(177, 38, 58, 20);
        this.txt_compno.setBounds(241, 32, 58, 26);
        this.lb_userid.setText("User ID : ");
        this.setupType = 2;
    }

    private void readAutoLogin() {
        String compno = "";
        String id = "";
        String pw = "";
        String saveid = "";
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences conn = root.node(SAVED);
        try {
            compno = conn.get(LAST_COMPNO, "");
            id = conn.get(LAST_USER, "");
            pw = conn.get(PASSWORD, "");
            saveid = conn.get(SAVED_ID, "");
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        if (compno.equals("") || id.equals("") || id.equals("")) {
            return;
        }
        this.txt_compno.setText("4");
        this.txt_id.setText(id);
        this.txt_pw.setText(pw);
        if (saveid.equals("Y")) {
            this.ck_autoLogin.setSelection(true);
            this.ck_autoLogin.setFocus();
        } else {
            this.ck_autoLogin.setSelection(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performAutoLogin() {
        if (!this.hasAutoLoginCredentials()) {
            return false;
        }
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = root.node(SAVED);
        try {
            String compno = node.get(LAST_COMPNO, "");
            String id = node.get(LAST_USER, "");
            String pw = node.get(PASSWORD, "");
            String saveid = node.get(SAVED_ID, "");
            try {
                Throwable throwable = null;
                Object var8_11 = null;
                try (ShopLoadingBar loading = new ShopLoadingBar(this.getShell());){
                    if (System.getProperty("os.name").contains("Windows")) {
                        this.killEmlinkChromeDriverWindows();
                    }
                    if (!this.loginAuthentication(compno, id, pw, saveid)) return false;
                    this.deleteImages();
                    this.deleteImages2();
                    this.deleteImages3();
                    this.authenticated = true;
                    return true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean hasAutoLoginCredentials() {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = root.node(SAVED);
        try {
            String compno = node.get(LAST_COMPNO, "");
            String id = node.get(LAST_USER, "");
            String pw = node.get(PASSWORD, "");
            String saveid = node.get(SAVED_ID, "");
            return !compno.isEmpty() && !id.isEmpty() && !pw.isEmpty() && "Y".equals(saveid);
        }
        catch (StorageException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void setAutoLogin(String compno, String id, String pw, String saveid) {
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        try {
            ISecurePreferences conn = root.node(SAVED);
            conn.put(LAST_COMPNO, compno, false);
            conn.put(LAST_USER, id, false);
            conn.put(PASSWORD, pw, false);
            conn.put(SAVED_ID, saveid, false);
        }
        catch (StorageException e) {
            e.printStackTrace();
        }
        try {
            root.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void okPressed() {
        String compno = this.txt_compno.getText().trim();
        String id = this.txt_id.getText().trim();
        String pw = this.txt_pw.getText().trim();
        String saveid = "Y";
        saveid = this.ck_autoLogin.getSelection() ? "Y" : "N";
        if (id.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.TITLE, (String)"\uc544\uc774\ub514\ub97c \uc785\ub825\ud558\uc138\uc694.");
            this.txt_id.setFocus();
            return;
        }
        if (pw.length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.TITLE, (String)"\ube44\ubc00\ubc88\ud638\ub97c \uc785\ub825\ud558\uc138\uc694.");
            this.txt_pw.setFocus();
            return;
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ShopLoadingBar loading = new ShopLoadingBar(this.getShell());){
                if (System.getProperty("os.name").toLowerCase().contains("windows")) {
                    this.killEmlinkChromeDriverWindows();
                    this.killEmlinkChromeChromeWindows();
                }
                if (this.loginAuthentication(compno, id, pw, saveid)) {
                    this.deleteImages();
                    this.deleteImages2();
                    this.deleteImages3();
                    this.authenticated = true;
                    super.okPressed();
                } else {
                    this.authenticated = false;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void killEmlinkChromeDriverWindows() {
        try {
            String line;
            Process proc;
            String query = "Name='chromedriver.exe'";
            String[] cmd = new String[]{"wmic", "process", "where", query, "get", "ProcessId"};
            try {
                proc = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException iOException) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            ArrayList<String> pidList = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.equalsIgnoreCase("ProcessId") || line.startsWith("Node")) continue;
                pidList.add(line);
            }
            reader.close();
            proc.waitFor();
            for (String pid : pidList) {
                String[] killCmd = new String[]{"taskkill", "/F", "/PID", pid};
                Process killProc = Runtime.getRuntime().exec(killCmd);
                killProc.waitFor();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private void killEmlinkChromeChromeWindows() {
        try {
            String line;
            Process proc;
            String query = "Name='chrome.exe' and CommandLine like '%--emlink%'";
            String[] cmd = new String[]{"wmic", "process", "where", query, "get", "ProcessId"};
            try {
                proc = Runtime.getRuntime().exec(cmd);
            }
            catch (IOException iOException) {
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            ArrayList<String> pidList = new ArrayList<String>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.equalsIgnoreCase("ProcessId") || line.startsWith("Node")) continue;
                pidList.add(line);
            }
            reader.close();
            proc.waitFor();
            for (String pid : pidList) {
                String[] killCmd = new String[]{"taskkill", "/F", "/PID", pid};
                Process killProc = Runtime.getRuntime().exec(killCmd);
                killProc.waitFor();
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    private boolean loginAuthentication(String compno, String id, String pw, String saveid) {
        UserDto dto;
        UserDao dao;
        block20: {
            block22: {
                block21: {
                    UserDto dtoImsi;
                    block19: {
                        dao = new UserDao();
                        dto = null;
                        dtoImsi = null;
                        dto = this.getUserPermitAPI(compno, id, pw);
                        if (dto != null) break block19;
                        this.errorMessage = MLinkSessonUtil.get().ResultLoginText;
                        this.lb_message.setText(this.errorMessage);
                        return false;
                    }
                    YDMASessonUtil.setConnectip(dto);
                    MLinkAPI.get().DosinCountCheck(dto.getCompno(), dto.getUserId(), dto.getUserpwd(), YDMATimeUtil.getCurrentTime());
                    dtoImsi = dao.getUserInfoLogin(dto.getCompno(), dto.getUserId(), dto.getUserpwd());
                    if (dtoImsi != null) break block20;
                    if (!ShopOrderDao.get().isOrderedJustOne()) break block21;
                    this.errorMessage = "\uc774\ubbf8 \uc0ac\uc6a9 \uc911\uc778 \uc5e0\ub9c1\ud06c ID\uac00 \uc788\uc2b5\ub2c8\ub2e4.\n\uc0c8\ub85c\uc6b4 ID\ub294 \ud504\ub85c\uadf8\ub7a8 \uc7ac\uc124\uce58 \ud6c4 \uc0ac\uc6a9 \uac00\ub2a5\ud569\ub2c8\ub2e4.";
                    this.lb_message.setText(this.errorMessage);
                    return false;
                }
                if (!ShopProductDao.get().isShopProductJustOne()) break block22;
                this.errorMessage = "\uc774\ubbf8 \uc0ac\uc6a9 \uc911\uc778 \uc5e0\ub9c1\ud06c ID\uac00 \uc788\uc2b5\ub2c8\ub2e4.\n\uc0c8\ub85c\uc6b4 ID\ub294 \ud504\ub85c\uadf8\ub7a8 \uc7ac\uc124\uce58 \ud6c4 \uc0ac\uc6a9 \uac00\ub2a5\ud569\ub2c8\ub2e4.";
                this.lb_message.setText(this.errorMessage);
                return false;
            }
            if (dao.insertUser("", dto.getUserId(), dto.getUserpwd(), "", "", dto.getCompno(), "2", -1) > 0) {
                dto = dao.getUserInfoLogin(dto.getCompno(), dto.getUserId(), dto.getUserpwd());
                break block20;
            }
            return false;
        }
        try {
            YDMASessonUtil.setUserInfo(dto);
            YDMASessonUtil.setCompnoInfo(dto);
            YDMASessonUtil.setUserpwd(dto);
            YDMASessonUtil.setCommoncodelist(ShopCommonDao.get().getCommonCode());
            List<ShoppingMallDetailDto> shopDtoList = ShopCommonDao.get().getShopCookies();
            List shopList = shopDtoList.stream().filter(d -> !d.getCookies().equals("")).collect(Collectors.toList());
            ObjectMapper mapper = new ObjectMapper();
            try {
                for (ShoppingMallDetailDto shopDto : shopList) {
                    Map mapCookies = (Map)mapper.readValue(shopDto.getCookies(), Map.class);
                    IShopCommonLogin.cokieManager.put(shopDto.getCookiekey(), mapCookies);
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print(e);
            }
            try {
                YDMASessonUtil.setBrandcodelist(BrandsDao.get().getBrandsByAll());
            }
            catch (Exception exception) {}
            int newCount = Activator.connectToSocketServerIncrement();
            if (newCount == 1) {
                ShopCommonDao.get().re_useCloudinary();
                ShopWorkService.getInstance().startSchedulerTasks();
            } else {
                ShopWorkService.getInstance().startProcessQueueOnly();
            }
            try {
                CompInfoDao imgDao = new CompInfoDao();
                List<String> list = imgDao.getCompno();
                if (list.size() > 0) {
                    YDMASessonUtil.setImageFolderName(list.get(1).trim());
                }
            }
            catch (Exception exception) {}
            dao.LoggingUser(id);
            try {
                YDMASessonUtil.setLoginType(dto.getLtype());
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.setAutoLogin(compno, id, pw, saveid);
            return true;
        }
        catch (Exception exception) {
            this.lb_message.setText("\ub85c\uadf8\uc778 \ucc98\ub9ac \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            return false;
        }
    }

    private boolean DomesinLogin(String compno, String id, String pw) {
        boolean ret = true;
        try {
            if (!DomesinAPI.get().Login(id, pw)) {
                throw new Exception(DomesinSessonUtil.get().ResultLoginText);
            }
        }
        catch (Exception exception) {
            ret = false;
        }
        return ret;
    }

    private boolean isCheckUsePermit(UserDto dto) {
        boolean ret = true;
        String curDate = YDMATimeUtil.getCurrentTimeByYDFormat();
        if (curDate.compareTo(dto.getEnduse()) > 0) {
            ret = false;
        }
        return ret;
    }

    private boolean isCheckUseApiPermit(String compno, String id, String pw) {
        boolean ret = true;
        try {
            MLinkAPI.get().Login(compno, id, pw);
        }
        catch (Exception exception) {
            ret = false;
        }
        return ret;
    }

    private UserDto getUserPermitAPI(String compno, String id, String pw) {
        UserDto dto = null;
        try {
            dto = MLinkAPI.get().Login(compno, id, pw);
        }
        catch (Exception exception) {
            dto = null;
        }
        return dto;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        GridLayout layout = new GridLayout(50, false);
        parent.setLayout((Layout)layout);
        Button btnSignup = this.createButton(parent, 1024, "\ud68c\uc6d0\uac00\uc785", false);
        GridData gd_btnSignup = new GridData(16384, 0x1000000, true, false);
        gd_btnSignup.horizontalSpan = 45;
        gd_btnSignup.minimumWidth = 100;
        btnSignup.setLayoutData((Object)gd_btnSignup);
        btnSignup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("https://kdjsystem.co.kr/member/agree.php"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.createButton(parent, 0, "\ud655\uc778", true);
        this.createButton(parent, 1, "\ucde8\uc18c", false);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("M-Link Login");
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(500, 311);
    }

    private void deleteImages() {
        try {
            String basePath = YDMASessonUtil.getAppPath("");
            String shopImagePath = YDMAProperties.getInstance().getAppProperty("Product.image.shopImage").replace("\\", File.separator);
            String fullPath = basePath + shopImagePath + File.separator + "dome";
            File folder = new File(fullPath);
            if (folder.exists() && folder.isDirectory()) {
                Files.walk(folder.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
                    try {
                        Files.delete(path);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
                YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc644\ub8cc: " + fullPath);
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            } else {
                YDMAStringUtil.Print("\ud3f4\ub354\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uac70\ub098 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: " + fullPath);
                Files.createDirectories(folder.toPath(), new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deleteImages2() {
        try {
            String basePath = YDMASessonUtil.getAppPath("");
            String shopImagePath = YDMAProperties.getInstance().getAppProperty("Product.image.shopImage2").replace("\\", File.separator);
            String fullPath = basePath + shopImagePath + File.separator + "dome";
            File folder = new File(fullPath);
            if (folder.exists() && folder.isDirectory()) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (!file.isDirectory()) {
                        file.delete();
                    }
                    ++n2;
                }
                YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc644\ub8cc: " + fullPath);
            } else {
                YDMAStringUtil.Print("\ud3f4\ub354\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uac70\ub098 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: " + fullPath);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void deleteImages3() {
        try {
            String basePath = YDMASessonUtil.getAppPath("");
            String shopImagePath = YDMAProperties.getInstance().getAppProperty("Product.imageChangePath").replace("\\", File.separator);
            String fullPath = basePath + shopImagePath;
            File folder = new File(fullPath);
            if (folder.exists() && folder.isDirectory()) {
                File[] fileArray = folder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName;
                    File file = fileArray[n2];
                    if (!(file.isDirectory() || (fileName = file.getName().toLowerCase()).endsWith(".txt") || fileName.endsWith(".dll") || fileName.endsWith(".exe"))) {
                        file.delete();
                    }
                    ++n2;
                }
                YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc644\ub8cc: " + fullPath);
            } else {
                YDMAStringUtil.Print("\ud3f4\ub354\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uac70\ub098 \uc720\ud6a8\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4: " + fullPath);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

